/*
 * Decompiled with CFR 0.152.
 */
package com.tridiumx.nacDriver.event;

import com.tridium.json.JSONArray;
import com.tridiumx.nacDriver.BNACNetwork;
import com.tridiumx.nacDriver.event.BNACDataWorker;
import com.tridiumx.nacDriver.message.NACServerTokenRequest;
import com.tridiumx.nacDriver.util.Utils;
import java.security.AccessController;
import java.util.logging.Level;
import javax.baja.sys.BAbsTime;

public class NACPoller
extends Thread {
    BNACDataWorker worker;
    BNACNetwork network;
    String dynamicSessionToken;
    boolean shutdown = false;
    BAbsTime dynamicSessionTime;
    static final int FAILURE_TIMEOUT = 2000;

    public NACPoller(BNACDataWorker worker, BNACNetwork network, String name) {
        super(name);
        this.worker = worker;
        this.network = network;
    }

    public NACPoller() {
    }

    @Override
    public void run() {
        while (!this.shutdown) {
            try {
                if (this.network.getSessionToken() == null) {
                    this.network.log().log(Level.FINE, "No long polling as session disconnected");
                    try {
                        Thread.sleep(2000L);
                    }
                    catch (InterruptedException interruptedException) {}
                    continue;
                }
                if (this.dynamicSessionToken == null || this.network.getNACServerDetails().getLastAuthenticationTime().isAfter(this.dynamicSessionTime)) {
                    this.openDynamicSession();
                }
                JSONArray dataList = this.longPolling();
                this.postAsyncToWorker(dataList);
            }
            catch (Exception e) {
                Utils.logException(this.network.log(), e, Level.WARNING);
                try {
                    Thread.sleep(2000L);
                }
                catch (InterruptedException interruptedException) {}
            }
        }
    }

    protected void postAsyncToWorker(JSONArray dataList) {
    }

    public JSONArray longPollingPublic() throws Exception {
        String uri = this.getLongPollUri();
        NACServerTokenRequest request = new NACServerTokenRequest(this.network.getHttpConfig().getAddress(), "GET", uri, this.network.getSessionToken());
        String response = new String(this.network.sendHttpRequest(request).getData());
        return new JSONArray(response);
    }

    private JSONArray longPolling() {
        return AccessController.doPrivileged(() -> {
            try {
                return this.longPollingPublic();
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        });
    }

    public void shutdown() {
        this.shutdown = true;
        this.interrupt();
    }

    protected String getLongPollUri() {
        return null;
    }

    private void openDynamicSession() throws Exception {
        NACServerTokenRequest request = AccessController.doPrivileged(() -> new NACServerTokenRequest(this.network.getHttpConfig().getAddress(), "GET", "/json/openDynamicSession", this.network.getSessionToken()));
        this.dynamicSessionToken = new String(this.network.sendHttpRequest(request).getData());
        this.dynamicSessionTime = BAbsTime.now();
    }

    protected int getTimeout() {
        return 5000;
    }
}

