/*
 * Decompiled with CFR 0.152.
 */
package com.tridiumx.nacDriver.event;

import com.tridium.json.JSONArray;
import com.tridiumx.nacDriver.BNACNetwork;
import com.tridiumx.nacDriver.event.BNACDataWorker;
import com.tridiumx.nacDriver.event.DevChangeRunnable;
import com.tridiumx.nacDriver.event.NACPoller;
import java.util.Enumeration;

public class NACDevChangePoller
extends NACPoller {
    public NACDevChangePoller(BNACDataWorker worker, BNACNetwork network) {
        super(worker, network, "NACNetwork:DevChangePoller");
    }

    public NACDevChangePoller() {
    }

    @Override
    protected String getLongPollUri() {
        return "/json/getAllChangedDevUnidToDevStateWithTimeout?token=" + this.dynamicSessionToken + "&" + this.getSpecificDevRestrictionsUri() + "timeout=" + this.getTimeout();
    }

    private String getSpecificDevRestrictionsUri() {
        StringBuilder specificDevRestrictionsUri = new StringBuilder();
        Enumeration<Integer> unids = this.network.getUnidsInMap();
        while (unids.hasMoreElements()) {
            specificDevRestrictionsUri.append("specificDevRestriction.devs=").append(unids.nextElement()).append("&");
        }
        return specificDevRestrictionsUri.toString();
    }

    @Override
    protected void postAsyncToWorker(JSONArray dataList) {
        int dataListSize = dataList.length();
        for (int i = 0; i < dataListSize; ++i) {
            this.worker.postAsync(new DevChangeRunnable(dataList.getJSONObject(i), this.network));
        }
    }
}

