/*
 * Decompiled with CFR 0.152.
 */
package com.tridiumx.nacDriver.doors;

import com.tridium.entsecDriver.BAbstractDoor;
import com.tridium.json.JSONArray;
import com.tridium.json.JSONObject;
import com.tridium.ndriver.comm.NCommException;
import com.tridiumx.nacDriver.BINACMappable;
import com.tridiumx.nacDriver.BNACNetwork;
import com.tridiumx.nacDriver.device.BNACDevice;
import com.tridiumx.nacDriver.doors.BDoorModeStatus;
import com.tridiumx.nacDriver.doors.BNACDoorModeSchedule;
import com.tridiumx.nacDriver.doors.BNACReader;
import com.tridiumx.nacDriver.doors.NACDefaultDoorMode;
import com.tridiumx.nacDriver.enums.BNACDoorModeTypeEnum;
import com.tridiumx.nacDriver.job.BDeleteScheduleLinkFromDoorJob;
import com.tridiumx.nacDriver.job.BDoorModeMappingToScheduleJob;
import com.tridiumx.nacDriver.message.NACServerTokenRequest;
import com.tridiumx.nacDriver.point.BNACPointDeviceExt;
import com.tridiumx.nacDriver.util.NACRequestUtils;
import com.tridiumx.nacDriver.util.Utils;
import java.security.AccessController;
import java.security.PrivilegedActionException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.logging.Level;
import javax.baja.data.BIDataValue;
import javax.baja.naming.SlotPath;
import javax.baja.nre.annotations.Facet;
import javax.baja.nre.annotations.NiagaraProperties;
import javax.baja.nre.annotations.NiagaraProperty;
import javax.baja.nre.annotations.NiagaraType;
import javax.baja.status.BStatus;
import javax.baja.status.BStatusEnum;
import javax.baja.sys.BComplex;
import javax.baja.sys.BComponent;
import javax.baja.sys.BDynamicEnum;
import javax.baja.sys.BEnum;
import javax.baja.sys.BEnumRange;
import javax.baja.sys.BFacets;
import javax.baja.sys.BLink;
import javax.baja.sys.BValue;
import javax.baja.sys.Context;
import javax.baja.sys.LocalizableRuntimeException;
import javax.baja.sys.Property;
import javax.baja.sys.Slot;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;

@NiagaraType
@NiagaraProperties(value={@NiagaraProperty(name="enabled", type="boolean", defaultValue="true"), @NiagaraProperty(name="unid", type="int", defaultValue="0", flags=69), @NiagaraProperty(name="doorModeStatus", type="BDoorModeStatus", defaultValue="new BDoorModeStatus()"), @NiagaraProperty(name="defaultDoorMode", type="BNACDoorModeTypeEnum", defaultValue="BNACDoorModeTypeEnum.cardOnly", facets={@Facet(value="BFacets.make(BFacets.FIELD_EDITOR, \"workbench:LimitedFrozenEnumFE\")")}), @NiagaraProperty(name="exemptFromGlobalLockdown", type="boolean", defaultValue="false"), @NiagaraProperty(name="exemptFromGlobalEmergencyUnlock", type="boolean", defaultValue="false"), @NiagaraProperty(name="denyDuressTransactions", type="boolean", defaultValue="false"), @NiagaraProperty(name="overrideSchedule", type="BStatusEnum", defaultValue="new BStatusEnum(BDynamicEnum.DEFAULT, BStatus.nullStatus)", flags=-2147483648, facets={@Facet(name="BFacets.FIELD_EDITOR", value="\"nacDriver:NACDoorModeScheduleLinkFE\"")})})
public class BNACDoor
extends BAbstractDoor
implements BINACMappable {
    public static final Property enabled = BNACDoor.newProperty((int)0, (boolean)true, null);
    public static final Property unid = BNACDoor.newProperty((int)69, (int)0, null);
    public static final Property doorModeStatus = BNACDoor.newProperty((int)0, (BValue)new BDoorModeStatus(), null);
    public static final Property defaultDoorMode = BNACDoor.newProperty((int)0, (BValue)BNACDoorModeTypeEnum.cardOnly, (BFacets)BFacets.make((String)"fieldEditor", (String)"workbench:LimitedFrozenEnumFE"));
    public static final Property exemptFromGlobalLockdown = BNACDoor.newProperty((int)0, (boolean)false, null);
    public static final Property exemptFromGlobalEmergencyUnlock = BNACDoor.newProperty((int)0, (boolean)false, null);
    public static final Property denyDuressTransactions = BNACDoor.newProperty((int)0, (boolean)false, null);
    public static final Property overrideSchedule = BNACDoor.newProperty((int)Integer.MIN_VALUE, (BValue)new BStatusEnum((BEnum)BDynamicEnum.DEFAULT, BStatus.nullStatus), (BFacets)BFacets.make((String)"fieldEditor", (String)"nacDriver:NACDoorModeScheduleLinkFE"));
    public static final Type TYPE = Sys.loadType(BNACDoor.class);
    private final AtomicBoolean taskInQueue = new AtomicBoolean(false);
    private int pendingUse = 0;

    @Override
    public boolean getEnabled() {
        return this.getBoolean(enabled);
    }

    public void setEnabled(boolean v) {
        this.setBoolean(enabled, v, null);
    }

    @Override
    public int getUnid() {
        return this.getInt(unid);
    }

    public void setUnid(int v) {
        this.setInt(unid, v, null);
    }

    public BDoorModeStatus getDoorModeStatus() {
        return (BDoorModeStatus)this.get(doorModeStatus);
    }

    public void setDoorModeStatus(BDoorModeStatus v) {
        this.set(doorModeStatus, (BValue)v, null);
    }

    public BNACDoorModeTypeEnum getDefaultDoorMode() {
        return (BNACDoorModeTypeEnum)this.get(defaultDoorMode);
    }

    public void setDefaultDoorMode(BNACDoorModeTypeEnum v) {
        this.set(defaultDoorMode, (BValue)v, null);
    }

    public boolean getExemptFromGlobalLockdown() {
        return this.getBoolean(exemptFromGlobalLockdown);
    }

    public void setExemptFromGlobalLockdown(boolean v) {
        this.setBoolean(exemptFromGlobalLockdown, v, null);
    }

    public boolean getExemptFromGlobalEmergencyUnlock() {
        return this.getBoolean(exemptFromGlobalEmergencyUnlock);
    }

    public void setExemptFromGlobalEmergencyUnlock(boolean v) {
        this.setBoolean(exemptFromGlobalEmergencyUnlock, v, null);
    }

    public boolean getDenyDuressTransactions() {
        return this.getBoolean(denyDuressTransactions);
    }

    public void setDenyDuressTransactions(boolean v) {
        this.setBoolean(denyDuressTransactions, v, null);
    }

    public BStatusEnum getOverrideSchedule() {
        return (BStatusEnum)this.get(overrideSchedule);
    }

    public void setOverrideSchedule(BStatusEnum v) {
        this.set(overrideSchedule, (BValue)v, null);
    }

    public Type getType() {
        return TYPE;
    }

    protected ArrayList<Integer> getDoorModeOrdinalsToRemove() {
        return new ArrayList<Integer>();
    }

    @Override
    public void storeMapping(int unid) {
        this.setUnid(unid);
        this.getNACNetwork().storeMapping(unid, this.getHandle());
    }

    public Object fw(int x, Object a, Object b, Object c, Object d) {
        if (x == 11) {
            this.fwStarted();
        }
        return super.fw(x, a, b, c, d);
    }

    private void fwStarted() {
        BEnumRange range = this.getNACDevice().getDoorModeRange();
        int[] ordinals = range.getOrdinals();
        ArrayList<Integer> ordinalsToRemove = this.getDoorModeOrdinalsToRemove();
        int[] defaultDoorModeOrdinals = Arrays.stream(ordinals).filter(ordinal -> !ordinalsToRemove.contains(ordinal)).toArray();
        String[] defaultDoorModeTags = (String[])Arrays.stream(defaultDoorModeOrdinals).mapToObj(ordinal -> SlotPath.escape((String)range.getDisplayTag(ordinal, null))).toArray(String[]::new);
        this.setFacets((Slot)defaultDoorMode, BFacets.make((BFacets)this.getSlotFacets((Slot)defaultDoorMode), (BFacets)BFacets.make((String)"range", (BIDataValue)BEnumRange.make((int[])defaultDoorModeOrdinals, (String[])defaultDoorModeTags))));
    }

    @Override
    public void addToServer(boolean partOfSync) {
    }

    @Override
    public void syncToServer() {
        Runnable r = () -> {
            this.syncServerName();
            this.syncDoor();
            this.syncRemoveLinkFromDoor();
            this.updateValue();
        };
        Utils.runSyncToServer(this.getNACNetwork(), this.taskInQueue, r, 1000L);
    }

    public String getServerDisplayName(Context cx) {
        return this.getNACDevice().getDisplayName(cx) + " " + this.getDisplayName(cx);
    }

    public void syncServerName() {
        AccessController.doPrivileged(() -> {
            NACRequestUtils.syncDeviceName(this.getNACNetwork(), String.valueOf(this.getUnid()), this.getServerDisplayName(null));
            return null;
        });
    }

    private void syncDoor() {
        this.getNACNetwork().postAsync(() -> {
            if (this.getUnid() == 0) {
                return;
            }
            String uri = "/dev/update/" + this.getUnid();
            NACServerTokenRequest request = AccessController.doPrivileged(() -> new NACServerTokenRequest(this.getNACNetwork().getHttpConfig().getAddress(), "GET", uri, this.getNACNetwork().getSessionToken()));
            try {
                String body = this.getDoorSyncBody();
                request.addHeader("Content-Type", "application/x-www-form-urlencoded;charset=UTF-8", true);
                request.setData(body);
                this.getNACNetwork().sendHttpRequest(request);
            }
            catch (Exception e) {
                Utils.logException(this.getNACNetwork().log(), e, Level.WARNING);
            }
        });
    }

    private void syncRemoveLinkFromDoor() {
        this.getNACNetwork().postAsync(() -> {
            if (this.getUnid() == 0 || this.checkIsLinkValid(this)) {
                return;
            }
            AccessController.doPrivileged(() -> {
                try {
                    this.removeAllLinkSFromDoor();
                }
                catch (Exception e) {
                    Utils.logException(this.getNACNetwork().log(), e, Level.WARNING);
                }
                return null;
            });
        });
    }

    private void removeAllLinkSFromDoor() throws Exception {
        JSONArray templatedPolicies;
        Utils.checkNACPermission();
        JSONObject doorInstance = this.getInstanceFromServer(String.valueOf(this.getUnid()), "dev");
        if (!doorInstance.isEmpty() && doorInstance.has("templatedPolicies") && (templatedPolicies = doorInstance.getJSONArray("templatedPolicies")).length() > 0) {
            for (int i = 0; i < templatedPolicies.length(); ++i) {
                JSONObject templatePolicy = templatedPolicies.getJSONObject(i);
                StringBuilder stringBody = new StringBuilder();
                this.appendDeleteDoorMappedWithScheduleStringBody(stringBody, templatePolicy);
                try {
                    BNACDoor.deleteDoorMappingFromSchedule(stringBody.toString(), this.getNACNetwork());
                    continue;
                }
                catch (NCommException e) {
                    if (e.getMessage().startsWith("Error 503")) {
                        // empty if block
                    }
                    Utils.logException(this.getNACNetwork().log(), (Exception)((Object)e), Level.WARNING);
                    continue;
                }
                catch (Exception e) {
                    Utils.logException(this.getNACNetwork().log(), e, Level.WARNING);
                }
            }
        }
    }

    private static JSONObject deleteDoorMappingFromSchedule(String body, BNACNetwork nacNetwork) throws Exception {
        try {
            return AccessController.doPrivileged(() -> NACRequestUtils.executeMultiDbChangePublic(body, nacNetwork));
        }
        catch (PrivilegedActionException pae) {
            throw pae.getException();
        }
    }

    private void appendDeleteDoorMappedWithScheduleStringBody(StringBuilder stringBody, JSONObject templatePolicy) {
        JSONObject owner;
        if (templatePolicy.has("ownerDev") && templatePolicy.has("sched") && (owner = templatePolicy.getJSONObject("ownerDev")).getInt("unid") == this.getUnid()) {
            stringBody.append("devUpdate").append("[").append(0).append("]").append(".id=").append(this.getUnid());
            stringBody.append("&").append("devUpdate").append("[").append(0).append("]").append(".unid=").append(this.getUnid());
            stringBody.append("&").append("devUpdate").append("[").append(0).append("]").append(".templatedPolicies[").append(0).append("].id=").append(templatePolicy.getInt("unid"));
            stringBody.append("&").append("devUpdate").append("[").append(0).append("]").append(".templatedPolicies[").append(0).append("].unid=").append(templatePolicy.getInt("unid"));
            stringBody.append("&").append("devUpdate").append("[").append(0).append("]").append(".templatedPolicies[").append(0).append("].deleted=").append(true);
        }
    }

    private JSONObject getInstanceFromServer(String uuid, String objectName) throws Exception {
        try {
            return NACRequestUtils.showResource(this.getNACNetwork(), objectName, uuid, 0).getJSONObject("instance");
        }
        catch (NCommException e) {
            if (e.getMessage().startsWith("Error 404")) {
                return null;
            }
            throw new RuntimeException(e);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    protected String getDoorSyncBody() throws Exception {
        return "enabled=" + this.getEnabled() + "&doorConfig.ignoreParentEmergencyStaticStateLocked=" + this.getExemptFromGlobalLockdown() + "&doorConfig.ignoreParentEmergencyStaticStateUnlocked=" + this.getExemptFromGlobalEmergencyUnlock() + "&doorConfig.denyDuress=" + this.getDenyDuressTransactions() + "&doorConfig.accessGrantedDoorUseTracking=2&doorConfig.apbConfig.apbTimed=&doorConfig.apbConfig.apbMethod=&" + NACDefaultDoorMode.getDoorModeBody(this.getDefaultDoorMode().getOrdinal());
    }

    public BNACNetwork getNACNetwork() {
        return Utils.getNACNetwork((BComponent)this);
    }

    public BNACDevice getNACDevice() {
        return Utils.getNACDevice((BComponent)this);
    }

    public void changed(Property property, Context context) {
        if (!this.isRunning() || context != null && context.equals(Context.decoding)) {
            return;
        }
        if (property.equals(doorModeStatus)) {
            return;
        }
        if (property.equals(unid) && this.getUnid() != 0) {
            BLink[] links;
            for (BLink link : links = this.getLinks((Slot)overrideSchedule)) {
                if (!link.isActive() || !link.getTargetSlot().equals((Object)overrideSchedule) || !link.getSourceSlot().equals((Object)BNACDoorModeSchedule.out)) continue;
                try {
                    Property linkProperty = link.getPropertyInParent();
                    this.doorMappingWithEnumSchedule(linkProperty, context);
                }
                catch (Exception e) {
                    throw new RuntimeException(e);
                }
            }
        }
        this.syncToServer();
    }

    public void updateValue() {
        this.getNACNetwork().postAsync(() -> {
            try {
                JSONObject response = AccessController.doPrivileged(() -> {
                    try {
                        return NACRequestUtils.showResource(this.getNACNetwork(), "devStateRecord", String.valueOf(this.getUnid()), 1);
                    }
                    catch (Exception e) {
                        throw new RuntimeException(e);
                    }
                });
                JSONObject instance = response.getJSONObject("instance");
                JSONObject devState = instance.getJSONObject("devState");
                this.updateState(devState);
            }
            catch (Exception e) {
                Utils.logException(this.getNACNetwork().log(), e, Level.WARNING);
            }
        });
    }

    @Override
    public void updateState(JSONObject devState) {
        JSONArray array = devState.getJSONArray("devAspectStates");
        for (Object elem : array) {
            JSONObject elemJson = (JSONObject)elem;
            this.updateEachState(elemJson);
        }
    }

    public void added(Property property, Context context) {
        super.added(property, context);
        if (!this.isRunning() || context != null && context.equals(Context.decoding)) {
            return;
        }
        BValue value = this.get(property);
        if (value instanceof BNACReader) {
            this.getPointDeviceExt().addAddress(((BNACReader)value).getAddress());
            this.getPointDeviceExt().addOsdpAddress(((BNACReader)value).getOSDPAddress());
        }
        if (value instanceof BLink && ((BLink)value).isActive() && ((BLink)value).getTargetSlot().equals((Object)overrideSchedule) && ((BLink)value).getSourceSlot().equals((Object)BNACDoorModeSchedule.out)) {
            try {
                this.doorMappingWithEnumSchedule(property, context);
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }
    }

    private void doorMappingWithEnumSchedule(Property property, Context context) {
        try {
            AccessController.doPrivileged(() -> {
                this.doorMappingWithEnumSchedulePublic((BLink)this.get(property), context);
                return null;
            });
        }
        catch (RuntimeException e) {
            throw new RuntimeException(e);
        }
    }

    private void deleteDoorMappingFromEnumSchedule(Property property, Context context) {
        try {
            AccessController.doPrivileged(() -> {
                this.deleteDoorMappingFromEnumSchedulePublic((BLink)this.get(property), context);
                return null;
            });
        }
        catch (RuntimeException e) {
            throw new RuntimeException(e);
        }
    }

    public final void doorMappingWithEnumSchedulePublic(BLink enumScheduleLink, Context context) {
        if (enumScheduleLink.getSourceComponent() != null) {
            BNACDoorModeSchedule nacDoorModeSchedule = (BNACDoorModeSchedule)enumScheduleLink.getSourceComponent();
            BDoorModeMappingToScheduleJob job = new BDoorModeMappingToScheduleJob(nacDoorModeSchedule, this);
            job.submit(context);
        }
    }

    public final void deleteDoorMappingFromEnumSchedulePublic(BLink enumScheduleLink, Context context) {
        if (enumScheduleLink.getSourceComponent() != null) {
            BNACDoorModeSchedule nacDoorModeSchedule = (BNACDoorModeSchedule)enumScheduleLink.getSourceComponent();
            BDeleteScheduleLinkFromDoorJob job = new BDeleteScheduleLinkFromDoorJob(nacDoorModeSchedule, this);
            job.submit(context);
        }
    }

    protected void updateEachState(JSONObject devStateElem) {
        if (devStateElem.getInt("key") == 0) {
            if (devStateElem.getJSONObject("value").optBoolean("doorModeStale") || devStateElem.getJSONObject("value").getInt("commState") == 0) {
                this.getDoorModeStatus().setOffline(true);
                this.getDoorModeStatus().setDoorMode("");
            } else {
                JSONObject doorConfig = devStateElem.getJSONObject("value").getJSONObject("doorMode");
                Object[] doorMode = new Object[]{doorConfig.getBoolean("requireCardWithBio"), doorConfig.getBoolean("requireConfirmingPinWithCard"), doorConfig.getBoolean("emergency"), doorConfig.getBoolean("firstCredUnlock"), doorConfig.getBoolean("allowBio"), doorConfig.getBoolean("allowUniquePin"), doorConfig.getBoolean("checkCardFacilityCodeOnly"), doorConfig.getBoolean("blocked"), doorConfig.getBoolean("requireIdNumWithBio"), doorConfig.getInt("staticState"), doorConfig.getBoolean("disableRex"), doorConfig.getBoolean("allowCard"), doorConfig.getBoolean("requireConfirmingPinWithBio")};
                this.getDoorModeStatus().setOffline(false);
                String currentDoorMode = NACDefaultDoorMode.getDoorModeProperty(doorMode);
                if (currentDoorMode != null) {
                    this.getDoorModeStatus().setDoorMode(currentDoorMode);
                } else {
                    this.getDoorModeStatus().setDoorMode(this.getLexicon().get("nacDoor.unknownDoorMode"));
                }
            }
        }
    }

    public String getRecordDisplayName(Context cx) {
        return this.getServerDisplayName(cx);
    }

    public void checkRemove(Property property, Context context) {
        BValue oldValue = this.get(property);
        if (oldValue instanceof BNACReader && ((BNACReader)oldValue).getPreventRemove()) {
            throw new LocalizableRuntimeException("nacDriver", this.getLexicon().getText("accessReader.readerDeleteException"));
        }
        if (oldValue instanceof BLink && ((BLink)oldValue).isActive() && ((BLink)oldValue).getTargetSlot().equals((Object)overrideSchedule) && ((BLink)oldValue).getSourceSlot().equals((Object)BNACDoorModeSchedule.out)) {
            try {
                this.deleteDoorMappingFromEnumSchedule(property, context);
            }
            catch (Exception e) {
                throw new LocalizableRuntimeException("nacDriver", "door.mapping.schedule.error.message");
            }
        }
    }

    private boolean checkIsLinkValid(BNACDoor nacDoor) {
        BLink[] links;
        for (BLink link : links = nacDoor.getLinks((Slot)overrideSchedule)) {
            if (!link.isActive() || !link.getTargetSlot().equals((Object)overrideSchedule) || !link.getSourceSlot().equals((Object)BNACDoorModeSchedule.out)) continue;
            return true;
        }
        return false;
    }

    public void removed(Property property, BValue oldValue, Context context) {
        if (oldValue instanceof BNACReader) {
            AccessController.doPrivileged(() -> {
                BNACReader reader = (BNACReader)oldValue;
                reader.deleteFromServer(this.getNACNetwork());
                this.getPointDeviceExt().removeAddress(reader.getAddress());
                this.getPointDeviceExt().removeOsdpAddress(reader.getOSDPAddress());
                reader.getBeeper().deleteFromServer(this.getNACNetwork());
                reader.getGreenLed().deleteFromServer(this.getNACNetwork());
                reader.getRedLed().deleteFromServer(this.getNACNetwork());
                return null;
            });
        }
        if (oldValue instanceof BLink && ((BLink)oldValue).isActive() && ((BLink)oldValue).getTargetSlot().equals((Object)overrideSchedule) && ((BLink)oldValue).getSourceSlot().equals((Object)BNACDoorModeSchedule.out)) {
            System.out.println("Remove called for link");
        }
    }

    public void checkAdd(String name, BValue value, int flags, BFacets facets, Context context) {
        if (value instanceof BNACReader && ((BNACReader[])this.getChildren(BNACReader.class)).length > 0) {
            throw new LocalizableRuntimeException("nacDriver", "door.oneReaderPerDoor");
        }
    }

    public BNACPointDeviceExt getPointDeviceExt() {
        for (BComplex parent = this.getParent(); parent != null; parent = parent.getParent()) {
            if (!(parent instanceof BNACPointDeviceExt)) continue;
            return (BNACPointDeviceExt)parent;
        }
        return null;
    }

    public BNACReader getReader() {
        BNACReader[] readers = (BNACReader[])this.getChildren(BNACReader.class);
        if (readers.length == 0) {
            return null;
        }
        return readers[0];
    }

    public String getDescription(Context cx) {
        return this.getServerDisplayName(cx);
    }

    public String getDeviceDisplayName(Context cx) {
        BNACDevice device = Utils.getNACDevice((BComponent)this);
        if (device != null) {
            return device.getDisplayName(cx);
        }
        return "";
    }

    public int getPendingUse() {
        return this.pendingUse;
    }

    public void setPendingUse(int pendingUse) {
        this.pendingUse = pendingUse;
    }

    public void updatePendingUse(int pendingUse) {
        this.pendingUse = pendingUse;
    }

    public String getStatusString(Context cx) {
        return this.getDoorModeStatus().toString(cx);
    }

    public String getAddToServerBody() {
        return null;
    }

    @Override
    public void cleanDeviceUnids() {
        this.setUnid(0);
    }
}

