/*
 * Decompiled with CFR 0.152.
 */
package com.tridiumx.nacDriver.doors;

import com.tridium.json.JSONArray;
import com.tridium.json.JSONObject;
import com.tridiumx.nacDriver.doors.BNACDoor;
import com.tridiumx.nacDriver.doors.BNACDoorManualCommands;
import com.tridiumx.nacDriver.doors.BNACExitDoor;
import com.tridiumx.nacDriver.doors.BNACReader;
import com.tridiumx.nacDriver.enums.BDoorStrikeReleaseModeEnum;
import com.tridiumx.nacDriver.enums.BNACDoorModeTypeEnum;
import com.tridiumx.nacDriver.point.BNACDevicePoint;
import com.tridiumx.nacDriver.point.BNACProxyExt;
import com.tridiumx.nacDriver.point.BNACSensorPoint;
import com.tridiumx.nacDriver.point.BNACStrikePoint;
import com.tridiumx.nacDriver.util.NACRequestUtils;
import java.security.AccessController;
import java.util.ArrayList;
import javax.baja.data.BIDataValue;
import javax.baja.nre.annotations.Facet;
import javax.baja.nre.annotations.NiagaraAction;
import javax.baja.nre.annotations.NiagaraProperties;
import javax.baja.nre.annotations.NiagaraProperty;
import javax.baja.nre.annotations.NiagaraType;
import javax.baja.status.BStatus;
import javax.baja.status.BStatusBoolean;
import javax.baja.status.BStatusValue;
import javax.baja.sys.Action;
import javax.baja.sys.BComplex;
import javax.baja.sys.BDynamicEnum;
import javax.baja.sys.BEnumRange;
import javax.baja.sys.BFacets;
import javax.baja.sys.BInteger;
import javax.baja.sys.BValue;
import javax.baja.sys.Context;
import javax.baja.sys.IPropertyValidator;
import javax.baja.sys.LocalizableRuntimeException;
import javax.baja.sys.Property;
import javax.baja.sys.Slot;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.sys.Validatable;
import javax.baja.units.BUnit;

@NiagaraType
@NiagaraProperties(value={@NiagaraProperty(name="strikeTime", type="int", defaultValue="5", facets={@Facet(name="BFacets.MIN", value="0"), @Facet(name="BFacets.UNITS", value="BUnit.getUnit(\"second\")")}), @NiagaraProperty(name="heldOpenAlarmTime", type="int", defaultValue="30", facets={@Facet(name="BFacets.MIN", value="0"), @Facet(name="BFacets.UNITS", value="BUnit.getUnit(\"second\")")}), @NiagaraProperty(name="minimumStrikeTime", type="int", defaultValue="0", facets={@Facet(name="BFacets.MIN", value="0"), @Facet(name="BFacets.UNITS", value="BUnit.getUnit(\"second\")")}), @NiagaraProperty(name="activateStrikeOnRex", type="boolean", defaultValue="true"), @NiagaraProperty(name="reLockOn", type="BDoorStrikeReleaseModeEnum", defaultValue="BDoorStrikeReleaseModeEnum.endOfStrikeTime"), @NiagaraProperty(name="sensor", type="BNACSensorPoint", defaultValue="new BNACSensorPoint(false)"), @NiagaraProperty(name="exitRequest", type="BNACSensorPoint", defaultValue="new BNACSensorPoint(true)"), @NiagaraProperty(name="strike", type="BNACStrikePoint", defaultValue="new BNACStrikePoint()"), @NiagaraProperty(name="doorForced", type="BNACDevicePoint", defaultValue="new BNACDevicePoint()"), @NiagaraProperty(name="doorHeldOpen", type="BNACDevicePoint", defaultValue="new BNACDevicePoint()"), @NiagaraProperty(name="suppressRexEvents", type="boolean", defaultValue="true"), @NiagaraProperty(name="manualCommandActionDefaultParameter", type="BNACDoorManualCommands", defaultValue="new BNACDoorManualCommands()", flags=5)})
@NiagaraAction(name="manualCommand", parameterType="BNACDoorManualCommands", defaultValue="new BNACDoorManualCommands()")
public class BNACAccessDoor
extends BNACDoor
implements IPropertyValidator {
    public static final Property strikeTime = BNACAccessDoor.newProperty((int)0, (int)5, (BFacets)BFacets.make((BFacets)BFacets.make((String)"min", (int)0), (BFacets)BFacets.make((String)"units", (BIDataValue)BUnit.getUnit((String)"second"))));
    public static final Property heldOpenAlarmTime = BNACAccessDoor.newProperty((int)0, (int)30, (BFacets)BFacets.make((BFacets)BFacets.make((String)"min", (int)0), (BFacets)BFacets.make((String)"units", (BIDataValue)BUnit.getUnit((String)"second"))));
    public static final Property minimumStrikeTime = BNACAccessDoor.newProperty((int)0, (int)0, (BFacets)BFacets.make((BFacets)BFacets.make((String)"min", (int)0), (BFacets)BFacets.make((String)"units", (BIDataValue)BUnit.getUnit((String)"second"))));
    public static final Property activateStrikeOnRex = BNACAccessDoor.newProperty((int)0, (boolean)true, null);
    public static final Property reLockOn = BNACAccessDoor.newProperty((int)0, (BValue)BDoorStrikeReleaseModeEnum.endOfStrikeTime, null);
    public static final Property sensor = BNACAccessDoor.newProperty((int)0, (BValue)new BNACSensorPoint(false), null);
    public static final Property exitRequest = BNACAccessDoor.newProperty((int)0, (BValue)new BNACSensorPoint(true), null);
    public static final Property strike = BNACAccessDoor.newProperty((int)0, (BValue)new BNACStrikePoint(), null);
    public static final Property doorForced = BNACAccessDoor.newProperty((int)0, (BValue)new BNACDevicePoint(), null);
    public static final Property doorHeldOpen = BNACAccessDoor.newProperty((int)0, (BValue)new BNACDevicePoint(), null);
    public static final Property suppressRexEvents = BNACAccessDoor.newProperty((int)0, (boolean)true, null);
    public static final Property manualCommandActionDefaultParameter = BNACAccessDoor.newProperty((int)5, (BValue)new BNACDoorManualCommands(), null);
    public static final Action manualCommand = BNACAccessDoor.newAction((int)0, (BValue)new BNACDoorManualCommands(), null);
    public static final Type TYPE = Sys.loadType(BNACAccessDoor.class);

    public int getStrikeTime() {
        return this.getInt(strikeTime);
    }

    public void setStrikeTime(int v) {
        this.setInt(strikeTime, v, null);
    }

    public int getHeldOpenAlarmTime() {
        return this.getInt(heldOpenAlarmTime);
    }

    public void setHeldOpenAlarmTime(int v) {
        this.setInt(heldOpenAlarmTime, v, null);
    }

    public int getMinimumStrikeTime() {
        return this.getInt(minimumStrikeTime);
    }

    public void setMinimumStrikeTime(int v) {
        this.setInt(minimumStrikeTime, v, null);
    }

    public boolean getActivateStrikeOnRex() {
        return this.getBoolean(activateStrikeOnRex);
    }

    public void setActivateStrikeOnRex(boolean v) {
        this.setBoolean(activateStrikeOnRex, v, null);
    }

    public BDoorStrikeReleaseModeEnum getReLockOn() {
        return (BDoorStrikeReleaseModeEnum)this.get(reLockOn);
    }

    public void setReLockOn(BDoorStrikeReleaseModeEnum v) {
        this.set(reLockOn, (BValue)v, null);
    }

    public BNACSensorPoint getSensor() {
        return (BNACSensorPoint)this.get(sensor);
    }

    public void setSensor(BNACSensorPoint v) {
        this.set(sensor, (BValue)v, null);
    }

    public BNACSensorPoint getExitRequest() {
        return (BNACSensorPoint)this.get(exitRequest);
    }

    public void setExitRequest(BNACSensorPoint v) {
        this.set(exitRequest, (BValue)v, null);
    }

    public BNACStrikePoint getStrike() {
        return (BNACStrikePoint)this.get(strike);
    }

    public void setStrike(BNACStrikePoint v) {
        this.set(strike, (BValue)v, null);
    }

    public BNACDevicePoint getDoorForced() {
        return (BNACDevicePoint)this.get(doorForced);
    }

    public void setDoorForced(BNACDevicePoint v) {
        this.set(doorForced, (BValue)v, null);
    }

    public BNACDevicePoint getDoorHeldOpen() {
        return (BNACDevicePoint)this.get(doorHeldOpen);
    }

    public void setDoorHeldOpen(BNACDevicePoint v) {
        this.set(doorHeldOpen, (BValue)v, null);
    }

    public boolean getSuppressRexEvents() {
        return this.getBoolean(suppressRexEvents);
    }

    public void setSuppressRexEvents(boolean v) {
        this.setBoolean(suppressRexEvents, v, null);
    }

    public BNACDoorManualCommands getManualCommandActionDefaultParameter() {
        return (BNACDoorManualCommands)this.get(manualCommandActionDefaultParameter);
    }

    public void setManualCommandActionDefaultParameter(BNACDoorManualCommands v) {
        this.set(manualCommandActionDefaultParameter, (BValue)v, null);
    }

    public void manualCommand(BNACDoorManualCommands parameter) {
        this.invoke(manualCommand, (BValue)parameter, null);
    }

    @Override
    public Type getType() {
        return TYPE;
    }

    @Override
    public Object fw(int x, Object a, Object b, Object c, Object d) {
        if (x == 11) {
            this.fwStarted();
        }
        return super.fw(x, a, b, c, d);
    }

    private void fwStarted() {
        this.updateReaderLEDs();
    }

    @Override
    protected ArrayList<Integer> getDoorModeOrdinalsToRemove() {
        ArrayList<Integer> ordinalsToRemove = new ArrayList<Integer>();
        ordinalsToRemove.add(8);
        ordinalsToRemove.add(9);
        return ordinalsToRemove;
    }

    public void syncChildren(JSONObject instance) throws Exception {
        if (instance == null) {
            instance = NACRequestUtils.showResource(this.getNACNetwork(), "dev", String.valueOf(this.getUnid()), 3).getJSONObject("instance");
        }
        JSONArray logicalChildren = instance.getJSONArray("logicalChildren");
        for (Object child : logicalChildren) {
            JSONObject childJson = (JSONObject)child;
            if (childJson.getString("type").equals("Actuator")) {
                this.syncActuatorChild(childJson);
                continue;
            }
            if (childJson.getString("type").equals("Door")) {
                BNACExitDoor exitDoor = this.getExit();
                if (exitDoor == null) continue;
                exitDoor.storeMapping(childJson.getInt("unid"));
                exitDoor.syncChildren(null);
                exitDoor.syncToServer();
                continue;
            }
            if (childJson.getString("type").equals("Sensor")) {
                this.syncSensorChild(childJson);
                continue;
            }
            if (!childJson.getString("type").equals("CredReader")) continue;
            BNACReader reader = ((BNACReader[])this.getChildren(BNACReader.class))[0];
            reader.storeMapping(childJson.getInt("unid"));
            reader.syncToServer();
        }
    }

    private void syncSensorChild(JSONObject child) {
        if (child.getString("name").endsWith("Door Contact")) {
            this.getSensor().storeMapping(child.getInt("unid"));
            this.getSensor().syncToServer();
        } else if (child.getString("name").endsWith("REX")) {
            this.getExitRequest().storeMapping(child.getInt("unid"));
            this.getExitRequest().syncToServer();
        }
    }

    private void syncActuatorChild(JSONObject child) {
        if (child.getString("name").endsWith("Door Strike")) {
            this.getStrike().storeMapping(child.getInt("unid"));
            this.getStrike().syncToServer();
        } else if (child.getString("name").endsWith("Reader LED (Green)")) {
            this.getReader().getGreenLed().storeMapping(child.getInt("unid"));
            this.getReader().getGreenLed().syncToServer();
        } else if (child.getString("name").endsWith("Reader LED (Red)")) {
            this.getReader().getRedLed().storeMapping(child.getInt("unid"));
            this.getReader().getRedLed().syncToServer();
        } else if (child.getString("name").endsWith("Reader Beeper")) {
            this.getReader().getBeeper().storeMapping(child.getInt("unid"));
            this.getReader().getBeeper().syncToServer();
        }
    }

    @Override
    public void syncServerName() {
        super.syncServerName();
        if (this.getExit() != null) {
            this.getExit().syncServerName();
        }
    }

    public void doManualCommand(BNACDoorManualCommands commands, Context cx) {
        int durationInMinutes = commands.getDurationInMinutes();
        Boolean untilCancelled = commands.getUntilCancelled();
        if (this.getEnabled()) {
            String accessModeTypeValue = commands.getCommand().getOrdinal() == 1 ? "RESET" : String.valueOf(commands.getAccessMode().getOrdinal());
            try {
                AccessController.doPrivileged(() -> {
                    try {
                        NACRequestUtils.setDoorManualCommands(this.getNACNetwork(), accessModeTypeValue, durationInMinutes, String.valueOf(this.getUnid()), untilCancelled);
                        return null;
                    }
                    catch (Exception e) {
                        throw new RuntimeException(e);
                    }
                });
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }
    }

    public BValue getActionParameterDefault(Action action) {
        if (action.equals(manualCommand)) {
            BNACDoorManualCommands commands = this.getManualCommandActionDefaultParameter();
            commands.setCommand(BDynamicEnum.make((int)0, (BEnumRange)commands.getCommand().getRange()));
            commands.setAccessMode(BNACDoorModeTypeEnum.DEFAULT);
            commands.setFacets((Slot)BNACDoorManualCommands.accessMode, BFacets.make((String)"range", (BIDataValue)this.getNACDevice().getDoorModeRange()));
            return commands;
        }
        return super.getActionParameterDefault(action);
    }

    public void validateSet(BComplex instance, Property property, BValue newValue, Context context) {
        int strikeTimeVal = this.getStrikeTime();
        int minStrikeTimeVal = this.getMinimumStrikeTime();
        if (strikeTime.equals(property)) {
            strikeTimeVal = ((BInteger)newValue).getInt();
        }
        if (minimumStrikeTime.equals(property)) {
            minStrikeTimeVal = ((BInteger)newValue).getInt();
        }
        if (minStrikeTimeVal > strikeTimeVal) {
            throw new LocalizableRuntimeException("nacDriver", "accessDoor.minStrikeTime.strikeTime", new Object[]{minStrikeTimeVal, strikeTimeVal});
        }
    }

    public void validateSet(Validatable validatable, Context context) {
        int proposedStrikeTime = ((BInteger)validatable.getProposedValue(strikeTime)).getInt();
        int proposedMinStrikeTime = ((BInteger)validatable.getProposedValue(minimumStrikeTime)).getInt();
        if (proposedMinStrikeTime > proposedStrikeTime) {
            throw new LocalizableRuntimeException("nacDriver", "accessDoor.minStrikeTime.strikeTime", new Object[]{proposedMinStrikeTime, proposedStrikeTime});
        }
    }

    public IPropertyValidator getPropertyValidator(Property[] properties, Context context) {
        return this;
    }

    public IPropertyValidator getPropertyValidator(Property property, Context context) {
        return this;
    }

    @Override
    protected String getDoorSyncBody() throws Exception {
        return super.getDoorSyncBody() + "&doorConfig.strikeTime=" + this.getStrikeTime() * 1000 + "&doorConfig.minStrikeTime=" + this.getMinimumStrikeTime() * 1000 + "&doorConfig.heldTime=" + this.getHeldOpenAlarmTime() * 1000 + "&doorConfig.extendedHeldTime=&doorConfig.extendedStrikeTime=&doorConfig.heldPreAlarmWarnTime=&doorConfig.strikeReleaseMode=" + this.getReLockOn().getOrdinal() + "&doorConfig.activateStrikeOnRex=" + this.getActivateStrikeOnRex() + "&doorConfig.suppressRexEvt=" + this.getSuppressRexEvents() + "&";
    }

    @Override
    public void updateEachState(JSONObject devStateElem) {
        if (devStateElem.getInt("key") == 5) {
            if (devStateElem.getJSONObject("value").optBoolean("doorModeStale") || devStateElem.getJSONObject("value").optBoolean("activityStateStale")) {
                ((BNACProxyExt)this.getDoorForced().getProxyExt()).setStale(true, null);
            } else if (devStateElem.getJSONObject("value").optInt("activityState") == 0) {
                ((BNACProxyExt)this.getDoorForced().getProxyExt()).readOk((BStatusValue)new BStatusBoolean(false, BStatus.ok));
            } else {
                ((BNACProxyExt)this.getDoorForced().getProxyExt()).readOk((BStatusValue)new BStatusBoolean(true, BStatus.ok));
            }
            return;
        }
        if (devStateElem.getInt("key") == 6) {
            if (devStateElem.getJSONObject("value").optBoolean("doorModeStale") || devStateElem.getJSONObject("value").optBoolean("activityStateStale")) {
                ((BNACProxyExt)this.getDoorHeldOpen().getProxyExt()).setStale(true, null);
            } else if (devStateElem.getJSONObject("value").optInt("activityState") == 0) {
                ((BNACProxyExt)this.getDoorHeldOpen().getProxyExt()).readOk((BStatusValue)new BStatusBoolean(false, BStatus.ok));
            } else {
                ((BNACProxyExt)this.getDoorHeldOpen().getProxyExt()).readOk((BStatusValue)new BStatusBoolean(true, BStatus.ok));
            }
            return;
        }
        super.updateEachState(devStateElem);
    }

    public void updateReaderLEDs() {
        if (this.getReader() != null) {
            this.getReader().updateLEDs(this.getStrike().getOut());
        }
        if (this.getExit() != null && this.getExit().getReader() != null) {
            this.getExit().getReader().updateLEDs(this.getStrike().getOut());
        }
    }

    @Override
    public void removed(Property property, BValue oldValue, Context context) {
        if (oldValue instanceof BNACExitDoor) {
            AccessController.doPrivileged(() -> {
                BNACExitDoor door = (BNACExitDoor)oldValue;
                door.deleteFromServer(this.getNACNetwork());
                if (door.getReader() != null) {
                    BNACReader reader = door.getReader();
                    reader.deleteFromServer(this.getNACNetwork());
                    this.getPointDeviceExt().removeAddress(reader.getAddress());
                    this.getPointDeviceExt().removeOsdpAddress(reader.getOSDPAddress());
                    reader.getBeeper().deleteFromServer(this.getNACNetwork());
                    reader.getGreenLed().deleteFromServer(this.getNACNetwork());
                    reader.getRedLed().deleteFromServer(this.getNACNetwork());
                }
                return null;
            });
        }
        super.removed(property, oldValue, context);
    }

    public BNACExitDoor getExit() {
        BNACExitDoor[] exits = (BNACExitDoor[])this.getChildren(BNACExitDoor.class);
        if (exits.length == 0) {
            return null;
        }
        return exits[0];
    }

    @Override
    public void updatePendingUse(int pending) {
        super.updatePendingUse(pending);
        if (this.getExit() != null) {
            this.getExit().setPendingUse(0);
        }
    }

    @Override
    public void changed(Property property, Context context) {
        if (!this.isRunning() || context != null && context.equals(Context.decoding)) {
            return;
        }
        if (property.equals(manualCommandActionDefaultParameter)) {
            return;
        }
        super.changed(property, context);
    }
}

