/*
 * Decompiled with CFR 0.152.
 */
package com.tridiumx.nacDriver.device;

import com.tridiumx.nacDriver.BNACNetwork;
import com.tridiumx.nacDriver.device.BNACDevice;
import com.tridiumx.nacDriver.doors.BNACReader;
import com.tridiumx.nacDriver.enums.BNACReaderTypeEnum;
import java.security.AccessController;
import java.util.logging.Level;
import javax.baja.job.BSimpleJob;
import javax.baja.job.JobLogItem;
import javax.baja.nre.annotations.NiagaraType;
import javax.baja.sys.BComponent;
import javax.baja.sys.Context;
import javax.baja.sys.LocalizableRuntimeException;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;

@NiagaraType
public class BNACRefreshAllEncryptionKeyJob
extends BSimpleJob {
    public static final Type TYPE = Sys.loadType(BNACRefreshAllEncryptionKeyJob.class);
    private BNACNetwork network;
    private BNACDevice accessDevice;

    public Type getType() {
        return TYPE;
    }

    public BNACRefreshAllEncryptionKeyJob() {
    }

    public BNACRefreshAllEncryptionKeyJob(BNACDevice device) {
        this.accessDevice = device;
    }

    public void run(Context context) throws Exception {
        this.network = (BNACNetwork)Sys.getService((Type)BNACNetwork.TYPE);
        this.logMessage(this.getLexicon().getText("nacRefreshAllEncryptionKeyJob.startJob"));
        AccessController.doPrivileged(() -> {
            BNACReader[] readers;
            int totalKeysUpdated = 0;
            int totalKeysUpdateFailed = 0;
            for (BNACReader reader : readers = this.network.getReaders((BComponent)this.accessDevice)) {
                if (!reader.getReaderType().equals((Object)BNACReaderTypeEnum.osdp)) continue;
                try {
                    reader.doRefreshEncryptionKey();
                    ++totalKeysUpdated;
                }
                catch (Exception e) {
                    ++totalKeysUpdateFailed;
                    this.log().add(new JobLogItem(4, this.getLexicon().getText("nacRefreshAllEncryptionKeyJob.jobFailed", new Object[]{reader.getDisplayName(null)}), (Throwable)e));
                }
            }
            if (totalKeysUpdated > 0) {
                this.log().success(this.getLexicon().getText("nacRefreshAllEncryptionKeyJob.totalKeyUpdate", new Object[]{totalKeysUpdated}));
            }
            if (totalKeysUpdateFailed > 0) {
                this.log().failed(this.getLexicon().getText("nacRefreshAllEncryptionKeyJob.totalKeyUpdateFailed", new Object[]{totalKeysUpdateFailed}));
                throw new LocalizableRuntimeException("nacDriver", "nacRefreshAllEncryptionKeyJob.allJobFailed");
            }
            this.logMessage(this.getLexicon().getText("nacRefreshAllEncryptionKeyJob.endJob"));
            return null;
        });
    }

    private void logMessage(String message) {
        this.log().message(message);
        if (this.network != null && this.network.log().isLoggable(Level.FINE)) {
            this.network.log().log(Level.FINE, "NAC Refresh Encryption Key Job:" + message);
        }
    }
}

