/*
 * Decompiled with CFR 0.152.
 */
package com.tridiumx.nacDriver;

import javax.baja.alarm.AlarmSupport;
import javax.baja.alarm.BAlarmRecord;
import javax.baja.alarm.BAlarmSourceInfo;
import javax.baja.alarm.BIAlarmSource;
import javax.baja.data.BIDataValue;
import javax.baja.driver.BNetworkExt;
import javax.baja.nre.annotations.NiagaraAction;
import javax.baja.nre.annotations.NiagaraActions;
import javax.baja.nre.annotations.NiagaraProperties;
import javax.baja.nre.annotations.NiagaraProperty;
import javax.baja.nre.annotations.NiagaraType;
import javax.baja.status.BIStatus;
import javax.baja.status.BStatus;
import javax.baja.sys.Action;
import javax.baja.sys.BAbsTime;
import javax.baja.sys.BBoolean;
import javax.baja.sys.BFacets;
import javax.baja.sys.BString;
import javax.baja.sys.BValue;
import javax.baja.sys.Property;
import javax.baja.sys.Slot;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.util.BFormat;

@NiagaraType
@NiagaraProperties(value={@NiagaraProperty(name="enabled", type="boolean", defaultValue="true"), @NiagaraProperty(name="status", type="BStatus", defaultValue="BStatus.stale", flags=75), @NiagaraProperty(name="faultCause", type="String", defaultValue="", flags=67), @NiagaraProperty(name="lastAttempt", type="BAbsTime", defaultValue="BAbsTime.DEFAULT", flags=65), @NiagaraProperty(name="lastReplication", type="BAbsTime", defaultValue="BAbsTime.DEFAULT", flags=65), @NiagaraProperty(name="lastFailure", type="BAbsTime", defaultValue="BAbsTime.DEFAULT", flags=65), @NiagaraProperty(name="lastRetentionTime", type="BAbsTime", defaultValue="BAbsTime.DEFAULT", flags=69), @NiagaraProperty(name="threatLevelGroupOverrunAlert", type="BAlarmSourceInfo", defaultValue="initAlarmInfo()"), @NiagaraProperty(name="replicationDataInconsistentAlarm", type="BAlarmSourceInfo", defaultValue="initAlarmInfo()")})
@NiagaraActions(value={@NiagaraAction(name="clearLastReplication", flags=4), @NiagaraAction(name="ackAlarm", parameterType="BAlarmRecord", defaultValue="new BAlarmRecord()", returnType="BBoolean", flags=4)})
public class BNACReplicationNetworkExt
extends BNetworkExt
implements BIStatus,
BIAlarmSource {
    public static final Property enabled = BNACReplicationNetworkExt.newProperty((int)0, (boolean)true, null);
    public static final Property status = BNACReplicationNetworkExt.newProperty((int)75, (BValue)BStatus.stale, null);
    public static final Property faultCause = BNACReplicationNetworkExt.newProperty((int)67, (String)"", null);
    public static final Property lastAttempt = BNACReplicationNetworkExt.newProperty((int)65, (BValue)BAbsTime.DEFAULT, null);
    public static final Property lastReplication = BNACReplicationNetworkExt.newProperty((int)65, (BValue)BAbsTime.DEFAULT, null);
    public static final Property lastFailure = BNACReplicationNetworkExt.newProperty((int)65, (BValue)BAbsTime.DEFAULT, null);
    public static final Property lastRetentionTime = BNACReplicationNetworkExt.newProperty((int)69, (BValue)BAbsTime.DEFAULT, null);
    public static final Property threatLevelGroupOverrunAlert = BNACReplicationNetworkExt.newProperty((int)0, (BValue)BNACReplicationNetworkExt.initAlarmInfo(), null);
    public static final Property replicationDataInconsistentAlarm = BNACReplicationNetworkExt.newProperty((int)0, (BValue)BNACReplicationNetworkExt.initAlarmInfo(), null);
    public static final Action clearLastReplication = BNACReplicationNetworkExt.newAction((int)4, null);
    public static final Action ackAlarm = BNACReplicationNetworkExt.newAction((int)4, (BValue)new BAlarmRecord(), null);
    public static final Type TYPE = Sys.loadType(BNACReplicationNetworkExt.class);
    private AlarmSupport threatReplicationOverrunAlert;
    private AlarmSupport replicationDataInconsistentAlarmSupport;

    public boolean getEnabled() {
        return this.getBoolean(enabled);
    }

    public void setEnabled(boolean v) {
        this.setBoolean(enabled, v, null);
    }

    public BStatus getStatus() {
        return (BStatus)this.get(status);
    }

    public void setStatus(BStatus v) {
        this.set(status, (BValue)v, null);
    }

    public String getFaultCause() {
        return this.getString(faultCause);
    }

    public void setFaultCause(String v) {
        this.setString(faultCause, v, null);
    }

    public BAbsTime getLastAttempt() {
        return (BAbsTime)this.get(lastAttempt);
    }

    public void setLastAttempt(BAbsTime v) {
        this.set(lastAttempt, (BValue)v, null);
    }

    public BAbsTime getLastReplication() {
        return (BAbsTime)this.get(lastReplication);
    }

    public void setLastReplication(BAbsTime v) {
        this.set(lastReplication, (BValue)v, null);
    }

    public BAbsTime getLastFailure() {
        return (BAbsTime)this.get(lastFailure);
    }

    public void setLastFailure(BAbsTime v) {
        this.set(lastFailure, (BValue)v, null);
    }

    public BAbsTime getLastRetentionTime() {
        return (BAbsTime)this.get(lastRetentionTime);
    }

    public void setLastRetentionTime(BAbsTime v) {
        this.set(lastRetentionTime, (BValue)v, null);
    }

    public BAlarmSourceInfo getThreatLevelGroupOverrunAlert() {
        return (BAlarmSourceInfo)this.get(threatLevelGroupOverrunAlert);
    }

    public void setThreatLevelGroupOverrunAlert(BAlarmSourceInfo v) {
        this.set(threatLevelGroupOverrunAlert, (BValue)v, null);
    }

    public BAlarmSourceInfo getReplicationDataInconsistentAlarm() {
        return (BAlarmSourceInfo)this.get(replicationDataInconsistentAlarm);
    }

    public void setReplicationDataInconsistentAlarm(BAlarmSourceInfo v) {
        this.set(replicationDataInconsistentAlarm, (BValue)v, null);
    }

    public void clearLastReplication() {
        this.invoke(clearLastReplication, null, null);
    }

    public BBoolean ackAlarm(BAlarmRecord parameter) {
        return (BBoolean)this.invoke(ackAlarm, (BValue)parameter, null);
    }

    public Type getType() {
        return TYPE;
    }

    public void started() throws Exception {
        this.threatReplicationOverrunAlert = new AlarmSupport((BIAlarmSource)this, this.getThreatLevelGroupOverrunAlert());
        this.replicationDataInconsistentAlarmSupport = new AlarmSupport((BIAlarmSource)this, this.getReplicationDataInconsistentAlarm());
    }

    public void doClearLastReplication() {
        this.setLastReplication(BAbsTime.NULL);
        this.setLastRetentionTime(BAbsTime.NULL);
    }

    private static BAlarmSourceInfo initAlarmInfo() {
        BAlarmSourceInfo asi = new BAlarmSourceInfo();
        asi.setFlags((Slot)BAlarmSourceInfo.toFaultText, 4);
        asi.setFlags((Slot)BAlarmSourceInfo.toOffnormalText, 4);
        asi.setFlags((Slot)BAlarmSourceInfo.toNormalText, 4);
        asi.setFlags((Slot)BAlarmSourceInfo.sourceName, 4);
        asi.setSourceName(BFormat.make((String)"%parent.parent.displayName%"));
        return asi;
    }

    public void generateReplicationDataInconsistentAlarm(String msg, String src) {
        try {
            this.replicationDataInconsistentAlarmSupport.newAlert(BFacets.make((String)"msgText", (BIDataValue)BString.make((String)msg), (String)"sourceName", (BIDataValue)BString.make((String)src)));
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public void generateReplicationOverrunAlert(String msg, String src) {
        try {
            this.threatReplicationOverrunAlert.newAlert(BFacets.make((String)"msgText", (BIDataValue)BString.make((String)msg), (String)"sourceName", (BIDataValue)BString.make((String)src)));
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public BBoolean doAckAlarm(BAlarmRecord rec) throws Exception {
        return BBoolean.make((this.replicationDataInconsistentAlarmSupport.ackAlarm(rec) || this.threatReplicationOverrunAlert.ackAlarm(rec) ? 1 : 0) != 0);
    }
}

