/*
 * Decompiled with CFR 0.152.
 */
package com.tridiumx.nacDriver;

import com.tridium.bql.cursor.BogCursor;
import com.tridium.json.JSONArray;
import com.tridium.json.JSONObject;
import com.tridium.ndriver.BNNetwork;
import com.tridium.ndriver.comm.http.HttpComm;
import com.tridium.ndriver.comm.http.NHttpRequest;
import com.tridium.ndriver.comm.http.NHttpResponse;
import com.tridium.ndriver.datatypes.BIpAddress;
import com.tridium.ndriver.poll.BNPollScheduler;
import com.tridium.nre.security.KeyRing;
import com.tridium.nre.security.SecretBytes;
import com.tridium.nre.security.SecretChars;
import com.tridiumx.entsec.BEnterpriseSecurityService;
import com.tridiumx.entsec.orionTools.replicate.BReplicationService;
import com.tridiumx.entsec.securityUtil.monitorSysDef.BMonitorSysDefSecurity;
import com.tridiumx.entsec.threat.BThreatLevelGroupRec;
import com.tridiumx.nacDriver.BINACMappable;
import com.tridiumx.nacDriver.BNACDeviceFolder;
import com.tridiumx.nacDriver.BNACHttpCommConfig;
import com.tridiumx.nacDriver.BNACReplicationNetworkExt;
import com.tridiumx.nacDriver.BNACServerDetails;
import com.tridiumx.nacDriver.BNACThreatLevelReplicationJob;
import com.tridiumx.nacDriver.device.BNACDevice;
import com.tridiumx.nacDriver.doors.BNACDoorModeSchedules;
import com.tridiumx.nacDriver.doors.BNACReader;
import com.tridiumx.nacDriver.enums.BNACReaderEncryptionStatusEnum;
import com.tridiumx.nacDriver.enums.BNACReaderTypeEnum;
import com.tridiumx.nacDriver.event.BNACDataWorker;
import com.tridiumx.nacDriver.event.NACDevChangePoller;
import com.tridiumx.nacDriver.event.NACEventPoller;
import com.tridiumx.nacDriver.firmware.BNACFirmwareInstanceContainer;
import com.tridiumx.nacDriver.job.BUpgradeNACFirmwareJob;
import com.tridiumx.nacDriver.learn.BNACLearnDevicesJob;
import com.tridiumx.nacDriver.message.NACServerTokenRequest;
import com.tridiumx.nacDriver.replicate.BCardPinTemplate;
import com.tridiumx.nacDriver.replicate.NACReplicator;
import com.tridiumx.nacDriver.util.NACOSDPKeyRingUtils;
import com.tridiumx.nacDriver.util.NACOSDPKeyStoreUtils;
import com.tridiumx.nacDriver.util.NACRequestUtils;
import com.tridiumx.nacDriver.util.Utils;
import java.io.File;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.security.AccessController;
import java.security.KeyStore;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.logging.Level;
import javax.baja.data.BIDataValue;
import javax.baja.driver.ping.BPingMonitor;
import javax.baja.license.Feature;
import javax.baja.naming.BOrd;
import javax.baja.naming.SlotPath;
import javax.baja.nre.annotations.NiagaraAction;
import javax.baja.nre.annotations.NiagaraActions;
import javax.baja.nre.annotations.NiagaraProperties;
import javax.baja.nre.annotations.NiagaraProperty;
import javax.baja.nre.annotations.NiagaraType;
import javax.baja.nre.util.Array;
import javax.baja.security.BPassword;
import javax.baja.security.dashboard.BISecurityDashboardProvider;
import javax.baja.security.dashboard.LexiconFormatInfo;
import javax.baja.security.dashboard.SecurityDashboardItem;
import javax.baja.security.dashboard.SecurityDashboardItemBuilder;
import javax.baja.sys.Action;
import javax.baja.sys.BBoolean;
import javax.baja.sys.BComplex;
import javax.baja.sys.BComponent;
import javax.baja.sys.BDynamicEnum;
import javax.baja.sys.BFacets;
import javax.baja.sys.BRelTime;
import javax.baja.sys.BValue;
import javax.baja.sys.Context;
import javax.baja.sys.LocalizableException;
import javax.baja.sys.LocalizableRuntimeException;
import javax.baja.sys.Property;
import javax.baja.sys.Slot;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.util.BUuid;
import javax.baja.util.Lexicon;

@NiagaraType
@NiagaraProperties(value={@NiagaraProperty(name="pollScheduler", type="BNPollScheduler", defaultValue="new BNPollScheduler()"), @NiagaraProperty(name="httpConfig", type="BNACHttpCommConfig", defaultValue="new BNACHttpCommConfig()"), @NiagaraProperty(name="NACServerDetails", type="BNACServerDetails", defaultValue="new BNACServerDetails()"), @NiagaraProperty(name="syncingToServer", type="boolean", defaultValue="false", flags=3), @NiagaraProperty(name="replication", type="BNACReplicationNetworkExt", defaultValue="new BNACReplicationNetworkExt()"), @NiagaraProperty(name="NACDevChangeWorker", type="BNACDataWorker", defaultValue="new BNACDataWorker()"), @NiagaraProperty(name="NACEventWorker", type="BNACDataWorker", defaultValue="new BNACDataWorker()"), @NiagaraProperty(name="cardPinTemplate", type="BCardPinTemplate", defaultValue="new BCardPinTemplate()"), @NiagaraProperty(name="nACFirmwareInstanceContainer", type="BNACFirmwareInstanceContainer", defaultValue="new BNACFirmwareInstanceContainer()"), @NiagaraProperty(name="nacDoorModeSchedules", type="BNACDoorModeSchedules", defaultValue="new BNACDoorModeSchedules()", flags=8)})
@NiagaraActions(value={@NiagaraAction(name="authenticate"), @NiagaraAction(name="terminate"), @NiagaraAction(name="syncToServer"), @NiagaraAction(name="submitDeviceDiscoveryJob", returnType="BOrd", flags=4), @NiagaraAction(name="submitThreatLevelReplicationJob", parameterType="BThreatLevelGroupRec", defaultValue="new BThreatLevelGroupRec()", flags=4), @NiagaraAction(name="allControllerFirmwareUpdate", parameterType="BDynamicEnum", defaultValue="BDynamicEnum.DEFAULT", flags=128)})
public class BNACNetwork
extends BNNetwork
implements BISecurityDashboardProvider {
    public static final Property pollScheduler = BNACNetwork.newProperty((int)0, (BValue)new BNPollScheduler(), null);
    public static final Property httpConfig = BNACNetwork.newProperty((int)0, (BValue)new BNACHttpCommConfig(), null);
    public static final Property NACServerDetails = BNACNetwork.newProperty((int)0, (BValue)new BNACServerDetails(), null);
    public static final Property syncingToServer = BNACNetwork.newProperty((int)3, (boolean)false, null);
    public static final Property replication = BNACNetwork.newProperty((int)0, (BValue)new BNACReplicationNetworkExt(), null);
    public static final Property NACDevChangeWorker = BNACNetwork.newProperty((int)0, (BValue)new BNACDataWorker(), null);
    public static final Property NACEventWorker = BNACNetwork.newProperty((int)0, (BValue)new BNACDataWorker(), null);
    public static final Property cardPinTemplate = BNACNetwork.newProperty((int)0, (BValue)new BCardPinTemplate(), null);
    public static final Property nACFirmwareInstanceContainer = BNACNetwork.newProperty((int)0, (BValue)new BNACFirmwareInstanceContainer(), null);
    public static final Property nacDoorModeSchedules = BNACNetwork.newProperty((int)8, (BValue)new BNACDoorModeSchedules(), null);
    public static final Action authenticate = BNACNetwork.newAction((int)0, null);
    public static final Action terminate = BNACNetwork.newAction((int)0, null);
    public static final Action syncToServer = BNACNetwork.newAction((int)0, null);
    public static final Action submitDeviceDiscoveryJob = BNACNetwork.newAction((int)4, null);
    public static final Action submitThreatLevelReplicationJob = BNACNetwork.newAction((int)4, (BValue)new BThreatLevelGroupRec(), null);
    public static final Action allControllerFirmwareUpdate = BNACNetwork.newAction((int)128, (BValue)BDynamicEnum.DEFAULT, null);
    public static final Type TYPE = Sys.loadType(BNACNetwork.class);
    private SecretBytes trustStorePassword;
    private KeyStore nacKeyStoreInstance;
    private KeyRing nacKeyRingInstance;
    public static Lexicon LEX = Lexicon.make(BNACNetwork.class);
    private static ConcurrentHashMap<Integer, Object> unidHandleMap = new ConcurrentHashMap();
    private static Set<Object> serverAdditionPending = ConcurrentHashMap.newKeySet();
    private static int nextSessionId = 1;
    private BPassword sessionToken;
    private static final int SECURITY_DASHBOARD_VERSION = 1;
    private static final SecurityDashboardItemBuilder dashboardItemBuilder = new SecurityDashboardItemBuilder(TYPE);
    private final NACReplicator<?> replicator = new NACReplicator();
    private NACDevChangePoller devChangeThread;
    private NACEventPoller eventThread;
    private static final int THREAT_LEVEL_REPLICATION_BATCH_SIZE = 100;
    private final ConcurrentHashMap<BUuid, BNACThreatLevelReplicationJob> threatLevelReplicationJobs = new ConcurrentHashMap();

    public BNPollScheduler getPollScheduler() {
        return (BNPollScheduler)this.get(pollScheduler);
    }

    public void setPollScheduler(BNPollScheduler v) {
        this.set(pollScheduler, (BValue)v, null);
    }

    public BNACHttpCommConfig getHttpConfig() {
        return (BNACHttpCommConfig)this.get(httpConfig);
    }

    public void setHttpConfig(BNACHttpCommConfig v) {
        this.set(httpConfig, (BValue)v, null);
    }

    public BNACServerDetails getNACServerDetails() {
        return (BNACServerDetails)this.get(NACServerDetails);
    }

    public void setNACServerDetails(BNACServerDetails v) {
        this.set(NACServerDetails, (BValue)v, null);
    }

    public boolean getSyncingToServer() {
        return this.getBoolean(syncingToServer);
    }

    public void setSyncingToServer(boolean v) {
        this.setBoolean(syncingToServer, v, null);
    }

    public BNACReplicationNetworkExt getReplication() {
        return (BNACReplicationNetworkExt)this.get(replication);
    }

    public void setReplication(BNACReplicationNetworkExt v) {
        this.set(replication, (BValue)v, null);
    }

    public BNACDataWorker getNACDevChangeWorker() {
        return (BNACDataWorker)this.get(NACDevChangeWorker);
    }

    public void setNACDevChangeWorker(BNACDataWorker v) {
        this.set(NACDevChangeWorker, (BValue)v, null);
    }

    public BNACDataWorker getNACEventWorker() {
        return (BNACDataWorker)this.get(NACEventWorker);
    }

    public void setNACEventWorker(BNACDataWorker v) {
        this.set(NACEventWorker, (BValue)v, null);
    }

    public BCardPinTemplate getCardPinTemplate() {
        return (BCardPinTemplate)this.get(cardPinTemplate);
    }

    public void setCardPinTemplate(BCardPinTemplate v) {
        this.set(cardPinTemplate, (BValue)v, null);
    }

    public BNACFirmwareInstanceContainer getNACFirmwareInstanceContainer() {
        return (BNACFirmwareInstanceContainer)this.get(nACFirmwareInstanceContainer);
    }

    public void setNACFirmwareInstanceContainer(BNACFirmwareInstanceContainer v) {
        this.set(nACFirmwareInstanceContainer, (BValue)v, null);
    }

    public BNACDoorModeSchedules getNacDoorModeSchedules() {
        return (BNACDoorModeSchedules)this.get(nacDoorModeSchedules);
    }

    public void setNacDoorModeSchedules(BNACDoorModeSchedules v) {
        this.set(nacDoorModeSchedules, (BValue)v, null);
    }

    public void authenticate() {
        this.invoke(authenticate, null, null);
    }

    public void terminate() {
        this.invoke(terminate, null, null);
    }

    public void syncToServer() {
        this.invoke(syncToServer, null, null);
    }

    public BOrd submitDeviceDiscoveryJob() {
        return (BOrd)this.invoke(submitDeviceDiscoveryJob, null, null);
    }

    public void submitThreatLevelReplicationJob(BThreatLevelGroupRec parameter) {
        this.invoke(submitThreatLevelReplicationJob, (BValue)parameter, null);
    }

    public void allControllerFirmwareUpdate(BDynamicEnum parameter) {
        this.invoke(allControllerFirmwareUpdate, (BValue)parameter, null);
    }

    public Type getType() {
        return TYPE;
    }

    public String getNetworkName() {
        return "NACNetwork";
    }

    public Type getDeviceFolderType() {
        return BNACDeviceFolder.TYPE;
    }

    public Type getDeviceType() {
        return BNACDevice.TYPE;
    }

    public final Feature getLicenseFeature() {
        return Sys.getLicenseManager().getFeature("tridium", "nacNetwork");
    }

    public void started() throws Exception {
        BPingMonitor monitor = this.getMonitor();
        monitor.setFacets((Slot)BPingMonitor.pingFrequency, BFacets.make((BFacets)monitor.getSlotFacets((Slot)BPingMonitor.pingFrequency), (String)"max", (BIDataValue)BRelTime.make((long)540000L)));
        this.linkToSysDefSecurity();
        try {
            BReplicationService repl = (BReplicationService)Sys.getService((Type)BReplicationService.TYPE);
            repl.addListener(this.replicator);
            this.instantiateKeyStore();
        }
        catch (Exception e) {
            this.configFail("ReplicationService required.");
        }
        super.started();
    }

    private void linkToSysDefSecurity() {
        String linkName;
        BEnterpriseSecurityService enterpriseSecurityService = (BEnterpriseSecurityService)Sys.getService((Type)BEnterpriseSecurityService.TYPE);
        BMonitorSysDefSecurity sysDefSecurity = enterpriseSecurityService.getMonitorSysDefSecurity();
        if (sysDefSecurity.get(linkName = "sysDefSecurityLink") == null) {
            sysDefSecurity.linkTo(linkName, (BComponent)this, (Slot)enabled, (Slot)BMonitorSysDefSecurity.hasNACSystem);
        }
    }

    public void stationStarted() throws Exception {
        super.started();
        this.doAuthenticate();
    }

    public void stopped() throws Exception {
        super.serviceStopped();
        try {
            BReplicationService repl = (BReplicationService)Sys.getService((Type)BReplicationService.TYPE);
            repl.removeListener(this.replicator);
        }
        catch (Exception e) {
            this.configFail("ReplicationService required.");
        }
        this.doTerminate();
        this.devChangeThread.shutdown();
        this.eventThread.shutdown();
    }

    public void atSteadyState() throws Exception {
        this.doSyncToServer(null);
        this.initializePolls();
        super.atSteadyState();
    }

    private void initializePolls() {
        if (this.devChangeThread == null) {
            this.devChangeThread = new NACDevChangePoller(this.getNACDevChangeWorker(), this);
        }
        this.devChangeThread.setDaemon(true);
        this.devChangeThread.start();
        if (this.eventThread == null) {
            this.eventThread = new NACEventPoller(this.getNACEventWorker(), this);
        }
        this.eventThread.setDaemon(true);
        this.eventThread.start();
    }

    public void doAuthenticate() {
        if (!AccessController.doPrivileged(() -> NACRequestUtils.authenticateToServer(this)).booleanValue()) {
            this.log().log(Level.SEVERE, "Server authentication failed");
            this.pingFail(LEX.get("server.authentication.failure"));
            return;
        }
        AccessController.doPrivileged(() -> {
            try {
                NACRequestUtils.setUnidOnCardTemplateFromNACServer(this);
                return null;
            }
            catch (Exception e) {
                this.log().log(Level.SEVERE, "Cred template creation failed");
                throw new RuntimeException(e);
            }
        });
        this.updateThreatLevelJob();
        this.ping();
    }

    private void updateThreatLevelJob() {
        for (BUuid uuid : this.threatLevelReplicationJobs.keySet()) {
            this.threatLevelReplicationJobs.remove(uuid).submit(null);
        }
    }

    public void doTerminate() {
        AccessController.doPrivileged(() -> {
            NACRequestUtils.terminateSession(this, this.sessionToken);
            return null;
        });
        this.setSessionToken(null);
        this.getNACServerDetails().setSessionTimeLeft(0);
        this.pingFail(LEX.get("connection.terminated"));
    }

    public BOrd doSubmitDeviceDiscoveryJob(Context cx) {
        return new BNACLearnDevicesJob().submit(cx);
    }

    public void doSubmitThreatLevelReplicationJob(BThreatLevelGroupRec rec, Context cx) {
        if (this.sessionToken != null) {
            new BNACThreatLevelReplicationJob(rec).submit(cx);
        } else {
            if (this.threatLevelReplicationJobs.size() >= 100) {
                this.getReplication().generateReplicationOverrunAlert(this.getLexicon().getText("nacReplicateThreatLevel.overRunAlert"), this.getNetworkName());
            }
            this.threatLevelReplicationJobs.put(rec.getUuid(), new BNACThreatLevelReplicationJob(rec));
        }
    }

    private void startRefreshMap() {
        this.log().log(Level.INFO, "NAC map refresh started");
        unidHandleMap.clear();
        serverAdditionPending.clear();
        this.fillMap((BComponent)this);
        this.log().log(Level.INFO, "NAC map refresh completed");
    }

    private void fillMap(BComponent item) {
        BComponent[] children;
        if (item instanceof BINACMappable) {
            if (((BINACMappable)item).getUnid() != 0) {
                unidHandleMap.put(((BINACMappable)item).getUnid(), item.getHandle());
                if (this.log().isLoggable(Level.FINE)) {
                    this.log().log(Level.FINE, item.getHandleOrd() + " added to unidOrd map");
                }
            } else {
                serverAdditionPending.add(item.getHandle());
                if (this.log().isLoggable(Level.FINE)) {
                    this.log().log(Level.FINE, item.getHandle() + " added to serverAdditionPending");
                }
            }
        }
        for (BComponent child : children = item.getChildComponents()) {
            this.fillMap(child);
        }
    }

    public void doSyncToServer(Context cx) {
        if (this.getSyncingToServer()) {
            this.log().log(Level.INFO, "Cannot start sync to server when previous sync in progress");
        }
        this.getAsync().post(() -> this.startSyncToServer(cx));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void startSyncToServer(Context cx) {
        block14: {
            try {
                this.setSyncingToServer(true);
                this.log().log(Level.INFO, "Starting syncing to NAC server");
                if (Thread.currentThread().getName().equals("Nre:Engine")) {
                    this.log().log(Level.WARNING, "BNACNetwork.startSyncToServer called from Nre:Engine Thread");
                }
                this.startRefreshMap();
                if (this.getStatus().isValid()) {
                    BINACMappable device;
                    for (Object handle : serverAdditionPending) {
                        device = (BINACMappable)this.getComponentSpace().findByHandle(handle);
                        if (!device.getEnabled()) continue;
                        AccessController.doPrivileged(() -> {
                            device.addToServer(true);
                            return null;
                        });
                    }
                    Iterator<Object> iterator = ((ConcurrentHashMap.KeySetView)unidHandleMap.keySet()).iterator();
                    while (iterator.hasNext()) {
                        int unid = (Integer)iterator.next();
                        try {
                            device = (BINACMappable)this.getComponentByUnid(unid, false);
                            device.syncToServer();
                        }
                        catch (Exception exception) {}
                    }
                    try {
                        JSONObject devices = AccessController.doPrivileged(() -> {
                            try {
                                return NACRequestUtils.listResources(this, "dev", 2);
                            }
                            catch (Exception e) {
                                throw new RuntimeException(e);
                            }
                        });
                        JSONArray devicesArray = devices.getJSONArray("instanceList");
                        for (Object device2 : devicesArray) {
                            int unid;
                            int devType = (Integer)((JSONObject)device2).get("devType");
                            if ((devType != 1 || !((JSONObject)device2).has("devUse")) && devType != 4 && devType != 3 && (devType != 5 || !((JSONObject)device2).has("devUse")) || unidHandleMap.containsKey(unid = ((JSONObject)device2).getInt("unid"))) continue;
                            try {
                                AccessController.doPrivileged(() -> {
                                    try {
                                        NACRequestUtils.removeDevice(this, String.valueOf(unid));
                                        return null;
                                    }
                                    catch (Exception e) {
                                        throw new RuntimeException(e);
                                    }
                                });
                            }
                            catch (Exception exception) {}
                        }
                    }
                    catch (Exception e) {
                        Utils.logException(this.log(), e, Level.WARNING, "Device removal process failed while syncing to NAC Server");
                    }
                    this.log().log(Level.INFO, "Sync to NAC Server completed");
                    break block14;
                }
                this.log().log(Level.INFO, "Cannot sync when disconnected from server");
            }
            finally {
                this.setSyncingToServer(false);
            }
        }
    }

    public void checkRemove(Property property, Context context) {
        ArrayList<String> readerPreventRemoveStatus = new ArrayList<String>();
        BValue oldValue = this.get(property);
        if (oldValue instanceof BNACDevice) {
            BNACReader[] readers;
            for (BNACReader reader : readers = this.getReaders(oldValue.asComponent())) {
                if (!reader.getPreventRemove()) continue;
                readerPreventRemoveStatus.add(reader.getDisplayName(context));
            }
        }
        if (readerPreventRemoveStatus.size() > 0) {
            throw new LocalizableRuntimeException("nacDriver", this.getLexicon().getText("accessReader.readerDeleteExceptionForDevice", new Object[]{String.join((CharSequence)", ", readerPreventRemoveStatus)}));
        }
        super.checkRemove(property, context);
    }

    public void removed(Property property, BValue oldValue, Context context) {
        if (oldValue instanceof BNACDevice) {
            AccessController.doPrivileged(() -> {
                ((BNACDevice)oldValue).deleteFromServer(this);
                return null;
            });
        }
    }

    public void doPing() {
        this.pingNACServer(false);
    }

    private void pingNACServer(boolean reAuthAttempted) {
        try {
            super.doPing();
            if (this.sessionToken == null) {
                throw new Exception("No session available to ping");
            }
            NACServerTokenRequest pingRequest = AccessController.doPrivileged(() -> new NACServerTokenRequest(this.getHttpConfig().getAddress(), "GET", "/ping", this.sessionToken));
            String response = new String(this.sendHttpRequest(pingRequest).getData());
            JSONObject responseJson = new JSONObject(response);
            this.getNACServerDetails().setSessionTimeLeft(responseJson.getInt("sessionRemainingSecs"));
            if (this.log().isLoggable(Level.FINE)) {
                this.log().log(Level.FINE, "Network ping successful");
            }
            this.pingOk();
        }
        catch (Exception e) {
            if (!reAuthAttempted && AccessController.doPrivileged(() -> NACRequestUtils.authenticateToServer(this)).booleanValue()) {
                this.pingNACServer(true);
                return;
            }
            Utils.logException(this.log(), e, Level.SEVERE, "NAC Flex Server ping failed");
            this.pingFail(LEX.get("server.ping.failure"));
        }
    }

    public void changed(Property p, Context cx) {
        super.changed(p, cx);
        if (!this.isRunning() || cx != null && cx.equals(Context.decoding)) {
            return;
        }
        if (p == status) {
            this.getHttpConfig().statusUpdate();
        }
    }

    public void renamed(Property property, String oldName, Context context) {
        super.renamed(property, oldName, context);
        BValue value = this.get(property);
        if (value instanceof BNACDevice) {
            ((BNACDevice)value).syncServerName();
        }
    }

    public NHttpResponse sendHttpRequest(NHttpRequest request) throws Exception {
        HttpComm comm = (HttpComm)this.getHttpConfig().comm();
        BIpAddress address = (BIpAddress)request.getAddress();
        address.setSessionId(this.getNextSessionId());
        return comm.sendRequest(request);
    }

    private synchronized int getNextSessionId() {
        int n = nextSessionId++;
        if (nextSessionId < 0) {
            nextSessionId = 1;
        }
        return n;
    }

    protected boolean useAutoManager() {
        return false;
    }

    public LexiconFormatInfo getSecurityDashboardSectionHeader(Context context) {
        return LexiconFormatInfo.make((Type)TYPE, (String)"securityDashboard.sectionHeader");
    }

    public BOrd getSecurityDashboardSectionHyperlinkOrd() {
        return this.getNavOrd().relativizeToSession();
    }

    public int getSecurityDashboardItemsVersion() {
        return 1;
    }

    public List<SecurityDashboardItem> getSecurityDashboardItems(Context context) {
        ArrayList<SecurityDashboardItem> items = new ArrayList<SecurityDashboardItem>();
        this.addTlsItems(items);
        this.addReaderEncryptionStatus(items);
        return items;
    }

    private void addTlsItems(List<SecurityDashboardItem> items) {
        if (this.getHttpConfig().getUseTls()) {
            items.add(dashboardItemBuilder.makeOk("securityDashboard.tlsProtocolOn.summary", "securityDashboard.tlsProtocol.description"));
        } else {
            items.add(dashboardItemBuilder.makeAlert("securityDashboard.tlsProtocolOff.summary", "securityDashboard.tlsProtocol.description"));
        }
    }

    private void addReaderEncryptionStatus(List<SecurityDashboardItem> items) {
        BNACReader[] readers;
        ArrayList<String> readersEncryptionStatus = new ArrayList<String>();
        ArrayList<String> readersOSDPUnEncryptedStatus = new ArrayList<String>();
        ArrayList<String> readersWiegandUnEncryptedStatus = new ArrayList<String>();
        for (BNACReader reader : readers = this.getReaders((BComponent)this)) {
            if (reader.getReaderType().equals((Object)BNACReaderTypeEnum.wiegand)) {
                readersWiegandUnEncryptedStatus.add(reader.getDisplayName(null));
                continue;
            }
            try {
                if (reader.getStatus().getFacets().getFacet(BNACReaderEncryptionStatusEnum.encrypted.getTag()) == BBoolean.TRUE) {
                    readersEncryptionStatus.add(reader.getDisplayName(null));
                }
                if (reader.getStatus().getFacets().getFacet(BNACReaderEncryptionStatusEnum.encryptedDefaultKey.getTag()) != BBoolean.TRUE) continue;
                readersOSDPUnEncryptedStatus.add(reader.getDisplayName(null));
            }
            catch (Exception e) {
                Utils.logException(this.getNetwork().getLogger(), e, Level.FINE);
            }
        }
        if (readersWiegandUnEncryptedStatus.size() > 0) {
            items.add(dashboardItemBuilder.makeWarning().withSummary("securityDashboard.addReaderWiegandUnEncryptionStatus.summary", new Object[]{String.join((CharSequence)", ", readersWiegandUnEncryptedStatus)}).withDescription("securityDashboard.addReaderWiegandUnEncryptionStatus.description", new Object[0]));
        }
        if (readersOSDPUnEncryptedStatus.size() > 0) {
            items.add(dashboardItemBuilder.makeAlert().withSummary("securityDashboard.addReaderOSDPUnEncryptionStatus.summary", new Object[]{String.join((CharSequence)", ", readersOSDPUnEncryptedStatus)}).withDescription("securityDashboard.addReaderOSDPUnEncryptionStatus.description", new Object[0]));
        }
        if (readersEncryptionStatus.size() > 0) {
            items.add(dashboardItemBuilder.makeOk().withSummary("securityDashboard.addReaderEncryptionStatus.summary", new Object[]{String.join((CharSequence)", ", readersEncryptionStatus)}).withDescription("securityDashboard.addReaderOSDPUnEncryptionStatus.description", new Object[0]));
        }
    }

    public BPassword getSessionToken() {
        return this.sessionToken;
    }

    public void setSessionToken(BPassword sessionToken) {
        this.sessionToken = sessionToken;
    }

    public void storeMapping(int unid, Object handle) {
        unidHandleMap.put(unid, handle);
    }

    public void removeMapping(int unid) {
        unidHandleMap.remove(unid);
    }

    public BComponent getComponentByUnid(int unid, boolean checkSyncingToServer) throws Exception {
        if (!checkSyncingToServer || !this.getSyncingToServer()) {
            Object handle = unidHandleMap.get(unid);
            if (handle == null) {
                throw new Exception("No mapping found for the unid");
            }
            return this.getComponentSpace().findByHandle(handle);
        }
        this.log().log(Level.FINE, "Cannot retrieve from map while sync in progress");
        return null;
    }

    private void instantiateKeyStore() {
        try {
            AccessController.doPrivileged(() -> {
                NACOSDPKeyStoreUtils.createBaseDirectory();
                this.nacKeyRingInstance = NACOSDPKeyRingUtils.loadKeyRing();
                this.nacKeyStoreInstance = NACOSDPKeyStoreUtils.createKeyStoreInstance();
                this.trustStorePassword = NACOSDPKeyRingUtils.getKeyFromKeyRing(this.nacKeyRingInstance);
                if (this.trustStorePassword == null) {
                    NACOSDPKeyRingUtils.saveKeyToKeyRing(this.nacKeyRingInstance);
                    this.trustStorePassword = NACOSDPKeyRingUtils.getKeyFromKeyRing(this.nacKeyRingInstance);
                }
                this.loadKeyStore(this.nacKeyStoreInstance, this.trustStorePassword);
                this.saveKeyStore(this.nacKeyStoreInstance, this.trustStorePassword);
                return null;
            });
        }
        catch (Exception e) {
            Utils.logException(this.getNetwork().getLogger(), e, Level.SEVERE, "Failed to instantiate KeyStore");
        }
    }

    public void loadKeyStore(KeyStore keyStoreInstance, SecretBytes trustStorePassword) {
        try {
            File trustStoreFile = new File(NACOSDPKeyStoreUtils.getNACBaseDirectory(), NACOSDPKeyStoreUtils.getTrustStoreName());
            try (InputStream is = trustStoreFile.exists() ? Files.newInputStream(trustStoreFile.toPath(), new OpenOption[0]) : null;
                 SecretChars secretChars = SecretChars.fromSecretBytes((SecretBytes)trustStorePassword, (Charset)StandardCharsets.UTF_8, (boolean)false);){
                keyStoreInstance.load(is, secretChars.get());
            }
        }
        catch (Exception e) {
            Utils.logException(this.getNetwork().getLogger(), e, Level.SEVERE, "Failed to load KeyStore");
        }
    }

    public void saveKeyStore(KeyStore keyStoreInstance, SecretBytes trustStorePassword) {
        try {
            File trustStoreFile = new File(NACOSDPKeyStoreUtils.getNACBaseDirectory(), NACOSDPKeyStoreUtils.getTrustStoreName());
            AccessController.doPrivileged(() -> {
                try (FileOutputStream fos = new FileOutputStream(trustStoreFile);
                     SecretChars secretChars = SecretChars.fromSecretBytes((SecretBytes)trustStorePassword, (Charset)StandardCharsets.UTF_8, (boolean)false);){
                    keyStoreInstance.store(fos, secretChars.get());
                }
                return null;
            });
        }
        catch (Exception e) {
            Utils.logException(this.getNetwork().getLogger(), e, Level.SEVERE, "Failed to save content in KeyStore");
        }
    }

    public KeyStore getKeyStoreInstance() {
        return this.nacKeyStoreInstance;
    }

    public SecretBytes getTrustStorePassword() {
        return this.trustStorePassword;
    }

    public BNACReader[] getReaders(BComponent root) {
        BogCursor cursor = new BogCursor((BComplex)root, 10, new Type[]{BNACReader.TYPE}, true, null);
        Array readers = new Array(BNACReader.class);
        while (cursor.next()) {
            readers.add((Object)((BNACReader)cursor.get()));
        }
        return (BNACReader[])readers.trim();
    }

    public BValue getActionParameterDefault(Action action) {
        if (action.equals(allControllerFirmwareUpdate)) {
            return NACRequestUtils.loadFirmwareVersionList(this);
        }
        return super.getActionParameterDefault(action);
    }

    public void doAllControllerFirmwareUpdate(BDynamicEnum firmwareList, Context cx) throws LocalizableException {
        if (firmwareList.isActive()) {
            if (this.getSessionToken() != null) {
                BNACDevice[] bnacDevices = (BNACDevice[])this.getChildren(BNACDevice.class);
                AccessController.doPrivileged(() -> {
                    int firmwareUnid = firmwareList.getOrdinal();
                    String firmwareName = SlotPath.unescape((String)firmwareList.getTag());
                    String formattedFirmwareName = firmwareName.substring(0, firmwareName.lastIndexOf("-"));
                    BUpgradeNACFirmwareJob job = new BUpgradeNACFirmwareJob(bnacDevices, firmwareUnid, formattedFirmwareName);
                    return job.submit(cx);
                });
            } else {
                this.getLogger().log(Level.SEVERE, "Server authentication failed");
            }
        } else {
            throw new LocalizableException(this.getLexicon(), "device.controller.firmware.required.error");
        }
    }

    public Enumeration<Integer> getUnidsInMap() {
        return unidHandleMap.keys();
    }
}

