/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.bacnetEde.wb;

import com.tridium.bacnet.asn.AsnConst;
import com.tridium.bacnet.asn.AsnUtil;
import com.tridium.bacnet.job.BDiscoveryPoint;
import com.tridium.bacnetEde.BEdeRecord;
import com.tridium.bacnetEde.jobs.BPointDiscoveryJob;
import com.tridium.bacnetEde.wb.BEdeBacnetPointManager;
import javax.baja.bacnet.point.BBacnetProxyExt;
import javax.baja.bacnet.util.PropertyInfo;
import javax.baja.control.BBooleanPoint;
import javax.baja.control.BBooleanWritable;
import javax.baja.control.BControlPoint;
import javax.baja.control.BEnumPoint;
import javax.baja.control.BEnumWritable;
import javax.baja.control.BNumericPoint;
import javax.baja.control.BNumericWritable;
import javax.baja.control.BStringPoint;
import javax.baja.control.BStringWritable;
import javax.baja.job.BJob;
import javax.baja.nre.util.Array;
import javax.baja.sys.BBoolean;
import javax.baja.sys.BComponent;
import javax.baja.sys.BFacets;
import javax.baja.sys.BObject;
import javax.baja.sys.Type;
import javax.baja.util.Lexicon;
import javax.baja.workbench.mgr.BAbstractManager;
import javax.baja.workbench.mgr.MgrColumn;
import javax.baja.workbench.mgr.MgrLearn;
import javax.baja.workbench.mgr.MgrTypeInfo;

public abstract class EdePointLearn
extends MgrLearn
implements AsnConst {
    static Lexicon lex = Lexicon.make((String)"bacnet");
    static String lexName = lex.getText("learn.objectName");
    static String lexObjectId = lex.getText("learn.objectId");
    static String lexPropertyId = lex.getText("pointManager.property");
    static String lexIndex = lex.getText("pointManager.index");
    static String lexValue = lex.getText("pointManager.value");
    static String lexDescription = lex.getText("pointManager.description");
    MgrColumn dcolName = new MgrColumn.Prop(lexName, BDiscoveryPoint.objectName, 0);
    MgrColumn dcolObjectId = new MgrColumn.Prop(lexObjectId, BDiscoveryPoint.objectId, 0);
    MgrColumn dcolPropertyId = new MgrColumn.Prop(lexPropertyId, BDiscoveryPoint.propertyIdentifier, 0);
    MgrColumn dcolIndex = new MgrColumn.Prop(lexIndex, BDiscoveryPoint.index, 0);
    MgrColumn dcolValue = new MgrColumn.Prop(lexValue, BDiscoveryPoint.value, 0);
    MgrColumn dcolDescription = new MgrColumn.Prop(lexDescription, BDiscoveryPoint.description, 0);
    MgrColumn[] dcols = new MgrColumn[]{this.dcolName, this.dcolObjectId, this.dcolPropertyId, this.dcolIndex, this.dcolValue, this.dcolDescription};

    public EdePointLearn(BEdeBacnetPointManager manager) {
        super((BAbstractManager)manager);
    }

    protected BDiscoveryPoint lr(Object o) {
        return (BDiscoveryPoint)o;
    }

    BPointDiscoveryJob getDiscoveryJob() {
        return (BPointDiscoveryJob)this.getJob();
    }

    protected MgrColumn[] makeColumns() {
        return this.dcols;
    }

    public void jobComplete(BJob job) {
        job.lease(1);
        Object[] root = (BDiscoveryPoint[])job.getChildren(BDiscoveryPoint.class);
        this.updateRoots(root);
    }

    public MgrTypeInfo[] toTypes(Object dis) {
        BDiscoveryPoint lr = this.lr(dis);
        Array typeList = new Array(MgrTypeInfo.class);
        int objectType = lr.getObjectId().getObjectType();
        int propId = lr.getPropertyId();
        BFacets facets = lr.getFacets();
        BObject bObject = facets.get(BEdeRecord.settable.getName());
        boolean writableFirst = false;
        if (objectType == 1 || objectType == 4 || objectType == 14 || null != bObject && bObject.getType().is(BBoolean.TYPE) && bObject.toString().equals(BBoolean.TRUE.toString())) {
            writableFirst = true;
        }
        BEdeBacnetPointManager mgr = (BEdeBacnetPointManager)this.getManager();
        PropertyInfo propInfo = mgr.getDevice().getPropertyInfo(objectType, propId);
        int asnType = -1;
        asnType = propInfo == null ? AsnUtil.getAsnType((Type)lr.getValue().getType()) : propInfo.getAsnType();
        block0 : switch (asnType) {
            case 0: {
                return null;
            }
            case 1: {
                this.addBooleanTypes((Array<MgrTypeInfo>)typeList, writableFirst);
                break;
            }
            case 2: 
            case 3: {
                this.addEnumTypes((Array<MgrTypeInfo>)typeList, writableFirst);
                this.addBooleanTypes((Array<MgrTypeInfo>)typeList, writableFirst);
                break;
            }
            case 4: 
            case 5: {
                this.addNumericTypes((Array<MgrTypeInfo>)typeList, writableFirst);
                break;
            }
            case 6: 
            case 7: 
            case 8: {
                break;
            }
            case 9: {
                if (propInfo != null && propInfo.getType().equals("bacnet:BacnetBinaryPv")) {
                    this.addBooleanTypes((Array<MgrTypeInfo>)typeList, writableFirst);
                }
                this.addEnumTypes((Array<MgrTypeInfo>)typeList, writableFirst);
                break;
            }
            case 10: 
            case 11: 
            case 12: {
                break;
            }
            case -1: {
                return null;
            }
            case -2: {
                if (lr.getPropertyArrayIndex() > 0) {
                    switch (lr.getObjectId().getObjectType()) {
                        case 1: 
                        case 2: {
                            this.addNumericTypes((Array<MgrTypeInfo>)typeList, true);
                            this.addBooleanTypes((Array<MgrTypeInfo>)typeList, true);
                            this.addEnumTypes((Array<MgrTypeInfo>)typeList, true);
                            break block0;
                        }
                        case 4: 
                        case 5: {
                            this.addBooleanTypes((Array<MgrTypeInfo>)typeList, true);
                            this.addEnumTypes((Array<MgrTypeInfo>)typeList, true);
                            this.addNumericTypes((Array<MgrTypeInfo>)typeList, true);
                            break block0;
                        }
                        case 14: 
                        case 19: {
                            this.addEnumTypes((Array<MgrTypeInfo>)typeList, true);
                            this.addNumericTypes((Array<MgrTypeInfo>)typeList, true);
                            this.addBooleanTypes((Array<MgrTypeInfo>)typeList, true);
                            break block0;
                        }
                    }
                    this.addNumericTypes((Array<MgrTypeInfo>)typeList, false);
                    this.addBooleanTypes((Array<MgrTypeInfo>)typeList, false);
                    this.addEnumTypes((Array<MgrTypeInfo>)typeList, false);
                    break;
                }
                return null;
            }
            case -3: {
                return null;
            }
        }
        this.addStringTypes((Array<MgrTypeInfo>)typeList, false);
        return (MgrTypeInfo[])typeList.trim();
    }

    void addNumericTypes(Array<MgrTypeInfo> typeList, boolean writableFirst) {
        if (writableFirst) {
            typeList.add((Object)MgrTypeInfo.make((Type)BNumericWritable.TYPE));
            typeList.add((Object)MgrTypeInfo.make((Type)BNumericPoint.TYPE));
        } else {
            typeList.add((Object)MgrTypeInfo.make((Type)BNumericPoint.TYPE));
            typeList.add((Object)MgrTypeInfo.make((Type)BNumericWritable.TYPE));
        }
    }

    void addBooleanTypes(Array<MgrTypeInfo> typeList, boolean writableFirst) {
        if (writableFirst) {
            typeList.add((Object)MgrTypeInfo.make((Type)BBooleanWritable.TYPE));
            typeList.add((Object)MgrTypeInfo.make((Type)BBooleanPoint.TYPE));
        } else {
            typeList.add((Object)MgrTypeInfo.make((Type)BBooleanPoint.TYPE));
            typeList.add((Object)MgrTypeInfo.make((Type)BBooleanWritable.TYPE));
        }
    }

    void addEnumTypes(Array<MgrTypeInfo> typeList, boolean writableFirst) {
        if (writableFirst) {
            typeList.add((Object)MgrTypeInfo.make((Type)BEnumWritable.TYPE));
            typeList.add((Object)MgrTypeInfo.make((Type)BEnumPoint.TYPE));
        } else {
            typeList.add((Object)MgrTypeInfo.make((Type)BEnumPoint.TYPE));
            typeList.add((Object)MgrTypeInfo.make((Type)BEnumWritable.TYPE));
        }
    }

    void addStringTypes(Array<MgrTypeInfo> typeList, boolean writableFirst) {
        if (writableFirst) {
            typeList.add((Object)MgrTypeInfo.make((Type)BStringWritable.TYPE));
            typeList.add((Object)MgrTypeInfo.make((Type)BStringPoint.TYPE));
        } else {
            typeList.add((Object)MgrTypeInfo.make((Type)BStringPoint.TYPE));
            typeList.add((Object)MgrTypeInfo.make((Type)BStringWritable.TYPE));
        }
    }

    public boolean isExisting(Object dis, BComponent comp) {
        BDiscoveryPoint learn = this.lr(dis);
        if (comp.getType().is(BControlPoint.TYPE)) {
            BControlPoint dbPoint = (BControlPoint)comp;
            BBacnetProxyExt ext = (BBacnetProxyExt)dbPoint.getProxyExt();
            int ndx = learn.getIndex().length() > 0 ? Integer.parseInt(learn.getIndex()) : -1;
            return ext.getObjectId().equals((Object)learn.getObjectId()) && ext.getPropertyId().getTag().equals(learn.getPropertyIdentifier()) && ext.getPropertyArrayIndex() == ndx;
        }
        return false;
    }
}

