/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.bacnetEde.wb;

import com.tridium.bacnet.stack.server.BBacnetExportFolder;
import com.tridium.bacnet.stack.server.BBacnetExportTable;
import com.tridium.bacnetEde.util.EDEUtil;
import com.tridium.file.exporters.BITableToCsv;
import java.io.PrintWriter;
import java.util.Hashtable;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.baja.alarm.ext.BAlarmSourceExt;
import javax.baja.alarm.ext.BOffnormalAlgorithm;
import javax.baja.alarm.ext.offnormal.BOutOfRangeAlgorithm;
import javax.baja.bacnet.datatypes.BBacnetObjectIdentifier;
import javax.baja.bacnet.enums.BBacnetEngineeringUnits;
import javax.baja.bacnet.export.BBacnetNotificationClassDescriptor;
import javax.baja.bacnet.export.BIBacnetCovSource;
import javax.baja.bacnet.export.BIBacnetExportObject;
import javax.baja.bacnet.export.BLocalBacnetDevice;
import javax.baja.control.BControlPoint;
import javax.baja.control.BPointExtension;
import javax.baja.control.ext.BAbstractProxyExt;
import javax.baja.file.BExporter;
import javax.baja.file.ExportOp;
import javax.baja.file.types.text.BCsvFile;
import javax.baja.naming.BOrd;
import javax.baja.nre.annotations.AgentOn;
import javax.baja.nre.annotations.Generated;
import javax.baja.nre.annotations.NiagaraProperties;
import javax.baja.nre.annotations.NiagaraProperty;
import javax.baja.nre.annotations.NiagaraType;
import javax.baja.registry.TypeInfo;
import javax.baja.status.BStatusValue;
import javax.baja.sys.BAbsTime;
import javax.baja.sys.BComponent;
import javax.baja.sys.BFacets;
import javax.baja.sys.BIcon;
import javax.baja.sys.BObject;
import javax.baja.sys.BValue;
import javax.baja.sys.NoSuchSlotException;
import javax.baja.sys.Property;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.units.BUnit;
import javax.baja.util.Lexicon;

@NiagaraType(agent={@AgentOn(types={"bacnet:BacnetExportTable"})})
@NiagaraProperties(value={@NiagaraProperty(name="projectName", type="String", defaultValue=""), @NiagaraProperty(name="versionOfReferenceFile", type="String", defaultValue=""), @NiagaraProperty(name="timestampOfLastChange", type="BAbsTime", defaultValue="BAbsTime.now()", flags=1), @NiagaraProperty(name="authorOfDocument", type="String", defaultValue=""), @NiagaraProperty(name="versionOfLayout", type="String", defaultValue="BLocalDeviceToEde.VERSION_OF_LAYOUT_DEFAULT"), @NiagaraProperty(name="limitedResources", type="String", defaultValue=""), @NiagaraProperty(name="fileDelimiter", type="String", defaultValue=",")})
public class BLocalDeviceToEde
extends BExporter {
    @Generated
    public static final Property projectName = BLocalDeviceToEde.newProperty((int)0, (String)"", null);
    @Generated
    public static final Property versionOfReferenceFile = BLocalDeviceToEde.newProperty((int)0, (String)"", null);
    @Generated
    public static final Property timestampOfLastChange = BLocalDeviceToEde.newProperty((int)1, (BValue)BAbsTime.now(), null);
    @Generated
    public static final Property authorOfDocument = BLocalDeviceToEde.newProperty((int)0, (String)"", null);
    @Generated
    public static final Property versionOfLayout = BLocalDeviceToEde.newProperty((int)0, (String)"2.1", null);
    @Generated
    public static final Property limitedResources = BLocalDeviceToEde.newProperty((int)0, (String)"", null);
    @Generated
    public static final Property fileDelimiter = BLocalDeviceToEde.newProperty((int)0, (String)",", null);
    @Generated
    public static final Type TYPE = Sys.loadType(BLocalDeviceToEde.class);
    private static final BIcon icon = BIcon.make((String)"module://bacnetEDE/res/EDE.png");
    private static final String VERSION_OF_LAYOUT_DEFAULT = "2.1";
    private static final Logger logger = Logger.getLogger("bacnet.ede.export");
    public static final Lexicon lex = Lexicon.make(BLocalDeviceToEde.class);
    public static final String HEADER_ROW_PROJ_NAME = "PROJECT_NAME";
    public static final String HEADER_ROW_VERSION = "VERSION_OF_REFERENCEFILE";
    public static final String HEADER_ROW_TIMESTAMP = "TIMESTAMP_OF_LAST_CHANGE";
    public static final String HEADER_ROW_AUTHOR = "AUTHOR_OF_LAST_CHANGE";
    public static final String HEADER_ROW_LAYOUT = "VERSION_OF_LAYOUT";
    public static final String HEADER_ROW_RESOURCES = "LIMITED_RESOURCES";
    public static final String HEADER_ROW_COLS = "#keyname,device obj.-instance,object-name,object-type,object-instance,description,present-value-default,min-present-value,max-present-value,settable,supports COV,hi-limit,low-limit,state-text-reference,unit-code,vendor-specific-address,notification-class";
    private int deviceInstanceNumber = -1;
    private String delim;
    private BITableToCsv tableToCsv = new BITableToCsv();
    private static final int TOTAL_COLS = 17;
    private static Hashtable<String, Integer> notificationClassTable = new Hashtable();
    private static Hashtable<BControlPoint, String> alarmClassTable = new Hashtable();

    @Generated
    public String getProjectName() {
        return this.getString(projectName);
    }

    @Generated
    public void setProjectName(String v) {
        this.setString(projectName, v, null);
    }

    @Generated
    public String getVersionOfReferenceFile() {
        return this.getString(versionOfReferenceFile);
    }

    @Generated
    public void setVersionOfReferenceFile(String v) {
        this.setString(versionOfReferenceFile, v, null);
    }

    @Generated
    public BAbsTime getTimestampOfLastChange() {
        return (BAbsTime)this.get(timestampOfLastChange);
    }

    @Generated
    public void setTimestampOfLastChange(BAbsTime v) {
        this.set(timestampOfLastChange, (BValue)v, null);
    }

    @Generated
    public String getAuthorOfDocument() {
        return this.getString(authorOfDocument);
    }

    @Generated
    public void setAuthorOfDocument(String v) {
        this.setString(authorOfDocument, v, null);
    }

    @Generated
    public String getVersionOfLayout() {
        return this.getString(versionOfLayout);
    }

    @Generated
    public void setVersionOfLayout(String v) {
        this.setString(versionOfLayout, v, null);
    }

    @Generated
    public String getLimitedResources() {
        return this.getString(limitedResources);
    }

    @Generated
    public void setLimitedResources(String v) {
        this.setString(limitedResources, v, null);
    }

    @Generated
    public String getFileDelimiter() {
        return this.getString(fileDelimiter);
    }

    @Generated
    public void setFileDelimiter(String v) {
        this.setString(fileDelimiter, v, null);
    }

    @Generated
    public Type getType() {
        return TYPE;
    }

    public BIcon getIcon() {
        return icon;
    }

    public TypeInfo getFileType() {
        return BCsvFile.TYPE.getTypeInfo();
    }

    public String getFileExtension() {
        return "csv";
    }

    public void export(ExportOp op) throws Exception {
        BBacnetExportTable table = (BBacnetExportTable)op.get();
        table.lease(Integer.MAX_VALUE);
        this.delim = this.getFileDelimiter();
        this.tableToCsv.setDelimiter(this.delim);
        try (PrintWriter out = new PrintWriter(op.getOutputStream());){
            this.writeHeader(out);
            this.writeDevice((BLocalBacnetDevice)table.getParent(), out);
            this.writeObjects((BComponent)table, out);
        }
    }

    private void writeHeader(PrintWriter out) {
        this.writeHeaderRow(HEADER_ROW_PROJ_NAME, this.getProjectName(), out);
        this.writeHeaderRow(HEADER_ROW_VERSION, this.getVersionOfReferenceFile(), out);
        this.writeHeaderRow(HEADER_ROW_TIMESTAMP, BAbsTime.now().toString(null), out);
        this.writeHeaderRow(HEADER_ROW_AUTHOR, this.getAuthorOfDocument(), out);
        this.writeHeaderRow(HEADER_ROW_LAYOUT, this.getVersionOfLayout(), out);
        this.writeHeaderRow(HEADER_ROW_RESOURCES, this.getLimitedResources(), out);
        out.print(HEADER_ROW_COLS);
        out.println();
        out.flush();
    }

    private void writeHeaderRow(String name, String val, PrintWriter out) {
        String tail = "";
        for (int i = 2; i < 17; ++i) {
            tail = tail + this.delim;
        }
        this.tableToCsv.printValue(name, out);
        out.print(this.delim);
        this.tableToCsv.printValue(val, out);
        out.print(this.delim);
        out.print(tail);
        out.println();
    }

    private void writeDevice(BLocalBacnetDevice device, PrintWriter out) {
        int objectType = 8;
        int objInstanceNumber = this.deviceInstanceNumber = device.getObjectId().getInstanceNumber();
        String keyName = device.getDisplayName(null);
        String objectName = device.getName();
        String description = device.getDescription();
        this.tableToCsv.printValue(keyName, out);
        out.print(this.delim);
        out.print(objInstanceNumber + this.delim);
        this.tableToCsv.printValue(objectName, out);
        out.print(this.delim);
        out.print(objectType + this.delim);
        out.print(objInstanceNumber + this.delim);
        this.tableToCsv.printValue(description, out);
        out.print(this.delim);
        out.print(this.delim + this.delim + this.delim);
        out.print("N" + this.delim + "N" + this.delim);
        out.print(this.delim + this.delim);
        out.print(this.delim);
        out.print(this.delim);
        out.print(this.delim);
        out.print(this.delim);
        out.println();
        out.flush();
    }

    private void writeObjects(BComponent exportTable, PrintWriter out) {
        BIBacnetExportObject[] children;
        for (BIBacnetExportObject child : children = (BIBacnetExportObject[])exportTable.getChildren(BIBacnetExportObject.class)) {
            if (!(child instanceof BBacnetNotificationClassDescriptor)) continue;
            BBacnetNotificationClassDescriptor nc = (BBacnetNotificationClassDescriptor)child;
            notificationClassTable.put(nc.getAlarmClass().getName(), nc.getObjectId().getInstanceNumber());
        }
        for (int i = 0; i < children.length; ++i) {
            BIBacnetExportObject obj = children[i];
            if (!obj.getType().is(BComponent.TYPE)) {
                EDEUtil.logThrowableIfFine(logger, Level.WARNING, "Found BacnetExportObject type that is not a BComponent: " + obj.toString(), null);
                continue;
            }
            if (obj.getType().is(BBacnetExportFolder.TYPE)) {
                this.writeObjects((BComponent)obj, out);
                continue;
            }
            BComponent comp = (BComponent)obj;
            if (!EDEUtil.isPoint(obj.getObjectId().getObjectType())) {
                EDEUtil.logThrowableIfFine(logger, Level.WARNING, "Not Exporting bacnet object: " + obj.getObjectId(), null);
                continue;
            }
            String keyName = comp.getDisplayName(null);
            this.tableToCsv.printValue(keyName, out);
            out.print(this.delim);
            out.print(this.deviceInstanceNumber + this.delim);
            String objectName = obj.getObjectName();
            this.tableToCsv.printValue(objectName, out);
            out.print(this.delim);
            BBacnetObjectIdentifier objectId = obj.getObjectId();
            int objectType = objectId.getObjectType();
            out.print(objectType + this.delim);
            int instanceNumber = objectId.getInstanceNumber();
            out.print(instanceNumber + this.delim);
            String desc = "";
            try {
                BValue bValue = comp.get("description");
                desc = bValue.toString();
            }
            catch (NoSuchSlotException bValue) {
                // empty catch block
            }
            this.tableToCsv.printValue(desc, out);
            out.print(this.delim);
            BOrd objectOrd = obj.getObjectOrd();
            BObject exportObj = objectOrd.get((BObject)exportTable);
            if (null != exportObj && exportObj.getType().is(BControlPoint.TYPE)) {
                boolean supportCov = obj instanceof BIBacnetCovSource;
                this.exportControlPoint(exportObj, out, objectId, supportCov);
                out.println();
                out.flush();
                continue;
            }
            for (int j = 0; j < 10; ++j) {
                out.print(this.delim);
            }
            out.println();
            out.flush();
        }
    }

    private void exportControlPoint(BObject exportPoint, PrintWriter out, BBacnetObjectIdentifier objectId, boolean supportCov) {
        BControlPoint point = (BControlPoint)exportPoint;
        BAbstractProxyExt proxyExt = point.getProxyExt();
        try {
            BValue bValue = point.get("fallback");
            if (null != bValue) {
                BValue fallbackValue = ((BStatusValue)bValue).getValueValue();
                this.tableToCsv.printValue(fallbackValue.toString(), out);
                out.print(this.delim);
            }
        }
        catch (Exception e) {
            out.print(this.delim);
        }
        String minPresentValue = this.getFacetsValue(proxyExt, "min");
        String maxPresentValue = this.getFacetsValue(proxyExt, "max");
        this.tableToCsv.printValue(minPresentValue, out);
        out.print(this.delim);
        this.tableToCsv.printValue(maxPresentValue, out);
        out.print(this.delim);
        out.print(this.getWritableValue(objectId.getObjectType()));
        if (supportCov) {
            out.print("Y" + this.delim);
        } else {
            out.print("N" + this.delim);
        }
        String limits = this.getLimits(point);
        out.print(limits);
        out.print(this.delim);
        BFacets pointFacets = proxyExt.getPointFacets();
        String unitCode = this.getUnitCode(pointFacets);
        out.print(unitCode);
        out.print(this.delim);
        String alarmClass = alarmClassTable.get(point);
        if (alarmClass != null) {
            out.print(notificationClassTable.get(alarmClass));
        } else {
            out.print(this.delim);
        }
    }

    private String getWritableValue(int objType) {
        if (1 == objType || 2 == objType || 46 == objType || 45 == objType || 48 == objType || 4 == objType || 5 == objType || 14 == objType || 19 == objType) {
            return "Y" + this.delim;
        }
        return "N" + this.delim;
    }

    private String getFacetsValue(BAbstractProxyExt proxyExt, String facetKey) {
        BFacets pointFacets;
        BObject facetVal;
        String value = "";
        if (null != proxyExt && null != (facetVal = (pointFacets = proxyExt.getPointFacets()).getFacet(facetKey))) {
            value = value + facetVal.toString();
        }
        return value;
    }

    private String getUnitCode(BFacets facets) {
        String value = this.delim;
        if (null != facets) {
            BUnit units = (BUnit)facets.getFacet("units");
            BBacnetEngineeringUnits engineeringUnits = BBacnetEngineeringUnits.make((BUnit)units);
            value = !BBacnetEngineeringUnits.noUnits.equals((Object)engineeringUnits) ? engineeringUnits.getOrdinal() + this.delim : this.delim;
        }
        return value;
    }

    private String getLimits(BControlPoint point) {
        String limits = "";
        BPointExtension[] extensions = point.getExtensions();
        for (int j = 0; j < extensions.length; ++j) {
            BPointExtension ext = extensions[j];
            if (!ext.getType().is(BAlarmSourceExt.TYPE)) continue;
            BAlarmSourceExt alarmExt = (BAlarmSourceExt)ext;
            alarmClassTable.put(point, alarmExt.getAlarmClass());
            BOffnormalAlgorithm offNorm = alarmExt.getOffnormalAlgorithm();
            if (!offNorm.getType().is(BOutOfRangeAlgorithm.TYPE)) continue;
            BOutOfRangeAlgorithm oora = (BOutOfRangeAlgorithm)offNorm;
            oora.lease();
            double highLimit = oora.getHighLimit();
            double lowLimit = oora.getLowLimit();
            limits = limits + highLimit + this.delim;
            limits = limits + lowLimit + this.delim;
            break;
        }
        if (limits.equals("")) {
            limits = this.delim + this.delim;
        }
        return limits;
    }
}

