/*
 * Decompiled with CFR 0.152.
 */
package javax.baja.ui.wizard;

import javax.baja.gx.BInsets;
import javax.baja.gx.Size;
import javax.baja.nre.annotations.Generated;
import javax.baja.nre.annotations.NiagaraType;
import javax.baja.sys.BValue;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.ui.BButton;
import javax.baja.ui.BDialog;
import javax.baja.ui.BNullWidget;
import javax.baja.ui.BSeparator;
import javax.baja.ui.BWidget;
import javax.baja.ui.Command;
import javax.baja.ui.CommandArtifact;
import javax.baja.ui.enums.BHalign;
import javax.baja.ui.enums.BOrientation;
import javax.baja.ui.event.BWindowEvent;
import javax.baja.ui.pane.BBorderPane;
import javax.baja.ui.pane.BEdgePane;
import javax.baja.ui.pane.BGridPane;
import javax.baja.ui.util.UiLexicon;
import javax.baja.ui.wizard.WizardModel;

@NiagaraType
public class BWizard
extends BDialog {
    @Generated
    public static final Type TYPE = Sys.loadType(BWizard.class);
    final UiLexicon lex = UiLexicon.bajaui();
    WizardModel model;
    BBorderPane stepPane;
    BackCommand backCommand = new BackCommand(this);
    NextCommand nextCommand = new NextCommand(this);
    FinishCommand finishCommand = new FinishCommand(this);
    CancelCommand cancelCommand = new CancelCommand(this);
    BButton back = new BButton(this.backCommand);
    BButton next = new BButton(this.nextCommand);
    BButton finish = new BButton(this.finishCommand);
    BButton cancel = new BButton(this.cancelCommand);

    @Override
    @Generated
    public Type getType() {
        return TYPE;
    }

    public static void open(BWidget owner, WizardModel model) {
        BWizard.open(owner, model, BInsets.make((double)0.0, (double)0.0, (double)0.0, (double)0.0));
    }

    public static void open(BWidget owner, WizardModel model, BInsets stepInsets) {
        BWizard wizard = new BWizard(owner, model, stepInsets);
        model.setWizard(wizard);
        wizard.setBoundsCenteredOnOwner();
        model.init();
        wizard.open();
        model.setWizard(null);
    }

    BWizard(BWidget owner, WizardModel model, BInsets stepInsets) {
        super(owner, model.getTitle(), true);
        this.model = model;
        this.stepPane = new BBorderPane((BWidget)new BNullWidget(), stepInsets);
        BGridPane b = new BGridPane(4);
        b.setColumnAlign(BHalign.fill);
        b.setUniformColumnWidth(true);
        b.setHalign(BHalign.right);
        b.add("back", (BValue)this.back);
        b.add("next", (BValue)this.next);
        b.add("finish", (BValue)this.finish);
        b.add("cancel", (BValue)this.cancel);
        BEdgePane buttons = new BEdgePane();
        buttons.setTop(new BSeparator(BOrientation.horizontal));
        buttons.setCenter(new BBorderPane(b));
        BEdgePane content = new BEdgePane();
        content.setCenter(this.stepPane);
        content.setBottom(buttons);
        this.setContent(content);
    }

    public BWizard() {
    }

    public WizardModel getModel() {
        return this.model;
    }

    @Override
    public void computePreferredSize() {
        super.computePreferredSize();
        double pw = this.getPreferredWidth();
        double ph = this.getPreferredHeight();
        Size steps = this.model.getPreferredSizeOfSteps();
        pw = Math.max(pw, steps.width);
        ph = Math.max(ph, steps.height);
        this.setPreferredSize(pw, ph);
    }

    public BButton getBackButton() {
        return this.back;
    }

    public void setBackVisible(boolean visible) {
        this.back.setVisible(visible);
        this.relayout();
    }

    public void setBackEnabled(boolean enabled) {
        this.back.setEnabled(enabled);
    }

    public void setBackAsDefault() {
        this.setDefaultButton(this.back);
        this.back.requestFocus();
    }

    public BButton getNextButton() {
        return this.next;
    }

    public void setNextVisible(boolean visible) {
        this.next.setVisible(visible);
        this.relayout();
    }

    public void setNextEnabled(boolean enabled) {
        this.next.setEnabled(enabled);
    }

    public void setNextAsDefault() {
        this.setDefaultButton(this.next);
        this.next.requestFocus();
    }

    public BButton getCancelButton() {
        return this.cancel;
    }

    public void setCancelVisible(boolean visible) {
        this.cancel.setVisible(visible);
        this.relayout();
    }

    public void setCancelEnabled(boolean enabled) {
        this.cancel.setEnabled(enabled);
    }

    public void setCancelAsDefault() {
        this.setDefaultButton(this.cancel);
    }

    public BButton getFinishButton() {
        return this.finish;
    }

    public void setFinishVisible(boolean visible) {
        this.finish.setVisible(visible);
        this.relayout();
    }

    public void setFinishEnabled(boolean enabled) {
        this.finish.setEnabled(enabled);
    }

    public void setFinishAsDefault() {
        this.setDefaultButton(this.finish);
        this.finish.requestFocus();
    }

    public void setCurrentStep(BWidget step) {
        if (this.stepPane.getContent() == step) {
            return;
        }
        this.stepPane.setContent(step);
        step.relayout();
    }

    @Override
    public void windowClosing(BWindowEvent event) {
        this.cancelCommand.doInvoke();
    }

    class CancelCommand
    extends Command {
        CancelCommand(BWizard wiz) {
            super((BWidget)wiz, BWizard.this.lex.module, "wizard.cancel");
        }

        @Override
        public CommandArtifact doInvoke() {
            if (BWizard.this.model.cancel()) {
                BWizard.this.close();
            }
            return null;
        }
    }

    class FinishCommand
    extends Command {
        FinishCommand(BWizard wiz) {
            super((BWidget)wiz, BWizard.this.lex.module, "wizard.finish");
        }

        @Override
        public CommandArtifact doInvoke() {
            if (BWizard.this.model.finish()) {
                BWizard.this.close();
            }
            return null;
        }
    }

    class NextCommand
    extends Command {
        NextCommand(BWizard wiz) {
            super((BWidget)wiz, BWizard.this.lex.module, "wizard.next");
        }

        @Override
        public CommandArtifact doInvoke() {
            BWizard.this.model.next();
            return null;
        }
    }

    class BackCommand
    extends Command {
        BackCommand(BWizard wiz) {
            super((BWidget)wiz, BWizard.this.lex.module, "wizard.back");
        }

        @Override
        public CommandArtifact doInvoke() {
            BWizard.this.model.back();
            return null;
        }
    }
}

