/*
 * Decompiled with CFR 0.152.
 */
package javax.baja.ui.treetable;

import javax.baja.ui.table.TableSubject;
import javax.baja.ui.treetable.BTreeTable;
import javax.baja.ui.treetable.TreeTableModel;
import javax.baja.ui.treetable.TreeTableNode;

public class TreeTableSubject
extends TableSubject {
    private TreeTableNode[] nodes;
    private TreeTableNode activeNode;

    public TreeTableSubject(BTreeTable table, int[] rows) {
        this(table, rows, -1);
    }

    public TreeTableSubject(BTreeTable table, int[] rows, int activeRow) {
        super(table, rows, activeRow);
        TreeTableModel model = table.getTreeTableModel();
        this.nodes = new TreeTableNode[rows.length];
        for (int i = 0; i < this.nodes.length; ++i) {
            this.nodes[i] = model.rowToNode(rows[i]);
        }
        this.activeNode = model.rowToNode(activeRow);
    }

    public BTreeTable getTreeTable() {
        return (BTreeTable)this.getTable();
    }

    public TreeTableNode[] getNodes() {
        return (TreeTableNode[])this.nodes.clone();
    }

    public TreeTableNode getNode(int index) {
        return this.nodes[index];
    }

    public TreeTableNode getActiveNode() {
        return this.activeNode;
    }
}

