/*
 * Decompiled with CFR 0.152.
 */
package javax.baja.ui.table;

import java.util.BitSet;
import javax.baja.ui.event.BWidgetEvent;
import javax.baja.ui.table.BTable;
import javax.baja.ui.table.TableSubject;

public class TableSelection
extends BTable.TableSupport {
    private BitSet bits = new BitSet();
    private int lead = -1;
    private int anchor = -1;

    public boolean isSelected(int row, int col) {
        return this.isSelected(row);
    }

    public boolean isSelected(int row) {
        return this.bits.get(row);
    }

    public void selectAll() {
        int count = this.getModel().getRowCount();
        if (count > 0) {
            this.select(0, count - 1);
        }
    }

    public void select(int row) {
        this.select(row, false);
    }

    public void select(int row, boolean clear) {
        if (clear || row < 0) {
            this.bits = new BitSet(this.bits.size());
        }
        if (row >= 0) {
            this.bits.set(row);
            this.anchor = this.lead = row;
        }
        this.updateTable();
    }

    public void select(int anchor, int lead) {
        this.select(anchor, lead, false);
    }

    public void select(int anchor, int lead, boolean clear) {
        if (clear) {
            this.bits = new BitSet(this.bits.size());
        }
        this.anchor = anchor;
        this.lead = lead;
        int end = lead;
        int start = anchor;
        if (end < start) {
            int temp = start;
            start = end;
            end = temp;
        }
        for (int r = start; r <= end; ++r) {
            this.bits.set(r);
        }
        this.updateTable();
    }

    public void select(int[] rows) {
        this.bits = new BitSet(this.bits.size());
        if (rows.length == 0) {
            return;
        }
        this.anchor = rows[0];
        this.lead = rows[rows.length - 1];
        for (int i = 0; i < rows.length; ++i) {
            this.bits.set(rows[i]);
        }
        this.updateTable();
    }

    public void deselect(int row) {
        this.bits.clear(row);
        this.anchor = this.lead = row;
        this.updateTable();
    }

    public void deselectAll() {
        this.bits = new BitSet(this.bits.size());
        this.updateTable();
    }

    public boolean isEmpty() {
        return this.getRowCount() == 0;
    }

    public int getRowCount() {
        int rowCount = this.getTable().getModel().getRowCount();
        int n = 0;
        for (int r = 0; r < rowCount; ++r) {
            if (!this.bits.get(r)) continue;
            ++n;
        }
        return n;
    }

    public int getRow() {
        for (int r = 0; r < this.bits.size(); ++r) {
            if (!this.bits.get(r)) continue;
            return r;
        }
        return -1;
    }

    public int[] getRows() {
        int rowCount = this.getTable().getModel().getRowCount();
        int[] temp = new int[rowCount];
        int n = 0;
        for (int r = 0; r < rowCount; ++r) {
            if (!this.bits.get(r)) continue;
            temp[n++] = r;
        }
        int[] result = new int[n];
        System.arraycopy(temp, 0, result, 0, n);
        return result;
    }

    public int getAnchor() {
        return this.anchor;
    }

    public int getLead() {
        return this.lead;
    }

    public final TableSubject getSubject() {
        return this.getSubject(this.lead);
    }

    public TableSubject getSubject(int activeRow) {
        return new TableSubject(this.getTable(), this.getRows(), activeRow);
    }

    public void updateTable() {
        BTable table = this.getTable();
        if (table != null) {
            table.repaint();
            this.getTable().fireSelectionModified(new BWidgetEvent(1, this.getTable()));
        }
    }
}

