/*
 * Decompiled with CFR 0.152.
 */
package javax.baja.ui.pane;

import com.tridium.gx.GraphPaper;
import com.tridium.gx.GxEnv;
import com.tridium.gx.Hatching;
import com.tridium.ui.util.LayoutUtil;
import com.tridium.ui.util.ScaledLayout;
import javax.baja.gx.BBrush;
import javax.baja.gx.BColor;
import javax.baja.gx.BSize;
import javax.baja.gx.BTransform;
import javax.baja.gx.Graphics;
import javax.baja.gx.IGeom;
import javax.baja.gx.IPoint;
import javax.baja.gx.Point;
import javax.baja.nre.annotations.Generated;
import javax.baja.nre.annotations.NiagaraProperties;
import javax.baja.nre.annotations.NiagaraProperty;
import javax.baja.nre.annotations.NiagaraType;
import javax.baja.nre.util.Array;
import javax.baja.sys.BIcon;
import javax.baja.sys.BValue;
import javax.baja.sys.Property;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.ui.BLayout;
import javax.baja.ui.BWidget;
import javax.baja.ui.enums.BHalign;
import javax.baja.ui.enums.BScaleMode;
import javax.baja.ui.enums.BValign;
import javax.baja.ui.pane.BLabelPane;
import javax.baja.ui.pane.BPane;
import javax.baja.ui.pane.BTabbedPane;
import javax.baja.ui.shape.BShape;

@NiagaraType
@NiagaraProperties(value={@NiagaraProperty(name="viewSize", type="BSize", defaultValue="BSize.make(100, 100)"), @NiagaraProperty(name="scale", type="BScaleMode", defaultValue="BScaleMode.none"), @NiagaraProperty(name="minScaleFactor", type="double", defaultValue="0"), @NiagaraProperty(name="maxScaleFactor", type="double", defaultValue="0"), @NiagaraProperty(name="halign", type="BHalign", defaultValue="BHalign.center"), @NiagaraProperty(name="valign", type="BValign", defaultValue="BValign.center"), @NiagaraProperty(name="background", type="BBrush", defaultValue="BBrush.NULL")})
public class BCanvasPane
extends BPane {
    @Generated
    public static final Property viewSize = BCanvasPane.newProperty((int)0, (BValue)BSize.make((double)100.0, (double)100.0), null);
    @Generated
    public static final Property scale = BCanvasPane.newProperty((int)0, (BValue)BScaleMode.none, null);
    @Generated
    public static final Property minScaleFactor = BCanvasPane.newProperty((int)0, (int)0, null);
    @Generated
    public static final Property maxScaleFactor = BCanvasPane.newProperty((int)0, (int)0, null);
    @Generated
    public static final Property halign = BCanvasPane.newProperty((int)0, (BValue)BHalign.center, null);
    @Generated
    public static final Property valign = BCanvasPane.newProperty((int)0, (BValue)BValign.center, null);
    @Generated
    public static final Property background = BCanvasPane.newProperty((int)0, (BValue)BBrush.NULL, null);
    @Generated
    public static final Type TYPE = Sys.loadType(BCanvasPane.class);
    private static final BIcon icon = BIcon.std((String)"widgets/canvasPane.png");
    public boolean overrideClip = false;
    private ScaledLayout scaledLayout = new ScaledLayout();
    private boolean paintGraphPaper;
    private boolean paintHatching;
    private GraphPaper graphPaper;
    private Hatching hatching;

    @Generated
    public BSize getViewSize() {
        return (BSize)this.get(viewSize);
    }

    @Generated
    public void setViewSize(BSize v) {
        this.set(viewSize, (BValue)v, null);
    }

    @Generated
    public BScaleMode getScale() {
        return (BScaleMode)this.get(scale);
    }

    @Generated
    public void setScale(BScaleMode v) {
        this.set(scale, (BValue)v, null);
    }

    @Generated
    public double getMinScaleFactor() {
        return this.getDouble(minScaleFactor);
    }

    @Generated
    public void setMinScaleFactor(double v) {
        this.setDouble(minScaleFactor, v, null);
    }

    @Generated
    public double getMaxScaleFactor() {
        return this.getDouble(maxScaleFactor);
    }

    @Generated
    public void setMaxScaleFactor(double v) {
        this.setDouble(maxScaleFactor, v, null);
    }

    @Generated
    public BHalign getHalign() {
        return (BHalign)this.get(halign);
    }

    @Generated
    public void setHalign(BHalign v) {
        this.set(halign, (BValue)v, null);
    }

    @Generated
    public BValign getValign() {
        return (BValign)this.get(valign);
    }

    @Generated
    public void setValign(BValign v) {
        this.set(valign, (BValue)v, null);
    }

    @Generated
    public BBrush getBackground() {
        return (BBrush)this.get(background);
    }

    @Generated
    public void setBackground(BBrush v) {
        this.set(background, (BValue)v, null);
    }

    @Override
    @Generated
    public Type getType() {
        return TYPE;
    }

    @Override
    public void computePreferredSize() {
        BWidget offsetParent = LayoutUtil.getOffsetParent(this);
        BSize viewSize = this.getViewSize();
        if (offsetParent != null) {
            ScaledLayout scaledLayout = ScaledLayout.scaleToOffsetParent(this, offsetParent);
            this.setPreferredSize(Math.round(viewSize.width * scaledLayout.getScaleX()), Math.round(viewSize.height * scaledLayout.getScaleY()));
        } else {
            this.setPreferredSize(viewSize.width, viewSize.height);
        }
    }

    @Override
    public void doLayout(BWidget[] kids) {
        this.scaledLayout = ScaledLayout.scaleToSelf(this);
        this.layoutKids(kids);
    }

    private void layoutKids(BWidget[] kids) {
        BSize viewSize = this.getViewSize();
        double vw = viewSize.width;
        double vh = viewSize.height;
        for (BWidget kid : kids) {
            BLayout layout = kid.getLayout();
            if (layout.isNull()) continue;
            kid.computePreferredSize();
            double cx = layout.getX();
            double cy = layout.getY();
            double cw = layout.getWidth();
            double ch = layout.getHeight();
            if (layout.getXUnit() == 1) {
                cx = cx / 100.0 * vw;
            }
            if (layout.getYUnit() == 1) {
                cy = cy / 100.0 * vh;
            }
            if (layout.getWidthUnit() == 1) {
                cw = cw / 100.0 * vw;
            } else if (layout.getWidthUnit() == 2) {
                cw = kid.getPreferredWidth();
            }
            if (layout.getHeightUnit() == 1) {
                ch = ch / 100.0 * vh;
            } else if (layout.getHeightUnit() == 2) {
                ch = kid.getPreferredHeight();
            }
            kid.setBounds(cx, cy, cw, ch);
        }
    }

    @Override
    public BWidget childAt(Point pt) {
        return super.childAt(this.getScaleTransform().getInverse().transform((IPoint)pt, null));
    }

    public BWidget[] childrenAt(Point pt) {
        pt = this.getScaleTransform().getInverse().transform((IPoint)pt, null);
        Array arr = new Array(BWidget.class);
        BWidget[] children = this.getChildWidgets();
        for (int i = children.length - 1; i >= 0; --i) {
            BWidget child = children[i];
            if (!child.isVisible() || !child.contains(pt.x - child.getX(), pt.y - child.getY())) continue;
            arr.add((Object)child);
        }
        if (arr.size() == 0) {
            return null;
        }
        return (BWidget[])arr.trim();
    }

    @Override
    public Point translateToChild(BWidget child, Point pt) {
        pt = this.getScaleTransform().getInverse().transform((IPoint)pt, pt);
        return super.translateToChild(child, pt);
    }

    @Override
    public Point translateFromChild(BWidget child, Point pt) {
        pt.x += child.getX();
        pt.y += child.getY();
        pt = this.getScaleTransform().transform((IPoint)pt, pt);
        return pt;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void paint(Graphics g) {
        double dx = this.scaledLayout.getOffsetX();
        double dy = this.scaledLayout.getOffsetY();
        double sx = this.scaledLayout.getScaleX();
        double sy = this.scaledLayout.getScaleY();
        BTransform transform = this.getScaleTransform();
        BBrush brush = this.getBackground();
        if (!brush.isNull()) {
            g.setBrush(brush);
            g.fillRect(0.0, 0.0, this.getWidth(), this.getHeight());
        }
        g.push();
        try {
            g.transform(transform);
            g.clip(0.0, 0.0, this.getViewSize().width + 1.0, this.getViewSize().height + 1.0);
            if (this.paintGraphPaper) {
                this.graphPaper.fillRect(g, dx < 0.0 ? -dx * sx : 0.0, dy < 0.0 ? -dy * sy : 0.0, this.getWidth() / sx, this.getHeight() / sy);
            }
            this.paintKids(g, this.paintHatching && this.hatchable());
        }
        finally {
            g.pop();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void paintKids(Graphics g, boolean hatch) {
        BWidget[] children;
        IGeom clip = g.getClip();
        double dx = this.scaledLayout.getOffsetX();
        double dy = this.scaledLayout.getOffsetY();
        double sx = this.scaledLayout.getScaleX();
        double sy = this.scaledLayout.getScaleY();
        BTransform scale = BTransform.make((BTransform.Transform)this.scaledLayout.getScale());
        for (BWidget child : children = this.getChildWidgets()) {
            if (!child.isVisible()) continue;
            double x = child.getX();
            double y = child.getY();
            double width = child.getWidth();
            double height = child.getHeight();
            if (!this.overrideClip && !clip.intersects(x, y, width, height)) continue;
            g.push();
            try {
                g.clip(x, y, width, height);
                g.translate(x, y);
                child.paint(g);
                if (!hatch || child instanceof BShape) continue;
                g.transform(scale);
                this.hatching.fillRect(g, dx + x < 0.0 ? -(dx + x) * sx : 0.0, dy + y < 0.0 ? -(dy + y) * sy : 0.0, Math.ceil(width / sx), Math.ceil(height / sy));
            }
            catch (Throwable e) {
                e.printStackTrace();
            }
            finally {
                g.pop();
            }
        }
    }

    private boolean hatchable() {
        for (BWidget parent = this.getParentWidget(); parent != null; parent = parent.getParentWidget()) {
            BLabelPane tab;
            BTabbedPane pane;
            if (parent instanceof BCanvasPane) {
                return false;
            }
            if (!(parent instanceof BLabelPane) || !(parent.getParentWidget() instanceof BTabbedPane) || (pane = (BTabbedPane)(tab = (BLabelPane)parent).getParentWidget()).getSelectedLabelPane() == tab) continue;
            return false;
        }
        return true;
    }

    @Override
    public Object fw(int x, Object a, Object b, Object c, Object d) {
        if (x == 304) {
            Object[] gp = (Object[])a;
            this.paintGraphPaper = (Boolean)gp[0];
            if (this.paintGraphPaper) {
                if (this.graphPaper == null) {
                    this.graphPaper = GxEnv.get().makeGraphPaper();
                }
                this.graphPaper.setSize(((Integer)gp[1]).intValue());
                this.graphPaper.setColor((BColor)gp[2]);
            }
            Object[] ha = (Object[])b;
            this.paintHatching = (Boolean)ha[0];
            if (this.paintHatching) {
                if (this.hatching == null) {
                    this.hatching = GxEnv.get().makeHatching();
                }
                this.hatching.setColor((BColor)ha[1]);
            }
        }
        return super.fw(x, a, b, c, d);
    }

    @Override
    public BIcon getIcon() {
        return icon;
    }

    public BTransform getScaleTransform() {
        return this.scaledLayout.transform();
    }
}

