/*
 * Decompiled with CFR 0.152.
 */
package javax.baja.ui.event;

import javax.baja.nre.annotations.Generated;
import javax.baja.nre.annotations.NiagaraType;
import javax.baja.sys.Clock;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.ui.BWidget;
import javax.baja.ui.event.BWidgetEvent;

@NiagaraType
public abstract class BInputEvent
extends BWidgetEvent {
    @Generated
    public static final Type TYPE = Sys.loadType(BInputEvent.class);
    public static final int ALT_MASK = 8;
    public static final int ALT_GRAPH_MASK = 32;
    public static final int BUTTON1_MASK = 16;
    public static final int BUTTON2_MASK = 8;
    public static final int BUTTON3_MASK = 4;
    public static final int CTRL_MASK = 2;
    public static final int META_MASK = 4;
    public static final int SHIFT_MASK = 1;
    public static final int SHIFT_DOWN_MASK = 64;
    public static final int CTRL_DOWN_MASK = 128;
    public static final int META_DOWN_MASK = 256;
    public static final int ALT_DOWN_MASK = 512;
    public static final int BUTTON1_DOWN_MASK = 1024;
    public static final int BUTTON2_DOWN_MASK = 2048;
    public static final int BUTTON3_DOWN_MASK = 4096;
    public static final int ALT_GRAPH_DOWN_MASK = 8192;
    public static final int BUTTON4_DOWN_MASK = 16384;
    public static final int BUTTON5_DOWN_MASK = 32768;
    int modifiers;
    private boolean consumed;
    private long when;
    static final int FIRST_HIGH_BIT = Integer.MIN_VALUE;
    static final int JDK_1_3_MODIFIERS = 63;
    static final int HIGH_MODIFIERS = Integer.MIN_VALUE;

    @Override
    @Generated
    public Type getType() {
        return TYPE;
    }

    public BInputEvent(int id, BWidget source, int modifiers) {
        super(id, source);
        this.modifiers = modifiers;
        this.when = Clock.millis();
        this.configureModifiers();
    }

    public BInputEvent(int id, BWidget source, long when, int modifiers) {
        super(id, source);
        this.modifiers = modifiers;
        this.when = when;
        this.configureModifiers();
    }

    public BInputEvent() {
    }

    private void configureModifiers() {
        if (this.getModifiers() != 0 && this.getModifiersEx() == 0) {
            this.setNewModifiers();
        } else if (this.getModifiers() == 0 && this.getModifiersEx() != 0) {
            this.setOldModifiers();
        }
    }

    protected void setNewModifiers() {
        if ((this.modifiers & 1) != 0) {
            this.modifiers |= 0x40;
        }
        if ((this.modifiers & 8) != 0) {
            this.modifiers |= 0x200;
        }
        if ((this.modifiers & 2) != 0) {
            this.modifiers |= 0x80;
        }
        if ((this.modifiers & 4) != 0) {
            this.modifiers |= 0x100;
        }
        if ((this.modifiers & 0x20) != 0) {
            this.modifiers |= 0x2000;
        }
        if ((this.modifiers & 0x10) != 0) {
            this.modifiers |= 0x400;
        }
    }

    protected void setOldModifiers() {
        if ((this.modifiers & 0x40) != 0) {
            this.modifiers |= 1;
        }
        if ((this.modifiers & 0x200) != 0) {
            this.modifiers |= 8;
        }
        if ((this.modifiers & 0x80) != 0) {
            this.modifiers |= 2;
        }
        if ((this.modifiers & 0x100) != 0) {
            this.modifiers |= 4;
        }
        if ((this.modifiers & 0x2000) != 0) {
            this.modifiers |= 0x20;
        }
        if ((this.modifiers & 0x400) != 0) {
            this.modifiers |= 0x10;
        }
    }

    public int getModifiers() {
        return this.modifiers & 0x8000003F;
    }

    public int getModifiersEx() {
        return this.modifiers & 0xFFFFFFC0;
    }

    public long getWhen() {
        return this.when;
    }

    public boolean isAltDown() {
        return (this.modifiers & 0x200) != 0;
    }

    public boolean isAltGraphDown() {
        return (this.modifiers & 0x2000) != 0;
    }

    public boolean isControlDown() {
        return (this.modifiers & 0x80) != 0;
    }

    public boolean isMetaDown() {
        return (this.modifiers & 0x100) != 0;
    }

    public boolean isShiftDown() {
        return (this.modifiers & 0x40) != 0;
    }

    public String modifiersToString() {
        String s = "";
        if (this.isAltDown()) {
            s = s + "Alt ";
        }
        if (this.isAltGraphDown()) {
            s = s + "AltGraph ";
        }
        if (this.isControlDown()) {
            s = s + "Ctrl ";
        }
        if (this.isMetaDown()) {
            s = s + "Meta ";
        }
        if (this.isShiftDown()) {
            s = s + "Shift ";
        }
        return s.trim();
    }

    public boolean isConsumed() {
        return this.consumed;
    }

    public void consume() {
        this.consumed = true;
    }
}

