/*
 * Decompiled with CFR 0.152.
 */
package javax.baja.ui;

import com.tridium.ui.ShellManager;
import com.tridium.ui.UiEnv;
import javax.baja.agent.AgentList;
import javax.baja.gx.Graphics;
import javax.baja.gx.IGeom;
import javax.baja.gx.Point;
import javax.baja.gx.RectGeom;
import javax.baja.nre.annotations.NiagaraProperties;
import javax.baja.nre.annotations.NiagaraProperty;
import javax.baja.nre.annotations.NiagaraTopic;
import javax.baja.nre.annotations.NiagaraTopics;
import javax.baja.nre.annotations.NiagaraType;
import javax.baja.nre.util.Array;
import javax.baja.sys.Action;
import javax.baja.sys.BComplex;
import javax.baja.sys.BComponent;
import javax.baja.sys.BIcon;
import javax.baja.sys.BValue;
import javax.baja.sys.Context;
import javax.baja.sys.Property;
import javax.baja.sys.Sys;
import javax.baja.sys.Topic;
import javax.baja.sys.Type;
import javax.baja.ui.BBinding;
import javax.baja.ui.BLayout;
import javax.baja.ui.BWidgetApplication;
import javax.baja.ui.BWidgetShell;
import javax.baja.ui.MouseCursor;
import javax.baja.ui.UndoManager;
import javax.baja.ui.event.BFocusEvent;
import javax.baja.ui.event.BKeyEvent;
import javax.baja.ui.event.BMouseEvent;
import javax.baja.ui.event.BMouseWheelEvent;
import javax.baja.ui.style.IStylable;
import javax.baja.util.BTypeSpec;

@NiagaraType
@NiagaraProperties(value={@NiagaraProperty(name="visible", type="boolean", defaultValue="true"), @NiagaraProperty(name="enabled", type="boolean", defaultValue="true"), @NiagaraProperty(name="layout", type="BLayout", defaultValue="BLayout.DEFAULT"), @NiagaraProperty(name="styleClasses", type="String", defaultValue="", flags=4), @NiagaraProperty(name="styleId", type="String", defaultValue="", flags=4)})
@NiagaraTopics(value={@NiagaraTopic(name="keyEvent", eventType="BKeyEvent"), @NiagaraTopic(name="mouseEvent", eventType="BMouseEvent"), @NiagaraTopic(name="focusEvent", eventType="BFocusEvent")})
public class BWidget
extends BComponent
implements IStylable {
    public static final Property visible = BWidget.newProperty((int)0, (boolean)true, null);
    public static final Property enabled = BWidget.newProperty((int)0, (boolean)true, null);
    public static final Property layout = BWidget.newProperty((int)0, (BValue)BLayout.DEFAULT, null);
    public static final Property styleClasses = BWidget.newProperty((int)4, (String)"", null);
    public static final Property styleId = BWidget.newProperty((int)4, (String)"", null);
    public static final Topic keyEvent = BWidget.newTopic((int)0, null);
    public static final Topic mouseEvent = BWidget.newTopic((int)0, null);
    public static final Topic focusEvent = BWidget.newTopic((int)0, null);
    public static final Type TYPE = Sys.loadType(BWidget.class);
    private static final BIcon icon = BIcon.std((String)"widgets/widget.png");
    static final BBinding[] noBindings;
    ShellManager shellManager;
    private double x;
    private double y;
    private double width;
    private double height;
    private double prefWidth;
    private double prefHeight;
    private boolean needsLayout = true;
    private boolean busy = false;
    private MouseCursor mouseCursor = MouseCursor.normal;
    private BBinding[] bindings = noBindings;

    public boolean getVisible() {
        return this.getBoolean(visible);
    }

    public void setVisible(boolean v) {
        this.setBoolean(visible, v, null);
    }

    public boolean getEnabled() {
        return this.getBoolean(enabled);
    }

    public void setEnabled(boolean v) {
        this.setBoolean(enabled, v, null);
    }

    public BLayout getLayout() {
        return (BLayout)this.get(layout);
    }

    public void setLayout(BLayout v) {
        this.set(layout, (BValue)v, null);
    }

    @Override
    public String getStyleClasses() {
        return this.getString(styleClasses);
    }

    @Override
    public void setStyleClasses(String v) {
        this.setString(styleClasses, v, null);
    }

    @Override
    public String getStyleId() {
        return this.getString(styleId);
    }

    @Override
    public void setStyleId(String v) {
        this.setString(styleId, v, null);
    }

    public Type getType() {
        return TYPE;
    }

    public final boolean isWidget() {
        return true;
    }

    public boolean isNull() {
        return false;
    }

    public final BWidgetShell getShell() {
        if (this.shellManager == null) {
            return null;
        }
        BWidget shell = this.shellManager.getShell();
        return shell instanceof BWidgetShell ? (BWidgetShell)shell : null;
    }

    public final ShellManager getShellManager() {
        return this.shellManager;
    }

    public final boolean isDesignTime() {
        return this.shellManager != null && this.shellManager.isDesignTime();
    }

    public static BWidgetApplication getApplication() {
        return UiEnv.app;
    }

    public final BWidget getParentWidget() {
        BComplex parent = this.getParent();
        if (parent instanceof BWidget) {
            return (BWidget)parent;
        }
        return null;
    }

    public final BWidget[] getChildWidgets() {
        return (BWidget[])this.getChildren(BWidget.class);
    }

    @Override
    public String getStyleSelector() {
        return "";
    }

    public MouseCursor getMouseCursor() {
        return this.mouseCursor;
    }

    public MouseCursor setMouseCursor(MouseCursor c) {
        if (c == null) {
            c = MouseCursor.normal;
        }
        MouseCursor old = this.mouseCursor;
        this.mouseCursor = c;
        if (this.shellManager != null) {
            this.shellManager.updateMouseCursor();
        }
        return old;
    }

    public void enterBusy() {
        if (this.shellManager != null) {
            this.busy = true;
            this.shellManager.enterBusy(this);
        }
    }

    public void exitBusy() {
        this.busy = false;
        if (this.shellManager != null) {
            this.shellManager.exitBusy(this);
        }
    }

    public void changed(Property prop, Context context) {
        this.repaint();
    }

    public Object fw(int x, Object a, Object b, Object c, Object d) {
        switch (x) {
            case 2: {
                this.fwChanged((Property)a, (Context)b);
                break;
            }
            case 6: {
                this.relayout();
                break;
            }
            case 7: {
                this.fwParented((Property)a, (BValue)b);
                break;
            }
            case 8: {
                this.fwUnparented((Property)a, (BValue)b);
                break;
            }
            case 9: {
                this.fireInvokedOnBindings((Action)a, (BValue)b, (Context)c);
                break;
            }
            case 10: {
                this.fireFiredOnBindings((Topic)a, (BValue)b, (Context)c);
                break;
            }
            case 19: {
                return this.getOverride((Property)a);
            }
            case 301: {
                return this;
            }
        }
        return super.fw(x, a, b, c, d);
    }

    void fwChanged(Property prop, Context cx) {
        if (prop == enabled && this.shellManager != null) {
            this.shellManager.checkMouseOver();
        }
        this.fireChangedOnBindings(prop, cx);
    }

    void fwParented(Property prop, BValue newChild) {
        if (this.shellManager != null && newChild instanceof BWidget) {
            BWidget child = (BWidget)newChild;
            child.initShell(this.shellManager);
        }
        if (newChild instanceof BBinding) {
            this.bindingAdd((BBinding)newChild);
        }
    }

    void fwUnparented(Property prop, BValue oldChild) {
        if (oldChild instanceof BWidget) {
            BWidget child = (BWidget)oldChild;
            child.cleanupShell();
            child.needsLayout = false;
            this.relayout();
        }
        if (oldChild instanceof BBinding) {
            this.bindingRemove((BBinding)oldChild);
        }
    }

    void initShell(ShellManager shellManager) {
        BWidget[] kids;
        if (this.shellManager == shellManager) {
            throw new IllegalStateException("Shell already initialized");
        }
        this.shellManager = shellManager;
        this.needsLayout = false;
        if (shellManager.forceFreshLayout()) {
            this.relayout();
        }
        for (BWidget kid : kids = this.getChildWidgets()) {
            kid.initShell(shellManager);
        }
    }

    void cleanupShell() {
        BWidget[] kids;
        if (this.shellManager != null && this.busy) {
            this.exitBusy();
        }
        this.busy = false;
        this.shellManager = null;
        for (BWidget kid : kids = this.getChildWidgets()) {
            kid.cleanupShell();
        }
    }

    public final BBinding[] getBindings() {
        if (this.bindings.length == 0) {
            return noBindings;
        }
        return (BBinding[])this.bindings.clone();
    }

    public final boolean hasBindings() {
        return this.bindings.length > 0;
    }

    public void bindingsChanged() {
    }

    private void bindingAdd(BBinding b) {
        BBinding[] temp = new BBinding[this.bindings.length + 1];
        System.arraycopy(this.bindings, 0, temp, 0, this.bindings.length);
        temp[this.bindings.length] = b;
        this.bindings = temp;
        try {
            this.bindingsChanged();
        }
        catch (Throwable e) {
            e.printStackTrace();
        }
    }

    private void bindingRemove(BBinding b) {
        if (this.bindings.length == 1 && this.bindings[0] == b) {
            this.bindings = noBindings;
        } else {
            for (int i = 0; i < this.bindings.length; ++i) {
                if (this.bindings[i] != b) continue;
                BBinding[] temp = new BBinding[this.bindings.length - 1];
                System.arraycopy(this.bindings, 0, temp, 0, i);
                if (i < this.bindings.length) {
                    System.arraycopy(this.bindings, i + 1, temp, i, this.bindings.length - i - 1);
                }
                this.bindings = temp;
                break;
            }
        }
        try {
            this.bindingsChanged();
        }
        catch (Throwable e) {
            e.printStackTrace();
        }
    }

    public boolean isOverriddenByBinding(Property prop) {
        return this.getOverride(prop) != null;
    }

    private BValue getOverride(Property prop) {
        for (BBinding binding : this.bindings) {
            BValue value;
            if (!binding.isBound() || (value = binding.getOnWidget(prop)) == null) continue;
            return value;
        }
        return null;
    }

    private void fireChangedOnBindings(Property prop, Context cx) {
        for (BBinding binding : this.bindings) {
            try {
                binding.changedOnWidget(prop, cx);
            }
            catch (Throwable e) {
                e.printStackTrace();
            }
        }
    }

    private void fireInvokedOnBindings(Action action, BValue value, Context cx) {
        for (BBinding binding : this.bindings) {
            try {
                boolean consumed = binding.invokedOnWidget(action, value, cx);
                if (!consumed) continue;
                return;
            }
            catch (Throwable e) {
                e.printStackTrace();
            }
        }
    }

    private void fireFiredOnBindings(Topic topic, BValue value, Context cx) {
        for (BBinding binding : this.bindings) {
            try {
                boolean consumed = binding.firedOnWidget(topic, value, cx);
                if (!consumed) continue;
                return;
            }
            catch (Throwable e) {
                e.printStackTrace();
            }
        }
    }

    public BWidget childAt(Point pt) {
        BWidget[] children = this.getChildWidgets();
        for (int i = children.length - 1; i >= 0; --i) {
            BWidget child = children[i];
            if (!child.isVisible() || !child.contains(pt.x - child.x, pt.y - child.y)) continue;
            return child;
        }
        return null;
    }

    public final BWidget descendentAt(Point pt) {
        BWidget child = this.childAt(pt);
        if (child != null) {
            this.translateToChild(child, pt);
            BWidget d = child.descendentAt(pt);
            return d != null ? d : child;
        }
        return null;
    }

    public Point translateToChild(BWidget child, Point pt) {
        pt.translate(-child.x, -child.y);
        return pt;
    }

    public Point translateFromChild(BWidget child, Point pt) {
        double x = pt.x;
        double y = pt.y;
        this.translateToChild(child, pt);
        pt.x = x - (pt.x - x);
        pt.y = y - (pt.y - y);
        return pt;
    }

    public final Point translateFromAncestor(BWidget ancestor, Point pt) {
        BWidget w;
        Array widgets = new Array(BWidget.class);
        if (ancestor != this) {
            for (w = this; w != null; w = w.getParentWidget()) {
                widgets.add((Object)w);
                if (w == ancestor) break;
            }
        }
        w = null;
        BWidget p = null;
        for (int i = widgets.size() - 1; i >= 0; --i) {
            w = (BWidget)widgets.get(i);
            if (w != null && p != null) {
                p.translateToChild(w, pt);
            }
            p = w;
        }
        return pt;
    }

    public final Point translateToAncestor(BWidget ancestor, Point pt) {
        BWidget p = this.getParentWidget();
        BWidget w = this;
        while (w != ancestor) {
            p.translateFromChild(w, pt);
            w = p;
            p = p.getParentWidget();
        }
        return pt;
    }

    public final Point translateToScreen(Point pt) {
        return this.shellManager.translateToScreen(this, pt);
    }

    public final double getX() {
        return this.x;
    }

    public final double getY() {
        return this.y;
    }

    public final double getWidth() {
        return this.width;
    }

    public final double getHeight() {
        return this.height;
    }

    public final double getPreferredWidth() {
        return this.prefWidth;
    }

    public final double getPreferredHeight() {
        return this.prefHeight;
    }

    public boolean contains(double x, double y) {
        return x >= 0.0 && x < this.width && y >= 0.0 && y < this.height;
    }

    public void setLocation(double x, double y) {
        this.x = x;
        this.y = y;
    }

    public void setSize(double width, double height) {
        if (this.width != width || this.height != height) {
            this.width = width;
            this.height = height;
            this.relayout();
        }
    }

    public void setBounds(double x, double y, double width, double height) {
        this.setLocation(x, y);
        this.setSize(width, height);
    }

    public final void setPreferredSize(double width, double height) {
        this.prefWidth = width;
        this.prefHeight = height;
    }

    public final boolean needsLayout() {
        return this.needsLayout;
    }

    public final void relayout() {
        this.relayout(false);
    }

    public final void relayoutSync() {
        this.relayout(true);
    }

    private void relayout(boolean sync) {
        if (!this.needsLayout || sync) {
            this.needsLayout = true;
            BWidget parent = this.getParentWidget();
            if (parent != null) {
                parent.childCalledRelayout(this);
            }
            if (this.shellManager != null) {
                this.shellManager.relayout(this, sync);
            }
        } else if (this.needsLayout && this.shellManager != null && this.shellManager.enqueueRelayout(this)) {
            BWidget parent = this.getParentWidget();
            if (parent != null) {
                parent.childCalledRelayout(this);
            }
            this.shellManager.relayout(this, sync);
        }
    }

    public void childCalledRelayout(BWidget child) {
        this.relayout();
    }

    public final void layout() {
        if (this.needsLayout) {
            if (this.width > 0.0 && this.height > 0.0) {
                BWidget[] children = this.getChildWidgets();
                try {
                    this.doLayout(children);
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
                for (BWidget child : children) {
                    child.layout();
                }
            }
            this.needsLayout = false;
        }
    }

    public void doLayout(BWidget[] children) {
    }

    public void computePreferredSize() {
        this.setPreferredSize(10.0, 10.0);
    }

    public void scrollToVisible(RectGeom rect) {
        BWidget parent = this.getParentWidget();
        if (parent != null) {
            rect.x += this.x;
            rect.y += this.y;
            parent.scrollToVisible(rect);
        }
    }

    public final boolean isVisible() {
        return this.getBoolean(visible);
    }

    public final boolean isEnabled() {
        return this.getBoolean(enabled);
    }

    public void repaint() {
        if (this.shellManager != null) {
            this.shellManager.repaint(this, 0, 0, (int)this.width, (int)this.height);
        }
    }

    public void repaint(double x, double y, double width, double height) {
        if (this.shellManager != null) {
            this.shellManager.repaint(this, (int)x, (int)y, (int)width, (int)height);
        }
    }

    public void paint(Graphics g) {
        this.paintChildren(g);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void paintChildren(Graphics g) {
        IGeom clip = g.getClip();
        for (BWidget child : this.getChildWidgets()) {
            if (!child.isVisible() || !clip.intersects(child.x, child.y, child.width, child.height)) continue;
            g.push();
            try {
                g.clip(child.x, child.y, child.width, child.height);
                g.translate(child.x, child.y);
                child.paint(g);
            }
            catch (Throwable e) {
                e.printStackTrace();
            }
            finally {
                g.pop();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void paintChild(Graphics g, BWidget child) {
        if (!child.isVisible()) {
            return;
        }
        if (g.getClip().intersects(child.x, child.y, child.width, child.height)) {
            g.push();
            try {
                g.clip(child.x, child.y, child.width, child.height);
                g.translate(child.x, child.y);
                child.paint(g);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            finally {
                g.pop();
            }
        }
    }

    public void animate() {
        this.animateChildren();
    }

    public void animateChildren() {
        for (BWidget child : this.getChildWidgets()) {
            if (!child.isVisible()) continue;
            child.animate();
        }
    }

    public boolean isFocusTraversable() {
        return false;
    }

    public final boolean hasFocus() {
        return this.shellManager != null && this.shellManager.hasFocus(this);
    }

    public void requestFocus() {
        if (this.shellManager != null) {
            this.shellManager.requestFocus(this);
        }
    }

    public boolean receiveInputEvents() {
        return true;
    }

    public final void fireFocusEvent(BFocusEvent event) {
        switch (event.getId()) {
            case 1005: {
                this.focusLost(event);
                break;
            }
            case 1004: {
                this.focusGained(event);
                break;
            }
            default: {
                throw new IllegalStateException();
            }
        }
        this.fire(focusEvent, (BValue)event, null);
    }

    public void focusGained(BFocusEvent event) {
        this.scrollToVisible(new RectGeom(0.0, 0.0, this.width, this.height));
        this.repaint();
    }

    public void focusLost(BFocusEvent event) {
        this.repaint();
    }

    public void fireMouseEvent(BMouseEvent event) {
        switch (event.getId()) {
            case 501: {
                this.mousePressed(event);
                break;
            }
            case 502: {
                this.mouseReleased(event);
                break;
            }
            case 504: {
                this.mouseEntered(event);
                break;
            }
            case 505: {
                this.mouseExited(event);
                break;
            }
            case 503: {
                this.mouseMoved(event);
                break;
            }
            case 506: {
                this.mouseDragged(event);
                break;
            }
            case 507: {
                this.mouseWheel((BMouseWheelEvent)event);
                break;
            }
            case 510: {
                this.mousePulsed(event);
                break;
            }
            case 511: {
                this.mouseDragStarted(event);
                break;
            }
            case 512: {
                this.mouseHover(event);
                break;
            }
            default: {
                throw new IllegalStateException();
            }
        }
        this.fire(mouseEvent, (BValue)event, null);
    }

    public void mousePressed(BMouseEvent event) {
    }

    public void mouseReleased(BMouseEvent event) {
    }

    public void mouseEntered(BMouseEvent event) {
    }

    public void mouseExited(BMouseEvent event) {
    }

    public void mouseMoved(BMouseEvent event) {
    }

    public void mouseDragged(BMouseEvent event) {
    }

    public void mousePulsed(BMouseEvent event) {
    }

    public void mouseDragStarted(BMouseEvent event) {
    }

    public void mouseWheel(BMouseWheelEvent event) {
    }

    public void mouseHover(BMouseEvent event) {
    }

    public void resetHover() {
        if (this.shellManager != null) {
            this.shellManager.resetHover(this);
        }
    }

    public void fireKeyEvent(BKeyEvent event) {
        switch (event.getId()) {
            case 401: {
                this.keyPressed(event);
                break;
            }
            case 402: {
                this.keyReleased(event);
                break;
            }
            case 400: {
                this.keyTyped(event);
            }
        }
        this.fire(keyEvent, (BValue)event, null);
    }

    public void keyPressed(BKeyEvent event) {
    }

    public void keyReleased(BKeyEvent event) {
    }

    public void keyTyped(BKeyEvent event) {
    }

    public AgentList getAgents(Context cx) {
        AgentList agents = super.getAgents(cx);
        agents.toTop("bajaui:ValueBinding");
        return agents;
    }

    public BIcon getIcon() {
        return icon;
    }

    public Object widgetSupport(Object x) {
        if (x != null) {
            this.initShell((ShellManager)x);
        }
        return this.shellManager;
    }

    public UndoManager getUndoManager() {
        BWidget w = this;
        do {
            UndoManager um;
            if (!(w instanceof UndoManager.Scope) || (um = ((UndoManager.Scope)((Object)w)).getInstalledUndoManager()) == null) continue;
            return um;
        } while ((w = w.getParentWidget()) != null);
        return null;
    }

    public static final void invokeLater(Runnable event) {
        UiEnv.get().invokeLater(event);
    }

    public String toDebugString() {
        return super.toDebugString() + "[" + this.getDebugString() + this.boundsToString() + "]";
    }

    public String getDebugString() {
        return "";
    }

    public String boundsToString() {
        return "" + this.x + ',' + this.y + ',' + this.width + ',' + this.height;
    }

    public String preferredSizeToString() {
        return "" + this.prefWidth + ',' + this.prefHeight;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static {
        try {
            Object object = UiEnv.appLock;
            synchronized (object) {
                if (Sys.getStation() == null && UiEnv.app == null) {
                    UiEnv.app = (BWidgetApplication)BTypeSpec.make((String)"workbench", (String)"WbApplication").getInstance();
                    UiEnv.app.start();
                }
            }
        }
        catch (Throwable e) {
            e.printStackTrace();
        }
        noBindings = new BBinding[0];
    }
}

