/*
 * Decompiled with CFR 0.152.
 */
package javax.baja.ui;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.util.StringTokenizer;
import javax.baja.nre.annotations.NiagaraType;
import javax.baja.nre.util.TextUtil;
import javax.baja.sys.BObject;
import javax.baja.sys.BSimple;
import javax.baja.sys.Context;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.ui.event.BKeyEvent;

@NiagaraType
public final class BAccelerator
extends BSimple {
    public static final BAccelerator NULL;
    public static final BAccelerator DEFAULT;
    public static final Type TYPE;
    private static final String[] keyCodeStrings;
    private int modifiers;
    private int keyCode;
    private String string = "null";

    public Type getType() {
        return TYPE;
    }

    public static BAccelerator make(int keyCode, int modifiers) {
        BAccelerator acc = new BAccelerator();
        acc.string = null;
        acc.keyCode = keyCode;
        acc.modifiers = modifiers;
        return acc;
    }

    public static BAccelerator make(String s) {
        try {
            BAccelerator acc = new BAccelerator();
            acc.parse(s);
            return acc;
        }
        catch (Exception e) {
            throw new IllegalArgumentException("Invalid accelerator \"" + s + "\"");
        }
    }

    private BAccelerator() {
    }

    public boolean isNull() {
        return this == NULL;
    }

    public boolean isMatch(BKeyEvent event) {
        return this.keyCode == event.getKeyCode() && (this.modifiers ^ event.getModifiersEx()) == 0;
    }

    public int getModifiers() {
        return this.modifiers;
    }

    public int getKeyCode() {
        return this.keyCode;
    }

    public String getModifiersString() {
        StringBuilder s = new StringBuilder();
        if ((this.modifiers & 0x80) != 0) {
            s.append("Ctrl+");
        }
        if ((this.modifiers & 0x40) != 0) {
            s.append("Shift+");
        }
        if ((this.modifiers & 0x200) != 0) {
            s.append("Alt+");
        }
        if ((this.modifiers & 0x100) != 0) {
            s.append("Meta+");
        }
        if (s.length() > 0) {
            s.setLength(s.length() - 1);
        }
        return s.toString();
    }

    public String getKeyCodeString() {
        String s = null;
        if (this.keyCode > 0 && this.keyCode < keyCodeStrings.length) {
            s = keyCodeStrings[this.keyCode];
        }
        if (s != null) {
            return s;
        }
        throw new IllegalArgumentException("Invalid key code: " + this.keyCode);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void parse(String s) {
        this.string = s;
        StringTokenizer st = new StringTokenizer(TextUtil.toLowerCase((String)s), "+");
        block17: while (st.hasMoreTokens()) {
            String token = st.nextToken();
            char c0 = token.charAt(0);
            int len = token.length();
            if (len == 1) {
                if ('a' <= c0 && c0 <= 'z') {
                    this.keyCode = 65 + (c0 - 97);
                } else if ('0' <= c0 && c0 <= '9') {
                    this.keyCode = 48 + (c0 - 48);
                } else {
                    if (c0 != '/') throw new RuntimeException();
                    this.keyCode = 47;
                }
            } else {
                char c1 = token.charAt(1);
                switch (c0) {
                    case 'a': {
                        if (!token.equals("alt")) break;
                        this.modifiers |= 0x200;
                        continue block17;
                    }
                    case 'b': {
                        if (!token.equals("backspace")) break;
                        this.keyCode = 8;
                        continue block17;
                    }
                    case 'c': {
                        if (!token.equals("ctrl")) break;
                        this.modifiers |= 0x80;
                        continue block17;
                    }
                    case 'd': {
                        if (token.equals("down")) {
                            this.keyCode = 40;
                            break;
                        }
                        if (!token.equals("delete")) break;
                        this.keyCode = 127;
                        break;
                    }
                    case 'e': {
                        if (token.equals("end")) {
                            this.keyCode = 35;
                            break;
                        }
                        if (!token.equals("esc")) break;
                        this.keyCode = 27;
                        break;
                    }
                    case 'f': {
                        if (len == 2 && '1' <= c1 && c1 <= '9') {
                            this.keyCode = 112 + (c1 - 49);
                            break;
                        }
                        if (token.equals("f10")) {
                            this.keyCode = 121;
                            break;
                        }
                        if (token.equals("f11")) {
                            this.keyCode = 122;
                            break;
                        }
                        if (!token.equals("f12")) break;
                        this.keyCode = 123;
                        break;
                    }
                    case 'h': {
                        if (!token.equals("home")) break;
                        this.keyCode = 36;
                        break;
                    }
                    case 'i': {
                        if (!token.equals("insert")) break;
                        this.keyCode = 155;
                        break;
                    }
                    case 'l': {
                        if (!token.equals("left")) break;
                        this.keyCode = 37;
                        break;
                    }
                    case 'm': {
                        if (!token.equals("meta")) break;
                        this.modifiers |= 0x100;
                        continue block17;
                    }
                    case 'p': {
                        if (token.equals("pageup")) {
                            this.keyCode = 33;
                            break;
                        }
                        if (!token.equals("pagedown")) break;
                        this.keyCode = 34;
                        break;
                    }
                    case 'r': {
                        if (!token.equals("right")) break;
                        this.keyCode = 39;
                        break;
                    }
                    case 's': {
                        if (token.equals("shift")) {
                            this.modifiers |= 0x40;
                            continue block17;
                        }
                        if (!token.equals("space")) break;
                        this.keyCode = 32;
                        break;
                    }
                    case 't': {
                        if (!token.equals("tab")) break;
                        this.keyCode = 9;
                        break;
                    }
                    case 'u': {
                        if (!token.equals("up")) break;
                        this.keyCode = 38;
                    }
                }
            }
            if (!st.hasMoreTokens()) break;
            throw new RuntimeException();
        }
        if (this.keyCode != 0) return;
        throw new RuntimeException();
    }

    public int hashCode() {
        return this.keyCode ^ ~this.modifiers;
    }

    public boolean equals(Object object) {
        if (object instanceof BAccelerator) {
            BAccelerator a = (BAccelerator)((Object)object);
            return this.keyCode == a.keyCode && this.modifiers == a.modifiers;
        }
        return false;
    }

    public String toString(Context context) {
        return this.encodeToString();
    }

    public void encode(DataOutput out) throws IOException {
        out.writeUTF(this.encodeToString());
    }

    public BObject decode(DataInput in) throws IOException {
        return this.decodeFromString(in.readUTF());
    }

    public String encodeToString() {
        if (this.string == null) {
            this.string = this.modifiers == 0 ? this.getKeyCodeString() : this.getModifiersString() + '+' + this.getKeyCodeString();
        }
        return this.string;
    }

    public BObject decodeFromString(String s) throws IOException {
        try {
            if (s.equals("null")) {
                return NULL;
            }
            return BAccelerator.make(s);
        }
        catch (Exception e) {
            throw new IOException("Invalid accelerator: " + s);
        }
    }

    static {
        int i;
        DEFAULT = NULL = new BAccelerator();
        TYPE = Sys.loadType(BAccelerator.class);
        keyCodeStrings = new String[255];
        for (i = 65; i <= 90; ++i) {
            BAccelerator.keyCodeStrings[i] = String.valueOf((char)(65 + i - 65));
        }
        for (i = 48; i <= 57; ++i) {
            BAccelerator.keyCodeStrings[i] = String.valueOf((char)(48 + i - 48));
        }
        for (i = 112; i <= 123; ++i) {
            BAccelerator.keyCodeStrings[i] = "F" + (i - 112 + 1);
        }
        BAccelerator.keyCodeStrings[47] = "/";
        BAccelerator.keyCodeStrings[38] = "Up";
        BAccelerator.keyCodeStrings[40] = "Down";
        BAccelerator.keyCodeStrings[37] = "Left";
        BAccelerator.keyCodeStrings[39] = "Right";
        BAccelerator.keyCodeStrings[36] = "Home";
        BAccelerator.keyCodeStrings[35] = "End";
        BAccelerator.keyCodeStrings[155] = "Insert";
        BAccelerator.keyCodeStrings[127] = "Delete";
        BAccelerator.keyCodeStrings[33] = "PageUp";
        BAccelerator.keyCodeStrings[34] = "PageDown";
        BAccelerator.keyCodeStrings[8] = "Backspace";
        BAccelerator.keyCodeStrings[9] = "Tab";
        BAccelerator.keyCodeStrings[32] = "Space";
    }
}

