/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.ui.wizard.step.util;

import com.tridium.ui.util.BProgressTextPane;
import com.tridium.ui.wizard.step.BWizardButtonMode;
import com.tridium.ui.wizard.step.ICommitLog;
import com.tridium.ui.wizard.step.IWizardView;
import com.tridium.ui.wizard.step.StepArtifact;
import com.tridium.ui.wizard.step.StepModel;
import com.tridium.ui.wizard.step.WidgetUiHandler;
import com.tridium.ui.wizard.step.WizardStep;
import javax.baja.sys.Context;
import javax.baja.ui.BWidget;

public class ProgressTextPaneUiHandler
extends WidgetUiHandler {
    private WorkerRunnable worker;
    private boolean showCancelWhenRunning = true;

    public ProgressTextPaneUiHandler(WorkerRunnable worker) {
        this.worker = worker;
    }

    @Override
    public StepArtifact create(WizardStep step, StepModel model, IWizardView view, Context cx) {
        step.setOverrideMode(this.showCancelWhenRunning ? BWizardButtonMode.cancel : BWizardButtonMode.none);
        this.worker.step = step;
        this.worker.model = model;
        this.worker.view = view;
        this.worker.uiHandler = this;
        this.worker.cx = cx;
        this.setWidget(new BProgressTextPane(this.worker));
        return super.create(step, model, view, cx);
    }

    @Override
    public boolean restoreFromNext(StepArtifact artifact, StepModel model, IWizardView view, Context cx) {
        return false;
    }

    @Override
    public boolean restoreFromBack(StepArtifact artifact, StepModel model, IWizardView view, Context cx) {
        WidgetUiHandler.WidgetStepArtifact widgetStepArtifact = (WidgetUiHandler.WidgetStepArtifact)artifact;
        BProgressTextPane box = (BProgressTextPane)widgetStepArtifact.getWidget();
        box.setWorkerRunnable(null);
        return super.restoreFromBack(artifact, model, view, cx);
    }

    public void setShowCancelWhenRunning(boolean showCancelWhenRunning) {
        this.showCancelWhenRunning = showCancelWhenRunning;
    }

    public boolean getShowCancelWhenRunning() {
        return this.showCancelWhenRunning;
    }

    public static abstract class WorkerRunnable
    extends BProgressTextPane.WorkerRunnable {
        private StepModel model;
        private WizardStep step;
        private IWizardView view;
        private ProgressTextPaneUiHandler uiHandler;
        private Context cx;
        private ICommitLog log = new ICommitLog(){

            @Override
            public void log(String msg) {
                this.add(msg);
            }
        };

        @Override
        public final void doRun() throws Exception {
            try {
                this.workIt();
            }
            catch (Throwable throwable) {
                BWidget.invokeLater(new Runnable(this){
                    final /* synthetic */ WorkerRunnable this$0;
                    {
                        this.this$0 = this$0;
                    }

                    @Override
                    public void run() {
                        this.this$0.step.clearOverrideMode();
                        if (!this.this$0.getStepModel().hasNext(this.this$0.getWizardView())) {
                            this.this$0.getStepModel().setFinished();
                        }
                        try {
                            this.this$0.model.update(this.this$0.view);
                        }
                        catch (Exception exception) {
                            // empty catch block
                        }
                    }
                });
                throw throwable;
            }
            BWidget.invokeLater(new /* invalid duplicate definition of identical inner class */);
        }

        public abstract void workIt() throws Exception;

        protected final StepModel getStepModel() {
            return this.model;
        }

        protected final WizardStep getWizardStep() {
            return this.step;
        }

        protected final IWizardView getWizardView() {
            return this.view;
        }

        protected final ProgressTextPaneUiHandler getUiHandler() {
            return this.uiHandler;
        }

        protected final Context getContext() {
            return this.cx;
        }

        protected final ICommitLog getCommitLog() {
            return this.log;
        }
    }
}

