/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.ui.util;

import com.tridium.ui.ShellManager;
import com.tridium.ui.UiEnv;
import com.tridium.ui.theme.Theme;
import javax.baja.gx.BBrush;
import javax.baja.gx.BColor;
import javax.baja.gx.BInsets;
import javax.baja.gx.BSize;
import javax.baja.gx.IRectGeom;
import javax.baja.gx.Insets;
import javax.baja.ui.BDialog;
import javax.baja.ui.BScrollBar;
import javax.baja.ui.BWidget;
import javax.baja.ui.BWidgetShell;
import javax.baja.ui.BWindow;
import javax.baja.ui.enums.BScrollBarPolicy;
import javax.baja.ui.enums.BWindowSizeEnum;
import javax.baja.ui.pane.BBorderPane;
import javax.baja.ui.pane.BConstrainedPane;
import javax.baja.ui.pane.BEdgePane;
import javax.baja.ui.pane.BFlowPane;
import javax.baja.ui.pane.BGridPane;
import javax.baja.ui.pane.BResponsivePane;
import javax.baja.ui.pane.BScrollPane;
import javax.baja.ui.pane.BTabbedPane;
import javax.baja.ui.pane.BTextEditorPane;
import javax.baja.ui.px.BPxInclude;

public final class LayoutUtil {
    private static final double SCROLL_BAR_DIMENSION = 13.0;

    private LayoutUtil() {
    }

    public static InsetInfo getAccumulatedInsets(BWidget widget) {
        BWidget ancestor = widget;
        BWidget offsetParent = LayoutUtil.getOffsetParent(widget);
        boolean responsiveFound = false;
        double top = 0.0;
        double right = 0.0;
        double bottom = 0.0;
        double left = 0.0;
        double zoomedScrollBarWidth = 0.0;
        while (ancestor != null && ancestor != offsetParent) {
            BInsets border;
            if ((ancestor = ancestor.getParentWidget()) instanceof BBorderPane) {
                border = ((BBorderPane)ancestor).getAccumulatedBorder();
                top += border.top;
                right += border.right;
                bottom += border.bottom;
                left += border.left;
                continue;
            }
            if (ancestor instanceof BResponsivePane) {
                responsiveFound = true;
                BResponsivePane responsivePane = (BResponsivePane)ancestor;
                BFlowPane flowPane = (BFlowPane)responsivePane.getParentWidget();
                double width = flowPane.getPreferredWidth(responsivePane);
                left = left + flowPane.getWidth() - width;
                continue;
            }
            if (ancestor instanceof BScrollPane && responsiveFound) {
                border = LayoutUtil.getScrollPaneInsets((BScrollPane)ancestor);
                top += border.top;
                right += border.right;
                bottom += border.bottom;
                left += border.left;
                continue;
            }
            if (!(ancestor instanceof BScrollPane)) continue;
            zoomedScrollBarWidth = Theme.scrollBar().getFixedWidth();
        }
        return new InsetInfo(BInsets.make((double)top, (double)right, (double)bottom, (double)left), zoomedScrollBarWidth);
    }

    public static BWidget getOffsetParent(BWidget widget) {
        BWidget parent;
        for (parent = widget.getParentWidget(); parent != null; parent = parent.getParentWidget()) {
            if (LayoutUtil.childMustSizeSelf(parent, widget)) {
                return null;
            }
            if (LayoutUtil.canScaleChildToSelf(parent)) {
                return widget;
            }
            widget = parent;
        }
        return parent == null ? null : widget;
    }

    private static boolean childMustSizeSelf(BWidget parent, BWidget child) {
        if (parent instanceof BEdgePane) {
            BEdgePane edgePane = (BEdgePane)parent;
            return child != edgePane.getCenter();
        }
        String parentType = parent.getType().toString();
        return parent instanceof BConstrainedPane || parent instanceof BGridPane || "mobile:BasicMobilePane".equals(parentType) || "mobile:MobileGridPane".equals(parentType);
    }

    private static boolean canScaleChildToSelf(BWidget widget) {
        return !(widget instanceof BBorderPane) && !(widget instanceof BScrollPane) && !(widget instanceof BFlowPane) && !(widget instanceof BResponsivePane) && !(widget instanceof BPxInclude);
    }

    public static boolean isSelfScalingEnabled(BWidget widget) {
        ShellManager shellManager = widget.getShellManager();
        return shellManager == null || shellManager.allowScalingTransforms();
    }

    public static BScrollPane getParentScrollPane(BWidget widget) {
        if (widget == null) {
            return null;
        }
        BWidget parent = widget.getParentWidget();
        while (parent instanceof BBorderPane) {
            parent = parent.getParentWidget();
        }
        return parent instanceof BScrollPane ? (BScrollPane)parent : null;
    }

    public static BInsets getAccumulatedBorderAndScrollSize(BWidget widget) {
        BInsets border;
        BWidget ancestor = widget;
        double top = 0.0;
        double right = 0.0;
        double bottom = 0.0;
        double left = 0.0;
        do {
            if (!((ancestor = ancestor.getParentWidget()) instanceof BBorderPane)) continue;
            border = ((BBorderPane)ancestor).getAccumulatedBorder();
            top += border.top;
            right += border.right;
            bottom += border.bottom;
            left += border.left;
        } while (ancestor instanceof BBorderPane);
        if (ancestor instanceof BScrollPane) {
            border = LayoutUtil.getScrollPaneInsets((BScrollPane)ancestor);
            top += border.top;
            right += border.right;
            bottom += border.bottom;
            left += border.left;
        }
        return BInsets.make((double)top, (double)right, (double)bottom, (double)left);
    }

    public static BInsets getScrollPaneInsets(BScrollPane scrollPane) {
        BScrollBar hsb = scrollPane.getHscrollBar();
        BScrollBar vsb = scrollPane.getVscrollBar();
        double scrollW = vsb.getPreferredWidth();
        double scrollH = hsb.getPreferredHeight();
        if (hsb.getWidth() == 0.0) {
            scrollH = 0.0;
        }
        return BInsets.make((double)0.0, (double)scrollW, (double)scrollH, (double)0.0);
    }

    public static BSize getPreferredSizeForDialogContent(BWidget c) {
        c.computePreferredSize();
        double width = c.getPreferredWidth() + 12.0;
        double height = c.getPreferredHeight() + 12.0;
        if (!(c instanceof BTextEditorPane) && (c instanceof BScrollPane || c instanceof BTabbedPane)) {
            if (c instanceof BScrollPane) {
                width = c.getPreferredWidth() > 800.0 ? 800.0 : (c.getPreferredWidth() < 400.0 ? 400.0 : c.getPreferredWidth() + 27.0);
                height = c.getPreferredHeight() > 800.0 ? 800.0 : (c.getPreferredHeight() < 100.0 ? 100.0 : c.getPreferredHeight() + 8.0);
            } else {
                width = 400.0;
                height = 300.0;
            }
        }
        return BSize.make((double)width, (double)height);
    }

    public static BSize getPreferredSizeForPotentialScrollBars(BWidget widget, boolean potentialVerticalScrollBar, boolean potentialHorizontalScrollbar) {
        double width = widget.getPreferredWidth();
        double height = widget.getPreferredHeight();
        if (potentialVerticalScrollBar) {
            width += 13.0;
        }
        if (potentialHorizontalScrollbar) {
            height += 13.0;
        }
        return BSize.make((double)width, (double)height);
    }

    public static void setPreferredSizeForPotentialScrollBars(BWidget widget, boolean potentialVerticalScrollBar, boolean potentialHorizontalScrollbar) {
        BSize size = LayoutUtil.getPreferredSizeForPotentialScrollBars(widget, potentialVerticalScrollBar, potentialHorizontalScrollbar);
        widget.setPreferredSize(size.width(), size.height());
    }

    public static BWidget getScrollablePaneForDialogEditor(BWidget widget) {
        BScrollPane scrollPane = new BScrollPane(widget);
        scrollPane.setViewportBackground(BBrush.makeSolid((BColor)BColor.transparent));
        scrollPane.setBorderPolicy(BScrollBarPolicy.never);
        return scrollPane;
    }

    public static BWidget getWidgetForPreferredDialogSizing(BWindow dlg) {
        BWidget widget = dlg.getContent();
        while (widget != null) {
            if (widget instanceof BBorderPane) {
                widget = ((BBorderPane)widget).getContent();
                continue;
            }
            if (widget instanceof BScrollPane) {
                widget = ((BScrollPane)widget).getContent();
                continue;
            }
            if (!(widget instanceof BConstrainedPane)) break;
            widget = ((BConstrainedPane)widget).getContent();
        }
        return widget;
    }

    public static void resizeDialog(BWidget widget, BWindowSizeEnum windowSizeEnum) {
        BWidgetShell shell = widget.getShell();
        if (shell instanceof BDialog) {
            BDialog dialog = (BDialog)shell;
            LayoutUtil.resizeWindow(dialog, widget, windowSizeEnum);
        }
    }

    public static void resizeWindow(BWindow window, BWindowSizeEnum windowSizeEnum) {
        LayoutUtil.resizeWindow(window, LayoutUtil.getWidgetForPreferredDialogSizing(window), windowSizeEnum);
    }

    public static void resizeWindow(BWindow window, BWidget widget, BWindowSizeEnum windowSizeEnum) {
        Insets insets = UiEnv.get().getWindowInsets(window);
        window.computePreferredSize();
        if (windowSizeEnum.equals((Object)BWindowSizeEnum.preferredSize)) {
            double w = window.getPreferredWidth() + insets.left + insets.right;
            double h = window.getPreferredHeight() + insets.top + insets.bottom;
            IRectGeom cur = window.getScreenBounds();
            window.setScreenBounds(cur.x(), cur.y(), w, h);
            return;
        }
        if (windowSizeEnum.equals((Object)BWindowSizeEnum.preferredWidth)) {
            double w = window.getPreferredWidth() + insets.left + insets.right;
            IRectGeom cur = window.getScreenBounds();
            window.setScreenBounds(cur.x(), cur.y(), w, cur.height());
            return;
        }
        if (windowSizeEnum.equals((Object)BWindowSizeEnum.preferredHeight)) {
            double h = window.getPreferredHeight() + insets.top + insets.bottom;
            IRectGeom cur = window.getScreenBounds();
            window.setScreenBounds(cur.x(), cur.y(), cur.width(), h);
            return;
        }
        InsetInfo info = LayoutUtil.getAccumulatedInsets(widget);
        BInsets infoInsets = info.getInsets();
        IRectGeom cur = window.getScreenBounds();
        IRectGeom screenBounds = UiEnv.get().getScreenBounds(window);
        double h = cur.height();
        if (!windowSizeEnum.equals((Object)BWindowSizeEnum.fitPreferredWidth)) {
            double maxHeight = screenBounds.height() + screenBounds.y() - cur.y();
            h = window.getPreferredHeight() + insets.top() + insets.bottom() + infoInsets.top() + infoInsets.bottom();
            h = Math.min(h, maxHeight);
        }
        double w = cur.width();
        if (!windowSizeEnum.equals((Object)BWindowSizeEnum.fitPreferredHeight)) {
            double maxWidth = screenBounds.width() + screenBounds.x() - cur.x();
            w = window.getPreferredWidth() + insets.left() + insets.right() + infoInsets.left() + infoInsets.right();
            w = Math.min(w, maxWidth);
        }
        window.setScreenBounds(cur.x(), cur.y(), w, h);
        widget.relayout();
    }

    public static class InsetInfo {
        private final BInsets inset;
        private final double zoomedScrollBarWidth;

        public InsetInfo(BInsets inset, double zoomedScrollBarWidth) {
            this.inset = inset;
            this.zoomedScrollBarWidth = zoomedScrollBarWidth;
        }

        public BInsets getInsets() {
            return this.inset;
        }

        public double getZoomedScrollBarWidth() {
            return this.zoomedScrollBarWidth;
        }
    }
}

