/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.ui.theme.palladium;

import com.tridium.ui.theme.SliderTheme;
import com.tridium.ui.theme.palladium.PalladiumWidgetTheme;
import javax.baja.gx.BBrush;
import javax.baja.gx.Graphics;
import javax.baja.gx.IGeom;
import javax.baja.gx.PolygonGeom;
import javax.baja.gx.RectGeom;
import javax.baja.ui.BSlider;
import javax.baja.ui.enums.BOrientation;

public class PalladiumSliderTheme
extends PalladiumWidgetTheme
implements SliderTheme {
    @Override
    public double getFixedWidth(BSlider s) {
        return 17.0;
    }

    @Override
    public double getThumbWidth(BSlider s) {
        return 11.0;
    }

    @Override
    public void paintTrack(Graphics g, BSlider s, RectGeom r) {
        BBrush brush = s.getTrackBrush();
        g.setBrush(brush.isNull() ? this.getControlAuxiliary() : brush);
        g.fillRect(r.x, r.y, r.width, r.height);
        if (s.getEnabled()) {
            g.setBrush(this.getControlForeground());
        } else {
            g.setBrush(this.getControlShadow());
        }
        g.strokeRect(r.x, r.y, r.width, r.height);
        if (s.getEnabled()) {
            g.setBrush(this.getControlShadow());
        } else {
            g.setBrush(this.getControlAuxiliary());
        }
        g.strokeLine(r.x + 1.0, r.y + 1.0, r.x + r.width - 1.0, r.y + 1.0);
        g.strokeLine(r.x + 1.0, r.y + 1.0, r.x + 1.0, r.y + r.height - 1.0);
        g.setBrush(this.getControlBackground());
        g.strokeLine(r.x + 2.0, r.y + r.height - 1.0, r.x + r.width - 1.0, r.y + r.height - 1.0);
        g.strokeLine(r.x + r.width - 1.0, r.y + r.height - 1.0, r.x + r.width - 1.0, r.y + 2.0);
    }

    @Override
    public void paintThumb(Graphics g, BSlider s, RectGeom r) {
        if (s.getOrientation() == BOrientation.horizontal) {
            this.paintThumbHoriz(g, s, r);
        } else {
            this.paintThumbVert(g, s, r);
        }
    }

    private void paintThumbHoriz(Graphics g, BSlider s, RectGeom r) {
        double rx = r.x;
        double ry = r.y;
        double rw = r.width;
        double rh = r.height;
        double[] tx = new double[5];
        double[] ty = new double[5];
        tx[0] = rx;
        ty[0] = ry;
        tx[1] = rx;
        ty[1] = ry + rh - 6.0;
        tx[2] = rx + (rw - 1.0) / 2.0;
        ty[2] = ry + rh - 1.0;
        tx[3] = rx + rw - 1.0;
        ty[3] = ry + rh - 6.0;
        tx[4] = rx + rw - 1.0;
        ty[4] = ry;
        PolygonGeom thumb = new PolygonGeom(tx, ty, 5);
        BBrush brush = s.getThumbBrush();
        g.setBrush(brush.isNull() ? this.getControlBackground() : brush);
        g.fill((IGeom)thumb);
        if (s.getEnabled()) {
            g.setBrush(this.getControlForeground());
        } else {
            g.setBrush(this.getControlShadow());
        }
        g.stroke((IGeom)thumb);
        g.setBrush(this.getControlHighlight());
        g.strokeLine(r.x + 1.0, r.y + 1.0, r.x + r.width - 3.0, r.y + 1.0);
        g.strokeLine(r.x + 1.0, r.y + 1.0, r.x + 1.0, r.y + r.height - 6.0);
        if (s.getEnabled()) {
            g.setBrush(this.getControlShadow());
        } else {
            g.setBrush(this.getControlAuxiliary());
        }
        g.strokeLine(rx + rw - 2.0, ry + 1.0, rx + rw - 2.0, ry + rh - 6.0);
        g.strokeLine(rx + (rw - 1.0) / 2.0, ry + rh - 2.0, rx + rw - 2.0, ry + rh - 6.0);
        double x = rx + 4.0;
        double y = ry + 4.0;
        g.setBrush(this.getControlHighlight());
        g.strokeLine(x, y + 1.0, x + 2.0, y + 1.0);
        g.strokeLine(x, y + 5.0, x + 2.0, y + 5.0);
        g.setBrush(this.getControlShadow());
        g.strokeLine(x, y, x, y + 1.0);
        g.strokeLine(x, y + 4.0, x, y + 5.0);
        g.strokeLine(x, y, x + 2.0, y);
        g.strokeLine(x, y + 4.0, x + 2.0, y + 4.0);
    }

    private void paintThumbVert(Graphics g, BSlider s, RectGeom r) {
        double rx = r.x;
        double ry = r.y;
        double rw = r.width;
        double rh = r.height;
        double[] tx = new double[5];
        double[] ty = new double[5];
        tx[0] = rx;
        ty[0] = ry;
        tx[1] = rx + rw - 6.0;
        ty[1] = ry;
        tx[2] = rx + rw - 1.0;
        ty[2] = ry + (rh - 1.0) / 2.0;
        tx[3] = rx + rw - 6.0;
        ty[3] = ry + rh - 1.0;
        tx[4] = rx;
        ty[4] = ry + rh - 1.0;
        PolygonGeom thumb = new PolygonGeom(tx, ty, 5);
        BBrush brush = s.getThumbBrush();
        g.setBrush(brush.isNull() ? this.getControlBackground() : brush);
        g.fill((IGeom)thumb);
        if (s.getEnabled()) {
            g.setBrush(this.getControlForeground());
        } else {
            g.setBrush(this.getControlShadow());
        }
        g.stroke((IGeom)thumb);
        g.setBrush(this.getControlHighlight());
        g.strokeLine(rx + 1.0, ry + 1.0, rx + rw - 6.0, ry + 1.0);
        g.strokeLine(rx + 1.0, ry + 1.0, rx + 1.0, ry + rh - 3.0);
        if (s.getEnabled()) {
            g.setBrush(this.getControlShadow());
        } else {
            g.setBrush(this.getControlAuxiliary());
        }
        g.strokeLine(rx + 1.0, ry + rh - 2.0, rx + rw - 6.0, ry + rh - 2.0);
        g.strokeLine(rx + rw - 2.0, ry + (rh - 1.0) / 2.0, rx + rw - 6.0, ry + rh - 2.0);
        double x = rx + 4.0;
        double y = ry + 4.0;
        g.setBrush(this.getControlHighlight());
        g.strokeLine(x + 1.0, y, x + 1.0, y + 2.0);
        g.strokeLine(x + 5.0, y, x + 5.0, y + 2.0);
        g.setBrush(this.getControlShadow());
        g.strokeLine(x, y, x + 1.0, y);
        g.strokeLine(x + 4.0, y, x + 5.0, y);
        g.strokeLine(x, y, x, y + 2.0);
        g.strokeLine(x + 4.0, y, x + 4.0, y + 2.0);
    }
}

