/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.ui.theme.custom.nss;

import com.tridium.gx.GxEnv;
import com.tridium.ui.theme.custom.nss.NSS;
import com.tridium.ui.theme.custom.nss.NSSDefaults;
import com.tridium.ui.theme.custom.nss.NSSException;
import com.tridium.ui.theme.custom.nss.NSSUtils;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.StreamTokenizer;
import java.io.StringReader;
import java.util.HashMap;
import java.util.Map;
import java.util.Stack;
import java.util.StringTokenizer;
import javax.baja.file.BIFile;
import javax.baja.naming.BOrd;

public class NSSReader {
    private Stack<NSS> stack = new Stack();
    private String currentTagName = null;
    private Object currentValue = null;
    private Map<String, Definition> definitions = new HashMap<String, Definition>();
    private StreamTokenizer tokenizer;
    private String token = "";
    private int tagNumber = 0;
    private NSS nss;
    private NSS parentNSS;
    private boolean fontsOverridden = false;

    public static NSS readFromFile(BIFile file) throws IOException {
        try (InputStreamReader reader = null;){
            reader = new InputStreamReader(file.getInputStream());
            NSS nSS = NSSReader.doRead(reader);
            return nSS;
        }
    }

    public static NSS readFromString(String s) throws IOException {
        try (StringReader reader = null;){
            reader = new StringReader(s);
            NSS nSS = NSSReader.doRead(reader);
            return nSS;
        }
    }

    private static NSS doRead(Reader reader) throws IOException {
        NSSReader nssReader = new NSSReader(reader);
        nssReader.read();
        nssReader.finish();
        NSS defaults = new NSS();
        NSSDefaults.setPalladiumDefaults(defaults);
        NSSReader.overrideNSS(nssReader.nss, defaults);
        return defaults;
    }

    private static void overrideNSS(NSS donor, NSS recipient) {
        for (Map.Entry entry : donor.entrySet()) {
            Object key = entry.getKey();
            Object value = entry.getValue();
            Object otherValue = recipient.get(key);
            if (value instanceof NSS && otherValue instanceof NSS) {
                NSSReader.overrideNSS((NSS)value, (NSS)otherValue);
                continue;
            }
            recipient.put((String)key, value);
        }
    }

    private NSSReader(Reader reader) {
        this.tokenizer = NSSReader.makeStreamTokenizer(reader);
    }

    private void read() throws IOException {
        NSS root = new NSS();
        this.stack.push(root);
        while ((this.token = this.getNextToken()) != null) {
            if (this.token.equals("{")) {
                this.startNewNode();
                continue;
            }
            if (this.token.equals("}")) {
                this.closeCurrentNode();
                continue;
            }
            if (this.token.equals(";")) {
                this.closeTag();
                continue;
            }
            if (this.token.equals(":")) {
                this.verifyTagStarted();
                continue;
            }
            this.handleValueToken();
        }
        if (this.parentNSS != null) {
            NSSReader.overrideNSS(root, this.parentNSS);
            this.nss = this.parentNSS;
        } else {
            this.nss = root;
        }
    }

    private String getNextToken() throws IOException {
        if (this.tokenizer.nextToken() == -1) {
            return null;
        }
        switch (this.tokenizer.ttype) {
            case 10: {
                return "";
            }
            case -3: 
            case 34: 
            case 39: {
                return this.tokenizer.sval;
            }
        }
        return new String(new char[]{(char)this.tokenizer.ttype});
    }

    private void startNewNode() {
        if (this.currentTagName == null) {
            throw new NSSException("unexpected symbol '{' on line " + this.tokenizer.lineno() + " (did you omit a name?)");
        }
        NSS newNode = new NSS(this.stack.peek(), this.currentTagName);
        this.addToHead(this.currentTagName, newNode);
        this.stack.push(newNode);
        this.reset();
    }

    private void closeCurrentNode() {
        if (this.stack.size() == 1) {
            throw new NSSException("unexpected symbol '}' on line " + this.tokenizer.lineno() + " (you've tried to close  a block with '}' but missed the opening '{')");
        }
        NSS nss = this.stack.pop();
        if (nss.getName().equals("font-families")) {
            this.applyFontOverrides(nss);
        }
        this.reset();
    }

    private void applyFontOverrides(NSS nss) {
        if (this.fontsOverridden) {
            throw new NSSException("Duplicate font-families tag detected - only one font-families tag allowed per NSS file");
        }
        if (nss.has("serif")) {
            NSSReader.doFontOverride("serif", (String)nss.get("serif"));
        }
        if (nss.has("sansserif")) {
            NSSReader.doFontOverride("sansserif", (String)nss.get("sansserif"));
        }
        if (nss.has("monospaced")) {
            NSSReader.doFontOverride("monospaced", (String)nss.get("monospaced"));
        }
        if (nss.has("dialog")) {
            NSSReader.doFontOverride("dialog", (String)nss.get("dialog"));
        }
        if (nss.has("dialoginput")) {
            NSSReader.doFontOverride("dialoginput", (String)nss.get("dialoginput"));
        }
        this.fontsOverridden = true;
    }

    private static void doFontOverride(String fontFamily, String newFonts) {
        GxEnv.get().overrideFontFamily(fontFamily, newFonts);
    }

    private void handleValueToken() {
        if (this.token.length() > 0) {
            if (this.currentTagName == null) {
                this.startTag(this.token);
            } else {
                this.appendValue(this.token);
            }
        }
    }

    private void startTag(String tagName) {
        this.currentTagName = tagName;
    }

    private void appendValue(String value) {
        this.currentValue = this.currentValue instanceof String ? this.currentValue + " " + value : value;
    }

    private void closeTag() {
        if (this.currentTagName == null || this.currentValue == null) {
            throw new NSSException("Unexpected symbol ';' at line " + this.tokenizer.lineno() + " (did you omit a property?)");
        }
        this.addToHead(this.currentTagName, this.currentValue);
        this.reset();
    }

    private void verifyTagStarted() {
        if (this.currentTagName == null || this.currentValue != null) {
            throw new NSSException("Unexpected symbol ':' on line " + this.tokenizer.lineno() + ": ':' is optional but must always separate tag name and value");
        }
    }

    private void reset() {
        this.currentTagName = null;
        this.currentValue = null;
    }

    private void addToHead(String name, Object value) {
        ++this.tagNumber;
        NSS parentNode = this.stack.peek();
        if (value instanceof NSS) {
            this.addChildNode(parentNode, name, (NSS)value);
        } else if (value instanceof String) {
            String s = (String)value;
            if (name.equals("#define")) {
                this.addDefinition(s);
            } else if (name.equals("#extends")) {
                this.processExtends(s);
            } else {
                this.addChildString(parentNode, name, s);
            }
        }
    }

    private void addChildNode(NSS parentNode, String tagName, NSS childNode) {
        parentNode.put(tagName, (Object)childNode);
    }

    private void addChildString(NSS parentNode, String tagName, String value) {
        parentNode.put(tagName, (Object)value);
    }

    private void addDefinition(String definition) {
        StringTokenizer tok = new StringTokenizer(definition, " \t\n\r\f=");
        Definition def = null;
        while (tok.hasMoreTokens()) {
            String token = tok.nextToken();
            if (def == null) {
                def = new Definition(token, this.tokenizer.lineno());
                continue;
            }
            def.append(token);
        }
        if (def != null && def.value != null) {
            this.definitions.put(def.tagName, def);
        }
    }

    private boolean isDefinition(String token) {
        return token.startsWith("$");
    }

    private Definition getDefinition(String definition) {
        Definition def = this.definitions.get(definition.substring(1));
        if (def == null) {
            throw new NSSException("No definition available for reference '" + definition + "'");
        }
        return def;
    }

    private void finish() {
        this.finalizeNSS(this.nss);
    }

    private void finalizeNSS(NSS nss) {
        for (Map.Entry entry : nss.entrySet()) {
            String tagName = (String)entry.getKey();
            Object value = entry.getValue();
            if (value instanceof String) {
                String s = (String)value;
                if (this.isDefinition(s)) {
                    Definition def = this.getDefinition(s);
                    try {
                        entry.setValue(NSSUtils.makeValueByTag(tagName, def.value));
                        continue;
                    }
                    catch (Exception e) {
                        throw new NSSException("Could not successfully parse defined value '" + def.value + "' defined by '" + s + "' at line " + def.lineNumber);
                    }
                }
                try {
                    entry.setValue(NSSUtils.makeValueByTag(tagName, s));
                    continue;
                }
                catch (Exception e) {
                    throw new NSSException("Could not successfully parse value '" + value + "'.");
                }
            }
            if (!(value instanceof NSS)) continue;
            this.finalizeNSS((NSS)value);
        }
    }

    private void processExtends(String parentNSSPath) {
        if (this.tagNumber > 1) {
            throw new NSSException("#extends must be the very first token in file");
        }
        Reader reader = null;
        try {
            BIFile file = (BIFile)BOrd.make((String)parentNSSPath).get();
            reader = new InputStreamReader(file.getInputStream());
            NSSReader parentReader = new NSSReader(reader);
            parentReader.read();
            this.definitions = parentReader.definitions;
            this.parentNSS = parentReader.nss;
        }
        catch (Exception e) {
            throw new NSSException("Could not read overridden NSS file " + parentNSSPath + ": " + e.getMessage());
        }
        finally {
            if (reader != null) {
                try {
                    reader.close();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
        }
    }

    private static StreamTokenizer makeStreamTokenizer(Reader reader) {
        BufferedReader br = new BufferedReader(reader);
        StreamTokenizer st = new StreamTokenizer(br);
        st.eolIsSignificant(true);
        st.ordinaryChars(48, 57);
        st.ordinaryChar(46);
        st.wordChars(33, 41);
        st.wordChars(43, 46);
        st.wordChars(48, 57);
        st.wordChars(95, 95);
        st.ordinaryChar(92);
        st.wordChars(92, 92);
        st.quoteChar(39);
        st.quoteChar(34);
        st.slashSlashComments(true);
        st.slashStarComments(true);
        st.ordinaryChar(59);
        st.ordinaryChar(58);
        return st;
    }

    private class Definition {
        String tagName;
        String value;
        int lineNumber;

        public Definition(String tagName, int lineNumber) {
            this.tagName = tagName;
            this.lineNumber = lineNumber;
        }

        public void append(String value) {
            this.value = this.value == null ? value : this.value + " " + value;
        }

        public boolean equals(Object o) {
            if (!(o instanceof Definition)) {
                return false;
            }
            return this.tagName.equals(((Definition)o).tagName);
        }

        public int hashCode() {
            return this.tagName.hashCode();
        }

        public String toString() {
            return this.tagName;
        }
    }
}

