/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.ui.theme.custom;

import com.tridium.gx.awt.AwtGraphics;
import com.tridium.ui.theme.TabbedPaneTheme;
import com.tridium.ui.theme.custom.CustomWidgetTheme;
import java.awt.Graphics2D;
import javax.baja.gx.BBrush;
import javax.baja.gx.BInsets;
import javax.baja.gx.Graphics;
import javax.baja.gx.RectGeom;
import javax.baja.ui.BLabel;
import javax.baja.ui.BWidget;
import javax.baja.ui.enums.BAlign;
import javax.baja.ui.pane.BTabbedPane;

public class CustomTabbedPaneTheme
extends CustomWidgetTheme
implements TabbedPaneTheme {
    private static int TAB_RADIUS = 8;
    private static BInsets contentInsetsFull = BInsets.make((double)2.0, (double)2.0, (double)2.0, (double)2.0);
    private static BInsets tabInsets = BInsets.make((double)5.0, (double)5.0, (double)5.0, (double)5.0);
    private static BInsets contentInsetsTop = BInsets.make((double)2.0, (double)0.0, (double)0.0, (double)0.0);
    private static BInsets contentInsetsLeft = BInsets.make((double)0.0, (double)0.0, (double)0.0, (double)2.0);
    private static BInsets contentInsetsRight = BInsets.make((double)0.0, (double)2.0, (double)0.0, (double)0.0);
    private static BInsets contentInsetsBottom = BInsets.make((double)0.0, (double)0.0, (double)2.0, (double)0.0);

    @Override
    String getNSSSelector() {
        return "pane tabbed-pane";
    }

    private BBrush selectedBrush(boolean isSelected, String tag) {
        return (BBrush)this.select(isSelected ? ".selected " + tag : tag);
    }

    private BBrush getShadow(boolean isSelected) {
        return this.selectedBrush(isSelected, "shadow");
    }

    private BBrush getHighlight(boolean isSelected) {
        return this.selectedBrush(isSelected, "highlight");
    }

    private BBrush getOutline(boolean isSelected) {
        return this.selectedBrush(isSelected, "outline");
    }

    private BBrush getBackground(boolean isSelected) {
        return this.selectedBrush(isSelected, "background-color");
    }

    @Override
    public BInsets getTabInsets(BAlign tabPlacement) {
        Object nssInsets = CustomTabbedPaneTheme.getNSS().select(this.getNSSSelector() + " tab-insets");
        return nssInsets != null ? BInsets.make((double)Integer.valueOf(nssInsets.toString()).intValue()) : tabInsets;
    }

    @Override
    public BInsets getContentInsets(BAlign tabPlacement, boolean fullBorder) {
        if (fullBorder) {
            return contentInsetsFull;
        }
        switch (tabPlacement.getOrdinal()) {
            case 0: {
                return contentInsetsTop;
            }
            case 1: {
                return contentInsetsLeft;
            }
            case 3: {
                return contentInsetsRight;
            }
            case 2: {
                return contentInsetsBottom;
            }
        }
        return null;
    }

    @Override
    public void paintContentBackground(Graphics g, BTabbedPane p, BAlign tabPlacement, BWidget content, boolean fullBorder) {
        BInsets ci = this.getContentInsets(tabPlacement, fullBorder);
        double cx = content.getX() - ci.left;
        double cy = content.getY() - ci.top;
        double cw = content.getWidth() + ci.left + ci.right;
        double ch = content.getHeight() + ci.top + ci.bottom;
        BBrush outline = this.getControlForeground(p);
        BBrush highlight = this.getControlHighlight(p);
        BBrush shadow = this.getControlShadow(p);
        if (fullBorder) {
            g.setBrush(outline);
            g.strokeRect(cx, cy, cw - 1.0, ch - 1.0);
            g.setBrush(highlight);
            g.strokeLine(cx + 1.0, cy + 1.0, cx + cw - 3.0, cy + 1.0);
            g.strokeLine(cx + 1.0, cy + 1.0, cx + 1.0, cy + ch - 3.0);
            g.setBrush(shadow);
            g.strokeLine(cx + cw - 2.0, cy + 1.0, cx + cw - 2.0, cy + ch - 2.0);
            g.strokeLine(cx + cw - 2.0, cy + ch - 2.0, cx + 1.0, cy + ch - 2.0);
        } else {
            switch (tabPlacement.getOrdinal()) {
                case 0: {
                    g.setBrush(highlight);
                    g.strokeLine(cx, cy, cx + cw, cy);
                    break;
                }
                case 2: {
                    g.setBrush(outline);
                    g.strokeLine(cx, cy + ch - 1.0, cx + cw, cy + ch - 1.0);
                    g.setBrush(shadow);
                    g.strokeLine(cx, cy + ch - 2.0, cx + cw, cy + ch - 2.0);
                    break;
                }
                case 1: {
                    g.setBrush(outline);
                    g.strokeLine(cx, cy, cx, cy + ch - 1.0);
                    g.setBrush(highlight);
                    g.strokeLine(cx + 1.0, cy, cx + 1.0, cy + ch - 1.0);
                    break;
                }
                case 3: {
                    g.setBrush(outline);
                    g.strokeLine(cx + cw - 1.0, cy, cx + cw - 1.0, cy + ch - 1.0);
                    g.setBrush(shadow);
                    g.strokeLine(cx + cw - 2.0, cy, cx + cw - 2.0, cy + ch - 1.0);
                }
            }
        }
    }

    @Override
    public void paintTabBackground(Graphics g, BTabbedPane p, BAlign tabPlacement, BLabel label, boolean isSelected, BWidget c, boolean fullBorder) {
        BInsets ti = this.getTabInsets(tabPlacement);
        BInsets ci = this.getContentInsets(tabPlacement, fullBorder);
        double tx = label.getX() - ti.left;
        double ty = label.getY() - ti.top;
        double tw = label.getWidth() + ti.left + ti.right;
        double th = label.getHeight() + ti.top + ti.bottom;
        double maxw = tw;
        double maxh = th;
        if (tx + tw >= p.getWidth()) {
            tw = p.getWidth() - tx - 1.0;
        }
        if (ty + th >= p.getHeight()) {
            th = p.getHeight() - ty - 1.0;
        }
        switch (tabPlacement.getOrdinal()) {
            case 0: {
                maxh = c.getY() - ci.top;
                break;
            }
            case 2: {
                maxh = c.getY() + c.getHeight() + ci.bottom;
                break;
            }
            case 1: {
                maxw = c.getX() - ci.left;
                break;
            }
            case 3: {
                maxw = c.getX() + c.getWidth() + ci.right;
            }
        }
        this.paintTabBackground(g, p, label, tabPlacement, tx, ty, tw, th, maxw, maxh, isSelected);
    }

    protected void paintTabBackground(Graphics g, BTabbedPane p, BLabel label, BAlign tabPlacement, double tx, double ty, double tw, double th, double maxw, double maxh, boolean isSelected) {
        if (tw <= 0.0 || th <= 0.0) {
            return;
        }
        switch (tabPlacement.getOrdinal()) {
            case 0: {
                this.paintTabTop(g, p, tx, ty, tw, th, maxw, maxh, isSelected);
                break;
            }
            case 1: {
                this.paintTabLeft(g, p, tx, ty, tw, th, maxw, maxh, isSelected);
                break;
            }
            case 3: {
                this.paintTabRight(g, p, tx, ty, tw, th, maxw, maxh, isSelected);
                break;
            }
            case 2: {
                this.paintTabBottom(g, p, tx, ty, tw, th, maxw, maxh, isSelected);
                break;
            }
            default: {
                return;
            }
        }
        if (p.hasFocus() && isSelected) {
            this.paintFocus(g, new RectGeom(label.getX() - 1.0, label.getY() - 1.0, label.getWidth() + 1.0, label.getHeight() + 1.0));
        }
    }

    protected void paintTabTop(Graphics g, BTabbedPane pane, double tx, double ty, double tw, double th, double maxw, double maxh, boolean isSelected) {
        BBrush highlight = this.getHighlight(isSelected);
        BBrush background = this.getBackground(isSelected);
        BBrush outline = this.getOutline(isSelected);
        if (!(g instanceof AwtGraphics)) {
            return;
        }
        Graphics2D g2d = ((AwtGraphics)g).getAwtGraphics();
        int tabRadius = TAB_RADIUS;
        int tabDiameter = 2 * tabRadius;
        g.setBrush(background);
        g.fillRect(tx, ty + (double)tabRadius, (double)tabRadius, th - (double)tabRadius);
        g.fillRect(tx + tw - (double)tabRadius, ty + (double)tabRadius, (double)tabRadius, th - (double)tabRadius);
        g.fillRect(tx + (double)tabRadius, ty, tw - (double)tabDiameter, th);
        g2d.fillArc((int)tx, (int)ty, tabDiameter, tabDiameter, 90, 90);
        g2d.fillArc((int)(tx + tw - (double)tabDiameter), (int)ty, tabDiameter, tabDiameter, 0, 90);
        g.setBrush(outline);
        g.strokeLine(tx, ty + th, tx, ty + (double)tabRadius);
        g2d.drawArc((int)tx, (int)ty, tabDiameter, tabDiameter, 90, 90);
        g.strokeLine(tx + (double)tabRadius, ty, tx + tw - (double)tabRadius, ty);
        g2d.drawArc((int)(tx + tw - (double)tabDiameter), (int)ty, tabDiameter, tabDiameter, 0, 90);
        g.strokeLine(tx + tw, ty + (double)tabRadius, tx + tw, ty + th);
        if (isSelected && maxh - ty <= th) {
            g.setBrush(highlight);
            g.strokeLine(tx, ty + th, tx + tw, ty + th);
        }
    }

    protected void paintTabLeft(Graphics g, BTabbedPane pane, double tx, double ty, double tw, double th, double maxw, double maxh, boolean isSelected) {
        BBrush highlight = this.getHighlight(isSelected);
        BBrush background = this.getBackground(isSelected);
        BBrush outline = this.getOutline(isSelected);
        if (!(g instanceof AwtGraphics)) {
            return;
        }
        Graphics2D g2d = ((AwtGraphics)g).getAwtGraphics();
        int tabRadius = TAB_RADIUS;
        int tabDiameter = 2 * tabRadius;
        g.setBrush(background);
        g.fillRect(tx + (double)tabRadius, ty, tw - (double)tabRadius, th);
        g.fillRect(tx, ty + (double)tabRadius, (double)tabRadius, th - (double)tabDiameter);
        g2d.fillArc((int)tx, (int)ty, tabDiameter, tabDiameter, 90, 90);
        g2d.fillArc((int)tx, (int)(ty + th - (double)tabDiameter), tabDiameter, tabDiameter, 180, 90);
        g.setBrush(outline);
        g.strokeLine(tx + (double)tabRadius, ty + th, tx + tw, ty + th);
        g2d.drawArc((int)tx, (int)(ty + th - (double)tabDiameter), tabDiameter, tabDiameter, 180, 90);
        g.strokeLine(tx, ty + (double)tabRadius, tx, ty + th - (double)tabRadius);
        g2d.drawArc((int)tx, (int)ty, tabDiameter, tabDiameter, 90, 90);
        g.strokeLine(tx + (double)tabRadius, ty, tx + tw, ty);
        if (isSelected && maxh - ty <= th) {
            g.setBrush(highlight);
            g.strokeLine(tx + tw, ty, tx + tw, ty + th);
        }
    }

    protected void paintTabRight(Graphics g, BTabbedPane pane, double tx, double ty, double tw, double th, double maxw, double maxh, boolean isSelected) {
        BBrush highlight = this.getHighlight(isSelected);
        BBrush background = this.getBackground(isSelected);
        BBrush outline = this.getOutline(isSelected);
        if (!(g instanceof AwtGraphics)) {
            return;
        }
        Graphics2D g2d = ((AwtGraphics)g).getAwtGraphics();
        int tabRadius = TAB_RADIUS;
        int tabDiameter = 2 * tabRadius;
        g.setBrush(background);
        g.fillRect(tx, ty, tw - (double)tabRadius, th);
        g.fillRect(tx + tw - (double)tabRadius, ty + (double)tabRadius, (double)tabRadius, th - (double)tabDiameter);
        g2d.fillArc((int)(tx + tw - (double)tabDiameter), (int)ty, tabDiameter, tabDiameter, 0, 90);
        g2d.fillArc((int)(tx + tw - (double)tabDiameter), (int)(ty + th - (double)tabDiameter), tabDiameter, tabDiameter, 270, 90);
        g.setBrush(outline);
        g.strokeLine(tx, ty + th, tx + tw - (double)tabRadius, ty + th);
        g2d.drawArc((int)(tx + tw - (double)tabDiameter), (int)(ty + th - (double)tabDiameter), tabDiameter, tabDiameter, 270, 90);
        g.strokeLine(tx + tw, ty + (double)tabRadius, tx + tw, ty + th - (double)tabRadius);
        g2d.drawArc((int)(tx + tw - (double)tabDiameter), (int)ty, tabDiameter, tabDiameter, 0, 90);
        g.strokeLine(tx, ty, tx + tw - (double)tabRadius, ty);
        if (isSelected && maxh - ty <= th) {
            g.setBrush(highlight);
            g.strokeLine(tx, ty, tx, ty + th);
        }
    }

    protected void paintTabBottom(Graphics g, BTabbedPane pane, double tx, double ty, double tw, double th, double maxw, double maxh, boolean isSelected) {
        BBrush highlight = this.getHighlight(isSelected);
        BBrush background = this.getBackground(isSelected);
        BBrush outline = this.getOutline(isSelected);
        if (!(g instanceof AwtGraphics)) {
            return;
        }
        Graphics2D g2d = ((AwtGraphics)g).getAwtGraphics();
        int tabRadius = TAB_RADIUS;
        int tabDiameter = 2 * tabRadius;
        g.setBrush(background);
        g.fillRect(tx, ty, (double)tabRadius, th - (double)tabRadius);
        g.fillRect(tx + tw - (double)tabRadius, ty, (double)tabRadius, th - (double)tabRadius);
        g.fillRect(tx + (double)tabRadius, ty, tw - (double)tabDiameter, th);
        g2d.fillArc((int)tx, (int)(ty + th - (double)tabDiameter), tabDiameter, tabDiameter, 180, 90);
        g2d.fillArc((int)(tx + tw - (double)tabDiameter), (int)(ty + th - (double)tabDiameter), tabDiameter, tabDiameter, 270, 90);
        g.setBrush(outline);
        g.strokeLine(tx, ty, tx, ty + th - (double)tabRadius);
        g2d.drawArc((int)tx, (int)(ty + th - (double)tabDiameter), tabDiameter, tabDiameter, 180, 90);
        g.strokeLine(tx + (double)tabRadius, ty + th, tx + tw - (double)tabRadius, ty + th);
        g2d.drawArc((int)(tx + tw - (double)tabDiameter), (int)(ty + th - (double)tabDiameter), tabDiameter, tabDiameter, 270, 90);
        g.strokeLine(tx + tw, ty, tx + tw, ty + th - (double)tabRadius);
        if (isSelected && maxh - ty <= th) {
            g.setBrush(highlight);
            g.strokeLine(tx, ty, tx + tw, ty);
        }
    }
}

