/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.ui.theme.custom;

import com.tridium.ui.theme.ScrollPaneTheme;
import com.tridium.ui.theme.custom.CustomPaneTheme;
import com.tridium.ui.theme.custom.nss.NSS;
import com.tridium.ui.theme.custom.nss.NSSUtils;
import javax.baja.gx.BBrush;
import javax.baja.gx.BInsets;
import javax.baja.gx.Graphics;
import javax.baja.ui.BWidget;
import javax.baja.ui.style.IStylable;

public class CustomScrollPaneTheme
extends CustomPaneTheme
implements ScrollPaneTheme {
    private BInsets insets;

    public CustomScrollPaneTheme() {
        NSS nss = CustomScrollPaneTheme.getNSS();
        NSS scrollPane = nss.selectNode("pane scroll-pane");
        this.regFallbackValue(scrollPane, "insets", "padding", "0");
    }

    @Override
    String getNSSSelector() {
        return "pane scroll-pane";
    }

    @Override
    public BInsets getInsets() {
        return this.insets;
    }

    public void setInsets(BInsets insets) {
        this.insets = insets;
    }

    @Override
    public BInsets getInsets(IStylable widget) {
        Object padding = CustomScrollPaneTheme.getNSS().select(widget, this.getNSSSelector(), "padding");
        if (padding != null) {
            NSSUtils.setThemeProperty(this, "insets", padding);
        }
        return this.getInsets();
    }

    @Override
    public BBrush getControlBackground() {
        return (BBrush)CustomScrollPaneTheme.getNSS().select("background-color");
    }

    @Override
    public BBrush getControlBackground(IStylable widget) {
        return this.getControlBackground();
    }

    @Override
    public void paintBorder(Graphics g, BWidget widget) {
        double w = widget.getWidth();
        double h = widget.getHeight();
        g.setBrush(this.getControlForeground(widget));
        g.strokeRect(0.0, 0.0, w - 1.0, h - 1.0);
    }
}

