/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.ui.fx.toolbar;

import com.tridium.ui.fx.BFxWidget;
import com.tridium.ui.fx.FxUtil;
import com.tridium.ui.fx.menu.FxMenuItemFactory;
import java.security.AccessController;
import java.util.logging.Logger;
import javafx.scene.Node;
import javafx.scene.control.Button;
import javafx.scene.control.ButtonBase;
import javafx.scene.control.MenuButton;
import javafx.scene.control.SplitMenuButton;
import javafx.scene.control.ToggleButton;
import javafx.scene.control.Tooltip;
import javafx.scene.image.ImageView;
import javax.baja.sys.BComponent;
import javax.baja.sys.Slot;
import javax.baja.sys.Subscriber;
import javax.baja.ui.BAbstractButton;
import javax.baja.ui.BMenu;
import javax.baja.ui.BMenuItem;
import javax.baja.ui.BToggleButton;
import javax.baja.ui.BWidget;
import javax.baja.ui.menu.BIMenuItem;

final class FxToolbarButtonBuilder {
    private ButtonBase base;
    private BAbstractButton button;
    private BAbstractButton.MenuController menuController;
    private Subscriber subscriber;
    private boolean isToggleButton;
    private boolean isMenuButton;
    private boolean isSplitMenuButton;
    private static final Logger log = Logger.getLogger("FxToolBarButton");

    private FxToolbarButtonBuilder(BAbstractButton button) {
        this.button = button;
        String text = button.getText();
        ImageView image = FxUtil.getImage(button.getImage());
        this.menuController = button.getMenuController();
        this.subscriber = this.makeSubscriber();
        if (button instanceof BToggleButton) {
            if (this.menuController == null) {
                this.isToggleButton = true;
                this.base = new ToggleButton(text, (Node)image);
                ((ToggleButton)this.base).setSelected(((BToggleButton)button).getSelected());
            } else {
                if (this.menuController.isMenuDistinct()) {
                    this.isSplitMenuButton = true;
                    this.base = new SplitMenuButton();
                    this.base.setText(text);
                    this.base.setGraphic((Node)image);
                } else {
                    this.isMenuButton = true;
                    this.base = new MenuButton(text, (Node)image);
                    this.base.setUserData((Object)false);
                }
                try {
                    BMenu menu = this.menuController.getMenu(button);
                    for (BMenuItem mi : menu.getMenuItems()) {
                        ((MenuButton)this.base).getItems().add((Object)FxMenuItemFactory.makeFor(mi));
                    }
                }
                catch (Exception exception) {}
            }
        } else {
            this.base = new Button(text, (Node)image);
        }
        this.base.setDisable(!button.isEnabled());
        AccessController.doPrivileged(() -> {
            if (button.getToolTip() != null && !button.getToolTip().isEmpty()) {
                this.base.setTooltip(new Tooltip(button.getToolTip()));
            }
            return null;
        });
        this.armEventHandlers();
    }

    static FxToolbarButtonBuilder makeFor(BAbstractButton button) {
        return new FxToolbarButtonBuilder(button);
    }

    Node toNode() {
        return this.base;
    }

    Subscriber getSubscriber() {
        return this.subscriber;
    }

    private void armEventHandlers() {
        this.base.setOnMouseReleased(event -> BWidget.invokeLater(() -> {
            try {
                if (this.isToggleButton) {
                    BToggleButton toggleButton = (BToggleButton)this.button;
                    toggleButton.setSelected(((ToggleButton)this.base).isSelected());
                } else {
                    this.button.doInvokeAction(FxUtil.makeCommandEvent(this.button, event));
                }
                if (this.isSplitMenuButton) {
                    SplitMenuButton sm = (SplitMenuButton)this.base;
                    sm.getItems().clear();
                    try {
                        BMenu menu = this.menuController.getMenu(this.button);
                        if (menu != null) {
                            for (BMenuItem mi : menu.getMenuItems()) {
                                sm.getItems().add((Object)FxMenuItemFactory.makeFor(mi));
                            }
                        }
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                }
                if (this.isMenuButton && FxUtil.toolbarFixRequired()) {
                    MenuButton mb;
                    mb.setUserData((Object)((Boolean)(mb = (MenuButton)this.base).getUserData() == false ? 1 : 0));
                    boolean showMenu = (Boolean)mb.getUserData();
                    BFxWidget.postfx(() -> {
                        if (showMenu) {
                            mb.show();
                        } else {
                            mb.hide();
                        }
                    });
                }
            }
            catch (Exception ex) {
                log.severe("Error executing command");
                ex.printStackTrace();
            }
        }));
    }

    private Subscriber makeSubscriber() {
        Subscriber sub = Subscriber.make(event -> {
            Slot slot = event.getSlot();
            if (event.getId() == 0) {
                BFxWidget.postfx(() -> {
                    if (slot.equals((Object)BWidget.enabled)) {
                        this.base.setDisable(!this.button.isEnabled());
                    }
                    if (this.isToggleButton) {
                        BToggleButton toggleButton = (BToggleButton)this.button;
                        if (slot.equals((Object)BToggleButton.selected)) {
                            ((ToggleButton)this.base).setSelected(toggleButton.getSelected());
                        } else if (slot.equals((Object)BToggleButton.image)) {
                            this.base.setGraphic((Node)FxUtil.getImage(toggleButton.getImage()));
                        }
                    }
                    if (this.isSplitMenuButton) {
                        try {
                            SplitMenuButton splitMenuButton = (SplitMenuButton)this.base;
                            splitMenuButton.getItems().clear();
                            BMenu menu = this.menuController.getMenu(this.button);
                            if (menu != null) {
                                for (BIMenuItem mi : menu.getMenuItems()) {
                                    splitMenuButton.getItems().add((Object)FxMenuItemFactory.makeFor(mi));
                                }
                            }
                        }
                        catch (Exception ex) {
                            log.severe("Subscriber error");
                            ex.printStackTrace();
                        }
                    }
                });
            }
        });
        if (this.button != null) {
            sub.subscribe((BComponent)this.button);
        }
        return sub;
    }
}

