/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.ui.fx.menu;

import com.tridium.ui.fx.BFxWidget;
import com.tridium.ui.fx.FxUtil;
import com.tridium.ui.fx.menu.BFxMenuBar;
import com.tridium.ui.fx.menu.FxMenuFactory;
import com.tridium.ui.theme.Theme;
import java.awt.event.KeyEvent;
import java.lang.ref.SoftReference;
import javafx.scene.Node;
import javafx.scene.control.CheckMenuItem;
import javafx.scene.control.ContextMenu;
import javafx.scene.control.MenuButton;
import javafx.scene.control.MenuItem;
import javafx.scene.control.RadioMenuItem;
import javafx.scene.image.ImageView;
import javafx.scene.input.KeyCombination;
import javax.baja.sys.BComponent;
import javax.baja.sys.BComponentEvent;
import javax.baja.sys.Subscriber;
import javax.baja.ui.BAccelerator;
import javax.baja.ui.BWidget;
import javax.baja.ui.Command;
import javax.baja.ui.CommandEvent;
import javax.baja.ui.ToggleCommand;
import javax.baja.ui.menu.BIMenuItem;
import javax.baja.ui.menu.BISubMenuItem;
import javax.baja.ui.menu.BIToggleMenuItem;

public final class FxMenuItemFactory {
    private BIMenuItem menuItem;
    private SoftReference<MenuItem> fxMenuItemReference;
    private SoftReference<Command> commandReference;
    private BAccelerator accelerator;
    private String text;
    private ImageView image;
    private Subscriber subscriber;
    private boolean isAccelerated;

    private FxMenuItemFactory(BIMenuItem menuItem) {
        this.menuItem = menuItem;
        this.fxMenuItemReference = new SoftReference<Object>(null);
        this.commandReference = new SoftReference<Command>(menuItem.getCommand());
        this.accelerator = menuItem.getAccelerator();
        this.text = menuItem.getText();
        this.image = FxUtil.getImage(menuItem.getImage());
    }

    public static MenuItem makeFor(BIMenuItem menuItem) {
        if (menuItem instanceof BISubMenuItem) {
            return FxMenuFactory.makeFor(menuItem);
        }
        return new FxMenuItemFactory(menuItem).asMenuItem();
    }

    private MenuItem asMenuItem() {
        boolean hideIcons = Theme.javaFx().shouldHideNonessentialIcons();
        MenuItem fxMenuItem = null;
        if (this.menuItem instanceof BIToggleMenuItem) {
            BIToggleMenuItem toggleItem = (BIToggleMenuItem)this.menuItem;
            if (toggleItem.isCheckBoxItem()) {
                fxMenuItem = hideIcons ? new CheckMenuItem(this.text) : new CheckMenuItem(this.text, (Node)this.image);
            } else if (toggleItem.isRadioButtonItem()) {
                fxMenuItem = hideIcons ? new RadioMenuItem(this.text) : new RadioMenuItem(this.text, (Node)this.image);
            }
        } else {
            fxMenuItem = hideIcons ? new MenuItem(this.text) : new MenuItem(this.text, (Node)this.image);
        }
        this.fxMenuItemReference = new SoftReference<MenuItem>(fxMenuItem);
        this.init();
        return fxMenuItem;
    }

    private BFxMenuBar getMenuBar() {
        BWidget widget;
        for (widget = this.menuItem.asWidget(); widget != null && !(widget instanceof BFxMenuBar); widget = widget.getParent()) {
        }
        return (BFxMenuBar)widget;
    }

    private void init() {
        this.registerSubscriber();
        this.registerEventHandler();
        this.update(null);
    }

    private void registerSubscriber() {
        if (this.subscriber == null) {
            this.subscriber = Subscriber.make(event -> {
                if (event.getId() == 0) {
                    BFxWidget.postfx(() -> this.update((BComponentEvent)event));
                }
            });
            this.subscriber.subscribe((BComponent)this.menuItem.asWidget());
        }
    }

    private void registerEventHandler() {
        MenuItem fxMenuItem = this.fxMenuItemReference.get();
        Command command = this.commandReference.get();
        if (fxMenuItem != null && command != null) {
            String keyCombination;
            if (this.accelerator != null && !(keyCombination = this.accelerator.encodeToString()).equals("null")) {
                fxMenuItem.setAccelerator(KeyCombination.valueOf((String)keyCombination));
                fxMenuItem.setOnMenuValidation(event -> {
                    this.isAccelerated = true;
                });
            }
            fxMenuItem.setOnAction(event -> {
                Node menuItemOwner;
                ContextMenu contextMenu;
                MenuItem menuItem = this.fxMenuItemReference.get();
                Command menuItemCommand = this.commandReference.get();
                if (menuItem == null || menuItemCommand == null) {
                    return;
                }
                if (FxUtil.toolbarFixRequired() && (contextMenu = menuItem.getParentPopup()) != null && (menuItemOwner = contextMenu.getOwnerNode()) != null && menuItemOwner instanceof MenuButton) {
                    menuItemOwner.setUserData((Object)false);
                }
                BWidget.invokeLater(() -> {
                    if (menuItemCommand instanceof ToggleCommand) {
                        boolean selected = menuItem instanceof CheckMenuItem ? ((CheckMenuItem)menuItem).isSelected() : menuItem instanceof RadioMenuItem && ((RadioMenuItem)menuItem).isSelected();
                        ((ToggleCommand)menuItemCommand).setSelected(selected);
                    }
                    if (this.isAccelerated) {
                        this.isAccelerated = false;
                        return;
                    }
                    BFxMenuBar menuBar = this.getMenuBar();
                    CommandEvent commandEvent = null;
                    if (menuBar != null) {
                        KeyEvent lastKeyEvent = menuBar.lastKeyEvent;
                        commandEvent = lastKeyEvent != null ? FxUtil.makeKeyEvent(menuBar.asWidget(), lastKeyEvent) : null;
                    }
                    menuItemCommand.invoke(commandEvent);
                });
            });
        }
    }

    private void update(BComponentEvent event) {
        if (event != null) {
            this.commandReference = new SoftReference<Command>(((BIMenuItem)event.getSourceComponent()).getCommand());
        }
        Command command = this.commandReference.get();
        MenuItem fxMenuItem = this.fxMenuItemReference.get();
        if (fxMenuItem != null && command != null) {
            if (command instanceof ToggleCommand) {
                ToggleCommand toggleCommand = (ToggleCommand)command;
                if (fxMenuItem instanceof CheckMenuItem) {
                    ((CheckMenuItem)fxMenuItem).setSelected(toggleCommand.isSelected());
                } else if (fxMenuItem instanceof RadioMenuItem) {
                    ((RadioMenuItem)fxMenuItem).setSelected(toggleCommand.isSelected());
                }
            }
            fxMenuItem.setDisable(!command.isEnabled());
            fxMenuItem.setText(command.getLabel());
            if (!Theme.javaFx().shouldHideNonessentialIcons()) {
                fxMenuItem.setGraphic((Node)FxUtil.getImage(command.getIcon()));
            }
        }
    }
}

