/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.ui.file;

import java.util.ArrayList;
import java.util.Vector;
import javax.baja.file.BIDirectory;
import javax.baja.file.BIFile;
import javax.baja.file.IFileFilter;
import javax.baja.nav.BINavNode;
import javax.baja.space.BISpace;
import javax.baja.space.BSpace;
import javax.baja.sys.BModule;
import javax.baja.sys.BModuleSpace;

public class FileChooserModel {
    private BSpace space;
    private BINavNode directory;
    private IFileFilter filter = IFileFilter.all;
    private Vector<BIFile> selection = new Vector();
    Support support;

    public FileChooserModel(BSpace space) {
        this.space = space;
        this.setSupport(new Support());
    }

    public void setSupport(Support support) {
        this.support = support;
    }

    public BSpace getSpace() {
        return this.space;
    }

    public void setSpace(BSpace space) {
        if (this.space != space) {
            this.space = space;
            this.directory = null;
        }
    }

    public BINavNode getDirectory() {
        return this.directory;
    }

    public void setDirectory(BINavNode dir) {
        this.directory = dir;
        this.support.pathModified();
    }

    public BINavNode[] getChildren() {
        ArrayList<BINavNode> list = new ArrayList<BINavNode>();
        if (this.directory == null) {
            BINavNode[] nav = this.space.getNavChildren();
            for (int i = 0; i < nav.length; ++i) {
                if (nav[i] instanceof BIFile) {
                    if (!(nav[i] instanceof BIDirectory) && (this.filter == null || !this.filter.accept((BIFile)nav[i]))) continue;
                    list.add(nav[i]);
                    continue;
                }
                list.add(nav[i]);
            }
        } else {
            BINavNode[] kids = this.directory.getNavChildren();
            for (int i = 0; i < kids.length; ++i) {
                if (kids[i] instanceof BIFile) {
                    if (!(kids[i] instanceof BIDirectory) && (this.filter == null || !this.filter.accept((BIFile)kids[i]))) continue;
                    list.add(kids[i]);
                    continue;
                }
                list.add(kids[i]);
            }
        }
        return list.toArray(new BINavNode[0]);
    }

    public void moveUpDirectory() {
        if (this.directory != null) {
            BINavNode node = this.directory.getNavParent();
            if (node instanceof BIFile) {
                this.setDirectory(node);
            } else if (node == null && BModule.isModuleFileSpace((BISpace)this.space)) {
                this.setSpace((BSpace)BModuleSpace.INSTANCE);
                this.setDirectory(null);
            } else {
                this.setDirectory(null);
            }
        }
    }

    public BINavNode[] getPath() {
        ArrayList<BINavNode> path = new ArrayList<BINavNode>();
        BINavNode parent = this.directory;
        while (parent != null) {
            path.add(parent);
            BINavNode node = parent.getNavParent();
            if (node instanceof BIFile) {
                parent = node;
                continue;
            }
            parent = null;
        }
        BINavNode[] reverse = new BINavNode[path.size()];
        for (int i = 0; i < path.size(); ++i) {
            reverse[path.size() - 1 - i] = (BINavNode)path.get(i);
        }
        return reverse;
    }

    public IFileFilter getFilter() {
        return this.filter;
    }

    public void setFilter(IFileFilter filter) {
        this.filter = filter;
        this.support.pathModified();
    }

    public boolean isSelected(BIFile file) {
        for (int i = 0; i < this.selection.size(); ++i) {
            BIFile x = this.selection.elementAt(i);
            if (!x.getNavName().equals(file.getNavName())) continue;
            return true;
        }
        return false;
    }

    public void select(BIFile file) {
        if (!this.isSelected(file)) {
            this.selection.add(file);
        }
        this.support.selectionModified();
    }

    public void deselect(BIFile file) {
        for (int i = 0; i < this.selection.size(); ++i) {
            BIFile x = this.selection.elementAt(i);
            if (!x.getNavName().equals(file.getNavName())) continue;
            this.selection.remove(i);
            break;
        }
        this.support.selectionModified();
    }

    public void deselectAll() {
        this.selection.clear();
        this.support.selectionModified();
    }

    public BIFile[] getSelectedFiles() {
        return this.selection.toArray(new BIFile[0]);
    }

    public final void chooseSelectedFiles() {
        this.support.chooseSelectedFiles();
    }

    public static class Support {
        public void pathModified() {
        }

        public void selectionModified() {
        }

        public void chooseSelectedFiles() {
        }
    }
}

