/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.ui.file;

import com.tridium.ui.file.BFilePathBar;
import com.tridium.ui.file.BFilePreview;
import com.tridium.ui.file.BFileSpaceList;
import com.tridium.ui.file.BListView;
import com.tridium.ui.file.FileChooserModel;
import java.io.File;
import java.lang.reflect.Method;
import java.util.Hashtable;
import java.util.Stack;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.baja.file.BDirectory;
import javax.baja.file.BFileSpace;
import javax.baja.file.BFileSystem;
import javax.baja.file.BIDirectory;
import javax.baja.file.BIFile;
import javax.baja.file.BIFileSpace;
import javax.baja.file.BajaFileUtil;
import javax.baja.file.FilePath;
import javax.baja.file.IExtFileFilter;
import javax.baja.file.IFileFilter;
import javax.baja.gx.BImage;
import javax.baja.gx.BInsets;
import javax.baja.gx.Graphics;
import javax.baja.gx.IRectGeom;
import javax.baja.gx.Point;
import javax.baja.gx.Size;
import javax.baja.naming.BOrd;
import javax.baja.naming.OrdQuery;
import javax.baja.naming.UnresolvedException;
import javax.baja.nav.BINavNode;
import javax.baja.nre.annotations.Generated;
import javax.baja.nre.annotations.NiagaraAction;
import javax.baja.nre.annotations.NiagaraActions;
import javax.baja.nre.annotations.NiagaraType;
import javax.baja.space.BISpace;
import javax.baja.space.BSpace;
import javax.baja.sys.Action;
import javax.baja.sys.BIcon;
import javax.baja.sys.BModule;
import javax.baja.sys.BModuleSpace;
import javax.baja.sys.BObject;
import javax.baja.sys.BValue;
import javax.baja.sys.IllegalNameException;
import javax.baja.sys.Slot;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.ui.BBorder;
import javax.baja.ui.BButton;
import javax.baja.ui.BDialog;
import javax.baja.ui.BFrame;
import javax.baja.ui.BLabel;
import javax.baja.ui.BListDropDown;
import javax.baja.ui.BNullWidget;
import javax.baja.ui.BSeparator;
import javax.baja.ui.BTextField;
import javax.baja.ui.BToolBar;
import javax.baja.ui.BWidget;
import javax.baja.ui.Command;
import javax.baja.ui.CommandArtifact;
import javax.baja.ui.ToggleCommand;
import javax.baja.ui.ToggleCommandGroup;
import javax.baja.ui.bookmark.BBookmark;
import javax.baja.ui.bookmark.BBookmarkFolder;
import javax.baja.ui.bookmark.BBookmarkItem;
import javax.baja.ui.bookmark.BBookmarkOptions;
import javax.baja.ui.enums.BHalign;
import javax.baja.ui.event.BWindowEvent;
import javax.baja.ui.file.BFileChooser;
import javax.baja.ui.file.ExtFileFilter;
import javax.baja.ui.options.BMruButton;
import javax.baja.ui.pane.BBorderPane;
import javax.baja.ui.pane.BEdgePane;
import javax.baja.ui.pane.BGridPane;
import javax.baja.ui.pane.BSplitPane;
import javax.baja.ui.pane.BToolPane;
import javax.baja.ui.tree.BTree;
import javax.baja.ui.tree.TreeController;
import javax.baja.ui.tree.TreeModel;
import javax.baja.ui.tree.TreeNode;
import javax.baja.ui.util.UiLexicon;

@NiagaraType
@NiagaraActions(value={@NiagaraAction(name="changeFilter"), @NiagaraAction(name="actionPerformed")})
public class BNFileChooser
extends BFileChooser {
    @Generated
    public static final Action changeFilter = BNFileChooser.newAction((int)0, null);
    @Generated
    public static final Action actionPerformed = BNFileChooser.newAction((int)0, null);
    @Generated
    public static final Type TYPE = Sys.loadType(BNFileChooser.class);
    BOrd tempOrd = null;
    final UiLexicon lex = UiLexicon.bajaui();
    FileChooserModel model;
    boolean confirmOverwrite = true;
    boolean createOnSave = true;
    BOrd savedFileOrd = null;
    private boolean updateFilenameExtensionFromFilter = false;
    BEdgePane content;
    BListView listView;
    BFilePreview preview;
    BFilePathBar pathBar;
    BTextField filename;
    BListDropDown filterList;
    BFileSpaceList spaceList;
    Hashtable<String, IFileFilter> filterMap;
    ConfirmCommand confirmCommand;
    CancelCommand cancelCommand;
    Stack<HistoryArtifact> history;
    BackCommand backCommand;
    UpLevelCommand upLevelCommand;
    CreateDirCommand createDirCommand;
    HomeCommand homeCommand;
    ListCommand listCommand;
    DetailsCommand detailsCommand;
    TogglePreviewCommand togglePreviewCommand;
    BookmarkCommand bookmarkCommand;
    BTree bookmarks;
    BMruButton recentDirs;
    Size lastSize = new Size(630.0, 430.0);
    Point lastLocation = null;
    private static final Logger LOG = Logger.getLogger("bajaui");

    @Generated
    public void changeFilter() {
        this.invoke(changeFilter, null, null);
    }

    @Generated
    public void actionPerformed() {
        this.invoke(actionPerformed, null, null);
    }

    @Override
    @Generated
    public Type getType() {
        return TYPE;
    }

    public static BFileChooser makeOpen(BWidget parent) {
        return new BNFileChooser(parent, UiLexicon.bajaui().getText("fileChooser.open"));
    }

    public static BFileChooser makeSave(BWidget parent) {
        return new BNFileChooser(parent, UiLexicon.bajaui().getText("fileChooser.save"), false);
    }

    public static BOrd showOpen(BWidget parent) {
        BFileChooser chooser = BNFileChooser.makeOpen(parent);
        return chooser.show();
    }

    public static BOrd showSave(BWidget parent) {
        BFileChooser chooser = BNFileChooser.makeSave(parent);
        return chooser.show();
    }

    private BNFileChooser(BWidget parent) {
        this(parent, UiLexicon.bajaui().getText("fileChooser.open"));
    }

    private BNFileChooser(BWidget parent, BFileSpace space) {
        this(parent, space, UiLexicon.bajaui().getText("fileChooser.open"), true);
    }

    private BNFileChooser(BWidget parent, String confirmLabel) {
        this(parent, (BFileSpace)BFileSystem.INSTANCE, confirmLabel, true);
    }

    private BNFileChooser(BWidget parent, String confirmLabel, boolean open) {
        this(parent, (BFileSpace)BFileSystem.INSTANCE, confirmLabel, open);
    }

    private BNFileChooser(BWidget parent, BFileSpace space, String confirmLabel, boolean open) {
        super(parent, UiLexicon.bajaui().getText("fileChooser.title"));
        this.model = new FileChooserModel((BSpace)space);
        this.model.setSupport(new FileChooserSupport(open ? 1 : 2));
        this.filename = new BTextField();
        this.filterList = new BListDropDown();
        this.listView = new BListView(this.model);
        this.preview = new BFilePreview(this.model);
        this.pathBar = new BFilePathBar(this.model);
        this.recentDirs = new BMruButton("fileChooserRecentDir");
        this.recentDirs.setMruController(new MruController());
        this.bookmarks = new BTree(new BookmarkModel());
        this.bookmarks.setController(new BookmarkController());
        this.linkTo(null, this.filename, (Slot)BTextField.actionPerformed, (Slot)actionPerformed);
        this.filename.setEditable(!open);
        String allstr = this.lex.getText("fileChooser.allFiles") + " (*.*)";
        this.filterList.getList().addItem(allstr);
        this.filterList.getList().setSelectedIndex(0);
        this.filterMap = new Hashtable();
        this.filterMap.put(allstr, IFileFilter.all);
        this.linkTo(null, this.filterList, (Slot)BListDropDown.listActionPerformed, (Slot)changeFilter);
        this.confirmCommand = new ConfirmCommand(confirmLabel);
        this.cancelCommand = new CancelCommand(this.lex.getText("fileChooser.cancel"));
        this.history = new Stack();
        this.history.push(new HistoryArtifact(this.model.getSpace(), this.model.getDirectory()));
        this.backCommand = new BackCommand();
        this.backCommand.setEnabled(false);
        this.upLevelCommand = new UpLevelCommand();
        this.upLevelCommand.setEnabled(this.model.getDirectory() != null);
        this.createDirCommand = new CreateDirCommand();
        this.createDirCommand.setEnabled(this.model.getSpace() instanceof BFileSpace);
        this.homeCommand = new HomeCommand();
        this.listCommand = new ListCommand();
        this.detailsCommand = new DetailsCommand();
        this.listCommand.setSelected(true);
        this.bookmarkCommand = new BookmarkCommand();
        this.togglePreviewCommand = new TogglePreviewCommand();
        this.togglePreviewCommand.setSelected(true);
        ToggleCommandGroup<ToggleCommand> group = new ToggleCommandGroup<ToggleCommand>();
        group.add(this.listCommand);
        group.add(this.detailsCommand);
        BToolBar toolbar = new BToolBar();
        toolbar.addButton(null, this.backCommand);
        toolbar.addButton(null, this.upLevelCommand);
        toolbar.addButton(null, this.homeCommand);
        toolbar.addButton(null, this.createDirCommand);
        toolbar.add(null, (BValue)new BSeparator());
        toolbar.addButton(null, this.listCommand);
        toolbar.addButton(null, this.detailsCommand);
        toolbar.add(null, (BValue)new BSeparator());
        toolbar.add(null, (BValue)this.recentDirs);
        toolbar.addButton(null, this.bookmarkCommand);
        toolbar.addButton(null, this.togglePreviewCommand);
        BEdgePane top = new BEdgePane();
        top.setTop(new BBorderPane((BWidget)this.pathBar, BBorder.inset, BInsets.make((double)0.0, (double)0.0, (double)0.0, (double)0.0)));
        top.setBottom(toolbar);
        BGridPane g1 = new BGridPane(2);
        g1.setStretchColumn(1);
        g1.setColumnAlign(BHalign.fill);
        g1.add(null, (BValue)new BLabel(this.lex.getText("fileChooser.fileName"), BHalign.left));
        g1.add(null, (BValue)this.filename);
        g1.add(null, (BValue)new BLabel(this.lex.getText("fileChooser.fileType"), BHalign.left));
        g1.add(null, (BValue)this.filterList);
        BGridPane g2 = new BGridPane(1);
        g2.setColumnAlign(BHalign.fill);
        g2.add(null, (BValue)new BButton(this.confirmCommand));
        g2.add(null, (BValue)new BButton(this.cancelCommand));
        BEdgePane bottom = new BEdgePane();
        bottom.setCenter(new BBorderPane(g1, 0.0, 10.0, 0.0, 0.0));
        bottom.setRight(g2);
        this.content = new BEdgePane();
        this.content.setTop(top);
        this.content.setCenter(this.buildPreview());
        this.content.setBottom(new BBorderPane(bottom, 5.0, 0.0, 0.0, 0.0));
        BImage icon1 = BImage.make((String)"module://icons/x16/computer.png");
        BImage icon2 = BImage.make((String)"module://icons/x16/bookmark.png");
        BLabel label1 = new BLabel(icon1, this.lex.getText("fileChooser.spaces"));
        BLabel label2 = new BLabel(icon2, this.lex.getText("fileChooser.bookmarks"));
        BToolPane toolpane = new BToolPane();
        this.spaceList = new BFileSpaceList(this.model, !open);
        toolpane.addPane(label1, (BWidget)this.spaceList);
        toolpane.addPane(label2, (BWidget)this.bookmarks);
        BSplitPane bigPicture = new BSplitPane();
        bigPicture.setDividerPosition(25.0);
        bigPicture.setWidget1(new BBorderPane((BWidget)toolpane, BBorder.inset, BInsets.make((double)0.0, (double)0.0, (double)0.0, (double)0.0)));
        bigPicture.setWidget2(this.content);
        this.setContent(new BBorderPane(bigPicture, 5.0, 5.0, 5.0, 5.0));
    }

    public BNFileChooser() {
        super(null, "");
    }

    private BWidget buildPreview() {
        BSplitPane split = new BSplitPane();
        split.setDividerPosition(55.0);
        split.setWidget1(new BBorderPane((BWidget)this.listView, BBorder.inset, BInsets.make((double)0.0, (double)0.0, (double)0.0, (double)0.0)));
        split.setWidget2(new BBorderPane((BWidget)this.preview, BBorder.inset, BInsets.make((double)0.0, (double)0.0, (double)0.0, (double)0.0)));
        return split;
    }

    private BWidget buildNoPreview() {
        return new BBorderPane((BWidget)this.listView, BBorder.inset, BInsets.make((double)0.0, (double)0.0, (double)0.0, (double)0.0));
    }

    @Override
    public BOrd[] show(boolean multipleSelection) {
        this.bookmarks.setModel(new BookmarkModel());
        this.bookmarks.relayout();
        this.model.setDirectory(this.model.getDirectory());
        if (this.tempOrd != null) {
            try {
                this.xSetCurrentDirectory(this.tempOrd);
            }
            catch (Exception exception) {
                // empty catch block
            }
            this.tempOrd = null;
        }
        if (this.lastLocation == null) {
            this.setBoundsCenteredOnOwner();
        } else {
            this.setScreenBounds(this.lastLocation.x, this.lastLocation.y, this.lastSize.width, this.lastSize.height);
        }
        if (!this.getCurrentSpace().isMounted()) {
            this.setCurrentSpace((BSpace)BFileSystem.INSTANCE);
            this.setCurrentNavDirectory(null);
        }
        this.listView.setMultipleSelection(multipleSelection);
        this.open();
        if (!this.createOnSave) {
            return new BOrd[]{this.savedFileOrd};
        }
        BIFile[] files = this.model.getSelectedFiles();
        BOrd[] ords = new BOrd[files.length];
        for (int i = 0; i < files.length; ++i) {
            ords[i] = files[i].getAbsoluteOrd();
        }
        return ords;
    }

    @Override
    public BOrd getCurrentDirectory() {
        BINavNode dir = this.model.getDirectory();
        return dir == null ? null : dir.getNavOrd();
    }

    @Override
    public void setCurrentDirectory(BOrd ord) {
        this.tempOrd = ord;
    }

    void xSetCurrentDirectory(BOrd ord) {
        if (ord.isNull()) {
            return;
        }
        BINavNode node = (BINavNode)ord.resolve((BObject)this.spaceList.getSpaces()[0]).get();
        if (node instanceof BIDirectory) {
            this.model.setSpace(BOrd.toSpace((BObject)((BObject)node)));
            this.model.setDirectory(node);
        } else if (node instanceof BIFile) {
            this.model.setSpace(BOrd.toSpace((BObject)((BObject)node)));
            this.model.setDirectory(node.getNavParent());
            this.model.select((BIFile)node);
        } else {
            this.model.setSpace(this.spaceList.getSpaces()[0]);
            this.model.setDirectory(null);
        }
    }

    void findCurrentDirectory() {
        if (this.model.getDirectory() != null) {
            return;
        }
        BObject obj = null;
        try {
            obj = this.model.getSpace().getNavOrd().resolve().get();
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (obj instanceof BIDirectory) {
            this.model.setDirectory((BINavNode)obj);
        } else if (obj instanceof BIFile) {
            this.model.setDirectory(((BINavNode)obj).getNavParent());
        }
    }

    @Override
    public void setDefaultFileName(String fname) {
        this.filename.setText(fname);
    }

    @Override
    public void setCreateFileOnSave(boolean create) {
        this.createOnSave = create;
    }

    @Override
    public void setConfirmOverwrite(boolean confirm) {
        this.confirmOverwrite = confirm;
    }

    @Override
    public void setUpdateFilenameExtensionFromFilter(boolean updateFilenameExtensionFromFilter) {
        this.updateFilenameExtensionFromFilter = updateFilenameExtensionFromFilter;
    }

    @Override
    public void addFilter(IFileFilter filter) {
        String name = filter.getDescription(null);
        this.filterList.getList().addItem(name);
        this.filterMap.put(name, filter);
        this.setCurrentFilter(filter);
    }

    @Override
    public void addFilters(IFileFilter[] filters) {
        for (int i = 0; i < filters.length; ++i) {
            this.addFilter(filters[i]);
        }
    }

    @Override
    public void clearFilters() {
        this.model.deselectAll();
        this.model.setFilter(null);
        this.filterList.getList().setSelectedItem(null);
        this.filterList.getList().removeAllItems();
        this.filterMap.clear();
    }

    @Override
    public BSpace[] getSpaces() {
        return this.spaceList.getSpaces();
    }

    @Override
    public void setSpaces(BSpace[] spaces) {
        this.spaceList.setSpaces(spaces);
    }

    public FileChooserModel getModel() {
        return this.model;
    }

    public BSpace getCurrentSpace() {
        return this.model.getSpace();
    }

    public void setCurrentSpace(BSpace space) {
        this.model.setSpace(space);
    }

    public BINavNode getCurrentNavDirectory() {
        return this.model.getDirectory();
    }

    public void setCurrentNavDirectory(BINavNode dir) {
        this.model.setDirectory(dir);
    }

    public void setCurrentDirectory(File dir) {
        BIFile bdir = (BIFile)BFileSystem.INSTANCE.localFileToOrd(dir).get();
        this.model.setDirectory((BINavNode)bdir);
    }

    public IFileFilter getCurrentFilter() {
        return this.model.getFilter();
    }

    public void setCurrentFilter(IFileFilter filter) {
        String name = filter.getDescription(null);
        if (this.filterMap.get(name) == null) {
            this.addFilter(filter);
        }
        int index = this.filterList.getList().indexOfItem(name);
        this.filterList.getList().setSelectedIndex(index);
        this.doChangeFilter();
    }

    @Override
    public void computePreferredSize() {
        this.setPreferredSize(this.lastSize.width, this.lastSize.height);
    }

    @Override
    public void paint(Graphics g) {
        super.paint(g);
        try {
            if (this.lastLocation == null) {
                this.lastLocation = new Point(0.0, 0.0);
            }
            IRectGeom r = this.getScreenBounds();
            this.lastLocation.x = r.x();
            this.lastLocation.y = r.y();
            this.lastSize.width = r.width();
            this.lastSize.height = r.height();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    @Override
    public void windowClosing(BWindowEvent event) {
        this.cancelCommand.invoke();
    }

    public void doChangeFilter() {
        String filterName = (String)this.filterList.getList().getSelectedItem();
        if (filterName != null) {
            this.model.setFilter(this.filterMap.get(filterName));
        }
    }

    public void doActionPerformed() {
        this.getModel().chooseSelectedFiles();
    }

    void openBookmark(BBookmark bm) {
        try {
            BINavNode dir = (BINavNode)bm.getBookmarkOrd().resolve().get();
            BSpace space = BOrd.toSpace((BObject)((BObject)dir));
            if (!(space instanceof BFileSpace)) {
                throw new Exception("Space not instance of BFileSpace");
            }
            this.model.setSpace(space);
            this.model.setDirectory(dir);
        }
        catch (Exception e) {
            BDialog.error((BWidget)this, this.lex.getText("fileChooser.error"), (Object)this.lex.getText("fileChooser.bookmarkResolveError"), e);
        }
    }

    BBookmark makeForCurrentContext() {
        BSpace space = this.model.getSpace();
        BINavNode dir = this.model.getDirectory();
        String name = dir.getNavDisplayName(null);
        if (BModule.isModuleFileSpace((BISpace)space) && dir.getNavParent() == null) {
            name = ((BModule)BModule.getModule((BISpace)space).get()).getModuleName();
            space = BModuleSpace.INSTANCE;
            dir = space.getNavChild(name);
        }
        return new BBookmark(name, dir.getNavOrd(), dir.getNavIcon());
    }

    static BBookmarkFolder getFileBookmarks() {
        BBookmarkOptions options = BBookmarkOptions.make();
        BBookmarkFolder folder = (BBookmarkFolder)options.getRootFolder().get("file");
        if (folder == null) {
            folder = new BBookmarkFolder(UiLexicon.bajaui().getText("bookmarks.file"));
            options.getRootFolder().add("file", (BValue)folder);
        }
        return folder;
    }

    public static void main(String[] args) {
        BFrame frame = new BFrame();
        ExtFileFilter images = new ExtFileFilter("Image files (*.gif, *.jpeg, *.png)", "gif,jpg,png");
        IFileFilter[] filterList = new IFileFilter[]{new ExtFileFilter("Print files (*.print)", "print"), new ExtFileFilter("XML files (*.xml, *.bog)", new String[]{"xml", "bog"})};
        BFileChooser x = BNFileChooser.makeOpen(frame);
        x.addFilters(filterList);
        BOrd[] files = x.show(true);
        for (int i = 0; i < files.length; ++i) {
            System.out.println("  " + files[i]);
        }
        System.exit(0);
    }

    class BookmarkController
    extends TreeController {
        BookmarkController() {
        }

        @Override
        protected void doSelectAction(TreeNode target, double x, double y) {
            Node node = (Node)target;
            if (node.item instanceof BBookmark) {
                BNFileChooser.this.openBookmark((BBookmark)node.item);
            }
        }
    }

    static class Node
    extends TreeNode {
        BBookmarkItem item;
        Node[] kids;

        public Node(TreeModel model, BBookmarkItem item) {
            super(model);
            this.item = item;
            this.load();
        }

        public Node(TreeNode parent, BBookmarkItem item) {
            super(parent);
            this.item = item;
            this.load();
        }

        public void load() {
            BBookmarkItem[] items = (BBookmarkItem[])this.item.getChildren(BBookmarkItem.class);
            this.kids = new Node[items.length];
            for (int i = 0; i < items.length; ++i) {
                this.kids[i] = new Node(this, items[i]);
            }
        }

        @Override
        public String getText() {
            return this.item.getText();
        }

        @Override
        public BImage getIcon() {
            return BImage.make((BIcon)this.item.getIcon());
        }

        @Override
        public Object getSubject() {
            return this.item;
        }

        @Override
        public int getChildCount() {
            return this.kids.length;
        }

        @Override
        public TreeNode getChild(int index) {
            return this.kids[index];
        }
    }

    static class BookmarkModel
    extends TreeModel {
        Node[] roots;

        public BookmarkModel() {
            BBookmarkFolder x = BNFileChooser.getFileBookmarks();
            BBookmarkItem[] items = (BBookmarkItem[])x.getChildren(BBookmarkItem.class);
            this.roots = new Node[items.length];
            for (int i = 0; i < items.length; ++i) {
                this.roots[i] = new Node((TreeModel)this, items[i]);
            }
        }

        @Override
        public int getRootCount() {
            return this.roots.length;
        }

        @Override
        public TreeNode getRoot(int index) {
            return this.roots[index];
        }
    }

    class MruController
    extends BMruButton.MruController {
        MruController() {
        }

        @Override
        public void select(String value) {
            try {
                BIFile dir = (BIFile)BOrd.make((String)value).resolve().get();
                BNFileChooser.this.setCurrentSpace((BSpace)dir.getFileSpace());
                BNFileChooser.this.setCurrentNavDirectory((BINavNode)dir);
            }
            catch (Exception e) {
                BDialog.error((BWidget)BNFileChooser.this, BNFileChooser.this.lex.getText("fileChooser.error"), (Object)BNFileChooser.this.lex.getText("fileChooser.noDirectoryError"), e);
            }
        }
    }

    class FileChooserSupport
    extends FileChooserModel.Support {
        static final int OPEN = 1;
        static final int SAVE = 2;
        int type;

        public FileChooserSupport(int type) {
            this.type = type;
        }

        @Override
        public void pathModified() {
            BNFileChooser.this.model.deselectAll();
            if (BNFileChooser.this.model.getDirectory() == null) {
                BNFileChooser.this.findCurrentDirectory();
            }
            this.updateFilenameExtension(true);
            BNFileChooser.this.upLevelCommand.setEnabled(BNFileChooser.this.model.getDirectory() != null);
            if (BNFileChooser.this.history.size() > 0) {
                BINavNode dir = BNFileChooser.this.model.getDirectory();
                HistoryArtifact art = BNFileChooser.this.history.peek();
                if (art.space != BNFileChooser.this.model.getSpace()) {
                    BNFileChooser.this.history.push(new HistoryArtifact(BNFileChooser.this.model.getSpace(), dir));
                } else if (art.dir == null && dir != null) {
                    BNFileChooser.this.history.push(new HistoryArtifact(BNFileChooser.this.model.getSpace(), dir));
                } else if (art.dir != null && dir == null) {
                    BNFileChooser.this.history.push(new HistoryArtifact(BNFileChooser.this.model.getSpace(), dir));
                } else if (art.dir != null && dir != null && !art.dir.getNavName().equals(dir.getNavName())) {
                    BNFileChooser.this.history.push(new HistoryArtifact(BNFileChooser.this.model.getSpace(), BNFileChooser.this.model.getDirectory()));
                }
            } else {
                BNFileChooser.this.history.push(new HistoryArtifact(BNFileChooser.this.model.getSpace(), BNFileChooser.this.model.getDirectory()));
            }
            BNFileChooser.this.backCommand.setEnabled(BNFileChooser.this.history.size() > 1);
            BNFileChooser.this.createDirCommand.setEnabled(BNFileChooser.this.model.getSpace() instanceof BFileSpace);
            BNFileChooser.this.spaceList.relayout();
            BNFileChooser.this.listView.getSelection().deselectAll();
            BNFileChooser.this.listView.populateChildren();
            BNFileChooser.this.listView.relayout();
            BNFileChooser.this.pathBar.relayout();
        }

        @Override
        public void selectionModified() {
            BIFile[] files = BNFileChooser.this.model.getSelectedFiles();
            StringBuilder str = new StringBuilder();
            int count = 0;
            for (int i = 0; i < files.length; ++i) {
                BNFileChooser.this.listView.select(files[i]);
                if (files[i] instanceof BIDirectory) continue;
                if (count > 0) {
                    str.append(";");
                }
                str.append(files[i].getNavDisplayName(null));
                ++count;
            }
            if (BNFileChooser.this.preview.isVisible()) {
                BNFileChooser.this.preview.relayout();
            }
            BNFileChooser.this.bookmarkCommand.setEnabled(BNFileChooser.this.model.getDirectory() != null);
            if (this.type == 1) {
                BNFileChooser.this.filename.setText(str.toString());
            } else if (count > 0) {
                BNFileChooser.this.filename.setText(str.toString());
            }
            BNFileChooser.this.filename.repaint();
        }

        /*
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        @Override
        public void chooseSelectedFiles() {
            BIFile[] files;
            block23: {
                if (this.type != 1) {
                    if (this.type == 2) {
                        FilePath path = null;
                        try {
                            this.updateFilenameExtension(false);
                            path = ((BIFile)BNFileChooser.this.model.getDirectory()).getFilePath().merge(BNFileChooser.this.filename.getText());
                        }
                        catch (Exception e) {
                            if (LOG.isLoggable(Level.FINE)) {
                                LOG.log(Level.FINE, "FileChooser error updating path on save", e);
                            }
                            BDialog.error((BWidget)BNFileChooser.this, BNFileChooser.this.lex.getText("fileChooser.error"), (Object)BNFileChooser.this.lex.getText("fileChooser.noDirectoryError"), e);
                            return;
                        }
                        try {
                            if (BNFileChooser.this.confirmOverwrite) {
                                try {
                                    BOrd.make((OrdQuery)path).resolve((BObject)BNFileChooser.this.model.getSpace()).get();
                                    if (4 != BDialog.open(BNFileChooser.this, BNFileChooser.this.lex.getText("fileChooser.fileExists"), BNFileChooser.this.lex.getText("fileChooser.fileExistsPrompt"), 14, BDialog.WARNING_ICON)) {
                                        return;
                                    }
                                }
                                catch (UnresolvedException e) {
                                    // empty catch block
                                }
                            }
                            if (BNFileChooser.this.createOnSave) {
                                BIFile file = null;
                                try {
                                    String cs = ":";
                                    if (BNFileChooser.this.filename.getText().contains(cs)) {
                                        throw new IllegalNameException("baja", "IllegalNameException.name", new Object[]{BNFileChooser.this.filename.getText()});
                                    }
                                    file = ((BIFileSpace)BNFileChooser.this.model.getSpace()).makeFile(path);
                                }
                                catch (Exception e) {
                                    if (LOG.isLoggable(Level.FINE)) {
                                        LOG.log(Level.FINE, "FileChooser error creating file on save", e);
                                    }
                                    BDialog.error((BWidget)BNFileChooser.this, BNFileChooser.this.lex.getText("fileChooser.error"), (Object)BNFileChooser.this.lex.getText("fileChooser.cannotCreateFile"), e);
                                    return;
                                }
                                BNFileChooser.this.model.deselectAll();
                                BNFileChooser.this.model.select(file);
                                break block23;
                            }
                            BNFileChooser.this.savedFileOrd = BOrd.make((BOrd)BNFileChooser.this.model.getSpace().getNavOrd(), (OrdQuery)path).normalize();
                        }
                        catch (Exception e) {
                            if (LOG.isLoggable(Level.FINE)) {
                                LOG.log(Level.FINE, "FileChooser error during save", e);
                            }
                        }
                    }
                } else {
                    files = BNFileChooser.this.model.getSelectedFiles();
                    if (files.length == 0) {
                        return;
                    }
                    for (BIFile file : files) {
                        if (!(file instanceof BIDirectory)) continue;
                        BNFileChooser.this.model.setDirectory((BINavNode)file);
                        return;
                    }
                }
            }
            if (BNFileChooser.this.createOnSave) {
                files = BNFileChooser.this.model.getSelectedFiles();
                if (files.length > 0) {
                    BNFileChooser.this.recentDirs.getMruOptions().save(files[0].getNavParent().getNavOrd().toString());
                }
            } else {
                BNFileChooser.this.recentDirs.getMruOptions().save(BNFileChooser.this.model.getDirectory().getNavOrd().toString());
            }
            BNFileChooser.this.close();
        }

        private void updateFilenameExtension(boolean replace) {
            IExtFileFilter filter;
            if (this.type == 2 && BNFileChooser.this.updateFilenameExtensionFromFilter && BNFileChooser.this.model.getFilter() instanceof IExtFileFilter && !(filter = (IExtFileFilter)BNFileChooser.this.model.getFilter()).acceptExtension(BajaFileUtil.getExtension((String)BNFileChooser.this.filename.getText())) && filter.getDefaultExtension() != null) {
                if (replace) {
                    BNFileChooser.this.filename.setText(BajaFileUtil.replaceExtension((String)BNFileChooser.this.filename.getText(), (String)filter.getDefaultExtension()));
                } else {
                    BNFileChooser.this.filename.setText(BNFileChooser.this.filename.getText() + "." + filter.getDefaultExtension());
                }
            }
        }
    }

    class HistoryArtifact {
        BSpace space;
        BINavNode dir;

        HistoryArtifact(BSpace space, BINavNode dir) {
            this.space = space;
            this.dir = dir;
        }
    }

    class TogglePreviewCommand
    extends ToggleCommand {
        TogglePreviewCommand() {
            super((BWidget)BNFileChooser.this, BNFileChooser.this.lex.module, "fileChooser.togglePreview");
        }

        @Override
        public CommandArtifact doInvoke() {
            BBorderPane parent = (BBorderPane)BNFileChooser.this.listView.getParentWidget();
            if (parent != null) {
                parent.setContent(new BNullWidget());
            }
            if ((parent = (BBorderPane)BNFileChooser.this.preview.getParentWidget()) != null) {
                parent.setContent(new BNullWidget());
            }
            BNFileChooser.this.content.setCenter(this.isSelected() ? BNFileChooser.this.buildPreview() : BNFileChooser.this.buildNoPreview());
            BNFileChooser.this.content.relayout();
            return null;
        }
    }

    class HomeCommand
    extends Command {
        HomeCommand() {
            super((BWidget)BNFileChooser.this, BNFileChooser.this.lex.module, "fileChooser.home");
        }

        @Override
        public CommandArtifact doInvoke() {
            BNFileChooser.this.model.setSpace((BSpace)BFileSystem.INSTANCE);
            BNFileChooser.this.model.setDirectory((BINavNode)BFileSystem.INSTANCE.findFile(new FilePath("~")));
            BNFileChooser.this.model.setDirectory((BINavNode)BFileSystem.INSTANCE.findFile(new FilePath("!")));
            return null;
        }
    }

    class BookmarkCommand
    extends Command {
        BookmarkCommand() {
            super((BWidget)BNFileChooser.this, BNFileChooser.this.lex.module, "fileChooser.bookmarks");
        }

        @Override
        public CommandArtifact doInvoke() {
            try {
                BBookmark bm = BNFileChooser.this.makeForCurrentContext();
                BNFileChooser.getFileBookmarks().add(null, (BValue)bm);
                BBookmarkOptions.make().save();
                BNFileChooser.this.bookmarks.setModel(new BookmarkModel());
                BNFileChooser.this.bookmarks.relayout();
            }
            catch (Exception e) {
                BDialog.error(this.getOwner(), "Error", (Object)"Add failed", e);
                return null;
            }
            try {
                Class cls = Sys.loadClass((String)"workbench", (String)"com.tridium.workbench.bookmark.BookmarkEvents");
                Object obj = cls.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
                Method method = cls.getDeclaredMethod("fireBookmarkChanged", new Class[0]);
                method.invoke(obj, new Object[0]);
            }
            catch (Exception exception) {
                // empty catch block
            }
            return null;
        }
    }

    class DetailsCommand
    extends ToggleCommand {
        DetailsCommand() {
            super((BWidget)BNFileChooser.this, BNFileChooser.this.lex.module, "fileChooser.details");
        }

        @Override
        public CommandArtifact doInvoke() {
            BNFileChooser.this.listView.setDetailsView();
            return null;
        }
    }

    class ListCommand
    extends ToggleCommand {
        ListCommand() {
            super((BWidget)BNFileChooser.this, BNFileChooser.this.lex.module, "fileChooser.list");
        }

        @Override
        public CommandArtifact doInvoke() {
            BNFileChooser.this.listView.setListView();
            return null;
        }
    }

    class CreateDirCommand
    extends Command {
        CreateDirCommand() {
            super((BWidget)BNFileChooser.this, BNFileChooser.this.lex.module, "fileChooser.createDir");
        }

        @Override
        public CommandArtifact doInvoke() {
            String title = BNFileChooser.this.lex.getText("fileChooser.title");
            try {
                BFileSpace space = (BFileSpace)BNFileChooser.this.model.getSpace();
                BIFile dir = (BIFile)BNFileChooser.this.model.getDirectory();
                String newFolderName = BNFileChooser.this.lex.getText("fileChooser.newFolder");
                newFolderName = BDialog.prompt(BNFileChooser.this, title, newFolderName, 20);
                if (newFolderName != null) {
                    BDirectory newDir = space.makeDir(dir.getFilePath().merge(newFolderName));
                    BNFileChooser.this.model.setDirectory((BINavNode)newDir);
                }
            }
            catch (Exception e) {
                BDialog.error((BWidget)BNFileChooser.this, title, (Object)BNFileChooser.this.lex.getText("fileChooser.createDirFailed"), e);
            }
            return null;
        }
    }

    class UpLevelCommand
    extends Command {
        UpLevelCommand() {
            super((BWidget)BNFileChooser.this, BNFileChooser.this.lex.module, "fileChooser.upLevel");
        }

        @Override
        public CommandArtifact doInvoke() {
            BNFileChooser.this.model.moveUpDirectory();
            return null;
        }
    }

    class BackCommand
    extends Command {
        BackCommand() {
            super((BWidget)BNFileChooser.this, BNFileChooser.this.lex.module, "fileChooser.back");
        }

        @Override
        public CommandArtifact doInvoke() {
            BNFileChooser.this.history.pop();
            HistoryArtifact art = BNFileChooser.this.history.pop();
            BNFileChooser.this.model.setSpace(art.space);
            BNFileChooser.this.model.setDirectory(art.dir);
            return null;
        }
    }

    class CancelCommand
    extends Command {
        CancelCommand(String label) {
            super(BNFileChooser.this, label);
        }

        @Override
        public CommandArtifact doInvoke() {
            BNFileChooser.this.model.deselectAll();
            BNFileChooser.this.close();
            return null;
        }
    }

    class ConfirmCommand
    extends Command {
        ConfirmCommand(String label) {
            super(BNFileChooser.this, label);
        }

        @Override
        public CommandArtifact doInvoke() {
            BNFileChooser.this.model.chooseSelectedFiles();
            return null;
        }
    }
}

