/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.ui.awt;

import com.tridium.sys.Nre;
import com.tridium.ui.UiEnv;
import com.tridium.ui.awt.AwtShellManager;
import com.tridium.ui.awt.AwtUiEnv;
import com.tridium.ui.awt.DragOperation;
import com.tridium.ui.awt.IMouseNavigableShell;
import com.tridium.ui.awt.NPopup;
import java.awt.event.MouseEvent;
import java.security.AccessController;
import javax.baja.gx.Point;
import javax.baja.ui.BWidget;
import javax.baja.ui.BWidgetShell;
import javax.baja.ui.event.BKeyEvent;
import javax.baja.ui.event.BMouseEvent;

public class MouseManager {
    public static final int PRESSED = 501;
    public static final int RELEASED = 502;
    public static final int ENTERED = 504;
    public static final int EXITED = 505;
    public static final int MOVED = 503;
    public static final int DRAGGED = 506;
    public static final int WHEEL = 507;
    public static final int PULSED = 510;
    public static final int DRAG_STARTED = 511;
    public static final int HOVER = 512;
    static final int FIRST_PULSE_MILLIS = 700;
    static final int PULSE_MILLIS = 150;
    static final int DRAG_TOLERANCE = 10;
    static final int HOVER_MILLIS = 700;
    static MouseManager hoverManager = null;
    static final HoverThread hoverThread = new HoverThread();
    static MouseManager pulseManager = null;
    static final PulseThread pulseThread = new PulseThread();
    AwtShellManager shellManager;
    BWidget over;
    BWidget active;
    int lastX = -1;
    int lastY = -1;
    int lastModifiers;
    int pressX;
    int pressY;
    boolean firedDragStarted;
    IMouseOverride override;
    public boolean holdRelease;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    MouseManager(AwtShellManager shellManager) {
        this.shellManager = shellManager;
        Thread thread = pulseThread;
        synchronized (thread) {
            if (pulseThread.getState() == Thread.State.NEW) {
                pulseThread.start();
            }
        }
        thread = hoverThread;
        synchronized (thread) {
            if (hoverThread.getState() == Thread.State.NEW) {
                hoverThread.start();
            }
        }
    }

    public BWidget over() {
        return this.over;
    }

    public int lastX() {
        return this.lastX;
    }

    public int lastY() {
        return this.lastY;
    }

    public void setMouseOverride(IMouseOverride override) {
        this.override = override;
    }

    final void process(MouseEvent event) {
        this.shellManager.userActivity();
        if (NPopup.cancel(event)) {
            return;
        }
        switch (event.getID()) {
            case 501: {
                this.pressed(event);
                return;
            }
            case 502: {
                this.released(event);
                return;
            }
            case 505: {
                this.exited(event);
                return;
            }
            case 503: {
                this.moved(event);
                return;
            }
            case 506: {
                this.dragged(event);
                return;
            }
        }
    }

    private void pressed(MouseEvent event) {
        BWidget t;
        this.active = t = this.getTarget(event);
        this.pressX = event.getX();
        this.pressY = event.getY();
        this.firedDragStarted = false;
        this.fire(501, event, t);
        this.startPulse();
    }

    private void released(MouseEvent event) {
        this.stopPulse();
        if (this.holdRelease) {
            this.holdRelease = false;
        } else {
            this.fire(502, event, this.active);
        }
        BWidget t = this.getTarget(event);
        if (t != this.active) {
            if (t != null) {
                this.fire(504, event, t);
            }
            if (this.over != t && this.over != null) {
                this.fire(505, event, this.over);
            }
            this.over = t;
        }
        this.active = null;
    }

    private void exited(MouseEvent event) {
        if (this.over != null) {
            this.fire(505, event, this.over);
        }
        this.over = null;
    }

    void checkOver() {
        if (this.active != null && this.active.isEnabled() && this.active.widgetSupport(null) != null) {
            return;
        }
        AccessController.doPrivileged(() -> {
            this.moved(new MouseEvent(this.shellManager, 503, System.currentTimeMillis(), this.lastModifiers, this.lastX, this.lastY, 0, false));
            return null;
        });
    }

    private void moved(MouseEvent event) {
        BWidget t = this.getTarget(event);
        if (t != this.over) {
            if (this.over != null) {
                this.fire(505, event, this.over);
            }
            if (t != null) {
                this.fire(504, event, t);
            }
            this.over = t;
            this.shellManager.updateMouseCursor();
        } else if (t != null) {
            this.fire(503, event, t);
        }
    }

    private void dragged(MouseEvent event) {
        BWidget t = this.getTarget(event);
        if (t != this.over) {
            if (t == this.active) {
                this.fire(504, event, this.active);
            } else {
                this.fire(505, event, this.active);
            }
            this.over = t;
        }
        this.fire(506, event, this.active);
        if (!this.firedDragStarted) {
            int dist;
            int dy;
            int mx = event.getX();
            int my = event.getY();
            int dx = mx - this.pressX;
            if (dx < 0) {
                dx = -dx;
            }
            if ((dy = my - this.pressY) < 0) {
                dy = -dy;
            }
            if ((dist = Math.max(dx, dy)) > 10) {
                this.firedDragStarted = true;
                BWidget w = this.active;
                if (w != null) {
                    Point pt = new Point((double)this.pressX, (double)this.pressY);
                    this.shellManager.shellToWidget(w, pt);
                    this.fire(new BMouseEvent(511, w, event.getWhen(), this.lastModifiers, pt.x, pt.y, -1, false));
                }
            }
        }
    }

    private void hover() {
        BWidget w = this.over;
        if (w != null) {
            Point pt = new Point((double)this.lastX, (double)this.lastY);
            this.shellManager.shellToWidget(w, pt);
            this.fire(new BMouseEvent(512, w, this.lastModifiers, pt.x, pt.y, -1, false));
        }
    }

    private void pulse() {
        BWidget w = this.active;
        if (w != null) {
            Point pt = new Point((double)this.lastX, (double)this.lastY);
            this.shellManager.shellToWidget(w, pt);
            this.fire(new BMouseEvent(510, w, this.lastModifiers, pt.x, pt.y, -1, false));
            DragOperation dragOp = AwtShellManager.dragOperation;
            if (dragOp != null) {
                dragOp.pulse();
            }
        }
    }

    public BMouseEvent fire(int id, MouseEvent src, BWidget w) {
        if (w == null) {
            return null;
        }
        try {
            BMouseEvent event;
            if (!UiEnv.get().hasMouse() && id == 501) {
                this.fire(504, src, w);
                this.fire(503, src, w);
            }
            this.lastX = src.getX();
            this.lastY = src.getY();
            this.lastModifiers = MouseManager.getModifiersExt(id, src, this.shellManager);
            Point pt = new Point((double)src.getX(), (double)src.getY());
            this.shellManager.shellToWidget(w, pt);
            if (id == 507) {
                event = ((AwtUiEnv)AwtUiEnv.get()).makeMouseWheelEvent(id, src, w, pt);
            } else {
                boolean isPopupTrigger = src.isPopupTrigger();
                if (this.override != null && this.override.isPopupTrigger()) {
                    if (id == 502) {
                        isPopupTrigger = true;
                        this.override.mouseReleased();
                    }
                    this.lastModifiers &= 0xFFFFFBFF;
                    this.lastModifiers |= 0x1000;
                }
                event = new BMouseEvent(id, w, src.getWhen(), this.lastModifiers, pt.x, pt.y, src.getClickCount(), isPopupTrigger);
            }
            this.fire(event);
            if (id == 504) {
                this.startHover();
            }
            if (!UiEnv.get().hasMouse() && id == 502) {
                this.fire(505, src, w);
            }
            return event;
        }
        catch (Throwable e) {
            e.printStackTrace();
            return null;
        }
    }

    private static int getModifiersExt(int id, MouseEvent src, AwtShellManager shellManager) {
        int modifiers = src.getModifiersEx();
        int button = src.getButton();
        if (id == 502) {
            if (button == 1) {
                modifiers |= 0x400;
            } else if (button == 2) {
                BKeyEvent lastKeyEvent = shellManager.getLastKeyEvent();
                if (lastKeyEvent == null || !lastKeyEvent.isAltDown()) {
                    modifiers &= 0xFFFFFDFF;
                }
                modifiers |= 0x800;
            } else if (button == 3) {
                BKeyEvent lastKeyEvent = shellManager.getLastKeyEvent();
                if (lastKeyEvent == null || !lastKeyEvent.isMetaDown()) {
                    modifiers &= 0xFFFFFEFF;
                }
                modifiers |= 0x1000;
            } else if (button == 4) {
                modifiers |= 0x4000;
            } else if (button == 5) {
                modifiers |= 0x8000;
            }
        }
        return modifiers;
    }

    private void fire(BMouseEvent event) {
        try {
            BWidget widget = event.getWidget();
            BWidgetShell shell = widget.getShell();
            if (shell instanceof IMouseNavigableShell && ((IMouseNavigableShell)((Object)shell)).navigateByMouse(event)) {
                return;
            }
            widget.fireMouseEvent(event);
        }
        catch (Throwable e) {
            e.printStackTrace();
        }
    }

    private BWidget getTarget(MouseEvent event) {
        BWidget target;
        Point pt = new Point((double)event.getX(), (double)event.getY());
        for (target = this.shellManager.widgetAt(pt, true); target != null && !target.receiveInputEvents(); target = target.getParentWidget()) {
        }
        return target;
    }

    private String eventIdToString(int id) {
        switch (id) {
            case 501: {
                return "Pressed";
            }
            case 502: {
                return "Released";
            }
            case 504: {
                return "Entered";
            }
            case 505: {
                return "Exited";
            }
            case 503: {
                return "Moved";
            }
            case 506: {
                return "Dragged";
            }
        }
        return "????";
    }

    private String toString(BMouseEvent event, BWidget widget) {
        switch (event.getId()) {
            case 501: {
                return "Pressed:  " + widget;
            }
            case 502: {
                return "Released: " + widget;
            }
            case 504: {
                return "Entered:  " + widget;
            }
            case 505: {
                return "Exited:   " + widget;
            }
            case 503: {
                return "Moved:    " + widget;
            }
            case 506: {
                return "Dragged:  " + widget;
            }
        }
        return "????";
    }

    private void startHover() {
        hoverThread.interrupt();
        hoverManager = this;
    }

    private void stopHover() {
        hoverManager = null;
    }

    void resetHover(BWidget w) {
        this.startHover();
    }

    private void startPulse() {
        pulseThread.interrupt();
        pulseManager = this;
    }

    private void stopPulse() {
        pulseManager = null;
    }

    private static class PulseThread
    extends Thread {
        int pulseTime;

        PulseThread() {
            super(Nre.mainThreadGroup, "Ui:PulseThread");
            this.setDaemon(true);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            while (true) {
                try {
                    while (true) {
                        PulseThread pulseThread = this;
                        synchronized (pulseThread) {
                            while (pulseManager == null) {
                                this.pulseTime = 700;
                                this.wait();
                            }
                        }
                        if (pulseManager != null) {
                            try {
                                pulseManager.pulse();
                            }
                            catch (Throwable e) {
                                e.printStackTrace();
                            }
                        }
                        Thread.sleep(this.pulseTime);
                        this.pulseTime = 150;
                    }
                }
                catch (InterruptedException e) {
                    this.pulseTime = 700;
                    continue;
                }
                catch (Throwable e) {
                    e.printStackTrace();
                    continue;
                }
                break;
            }
        }
    }

    private static class HoverThread
    extends Thread {
        HoverThread() {
            super(Nre.mainThreadGroup, "Ui:HoverThread");
            this.setDaemon(true);
        }

        @Override
        public void run() {
            while (true) {
                try {
                    while (true) {
                        HoverThread.sleep(700L);
                        if (hoverManager != null) {
                            try {
                                hoverManager.hover();
                            }
                            catch (Throwable e) {
                                e.printStackTrace();
                            }
                        }
                        Thread.sleep(Long.MAX_VALUE);
                    }
                }
                catch (InterruptedException e) {
                    continue;
                }
                catch (Throwable e) {
                    e.printStackTrace();
                    continue;
                }
                break;
            }
        }
    }

    public static interface IMouseOverride {
        public boolean isPopupTrigger();

        public void mouseReleased();
    }
}

