/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.ui.awt;

import com.tridium.ui.theme.Theme;
import java.awt.Color;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Frame;
import java.awt.Graphics;
import java.awt.GraphicsDevice;
import java.awt.GraphicsEnvironment;
import java.awt.Rectangle;
import java.awt.Toolkit;
import java.awt.Window;
import java.util.ArrayList;
import java.util.StringTokenizer;

public class BubbleHelp
extends Window {
    private static BubbleHelp window = new BubbleHelp(new Frame());
    private String[] text = new String[0];
    private int delta;
    private Color foreground;
    private Color background;
    private Font font;

    public static void open(int x, int y, String msg) {
        window.setLocation(x, y);
        window.setText(msg);
        window.checkLocation();
        window.pack();
        window.setVisible(true);
    }

    public static void update(int x, int y, String msg) {
        window.setLocation(x, y);
        window.setText(msg);
        window.checkLocation();
        window.pack();
        window.repaint();
    }

    public static void close() {
        window.setVisible(false);
    }

    private BubbleHelp(Frame frame) {
        super(frame);
        this.setLayout(null);
        this.foreground = Color.black;
        this.background = Color.white;
        this.font = new Font(Theme.widget().getTextFont().getName(), 0, 11);
    }

    private void setText(String msg) {
        int sw = Toolkit.getDefaultToolkit().getScreenSize().width;
        FontMetrics fm = Toolkit.getDefaultToolkit().getFontMetrics(this.font);
        this.delta = fm.getHeight();
        ArrayList<String> v = new ArrayList<String>();
        StringTokenizer st = new StringTokenizer(msg, "\n");
        while (st.hasMoreTokens()) {
            String line = st.nextToken();
            String[] wrap = BubbleHelp.wrap(fm, sw, line);
            for (int i = 0; i < wrap.length; ++i) {
                v.add(wrap[i]);
            }
        }
        this.text = v.toArray(new String[0]);
        int longest = 0;
        for (int i = 0; i < this.text.length; ++i) {
            int width = fm.stringWidth(this.text[i]);
            if (width <= longest) continue;
            longest = width;
        }
        int w = longest + 8;
        int h = this.delta * this.text.length + 4;
        this.setSize(w, h);
    }

    public static String[] wrap(FontMetrics fm, int sw, String s) {
        if (fm.stringWidth(s) < sw - 10) {
            return new String[]{s};
        }
        ArrayList<String> v = new ArrayList<String>();
        block0: while (fm.stringWidth(s) > sw - 10) {
            char[] c = s.toCharArray();
            StringBuilder buf = new StringBuilder();
            for (int i = 0; i < s.length(); ++i) {
                if (fm.charsWidth(c, 0, i) > sw - 20) {
                    v.add(buf.toString());
                    s = s.substring(i);
                    continue block0;
                }
                buf.append(c[i]);
            }
        }
        v.add(s);
        return v.toArray(new String[0]);
    }

    public void checkLocation() {
        int x = this.getLocation().x;
        int y = this.getLocation().y;
        int w = this.getSize().width;
        int h = this.getSize().height;
        GraphicsEnvironment env = GraphicsEnvironment.getLocalGraphicsEnvironment();
        GraphicsDevice[] devices = env.getScreenDevices();
        Rectangle currentDimensions = null;
        for (int i = 0; i < devices.length && !(currentDimensions = devices[i].getDefaultConfiguration().getBounds()).contains(this.getLocation()); ++i) {
        }
        if (currentDimensions != null) {
            int y_difference;
            int x_difference = this.getLocation().x + w + 5 - (currentDimensions.x + currentDimensions.width);
            if (x_difference > 0) {
                x -= x_difference;
            }
            if ((y_difference = this.getLocation().y + h + 5 - (currentDimensions.y + currentDimensions.height)) > 0) {
                y -= y_difference;
                y -= h * 2;
            }
        }
        this.setLocation(x, y);
    }

    @Override
    public void paint(Graphics g) {
        int w = this.getWidth();
        int h = this.getHeight();
        g.setColor(this.foreground);
        g.fillRect(0, 0, w, h);
        g.setColor(this.background);
        g.fillRect(1, 1, w - 2, h - 2);
        g.setColor(this.foreground);
        g.setFont(this.font);
        for (int i = 0; i < this.text.length; ++i) {
            g.drawString(this.text[i], 4, (i + 1) * this.delta);
        }
    }
}

