/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.ui.awt;

import com.tridium.ui.DialogPeer;
import com.tridium.ui.FramePeer;
import com.tridium.ui.ShellManager;
import com.tridium.ui.ShellPeer;
import com.tridium.ui.UiEnv;
import com.tridium.ui.WindowPeer;
import com.tridium.ui.awt.AwtDialogPeer;
import com.tridium.ui.awt.AwtFramePeer;
import com.tridium.ui.awt.AwtShellManager;
import com.tridium.ui.awt.AwtWindowPeer;
import com.tridium.ui.awt.BubbleHelp;
import com.tridium.ui.awt.NMouseCursor;
import com.tridium.ui.awt.NPopup;
import com.tridium.ui.awt.PanelPeer;
import com.tridium.ui.awt.TransferManager;
import com.tridium.ui.file.BNDirectoryChooser;
import com.tridium.ui.file.BNFileChooser;
import java.awt.Component;
import java.awt.Container;
import java.awt.Cursor;
import java.awt.Dialog;
import java.awt.EventQueue;
import java.awt.Frame;
import java.awt.GraphicsConfiguration;
import java.awt.GraphicsDevice;
import java.awt.GraphicsEnvironment;
import java.awt.IllegalComponentStateException;
import java.awt.Rectangle;
import java.awt.Window;
import java.awt.datatransfer.DataFlavor;
import java.awt.event.FocusEvent;
import java.awt.event.MouseEvent;
import java.security.AccessController;
import java.security.PrivilegedAction;
import javax.baja.gx.IRectGeom;
import javax.baja.gx.Insets;
import javax.baja.gx.Point;
import javax.baja.gx.RectGeom;
import javax.baja.ui.BWidget;
import javax.baja.ui.BWidgetShell;
import javax.baja.ui.BWindow;
import javax.baja.ui.MouseCursor;
import javax.baja.ui.event.BMouseEvent;
import javax.baja.ui.file.BDirectoryChooser;
import javax.baja.ui.file.BFileChooser;

public abstract class AwtUiEnv
extends UiEnv {
    public final Frame defaultFrame = AccessController.doPrivileged(new PrivilegedAction<Frame>(){

        @Override
        public Frame run() {
            return new Frame();
        }
    });
    private static Insets frameInsets;
    private static Insets dialogInsets;
    private static Insets windowInsets;

    private GraphicsDevice getScreenDevice(BWidget w) {
        Window window = this.ownerToWindow(w);
        GraphicsConfiguration config = window.getGraphicsConfiguration();
        return config.getDevice();
    }

    public IRectGeom getDefaultScreenBounds() {
        GraphicsEnvironment env = GraphicsEnvironment.getLocalGraphicsEnvironment();
        GraphicsDevice device = env.getDefaultScreenDevice();
        GraphicsConfiguration config = device.getDefaultConfiguration();
        Rectangle fullBounds = config.getBounds();
        java.awt.Insets insets = this.getScreenInsets(config);
        RectGeom bounds = new RectGeom((double)(fullBounds.x + insets.left), (double)(fullBounds.y + insets.top), (double)(fullBounds.width - insets.left - insets.right), (double)(fullBounds.height - insets.top - insets.bottom));
        return bounds;
    }

    @Override
    public IRectGeom getScreenBounds(double x, double y) {
        GraphicsEnvironment env = GraphicsEnvironment.getLocalGraphicsEnvironment();
        GraphicsDevice[] screens = env.getScreenDevices();
        GraphicsDevice screen = null;
        for (int i = 0; i < screens.length; ++i) {
            Rectangle screenBounds = screens[i].getDefaultConfiguration().getBounds();
            if (!screenBounds.contains((int)x, (int)y)) continue;
            screen = screens[i];
            break;
        }
        if (screen == null) {
            screen = env.getDefaultScreenDevice();
        }
        GraphicsConfiguration config = screen.getDefaultConfiguration();
        Rectangle fullBounds = config.getBounds();
        java.awt.Insets insets = this.getScreenInsets(config);
        RectGeom bounds = new RectGeom((double)(fullBounds.x + insets.left), (double)(fullBounds.y + insets.top), (double)(fullBounds.width - insets.left - insets.right), (double)(fullBounds.height - insets.top - insets.bottom));
        return bounds;
    }

    @Override
    public IRectGeom getScreenBounds(BWidget w) {
        if (w == null) {
            return this.getDefaultScreenBounds();
        }
        AwtShellManager mgr = (AwtShellManager)w.widgetSupport(null);
        if (mgr.isShowing()) {
            GraphicsConfiguration config = mgr.getGraphicsConfiguration();
            Rectangle rect = config.getBounds();
            java.awt.Insets insets = this.getScreenInsets(config);
            return new RectGeom((double)(rect.x + insets.left), (double)(rect.y + insets.top), (double)(rect.width - insets.left - insets.right), (double)(rect.height - insets.top - insets.bottom));
        }
        ShellPeer peer = mgr.getShellPeer();
        if (peer instanceof Window) {
            java.awt.Point loc = ((Window)((Object)peer)).getLocation();
            return this.getScreenBounds(loc.x, loc.y);
        }
        return this.getDefaultScreenBounds();
    }

    protected abstract java.awt.Insets getScreenInsets(GraphicsConfiguration var1);

    @Override
    public Insets getWindowInsets(BWindow window) {
        AwtShellManager shellManager = (AwtShellManager)window.widgetSupport(null);
        for (Container c = (Container)((Object)shellManager.getShellPeer()); c != null; c = c.getParent()) {
            if (c instanceof Frame) {
                if (null == frameInsets) {
                    Frame f = new Frame();
                    f.setBounds(new Rectangle(-200, -200, 100, 100));
                    f.setVisible(true);
                    java.awt.Insets insets = f.getInsets();
                    f.setVisible(false);
                    f.dispose();
                    frameInsets = AwtUiEnv.makeInsets(insets);
                }
                return frameInsets;
            }
            if (c instanceof Dialog) {
                if (null == dialogInsets) {
                    Frame frame = new Frame();
                    frame.setBounds(new Rectangle(-200, -200, 100, 100));
                    frame.setVisible(true);
                    Dialog d = new Dialog(frame, "Test");
                    d.setBounds(-200, -200, 100, 100);
                    d.setVisible(true);
                    java.awt.Insets insets = d.getInsets();
                    d.setVisible(false);
                    d.dispose();
                    frame.setVisible(false);
                    frame.dispose();
                    dialogInsets = AwtUiEnv.makeInsets(insets);
                }
                return dialogInsets;
            }
            if (!(c instanceof Window)) continue;
            if (null == windowInsets) {
                Window w = new Window(shellManager.getWindow());
                w.setBounds(-200, -200, 100, 100);
                w.setVisible(true);
                java.awt.Insets insets = w.getInsets();
                w.setVisible(false);
                w.dispose();
                windowInsets = AwtUiEnv.makeInsets(insets);
            }
            return windowInsets;
        }
        return null;
    }

    private static Insets makeInsets(java.awt.Insets insets) {
        Insets gxInsets = new Insets();
        gxInsets.top = insets.top;
        gxInsets.bottom = insets.bottom;
        gxInsets.left = insets.left;
        gxInsets.right = insets.right;
        return gxInsets;
    }

    public abstract boolean isIconified(Frame var1);

    public abstract void setIconified(Frame var1, boolean var2);

    public abstract boolean isMaximized(Frame var1);

    public abstract void setMaximized(Frame var1, boolean var2);

    @Override
    public final ShellManager makeShellManager(BWidgetShell shell) {
        ShellPeer peer = shell instanceof ShellManager.ShellPeerFactory ? ((ShellManager.ShellPeerFactory)((Object)shell)).newShellPeer() : new PanelPeer();
        return this.makeAwtShellManager(shell, peer);
    }

    @Override
    public final ShellManager makeShellManager(BWidgetShell shell, ShellPeer peer) {
        return this.makeAwtShellManager(shell, peer);
    }

    public abstract AwtShellManager makeAwtShellManager(BWidget var1, ShellPeer var2);

    @Override
    public final FramePeer makeFramePeer(String title) {
        return new AwtFramePeer(title);
    }

    @Override
    public final DialogPeer makeDialogPeer(final BWidget owner, final String title, final boolean modal) {
        return AccessController.doPrivileged(new PrivilegedAction<DialogPeer>(){

            @Override
            public DialogPeer run() {
                Window w = AwtUiEnv.this.ownerToWindow(owner);
                if (w instanceof Dialog) {
                    return new AwtDialogPeer((Dialog)w, title, modal);
                }
                if (w instanceof Frame) {
                    return new AwtDialogPeer((Frame)w, title, modal);
                }
                return new AwtDialogPeer(AwtUiEnv.this.defaultFrame, title, modal);
            }
        });
    }

    @Override
    public final WindowPeer makeWindowPeer(BWidget owner) {
        Window window = this.ownerToWindow(owner);
        if (window instanceof Frame) {
            return new AwtWindowPeer((Frame)window);
        }
        return new AwtWindowPeer(window);
    }

    @Override
    public WindowPeer makeRoundedWindowPeer(BWidget owner, float arcWidth, float arcHeight) {
        return this.makeWindowPeer(owner);
    }

    @Override
    public FramePeer makeRoundedFramePeer(String title, float arcWidth, float arcHeight) {
        return this.makeFramePeer(title);
    }

    @Override
    public DialogPeer makeRoundedDialogPeer(BWidget owner, String title, boolean modal, float arcWidth, float arcHeight) {
        return this.makeDialogPeer(owner, title, modal);
    }

    protected Window ownerToWindow(BWidget owner) {
        Window window = null;
        if (owner != null) {
            AwtShellManager shellManager = (AwtShellManager)owner.widgetSupport(null);
            if (shellManager == null) {
                throw new IllegalArgumentException("Not in windowing system");
            }
            window = shellManager.getWindow();
        }
        if (window == null) {
            return this.defaultFrame;
        }
        return window;
    }

    Frame ownerToFrame(BWidget owner) {
        Container window = this.ownerToWindow(owner);
        while (window != null) {
            if (window instanceof Frame) {
                return (Frame)window;
            }
            window = window.getParent();
        }
        return ((AwtUiEnv)AwtUiEnv.get()).defaultFrame;
    }

    @Override
    public MouseCursor makeCursor(int id) {
        switch (id) {
            case 0: {
                return AwtUiEnv.toCursor(Cursor.getDefaultCursor());
            }
            case 1: {
                return AwtUiEnv.toCursor(1);
            }
            case 2: {
                return AwtUiEnv.toCursor(12);
            }
            case 3: {
                return AwtUiEnv.toCursor(13);
            }
            case 4: {
                return AwtUiEnv.toCursor(2);
            }
            case 5: {
                return AwtUiEnv.toCursor(3);
            }
            case 6: {
                return AwtUiEnv.toCursor(11);
            }
            case 7: {
                return AwtUiEnv.toCursor(10);
            }
            case 8: {
                return AwtUiEnv.toCursor(8);
            }
            case 9: {
                return AwtUiEnv.toCursor(9);
            }
            case 10: {
                return AwtUiEnv.toCursor(7);
            }
            case 11: {
                return AwtUiEnv.toCursor(6);
            }
            case 12: {
                return AwtUiEnv.toCursor(5);
            }
            case 13: {
                return AwtUiEnv.toCursor(4);
            }
            case 14: {
                return this.toCursor("grabHand", 16, 16, 0);
            }
            case 15: {
                return this.toCursor("openHand", 16, 16, 0);
            }
            case 16: {
                return this.toCursor("doNotEnter", 16, 16, 0);
            }
            case 17: {
                return this.toCursor("stacked", 16, 16, 0);
            }
            case 18: {
                return this.toCursor("dropLeft", 9, 16, 0);
            }
            case 19: {
                return this.toCursor("dropRight", 22, 16, 0);
            }
            case 20: {
                return this.toCursor("dropTop", 16, 9, 0);
            }
            case 21: {
                return this.toCursor("dropBottom", 16, 22, 0);
            }
            case 22: {
                return this.toCursor("dropper", 8, 23, 0);
            }
            case 25: {
                return this.toCursor("magnify", 16, 16, 0);
            }
            case 23: {
                return this.toCursor("linkLeft", 9, 16, 10);
            }
            case 24: {
                return this.toCursor("linkRight", 22, 16, 11);
            }
        }
        throw new IllegalStateException();
    }

    private static MouseCursor toCursor(Cursor c) {
        return new NMouseCursor(c);
    }

    private static MouseCursor toCursor(int predefined) {
        return new NMouseCursor(Cursor.getPredefinedCursor(predefined));
    }

    protected abstract MouseCursor toCursor(String var1, int var2, int var3, int var4);

    @Override
    public void invokeLater(Runnable event) {
        EventQueue.invokeLater(event);
    }

    public abstract BMouseEvent makeMouseWheelEvent(int var1, MouseEvent var2, BWidget var3, Point var4);

    public abstract Component getOpposite(FocusEvent var1);

    @Override
    public boolean isPopupOpen(BWidget popup) {
        return NPopup.isOpen(popup);
    }

    @Override
    public void openPopup(BWidget popup, BWidget owner, double x, double y) {
        NPopup.open(popup, owner, x, y);
    }

    @Override
    public void openPopup(BWidget popup, BWidget owner, double x, double y, double fixedWidth, double fixedHeight) {
        NPopup.open(popup, owner, x, y, fixedWidth, fixedHeight);
    }

    @Override
    public void closePopup(BWidget popup) {
        NPopup.close(popup);
    }

    @Override
    public void openBubbleHelp(BWidget owner, double x, double y, String text) {
        try {
            Point pt = new Point(x, y);
            pt = owner.translateToScreen(pt);
            BubbleHelp.open((int)pt.x, (int)pt.y, text);
        }
        catch (IllegalComponentStateException illegalComponentStateException) {
            // empty catch block
        }
    }

    @Override
    public void updateBubbleHelp(BWidget owner, double x, double y, String text) {
        try {
            Point pt = new Point(x, y);
            pt = owner.translateToScreen(pt);
            BubbleHelp.update((int)pt.x, (int)pt.y, text);
        }
        catch (IllegalComponentStateException illegalComponentStateException) {
            // empty catch block
        }
    }

    @Override
    public void closeBubbleHelp() {
        BubbleHelp.close();
    }

    @Override
    public void setPopupOpacity(BWidget popup, float f) {
    }

    @Override
    public BFileChooser makeOpenFileChooser(BWidget owner) {
        return BNFileChooser.makeOpen(owner);
    }

    @Override
    public BFileChooser makeSaveFileChooser(BWidget owner) {
        return BNFileChooser.makeSave(owner);
    }

    @Override
    public BDirectoryChooser makeDirectoryChooser(BWidget owner) {
        return new BNDirectoryChooser(owner);
    }

    @Override
    public UiEnv.ClipboardManager makeDefaultClipboardManager() {
        return TransferManager.defaultClipboardManager;
    }

    public abstract DataFlavor makeMarkDataFlavor() throws Exception;
}

