/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.ui.awt;

import com.tridium.gx.awt.AwtEnv;
import com.tridium.gx.awt.ImageManager;
import com.tridium.sys.Nre;
import com.tridium.ui.BNiagaraWidgetApplication;
import com.tridium.ui.PxIncludeManager;
import com.tridium.ui.ShellManager;
import com.tridium.ui.ShellPeer;
import com.tridium.ui.awt.DragOperation;
import com.tridium.ui.awt.FocusManager;
import com.tridium.ui.awt.MouseManager;
import com.tridium.ui.awt.NMouseCursor;
import com.tridium.ui.awt.Perf;
import com.tridium.ui.awt.WindowManager;
import com.tridium.ui.theme.Theme;
import com.tridium.util.ThrowableUtil;
import java.awt.Container;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Panel;
import java.awt.Rectangle;
import java.awt.Window;
import java.awt.event.FocusEvent;
import java.awt.event.KeyEvent;
import java.awt.event.MouseEvent;
import java.security.AccessController;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import javax.baja.gx.Graphics;
import javax.baja.gx.Point;
import javax.baja.sys.BValue;
import javax.baja.sys.Clock;
import javax.baja.sys.Property;
import javax.baja.ui.BWidget;
import javax.baja.ui.BWidgetShell;
import javax.baja.ui.MouseCursor;
import javax.baja.ui.event.BKeyEvent;

public abstract class AwtShellManager
extends Panel
implements ShellManager {
    static CoalesceThread coalesceThread = new CoalesceThread();
    long coalesceDeadline;
    AwtShellManager coalesceNext;
    static int dumpCounter;
    public static volatile DragOperation dragOperation;
    static Cursor busyCursor;
    public final MouseManager mouseManager;
    public final BWidget shell;
    public final FocusManager focusManager;
    public final WindowManager windowManager;
    private ShellPeer peer;
    private int lastWidth = -1;
    private int lastHeight = -1;
    private Image buffer;
    private HashMap<BWidget, BWidget> relayoutQueue = new HashMap();
    private Thread layoutThread;
    private Property mountProperty;
    private Object busyLock = new Object();
    private int busyCount;
    private ArrayList<String> busyStack = new ArrayList();
    private boolean isActivated = true;
    public Perf perf = new Perf(this);
    private volatile int disableInputCount = 0;
    private Object disableInputLock = new Object();
    private static final boolean disableDoubleBuff;

    public AwtShellManager(BWidget shell, ShellPeer peer) {
        dragOperation = null;
        this.setLayout(null);
        this.shell = shell;
        this.peer = peer;
        peer.installShellManager(this);
        if (this.getParent() != peer) {
            throw new IllegalStateException();
        }
        this.relayout(shell, false);
        this.enableEvents(60L);
        this.mouseManager = new MouseManager(this);
        this.focusManager = new FocusManager(this);
        this.windowManager = new WindowManager(this);
    }

    @Override
    public void activate() {
        this.mountProperty = BWidget.getApplication().add(null, (BValue)this.shell, null);
        this.shell.start();
        Window window = this.getWindow();
        if (window != null) {
            window.addWindowListener(this.windowManager);
            window.addComponentListener(this.windowManager);
        }
        this.isActivated = true;
    }

    @Override
    public void deactivate() {
        Window window;
        this.isActivated = false;
        this.shell.stop();
        this.disposeBuffer();
        if (this.mountProperty != null) {
            BWidget.getApplication().remove(this.mountProperty, null);
            this.mountProperty = null;
        }
        if ((window = this.getWindow()) != null) {
            window.removeWindowListener(this.windowManager);
            window.addComponentListener(this.windowManager);
        }
    }

    void disposeBuffer() {
        if (this.buffer != null) {
            this.buffer.flush();
            this.buffer = null;
        }
    }

    @Override
    public final BWidget getShell() {
        return this.shell;
    }

    @Override
    public final ShellPeer getShellPeer() {
        return this.peer;
    }

    @Override
    public final void repaint(BWidget c, int x, int y, int w, int h) {
        Point a = this.widgetToShell(c, new Point((double)x, (double)y));
        Point b = this.widgetToShell(c, new Point((double)(x + w), (double)(y + h)));
        if (a.x < 0.0) {
            a.x = 0.0;
        }
        if (a.y < 0.0) {
            a.y = 0.0;
        }
        if (b.x < 0.0) {
            b.x = 0.0;
        }
        if (b.y < 0.0) {
            b.y = 0.0;
        }
        this.repaint((int)a.x, (int)a.y, (int)(b.x - a.x), (int)(b.y - a.y));
    }

    @Override
    public final boolean hasFocus(BWidget c) {
        return this.focusManager.hasFocus(c);
    }

    @Override
    public final void requestFocus(BWidget c) {
        this.requestFocus();
        this.focusManager.requestFocus(c);
    }

    @Override
    public final BWidget getCurrentFocus() {
        return this.focusManager.getCurrentFocus();
    }

    public void takeTempFocus(AwtShellManager master) {
        master.focusManager.takeTempFocus(this);
    }

    public void releaseTempFocus(AwtShellManager master) {
        master.focusManager.releaseTempFocus(master);
    }

    public void clearTempFocus() {
        this.focusManager.takeBack = false;
    }

    public final Window getWindow() {
        Container p = this.getParent();
        while (!(p instanceof Window)) {
            if (p == null) {
                return null;
            }
            p = p.getParent();
        }
        return (Window)p;
    }

    @Override
    public final Point translateToScreen(BWidget c, Point pt) {
        java.awt.Point onScreen = this.getLocationOnScreen();
        this.widgetToShell(c, pt);
        pt.translate((double)onScreen.x, (double)onScreen.y);
        return pt;
    }

    public final BKeyEvent getLastKeyEvent() {
        return this.focusManager.lastKeyEvent;
    }

    @Override
    public void update(java.awt.Graphics g) {
        this.paint(g);
    }

    @Override
    public void paint(java.awt.Graphics g) {
        long t1 = Perf.now();
        if (!this.isActivated) {
            return;
        }
        Rectangle clip = g.getClipBounds();
        Dimension dim = this.getSize();
        clip.width = Math.min(clip.width, dim.width);
        clip.height = Math.min(clip.height, dim.height);
        if (dim.width != this.lastWidth || dim.height != this.lastHeight) {
            this.shell.setSize(dim.width, dim.height);
            this.lastWidth = dim.width;
            this.lastHeight = dim.height;
            if (this.buffer != null) {
                this.buffer.flush();
            }
            this.buffer = null;
        }
        if (this.buffer == null) {
            if (dim.width <= 0) {
                dim.width = 1;
            }
            if (dim.height <= 0) {
                dim.height = 1;
            }
            long cb1 = Perf.now();
            this.buffer = this.createImage(dim.width, dim.height);
            clip = new Rectangle(0, 0, dim.width, dim.height);
            long cb2 = Perf.now();
            this.perf.durCreateBuffer += cb2 - cb1;
        }
        Graphics2D bufGraphics = null;
        try {
            if (!disableDoubleBuff) {
                bufGraphics = (Graphics2D)this.buffer.getGraphics();
            }
        }
        catch (Exception e) {
            System.out.println("AwtShellManager.paint.getGraphics " + e);
            return;
        }
        if (bufGraphics != null) {
            bufGraphics.setClip(clip.x, clip.y, clip.width, clip.height);
        }
        long l1 = Perf.now();
        this.layoutWidgets();
        long l2 = Perf.now();
        this.perf.durWidgetLayout += l2 - l1;
        long c1 = Perf.now();
        boolean useAA = ((BNiagaraWidgetApplication)BWidget.getApplication()).useAntiAlias();
        Graphics2D graphics2D = bufGraphics == null ? (Graphics2D)g : bufGraphics;
        AwtEnv.makeHighQuality((Graphics2D)graphics2D);
        Graphics graphics = ((AwtEnv)AwtEnv.get()).makeGraphics(graphics2D);
        graphics.useAntiAliasing(useAA);
        graphics.setBrush(Theme.widget().getControlBackground());
        graphics.fillRect((double)clip.x, (double)clip.y, (double)clip.width, (double)clip.height);
        long c2 = Perf.now();
        this.perf.durClearClip += c2 - c1;
        long p1 = Perf.now();
        this.shell.paint(graphics);
        long p2 = Perf.now();
        this.perf.durWidgetPaint += p2 - p1;
        DragOperation dragOp = dragOperation;
        if (dragOp != null) {
            dragOp.paintDragEffect(this, graphics);
        }
        if (bufGraphics != null) {
            graphics.dispose();
            graphics = null;
            bufGraphics.dispose();
            bufGraphics = null;
            try {
                long db1 = Perf.now();
                g.drawImage(this.buffer, 0, 0, null);
                long db2 = Perf.now();
                this.perf.durDrawBuffer += db2 - db1;
            }
            catch (Exception e) {
                System.out.println("AwtShellManager.paint.drawImage: " + e);
            }
        }
        long t2 = Perf.now();
        ++this.perf.numShellPaint;
        this.perf.durTotalPaint += t2 - t1;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void layoutWidgets() {
        BWidget[] relayout = null;
        HashMap<BWidget, BWidget> hashMap = this.relayoutQueue;
        synchronized (hashMap) {
            if (this.relayoutQueue.size() > 0) {
                Collection<BWidget> values = this.relayoutQueue.values();
                relayout = values.toArray(new BWidget[0]);
                this.relayoutQueue.clear();
            }
        }
        if (relayout != null) {
            this.layoutThread = Thread.currentThread();
            for (int i = 0; i < relayout.length; ++i) {
                relayout[i].layout();
            }
            this.layoutThread = null;
            this.checkMouseOver();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final void relayout(BWidget widget, boolean sync) {
        HashMap<BWidget, BWidget> hashMap = this.relayoutQueue;
        synchronized (hashMap) {
            if (this.layoutThread != Thread.currentThread() && this.relayoutQueue.get(widget) == null) {
                this.relayoutQueue.put(widget, widget);
            }
        }
        if (sync) {
            this.layoutWidgets();
            this.repaint();
        } else {
            coalesceThread.repaint(this);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean enqueueRelayout(BWidget widget) {
        HashMap<BWidget, BWidget> hashMap = this.relayoutQueue;
        synchronized (hashMap) {
            if (this.layoutThread != Thread.currentThread() && this.relayoutQueue.get(widget) == null) {
                this.relayoutQueue.put(widget, widget);
                return true;
            }
        }
        return false;
    }

    @Override
    public void processMouseEvent(MouseEvent event) {
        if (this.isInputDisabled()) {
            return;
        }
        DragOperation dragOp = dragOperation;
        if (dragOp != null) {
            dragOp.process(this, event);
        }
        this.mouseManager.process(event);
        super.processMouseEvent(event);
    }

    @Override
    public void processMouseMotionEvent(MouseEvent event) {
        if (this.isInputDisabled()) {
            return;
        }
        DragOperation dragOp = dragOperation;
        if (dragOp != null) {
            dragOp.process(this, event);
        }
        this.mouseManager.process(event);
        super.processMouseMotionEvent(event);
    }

    @Override
    public void processFocusEvent(FocusEvent event) {
        if (this.isInputDisabled()) {
            return;
        }
        this.focusManager.process(event);
        super.processFocusEvent(event);
    }

    @Override
    public void processKeyEvent(KeyEvent event) {
        if (this.isInputDisabled()) {
            return;
        }
        DragOperation dragOp = dragOperation;
        if (dragOp != null) {
            dragOp.process(this, event);
        }
        this.focusManager.process(event);
        super.processKeyEvent(event);
    }

    @Override
    public void resetHover(BWidget w) {
        this.mouseManager.resetHover(w);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void enableInput() {
        Object object = this.disableInputLock;
        synchronized (object) {
            if (this.disableInputCount > 0) {
                --this.disableInputCount;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void disableInput() {
        Object object = this.disableInputLock;
        synchronized (object) {
            ++this.disableInputCount;
        }
    }

    private boolean isInputDisabled() {
        return this.disableInputCount > 0;
    }

    public final BWidget widgetAt(Point pt, boolean enabledOnly) {
        if (!this.shell.isEnabled()) {
            return null;
        }
        return this.widgetAt(this.shell, pt, enabledOnly);
    }

    public final BWidget widgetAt(BWidget widget, Point pt, boolean enabledOnly) {
        BWidget child = widget.childAt(pt);
        if (child != null && child.isEnabled()) {
            return this.widgetAt(child, widget.translateToChild(child, pt), enabledOnly);
        }
        return widget;
    }

    public final Point widgetToShell(BWidget w, Point pt) {
        return w.translateToAncestor(this.shell, pt);
    }

    public final Point shellToWidget(BWidget w, Point pt) {
        try {
            return w.translateFromAncestor(this.shell, pt);
        }
        catch (NullPointerException e) {
            System.out.println("WARNING: NWidgetContext.shellToWidget() NullPointerException");
            return new Point(0.0, 0.0);
        }
    }

    @Override
    public void checkMouseOver() {
        this.mouseManager.checkOver();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void updateMouseCursor() {
        Object object = this.busyLock;
        synchronized (object) {
            if (this.busyCount == 0) {
                BWidget w = this.mouseManager.over;
                MouseCursor c = null;
                if (w != null) {
                    c = w.getMouseCursor();
                }
                if (c == null) {
                    c = MouseCursor.normal;
                }
                this.setCursor(((NMouseCursor)c).cursor);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void enterBusy(BWidget w) {
        Object object = this.busyLock;
        synchronized (object) {
            ++this.busyCount;
            if (this.busyCount == 1) {
                this.setCursor(busyCursor);
            }
            this.busyStack.add(ThrowableUtil.getStack());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void exitBusy(BWidget w) {
        Object object = this.busyLock;
        synchronized (object) {
            --this.busyCount;
            if (this.busyCount < 0) {
                this.busyCount = 0;
            }
            if (this.busyCount == 0) {
                this.updateMouseCursor();
            }
            if (this.busyStack.size() > 0) {
                this.busyStack.remove(this.busyStack.size() - 1);
            }
        }
    }

    public void userActivity() {
        BNiagaraWidgetApplication.inputActivity();
        if (this.shell instanceof BWidgetShell) {
            ((BWidgetShell)this.shell).userActivity();
        }
    }

    public void debug() {
        BWidget focus = this.focusManager.getCurrentFocus();
        System.out.println("###########################################################################");
        System.out.println("# " + dumpCounter++ + "  [" + new Date() + "]");
        System.out.println("# Focus: " + (focus == null ? "null" : focus.toDebugString()));
        if (this.peer != null) {
            System.out.println("# Peer Bounds: " + this.peer.getScreenBounds());
        }
        for (int i = 0; i < this.busyStack.size(); ++i) {
            System.out.println("----- busyStack[" + i + "] -----");
            System.out.println(this.busyStack.get(i));
        }
        if (this.shell instanceof DebugShell) {
            ((DebugShell)((Object)this.shell)).debug();
        }
        ImageManager.trimAll();
        PxIncludeManager.trimAll();
        this.perf.dump();
        System.gc();
        System.out.println("###########################################################################");
    }

    @Override
    public boolean isDesignTime() {
        return false;
    }

    static {
        coalesceThread.start();
        dumpCounter = 0;
        busyCursor = Cursor.getPredefinedCursor(3);
        disableDoubleBuff = AccessController.doPrivileged(() -> Boolean.getBoolean("bajaui.disableDoubleBuff"));
    }

    public static interface DebugShell {
        public void debug();
    }

    public static interface ShellPeerFactory {
        public ShellPeer newShellPeer();
    }

    static class CoalesceThread
    extends Thread {
        Object lock = new Object();
        AwtShellManager head;
        AwtShellManager tail;

        CoalesceThread() {
            super(Nre.mainThreadGroup, "Ui:CoalesceThread");
            this.setDaemon(true);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void repaint(AwtShellManager manager) {
            long now = Clock.ticks();
            Object object = this.lock;
            synchronized (object) {
                if (manager.coalesceDeadline == 0L) {
                    if (this.head == null) {
                        this.head = this.tail = manager;
                    } else {
                        this.tail.coalesceNext = manager;
                        this.tail = manager;
                    }
                }
                manager.coalesceDeadline = now + 10L;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        @Override
        public void run() {
            while (true) {
                try {
                    while (true) {
                        Thread.sleep(10L);
                        long now = Clock.ticks();
                        Object object = this.lock;
                        synchronized (object) {
                            AwtShellManager last = null;
                            AwtShellManager cur = this.head;
                            while (cur != null) {
                                AwtShellManager next = cur.coalesceNext;
                                if (cur.coalesceDeadline <= now) {
                                    cur.coalesceDeadline = 0L;
                                    if (last == null) {
                                        this.head = next;
                                    } else {
                                        last.coalesceNext = next;
                                    }
                                    if (next == null) {
                                        this.tail = last;
                                    }
                                    cur.coalesceNext = null;
                                    cur.repaint();
                                } else {
                                    last = cur;
                                }
                                cur = next;
                            }
                        }
                    }
                }
                catch (Throwable e) {
                    e.printStackTrace();
                    continue;
                }
                break;
            }
        }
    }
}

