/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.ui;

import com.tridium.sys.Nre;
import com.tridium.sys.spy.CacheSpy;
import java.security.AccessController;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.baja.file.BIFile;
import javax.baja.naming.BOrd;
import javax.baja.nre.util.Array;
import javax.baja.nre.util.SortUtil;
import javax.baja.spy.Spy;
import javax.baja.spy.SpyWriter;
import javax.baja.sys.BComponent;
import javax.baja.sys.BFacets;
import javax.baja.sys.BRelTime;
import javax.baja.sys.BValue;
import javax.baja.sys.Clock;
import javax.baja.sys.Property;
import javax.baja.ui.BWidget;
import javax.baja.ui.px.BPxInclude;
import javax.baja.ui.px.PxDecoder;
import javax.baja.ui.px.PxProperty;
import javax.baja.util.Queue;

public final class PxIncludeManager {
    private static Logger log = Logger.getLogger("pxInclude");
    private static final Collection<String> nonCachedTypes;
    private static final PxIncludeCache pxIncludeCache;

    public static void load(BPxInclude include) {
        pxIncludeCache.load(include);
    }

    public static void trimAll() {
        pxIncludeCache.trimAll();
        log.info("Entire cache cleared");
    }

    private static void setBaseOrd(BOrd baseOrd, BWidget w) {
        w.fw(205, baseOrd, null, null, null);
        for (BWidget kid : (BWidget[])w.getChildren(BWidget.class)) {
            PxIncludeManager.setBaseOrd(baseOrd, kid);
        }
    }

    private static void findOrds(BComponent c, Array<BOrd> arr) {
        if (c == null) {
            return;
        }
        arr.addAll(c.getChildren(BOrd.class));
        for (BComponent kid : c.getChildComponents()) {
            PxIncludeManager.findOrds(kid, arr);
        }
    }

    private static void subOrds(BComponent c, BFacets vars) throws Exception {
        if (c == null) {
            return;
        }
        for (Property property : c.getPropertiesArray()) {
            BValue val = c.get(property);
            if (!(val instanceof BOrd)) continue;
            BOrd ord = (BOrd)val;
            c.set(property, (BValue)ord.substitute(vars));
        }
        for (Property property : c.getChildComponents()) {
            PxIncludeManager.subOrds((BComponent)property, vars);
        }
    }

    static {
        ArrayList types = new ArrayList();
        Collections.addAll(types, "schedule:Scheduler", "history:HistoryTable", "wiresheet:WireSheet", "workbench:SlotSheet", "wbutil:CategorySheet");
        Collections.addAll(types, AccessController.doPrivileged(() -> System.getProperty("niagara.pxInclude.cache.ignore", "")).split(";"));
        nonCachedTypes = Collections.unmodifiableList(types);
        String cacheType = AccessController.doPrivileged(() -> System.getProperty("niagara.pxInclude.cache", "widget"));
        pxIncludeCache = cacheType.trim().equalsIgnoreCase("widget") ? new WidgetCache() : new NoCache();
    }

    private static final class NoCache
    implements PxIncludeCache {
        private NoCache() {
            Spy.ROOT.add("pxIncludeManager", (Spy)new NoCacheSpy());
            if (log.isLoggable(Level.FINE)) {
                log.fine("No PxInclude caching is active");
            }
        }

        @Override
        public void load(BPxInclude include) {
            BOrd ord = include.getOrd();
            if (ord.isNull()) {
                include.fw(307, null, null, null, null);
                return;
            }
            try {
                BOrd baseOrd = include.getBaseOrd();
                if (baseOrd != null) {
                    ord = BOrd.make((BOrd)baseOrd, (BOrd)ord).normalize();
                }
                BIFile file = (BIFile)ord.resolve().get();
                PxDecoder decoder = new PxDecoder(file);
                BWidget root = decoder.decodeDocument();
                NoCache.loadInclude(root, decoder, include, baseOrd, file);
            }
            catch (Throwable e) {
                e.printStackTrace();
                include.fw(307, null, null, null, null);
            }
        }

        private static void loadInclude(BWidget root, PxDecoder decoder, BPxInclude include, BOrd baseOrd, BIFile file) throws Exception {
            PxProperty[] props = decoder.getPxProperties();
            Array ordArr = new Array(BOrd.class);
            PxIncludeManager.findOrds(root, (Array<BOrd>)ordArr);
            BOrd[] origOrds = (BOrd[])ordArr.trim();
            PxIncludeManager.setBaseOrd(baseOrd, root);
            PxIncludeManager.subOrds(root, include.getVariables());
            include.fw(307, root, props, origOrds, file);
        }

        @Override
        public void trimAll() {
        }

        private static class NoCacheSpy
        extends Spy {
            private NoCacheSpy() {
            }

            public void write(SpyWriter out) throws Exception {
                out.w((Object)"<p>No PxInclude Caching is currently active!</p>");
            }
        }
    }

    private static final class WidgetCache
    implements PxIncludeCache {
        private static final long TRIM_AGE = 900000L;
        private final HashMap<BOrd, Item> cache = new HashMap();
        private final Queue queue = new Queue();
        private WidgetCacheThread thread;

        private WidgetCache() {
            Spy.ROOT.add("pxIncludeManager", (Spy)new WidgetCacheSpy());
            this.thread = new WidgetCacheThread();
            this.thread.start();
            if (log.isLoggable(Level.FINE)) {
                log.fine("Activated PxInclude WidgetCache");
            }
        }

        @Override
        public void load(BPxInclude include) {
            this.queue.enqueue((Object)include);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void doLoad(BPxInclude include) {
            BOrd ord = include.getOrd();
            if (ord.isNull()) {
                include.fw(307, null, null, null, null);
                return;
            }
            try {
                BWidget root;
                Item item;
                BIFile file;
                BOrd baseOrd;
                block21: {
                    baseOrd = include.getBaseOrd();
                    if (baseOrd != null) {
                        ord = BOrd.make((BOrd)baseOrd, (BOrd)ord).normalize();
                    }
                    file = null;
                    boolean skipCache = false;
                    PxDecoder decoder = null;
                    BWidget widget = null;
                    HashMap<BOrd, Item> hashMap = this.cache;
                    synchronized (hashMap) {
                        item = this.cache.get(ord);
                        if (item != null && item.lastModified != item.file.getLastModified().getMillis()) {
                            item = null;
                            if (log.isLoggable(Level.FINE)) {
                                log.fine("  updateCache");
                            }
                        }
                        if (item == null) {
                            file = (BIFile)ord.resolve().get();
                            decoder = new PxDecoder(file);
                            widget = decoder.decodeDocument();
                            if (WidgetCache.hasNonCachedTypes(widget)) {
                                if (log.isLoggable(Level.FINE)) {
                                    log.fine("  skipCache");
                                }
                                skipCache = true;
                            } else {
                                if (log.isLoggable(Level.FINE)) {
                                    log.fine("  notCached");
                                }
                                item = new Item();
                                item.key = ord;
                                item.root = widget;
                                Item.access$602(item, decoder.getPxProperties());
                                item.file = file;
                                item.lastModified = file.getLastModified().getMillis();
                                Array ordArr = new Array(BOrd.class);
                                PxIncludeManager.findOrds(item.root, (Array<BOrd>)ordArr);
                                Item.access$802(item, (BOrd[])ordArr.trim());
                                this.cache.put(ord, item);
                            }
                        } else if (log.isLoggable(Level.FINE)) {
                            log.fine("  cached");
                        }
                    }
                    if (skipCache) {
                        NoCache.loadInclude(widget, decoder, include, baseOrd, file);
                        return;
                    }
                    item.lastUsedTicks = Clock.ticks();
                    try {
                        root = (BWidget)item.root.newCopy(true);
                    }
                    catch (Throwable e) {
                        file = (BIFile)ord.resolve().get();
                        root = new PxDecoder(file).decodeDocument();
                        if (!log.isLoggable(Level.FINE)) break block21;
                        log.fine("Could not newCopy on Widget tree. Reloading from Px file");
                    }
                }
                PxIncludeManager.setBaseOrd(baseOrd, root);
                PxProperty[] props = new PxProperty[item.props.length];
                for (int i = 0; i < props.length; ++i) {
                    PxProperty p = item.props[i];
                    props[i] = new PxProperty(p.getName(), p.getTypeSpec(), p.getValue(), p.getTargets());
                }
                BOrd[] origOrds = new BOrd[item.origOrds.length];
                System.arraycopy(item.origOrds, 0, origOrds, 0, origOrds.length);
                if (file == null) {
                    file = item.file;
                }
                PxIncludeManager.subOrds(root, include.getVariables());
                include.fw(307, root, props, origOrds, file);
            }
            catch (Throwable e) {
                e.printStackTrace();
                include.fw(307, null, null, null, null);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void trim() {
            HashMap<BOrd, Item> hashMap = this.cache;
            synchronized (hashMap) {
                log.fine("trim");
                long now = Clock.ticks();
                for (Item item : this.cache.values().toArray(new Item[0])) {
                    if (now - item.lastUsedTicks <= 900000L) continue;
                    if (log.isLoggable(Level.FINE)) {
                        log.fine("  trim: " + item.key);
                    }
                    this.cache.remove(item.key);
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void trimAll() {
            log.warning("Entire cache cleared");
            HashMap<BOrd, Item> hashMap = this.cache;
            synchronized (hashMap) {
                this.cache.clear();
            }
        }

        private static boolean hasNonCachedTypes(BWidget widget) {
            BWidget root;
            if (widget == null) {
                return false;
            }
            if (nonCachedTypes.contains(widget.getType().toString())) {
                if (log.isLoggable(Level.FINE)) {
                    log.fine("  found non-cache type: " + widget.getType());
                }
                return true;
            }
            if (widget instanceof BPxInclude && (root = ((BPxInclude)widget).getRootWidget()) != null && WidgetCache.hasNonCachedTypes(root)) {
                return true;
            }
            for (BWidget child : widget.getChildWidgets()) {
                if (!WidgetCache.hasNonCachedTypes(child)) continue;
                return true;
            }
            return false;
        }

        private final class WidgetCacheSpy
        extends CacheSpy
        implements Comparator<Item> {
            WidgetCacheSpy() {
                super("PxInclude Manager", "/pxIncludeManager");
            }

            protected void clearCache() {
                PxIncludeManager.trimAll();
            }

            public void write(SpyWriter out) throws Exception {
                super.write(out);
                Object[] items = WidgetCache.this.cache.values().toArray(new Item[0]);
                SortUtil.sort((Object[])items, (Object[])items, (Comparator)this);
                out.startTable(true);
                out.trTitle((Object)("PxInclude WidgetCache [" + items.length + "]"), 2);
                out.w((Object)"<tr>").th().w((Object)"<b>PxInclude</b>").endTh().th().w((Object)"<b>Last Used</b>").endTh().w((Object)"</tr>\n");
                for (Object item : items) {
                    String lastUsed = BRelTime.toString((long)(Clock.ticks() - ((Item)item).lastUsedTicks));
                    out.tr((Object)((Item)item).key, (Object)lastUsed);
                }
                out.endTable();
            }

            @Override
            public int compare(Item a, Item b) {
                long bticks;
                long aticks = a.lastUsedTicks;
                if (aticks < (bticks = b.lastUsedTicks)) {
                    return -1;
                }
                return 1;
            }
        }

        private class WidgetCacheThread
        extends Thread {
            WidgetCacheThread() {
                super(Nre.mainThreadGroup, "Ui:PxIncludeManagerWidgetCache");
                this.setDaemon(true);
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                long lastTrim = Clock.ticks();
                while (!this.isInterrupted()) {
                    try {
                        BPxInclude include;
                        while (!this.isInterrupted() && (include = (BPxInclude)WidgetCache.this.queue.dequeue()) != null) {
                            if (log.isLoggable(Level.FINE)) {
                                log.fine("loading: " + include.getOrd());
                            }
                            WidgetCache.this.doLoad(include);
                            if (!log.isLoggable(Level.FINE)) continue;
                            log.fine("  ok");
                        }
                        if (Clock.ticks() - lastTrim > 60000L) {
                            lastTrim = Clock.ticks();
                            WidgetCache.this.trim();
                        }
                        include = WidgetCache.this.queue;
                        synchronized (include) {
                            if (WidgetCache.this.queue.isEmpty()) {
                                WidgetCache.this.queue.wait(10000L);
                            }
                        }
                    }
                    catch (Throwable e) {
                        e.printStackTrace();
                        if (!(e instanceof InterruptedException)) continue;
                        return;
                    }
                }
            }
        }

        private static final class Item {
            private BOrd key;
            private long lastUsedTicks;
            private long lastModified;
            private BWidget root;
            private PxProperty[] props;
            private BOrd[] origOrds;
            private BIFile file;

            private Item() {
            }

            static /* synthetic */ PxProperty[] access$602(Item x0, PxProperty[] x1) {
                x0.props = x1;
                return x1;
            }

            static /* synthetic */ BOrd[] access$802(Item x0, BOrd[] x1) {
                x0.origOrds = x1;
                return x1;
            }
        }
    }

    private static interface PxIncludeCache {
        public void load(BPxInclude var1);

        public void trimAll();
    }
}

