/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.nmilestone.util;

import com.tridium.nmilestone.BMilestoneCamera;
import java.io.InputStream;
import javax.baja.sys.BAbsTime;
import javax.baja.sys.BMonth;
import javax.baja.timezone.BTimeZone;
import javax.baja.xml.XElem;
import javax.baja.xml.XParser;
import javax.baja.xml.XText;
import org.owasp.encoder.Encode;

public class MilestoneReqUtil {
    public static XElem getMilestoneMethodResponseElem(InputStream in) throws Exception {
        return MilestoneReqUtil.getElem(in, "methodresponse");
    }

    public static BAbsTime getTime(XElem parentElem, String tag) throws Exception {
        String text = MilestoneReqUtil.getText(parentElem, tag);
        if (text != null && text.length() > 0) {
            int indexOfDash1 = text.indexOf(45);
            if (indexOfDash1 > 0) {
                String sYear = text.substring(0, indexOfDash1);
                int indexOfDash2 = text.indexOf(45, indexOfDash1 + 1);
                if (indexOfDash2 > 0) {
                    String sMonth = text.substring(indexOfDash1 + 1, indexOfDash2);
                    int indexOfSpace = text.indexOf(32, indexOfDash2 + 1);
                    if (indexOfSpace > 0) {
                        String sDay = text.substring(indexOfDash2 + 1, indexOfSpace);
                        int indexOfColon1 = text.indexOf(58, indexOfSpace + 1);
                        if (indexOfColon1 > 0) {
                            String sHour = text.substring(indexOfSpace + 1, indexOfColon1);
                            int indexOfColon2 = text.indexOf(58, indexOfColon1 + 1);
                            if (indexOfColon2 > 0) {
                                String sMinute = text.substring(indexOfColon1 + 1, indexOfColon2);
                                String sSecond = text.substring(indexOfColon2 + 1);
                                try {
                                    int iYear = Integer.parseInt(sYear);
                                    try {
                                        int iMonth = Integer.parseInt(sMonth) - 1;
                                        try {
                                            int iDay = Integer.parseInt(sDay);
                                            try {
                                                int iHour = Integer.parseInt(sHour);
                                                try {
                                                    int iMinute = Integer.parseInt(sMinute);
                                                    try {
                                                        int iSecond = Integer.parseInt(sSecond);
                                                        return BAbsTime.make((int)iYear, (BMonth)BMonth.make((int)iMonth), (int)iDay, (int)iHour, (int)iMinute, (int)iSecond, (int)0, (BTimeZone)BTimeZone.UTC);
                                                    }
                                                    catch (NumberFormatException nfe) {
                                                        throw new NumberFormatException("Unable to convert 'second' from String to int: " + nfe.toString());
                                                    }
                                                }
                                                catch (NumberFormatException nfe) {
                                                    throw new NumberFormatException("Unable to convert 'minute' from String to int: " + nfe.toString());
                                                }
                                            }
                                            catch (NumberFormatException nfe) {
                                                throw new NumberFormatException("Unable to convert 'hour' from String to int: " + nfe.toString());
                                            }
                                        }
                                        catch (NumberFormatException nfe) {
                                            throw new NumberFormatException("Unable to convert 'day' from String to int: " + nfe.toString());
                                        }
                                    }
                                    catch (NumberFormatException nfe) {
                                        throw new NumberFormatException("Unable to convert 'month' from String to int: " + nfe.toString());
                                    }
                                }
                                catch (NumberFormatException nfe) {
                                    throw new NumberFormatException("Unable to convert 'year' from String to int: " + nfe.toString());
                                }
                            }
                            throw new Exception("Unrecognized time format. Cannot recognize 'minutes' field: " + text);
                        }
                        throw new Exception("Unrecognized time format. Cannot recognize 'hours' field: " + text);
                    }
                    throw new Exception("Unrecognized time format. Cannot recognize day: " + text);
                }
                throw new Exception("Unrecognized time format. Cannot recognize month: " + text);
            }
            throw new Exception("Unrecognized time format. Cannot recognize year: " + text);
        }
        throw new Exception("Time tag " + tag + " not found under " + parentElem.name());
    }

    public static synchronized XElem getElem(InputStream in, String rootName) throws Exception {
        XElem rootElem;
        try {
            XParser p = XParser.make((InputStream)in);
            rootElem = p.parse();
        }
        catch (Exception e) {
            throw new Exception(e);
        }
        if (rootElem == null) {
            throw new Exception("No XML in reply");
        }
        if (rootElem.name().equals(rootName)) {
            return rootElem;
        }
        throw new Exception("Unexpected XML root: " + rootElem.name() + " Expected:  " + rootName);
    }

    public static synchronized XElem getElem(InputStream in) throws Exception {
        XElem rootElem;
        try {
            XParser p = XParser.make((InputStream)in);
            rootElem = p.parse();
        }
        catch (Exception e) {
            throw new Exception(e);
        }
        if (rootElem == null) {
            throw new Exception("No XML in reply");
        }
        return rootElem;
    }

    public static synchronized XElem getElem(XElem parentElem, String elemName) throws Exception {
        XElem elem = parentElem.elem(elemName);
        if (elem == null) {
            throw new Exception("Elem '" + elemName + "' not found under '" + parentElem.name() + '\'');
        }
        return elem;
    }

    public static synchronized String getText(XElem parentElem, String tag) {
        XElem tagElem = parentElem.elem(tag);
        if (tagElem == null) {
            return "";
        }
        return MilestoneReqUtil.getText(tagElem);
    }

    public static String getText(XElem elem) {
        XText text = elem.text();
        if (text == null) {
            return "";
        }
        return text.string();
    }

    public static String getCameraConnectXml(String userName, String password, String milestoneDatabaseId, boolean alwaysStdJpeg) {
        if (!alwaysStdJpeg) {
            return "<?xml version=\"1.0\" encoding=\"UTF-8\"?>\r\n<methodcall>\r\n  <requestid>" + BMilestoneCamera.getNextVideoRequestId() + "</requestid>\r\n  <methodname>connect</methodname>\r\n  <username>" + Encode.forXmlContent((String)userName) + "</username>\r\n  <password>" + Encode.forXmlContent((String)password) + "</password>\r\n  <cameraid>" + Encode.forXmlContent((String)milestoneDatabaseId) + "</cameraid>\r\n  <alwaysstdjpeg>no</alwaysstdjpeg>\r\n</methodcall>\r\n\r\n";
        }
        return "<?xml version=\"1.0\" encoding=\"UTF-8\"?>\r\n<methodcall>\r\n  <requestid>" + BMilestoneCamera.getNextVideoRequestId() + "</requestid>\r\n  <methodname>connect</methodname>\r\n  <username>" + Encode.forXmlContent((String)userName) + "</username>\r\n  <password>" + Encode.forXmlContent((String)password) + "</password>\r\n  <cameraid>" + Encode.forXmlContent((String)milestoneDatabaseId) + "</cameraid>\r\n  <alwaysstdjpeg>yes</alwaysstdjpeg>\r\n</methodcall>\r\n\r\n";
    }
}

