/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.nmilestone.upgrade;

import com.tridium.driver.upgrade.Upgrade;
import com.tridium.nmilestone.BMilestoneCamera;
import com.tridium.nmilestone.BMilestoneCameraDeviceId;
import com.tridium.nmilestone.BMilestoneDvr;
import com.tridium.nmilestone.BMilestoneNetwork;
import com.tridium.nmilestone.util.BMilestoneImageServerUserNameAndPassword;
import com.tridium.nvideo.datatypes.BVideoCameraInfo;
import com.tridium.nvideo.upgrade.NVideoUpgrade;
import javax.baja.security.BPassword;
import javax.baja.security.BUsernameAndPassword;
import javax.baja.sys.BComplex;
import javax.baja.sys.BValue;
import javax.baja.sys.Type;

public class MilestoneUpgrade
extends Upgrade {
    public String[] upgradableClasses() {
        return new String[]{"milestone:MilestoneCamera", "milestone:MilestoneDeviceExt", "milestone:MilestoneCameraDeviceExt", "milestone:MilestoneCameraDiscoveryLeaf", "milestone:MilestoneCameraDiscoveryPreferences", "milestone:DeviceFolder", "milestone:MilestoneDvr", "milestone:MilestoneNetwork", "milestone:MilestoneVideoSourcePreferences", "milestone:MilestoneStopRecordingModeEnum", "milestone:MilestoneEventCameraExt", "milestone:MilestoneEventDiscoveryLeaf", "milestone:MilestoneEventDiscoveryList", "milestone:MilestoneEventDiscoveryPreferences", "milestone:MilestoneEventFolder", "milestone:MilestoneEventPointId", "milestone:MilestoneEventProxyExt", "milestone:MilestoneEventTypeEnum", "milestone:MilestoneCameraInfoFE", "milestone:MilestoneEventPointIdFE", "milestone:MilestoneImageServerUserNameAndPassword", "milestone:MilestoneVideoCameraInfo"};
    }

    public BValue upgrade(BValue origObj, BValue newObj) {
        Type typ = origObj.getType();
        if (!typ.getModule().getModuleName().equals("milestone")) {
            return null;
        }
        if (typ.getTypeName().equals("MilestoneNetwork")) {
            return this.upgradeNetwork((BComplex)origObj);
        }
        if (typ.getTypeName().equals("MilestoneCamera")) {
            return this.upgradeCamera((BComplex)origObj);
        }
        if (typ.getTypeName().equals("MilestoneDvr")) {
            return this.upgradeDvr((BComplex)origObj);
        }
        if (typ.getTypeName().equals("MilestoneImageServerUserNameAndPassword")) {
            return this.upgradeCred((BComplex)origObj);
        }
        return MilestoneUpgrade.getInstance((String)"nmilestone", (String)typ.getTypeName());
    }

    private BValue upgradeNetwork(BComplex origObj) {
        BMilestoneNetwork net = new BMilestoneNetwork();
        return net;
    }

    private BValue upgradeCamera(BComplex origObj) {
        BMilestoneCamera dcam = new BMilestoneCamera();
        String sv = MilestoneUpgrade.getString((BComplex)origObj, (String[])new String[]{"deviceId", "description"});
        dcam.getVideoDeviceId().setDescription(sv);
        int sid = MilestoneUpgrade.getInt((BComplex)origObj, (String[])new String[]{"deviceId", "cameraId"});
        ((BMilestoneCameraDeviceId)dcam.getVideoDeviceId()).setCameraId(sid);
        BValue v = MilestoneUpgrade.getValue((BComplex)origObj, (String[])new String[]{"pingParameters"});
        BVideoCameraInfo ci = NVideoUpgrade.upgradeCameraInfo((BComplex)((BComplex)v), null);
        dcam.setPtzSupport(ci);
        return dcam;
    }

    private BValue upgradeDvr(BComplex origObj) {
        BMilestoneDvr dvr = new BMilestoneDvr();
        String sv = MilestoneUpgrade.getString((BComplex)origObj, (String[])new String[]{"communicator", "milestoneEngineIpAddress"});
        dvr.setMilestoneEngineIpAddress(sv);
        int iisp = MilestoneUpgrade.getInt((BComplex)origObj, (String[])new String[]{"communicator", "milestoneImageServerPort"});
        dvr.setMilestoneImageServerPort(iisp);
        int icp = MilestoneUpgrade.getInt((BComplex)origObj, (String[])new String[]{"communicator", "milestoneCentralPort"});
        dvr.setMilestoneImageServerPort(icp);
        int iuep = MilestoneUpgrade.getInt((BComplex)origObj, (String[])new String[]{"communicator", "uploadEventsPort"});
        dvr.setMilestoneImageServerPort(iuep);
        String susername = MilestoneUpgrade.getString((BComplex)origObj, (String[])new String[]{"communicator", "httpCommunicator", "credentials", "username"});
        BPassword spassword = (BPassword)MilestoneUpgrade.getValue((BComplex)origObj, (String[])new String[]{"communicator", "httpCommunicator", "credentials", "password"});
        BUsernameAndPassword credentials = new BUsernameAndPassword();
        credentials.setUsername(susername);
        credentials.setPassword(spassword);
        dvr.setCredentials(credentials);
        BValue cenCred = MilestoneUpgrade.getValue((BComplex)origObj, (String[])new String[]{"communicator", "tcpCommunicator", "milestoneCentralCredentials"});
        dvr.setMilestoneCentralCredentials((BMilestoneImageServerUserNameAndPassword)this.upgrade(cenCred, null));
        return dvr;
    }

    private BValue upgradeCred(BComplex origObj) {
        BMilestoneImageServerUserNameAndPassword cred = new BMilestoneImageServerUserNameAndPassword();
        String susername = MilestoneUpgrade.getString((BComplex)origObj, (String[])new String[]{"username"});
        BPassword spassword = (BPassword)MilestoneUpgrade.getValue((BComplex)origObj, (String[])new String[]{"password"});
        cred.setUsername(susername);
        cred.setPassword(spassword);
        return cred;
    }
}

