/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.lonworks.ui.router;

import com.tridium.lonworks.BLonRouter;
import com.tridium.lonworks.datatypes.BCommissionParameter;
import com.tridium.lonworks.datatypes.BLearnParameter;
import com.tridium.lonworks.datatypes.BRouterEntry;
import com.tridium.lonworks.datatypes.BRouterEntryTable;
import com.tridium.lonworks.netmgmt.BLonCommissionRouterJob;
import com.tridium.lonworks.netmgmt.BLonNetmgmt;
import com.tridium.lonworks.netmgmt.BLonServicePinJob;
import com.tridium.lonworks.ui.BCommReplDialog;
import com.tridium.lonworks.ui.ServicePinMonitor;
import com.tridium.lonworks.ui.router.BLonRouterManager;
import java.util.ArrayList;
import javax.baja.driver.ui.device.BDeviceManager;
import javax.baja.driver.ui.device.DeviceController;
import javax.baja.job.BJob;
import javax.baja.lonworks.BLonNetwork;
import javax.baja.lonworks.datatypes.BDeviceData;
import javax.baja.lonworks.datatypes.BNeuronId;
import javax.baja.lonworks.datatypes.BSubnetNode;
import javax.baja.naming.BOrd;
import javax.baja.nre.util.Array;
import javax.baja.sys.BComponent;
import javax.baja.sys.BObject;
import javax.baja.sys.BValue;
import javax.baja.sys.Context;
import javax.baja.ui.BCheckBox;
import javax.baja.ui.BDialog;
import javax.baja.ui.BWidget;
import javax.baja.ui.CommandArtifact;
import javax.baja.ui.pane.BBorderPane;
import javax.baja.ui.pane.BEdgePane;
import javax.baja.ui.pane.BGridPane;
import javax.baja.ui.util.UiLexicon;
import javax.baja.util.Lexicon;
import javax.baja.workbench.mgr.MgrController;
import javax.baja.workbench.view.BWbComponentView;

public class RouterController
extends DeviceController {
    public final MgrController.MgrCommand lonDiscover;
    public final MgrController.MgrCommand commission;
    public final MgrController.MgrCommand replace;
    public final MgrController.MgrCommand quikLearn;
    public final MgrController.MgrCommand clearTable;
    public final TempBridge tempBridge;
    public final MgrController.MgrCommand updateRouters;
    public final UseNetAddressToggle useNetAddrToggle;
    public final UseDbAddressToggle useDbAddrToggle;

    RouterController(BLonRouterManager manager) {
        super((BDeviceManager)manager);
        this.commission = new Commission((BWidget)manager);
        this.replace = new Replace((BWidget)manager);
        this.quikLearn = new QuikLearn((BWidget)manager);
        this.useNetAddrToggle = new UseNetAddressToggle((BWidget)manager);
        this.useDbAddrToggle = new UseDbAddressToggle((BWidget)manager);
        this.clearTable = new ClearTable((BWidget)manager);
        this.tempBridge = new TempBridge((BWidget)manager);
        this.updateRouters = new UpdateRouters((BWidget)manager);
        this.lonDiscover = new LonDiscover((BWidget)manager);
        this.lonDiscover.setFlags(7);
        this.commission.setFlags(7);
        this.replace.setFlags(7);
        this.quikLearn.setFlags(7);
        this.useNetAddrToggle.setFlags(1);
        this.useDbAddrToggle.setFlags(1);
        this.clearTable.setFlags(16);
        this.tempBridge.setFlags(7);
        this.updateRouters.setFlags(7);
        this.setUseNetAddress(manager.isUseNetAddress());
        this.tempBridge.doSetSelected(this.netmgmt().getTempBridge());
    }

    protected MgrController.IMgrCommand[] makeCommands() {
        return new MgrController.IMgrCommand[]{this.allDescendants, this.newCommand, this.edit, this.learnMode, this.lonDiscover, this.cancel, this.add, this.match, this.quickMatch, this.quickAdd, this.commission, this.replace, this.quikLearn, this.useNetAddrToggle, this.useDbAddrToggle, this.tempBridge, this.clearTable, this.updateRouters};
    }

    public void updateCommands() {
        super.updateCommands();
        int[] s = this.getSelectedRows();
        boolean sels = s.length > 0;
        boolean disable = !this.netmgmt().getEnabled() || !this.getNetwork().getEnabled();
        boolean inFault = false;
        if (this.getTable() != null) {
            BLonRouter[] routers = this.getSelectedRouters();
            for (int i = 0; i < routers.length; ++i) {
                if (!routers[0].getStatus().isFault()) continue;
                inFault = true;
            }
        }
        this.commission.setEnabled(!disable && sels && !inFault);
        this.replace.setEnabled(!disable && sels && !inFault);
        this.quikLearn.setEnabled(!disable && !sels);
        this.lonDiscover.setEnabled(!disable);
        this.updateRouters.setEnabled(!disable);
    }

    public BWidget makeActionBar() {
        MgrController.IMgrCommand[] cmds = new MgrController.IMgrCommand[]{this.newCommand, this.edit, this.learnMode, this.lonDiscover, this.cancel, this.add, this.match};
        MgrController.IMgrCommand[] cmds2 = new MgrController.IMgrCommand[]{this.commission, this.replace, this.quikLearn, this.tempBridge, this.updateRouters};
        BEdgePane pane = new BEdgePane();
        pane.setTop(this.makeActionPane(cmds));
        pane.setCenter((BWidget)new BBorderPane(this.makeActionPane(cmds2)));
        return pane;
    }

    public MgrController.IMgrCommand[] getDropDownCommands(MgrController.IMgrCommand command) {
        if (command == this.match) {
            return new MgrController.IMgrCommand[]{this.useNetAddrToggle, this.useDbAddrToggle};
        }
        return null;
    }

    public CommandArtifact doMatch(Object discovery, BComponent database, Context cx) throws Exception {
        CommandArtifact ca = super.doMatch(discovery, database, cx);
        BRouterEntryTable entryTab = this.netmgmt().getRouterDiscoverTable();
        entryTab.removeEntry((BRouterEntry)discovery);
        ((BLonRouterManager)this.getManager()).updateDiscoveryRows(entryTab);
        return ca;
    }

    public void doAllDescendants(boolean selected) {
        if (selected) {
            ((BLonRouterManager)this.getManager()).loadDescendants();
        }
        ((BLonRouterManager)this.getManager()).getModel().getTable().reload();
    }

    public CommandArtifact doClearDiscover() {
        this.netmgmt().getRouterDiscoverTable().clearEntries();
        ((BLonRouterManager)this.getManager()).updateDiscoveryRows(this.netmgmt().getRouterDiscoverTable());
        return null;
    }

    public CommandArtifact doUpdate() {
        this.setJob(this.netmgmt().updateRouters());
        return null;
    }

    public CommandArtifact doCommission() {
        BLonNetmgmt net = this.netmgmt();
        int[] s = this.getSelectedRows();
        if (s.length == 0) {
            return null;
        }
        BLonRouter[] routers = this.getSelectedRouters();
        if (routers.length == 1) {
            BLonRouter router = routers[0];
            BDeviceData dd = router.getNearDeviceData();
            BCommReplDialog commReplPane = this.routerPopup("Commission", dd);
            int retVal = commReplPane.getResult();
            BNeuronId nId = commReplPane.getSelectedNeuronId();
            if (retVal == 1) {
                this.setJob(net.commissionRouter(new BCommissionParameter(dd.getSubnetNodeId(), nId, false)));
            } else if (retVal == BCommReplDialog.SERVICE_PIN) {
                BLonCommissionRouterJob job = (BLonCommissionRouterJob)this.setJob(net.commissionRouter(new BCommissionParameter(dd.getSubnetNodeId(), true)));
                this.getManager().attach((BWbComponentView.Attachable)new ServicePinMonitor((BWbComponentView)this.getManager(), (BLonServicePinJob)job));
            }
        } else {
            BSubnetNode[] sns = new BSubnetNode[routers.length];
            for (int i = 0; i < routers.length; ++i) {
                sns[i] = routers[i].getNearDeviceData().getSubnetNodeId();
            }
            this.setJob(net.commissionRouter(new BCommissionParameter(sns)));
        }
        return null;
    }

    public CommandArtifact doReplace() {
        BLonNetmgmt net = this.netmgmt();
        int[] s = this.getSelectedRows();
        if (s.length == 0) {
            return null;
        }
        BLonRouter[] routers = this.getSelectedRouters();
        if (routers.length == 1) {
            BLonRouter router = routers[0];
            BDeviceData dd = router.getNearDeviceData();
            BCommReplDialog commReplPane = this.routerPopup("Commission", dd);
            int retVal = commReplPane.getResult();
            BNeuronId nId = commReplPane.getSelectedNeuronId();
            if (retVal == 1) {
                this.setJob(net.replaceRouter(new BCommissionParameter(dd.getSubnetNodeId(), nId, false)));
            } else if (retVal == BCommReplDialog.SERVICE_PIN) {
                this.setJob(net.replaceRouter(new BCommissionParameter(dd.getSubnetNodeId(), true)));
            }
        } else {
            BSubnetNode[] sns = new BSubnetNode[routers.length];
            for (int i = 0; i < routers.length; ++i) {
                sns[i] = routers[i].getNearDeviceData().getSubnetNodeId();
            }
            this.setJob(net.replaceRouter(new BCommissionParameter(sns)));
        }
        return null;
    }

    public CommandArtifact doQuikLearn() {
        BLonNetmgmt net = this.netmgmt();
        BGridPane pane = new BGridPane(1);
        BCheckBox unmanaged = new BCheckBox(this.lex().getText("learnPopup.unmanaged"));
        pane.add(null, (BValue)unmanaged);
        int retVal = BDialog.open((BWidget)this.getManager(), (String)"Learn", (Object)pane, (int)3);
        if (retVal == 2) {
            return null;
        }
        BLearnParameter learnParam = new BLearnParameter();
        learnParam.setUnmanagedNetwork(unmanaged.isSelected());
        this.setJob(net.learn(learnParam));
        return null;
    }

    private void setUseNetAddress(boolean selected) {
        ((BLonRouterManager)this.getManager()).setUseNetAddress(selected);
        this.useNetAddrToggle.doSetSelected(selected);
        this.useDbAddrToggle.doSetSelected(!selected);
    }

    public void doTempBridge(boolean sel) {
        if (sel) {
            this.netmgmt().tempBridgeOn();
        } else {
            this.netmgmt().tempBridgeOff();
        }
    }

    private BLonNetmgmt netmgmt() {
        return ((BLonRouterManager)this.getManager()).getNetwork().netmgmt();
    }

    private BLonNetwork getNetwork() {
        return ((BLonRouterManager)this.getManager()).getNetwork();
    }

    private UiLexicon lex() {
        return BLonRouterManager.lexicon;
    }

    private BCommReplDialog routerPopup(String label, BDeviceData dd) {
        BNeuronId[] nids;
        BNeuronId nid = dd.getNeuronId();
        if (!nid.equals((Object)BNeuronId.DEFAULT)) {
            nids = new BNeuronId[]{nid};
        } else {
            ArrayList<BNeuronId> unnamedEntries = new ArrayList<BNeuronId>();
            BRouterEntry[] a = this.netmgmt().getRouterDiscoverTable().getRouterEntries();
            for (int i = 0; i < a.length; ++i) {
                BRouterEntry entry = a[i];
                if (entry.getDevName() != null && !entry.getDevName().equals("")) continue;
                unnamedEntries.add(entry.getNeuronId());
            }
            BNeuronId[] unnamed = new BNeuronId[unnamedEntries.size()];
            nids = unnamedEntries.toArray(unnamed);
        }
        BCommReplDialog commReplPane = new BCommReplDialog((BWidget)this.getManager(), "Commission", nids);
        commReplPane.setBoundsCenteredOnOwner();
        commReplPane.open();
        return commReplPane;
    }

    private BJob setJob(BOrd jobOrd) {
        try {
            BComponent base = (BComponent)this.getManager().getCurrentValue();
            base.getComponentSpace().sync();
            BJob job = (BJob)jobOrd.get((BObject)base);
            this.getManager().registerForComponentEvents((BComponent)job);
            ((BLonRouterManager)this.getManager()).jobBar.load(job);
            return job;
        }
        catch (Exception e) {
            System.out.println(e);
            return null;
        }
    }

    private BLonRouter[] getSelectedRouters() {
        if (this.getTable() == null) {
            return new BLonRouter[0];
        }
        BComponent[] a = this.getTable().getSelectedComponents();
        Array al = new Array(BLonRouter.class);
        for (int i = 0; i < a.length; ++i) {
            if (!a[i].getType().is(BLonRouter.TYPE)) continue;
            al.add((Object)((BLonRouter)a[i]));
        }
        return (BLonRouter[])al.trim();
    }

    class TempBridge
    extends MgrController.MgrToggleCommand {
        TempBridge(BWidget owner) {
            super(owner, (Lexicon)RouterController.this.lex(), "commands.tempBridge");
        }

        public void setSelected(boolean sel) {
            RouterController.this.doTempBridge(sel);
        }

        private void doSetSelected(boolean sel) {
            super.setSelected(sel);
        }
    }

    class UseDbAddressToggle
    extends MgrController.MgrToggleCommand {
        UseDbAddressToggle(BWidget owner) {
            super(owner, (Lexicon)RouterController.this.lex(), "commands.useDbAddress");
        }

        public void setSelected(boolean sel) {
            RouterController.this.setUseNetAddress(!sel);
        }

        private void doSetSelected(boolean sel) {
            super.setSelected(sel);
        }
    }

    class UseNetAddressToggle
    extends MgrController.MgrToggleCommand {
        UseNetAddressToggle(BWidget owner) {
            super(owner, (Lexicon)RouterController.this.lex(), "commands.useNetAddress");
        }

        public void setSelected(boolean sel) {
            RouterController.this.setUseNetAddress(sel);
        }

        private void doSetSelected(boolean sel) {
            super.setSelected(sel);
        }
    }

    class QuikLearn
    extends MgrController.MgrCommand {
        QuikLearn(BWidget owner) {
            super(owner, (Lexicon)RouterController.this.lex(), "commands.quikLearn");
        }

        public CommandArtifact doInvoke() throws Exception {
            return RouterController.this.doQuikLearn();
        }
    }

    class Replace
    extends MgrController.MgrCommand {
        Replace(BWidget owner) {
            super(owner, (Lexicon)RouterController.this.lex(), "commands.replace");
        }

        public CommandArtifact doInvoke() throws Exception {
            return RouterController.this.doReplace();
        }
    }

    class Commission
    extends MgrController.MgrCommand {
        Commission(BWidget owner) {
            super(owner, (Lexicon)RouterController.this.lex(), "commands.commission");
        }

        public CommandArtifact doInvoke() throws Exception {
            return RouterController.this.doCommission();
        }
    }

    class UpdateRouters
    extends MgrController.MgrCommand {
        UpdateRouters(BWidget owner) {
            super(owner, (Lexicon)RouterController.this.lex(), "commands.updateRouters");
        }

        public CommandArtifact doInvoke() throws Exception {
            return RouterController.this.doUpdate();
        }
    }

    class ClearTable
    extends MgrController.MgrCommand {
        ClearTable(BWidget owner) {
            super(owner, (Lexicon)RouterController.this.lex(), "commands.clearDiscoverTable");
        }

        public CommandArtifact doInvoke() throws Exception {
            return RouterController.this.doClearDiscover();
        }
    }

    class LonDiscover
    extends MgrController.MgrCommand {
        LonDiscover(BWidget owner) {
            super(owner, (Lexicon)RouterController.this.lex(), "commands.discover");
        }

        public CommandArtifact doInvoke() throws Exception {
            RouterController.this.learnMode.setSelected(true);
            RouterController.this.setJob(RouterController.this.netmgmt().discover());
            return null;
        }
    }
}

