/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.aapup.job;

import com.tridium.aapup.AaPupConst;
import com.tridium.aapup.BPupDevice;
import com.tridium.aapup.PupException;
import com.tridium.aapup.datatypes.BPupPointDiscoveryConfig;
import com.tridium.aapup.job.BPupDiscoveryPoint;
import com.tridium.aapup.messages.PupErrorResponse;
import com.tridium.aapup.messages.PupNumericDataResponse;
import com.tridium.aapup.messages.PupReadAttributeMessage;
import com.tridium.aapup.messages.PupReadChannelsMessage;
import com.tridium.aapup.messages.PupReadChannelsResponse;
import com.tridium.aapup.messages.PupResponse;
import com.tridium.aapup.messages.PupTextDataResponse;
import java.io.InputStream;
import java.util.StringTokenizer;
import java.util.Vector;
import javax.baja.file.BIFile;
import javax.baja.job.BSimpleJob;
import javax.baja.naming.BOrd;
import javax.baja.nre.annotations.Generated;
import javax.baja.nre.annotations.NiagaraProperty;
import javax.baja.nre.annotations.NiagaraTopic;
import javax.baja.nre.annotations.NiagaraType;
import javax.baja.nre.util.TextUtil;
import javax.baja.sys.BComponent;
import javax.baja.sys.BString;
import javax.baja.sys.BValue;
import javax.baja.sys.Context;
import javax.baja.sys.Property;
import javax.baja.sys.Sys;
import javax.baja.sys.Topic;
import javax.baja.sys.Type;
import javax.baja.util.BFolder;
import javax.baja.xml.XElem;
import javax.baja.xml.XParser;

@NiagaraType
@NiagaraProperty(name="learnedPoints", type="BFolder", defaultValue="new BFolder()")
@NiagaraTopic(name="channelLearned")
public class BPupDiscoverPointsJob
extends BSimpleJob
implements AaPupConst {
    @Generated
    public static final Property learnedPoints = BPupDiscoverPointsJob.newProperty((int)0, (BValue)new BFolder(), null);
    @Generated
    public static final Topic channelLearned = BPupDiscoverPointsJob.newTopic((int)0, null);
    @Generated
    public static final Type TYPE = Sys.loadType(BPupDiscoverPointsJob.class);
    private BPupDevice device;
    private BPupPointDiscoveryConfig config;
    private Vector<Channel> channelMap;

    @Generated
    public BFolder getLearnedPoints() {
        return (BFolder)this.get(learnedPoints);
    }

    @Generated
    public void setLearnedPoints(BFolder v) {
        this.set(learnedPoints, (BValue)v, null);
    }

    @Generated
    public void fireChannelLearned(BValue event) {
        this.fire(channelLearned, event, null);
    }

    @Generated
    public Type getType() {
        return TYPE;
    }

    public BPupDiscoverPointsJob() {
    }

    public BPupDiscoverPointsJob(BPupDevice device, BPupPointDiscoveryConfig config) {
        this.device = device;
        this.config = config;
    }

    public void run(Context cx) throws Exception {
        try {
            if (this.device == null) {
                throw new IllegalStateException("Must submit through PupDevice.submitPointDiscoveryJob()");
            }
            this.channelMap = new Vector();
            int cm = this.config.getCm();
            int ct = this.config.getCt();
            if (ct == -1 || cm == -1) {
                ct = this.learnCt();
                cm = this.learnCm();
                if (ct == -1 || cm == -1) {
                    this.logMessage("Error, controller type not determined");
                    this.progress(100);
                    this.failed(new Throwable("controller type not determined"));
                    return;
                }
                this.device.setControllerDescription(this.device.pupNetwork().getControllerDescription(cm, ct));
            }
            if (this.supportsReadChannelsCommand(cm, ct)) {
                this.getChannelMapByLearning();
            } else {
                this.getChannelMapFromXml(cm, ct);
            }
            this.learnChannels();
        }
        catch (Throwable e) {
            this.failed(e);
        }
    }

    private int learnCm() {
        int manufacturer = -1;
        PupResponse rsp = (PupResponse)this.device.pupNetwork().sendSync(new PupReadAttributeMessage(this.device.getUnitNumber(), 65280, "CM"));
        if (rsp != null && rsp.getIn().verifyChecksum()) {
            if (rsp.getIn().getUnitNumber() != this.device.getUnitNumber()) {
                this.logMessage("DiscoverPointsJob Error: Request to unit " + this.device.getUnitNumber() + " but received from " + rsp.getIn().getUnitNumber());
                return manufacturer;
            }
            if (rsp instanceof PupNumericDataResponse) {
                PupNumericDataResponse dataRsp = (PupNumericDataResponse)rsp;
                manufacturer = dataRsp.getDouble().getInt();
                this.device.setManufacturer(manufacturer);
                this.config.setCm(manufacturer);
            }
        }
        return manufacturer;
    }

    private int learnCt() {
        int controllerType = -1;
        PupResponse rsp = (PupResponse)this.device.pupNetwork().sendSync(new PupReadAttributeMessage(this.device.getUnitNumber(), 65280, "CT"));
        if (rsp != null && rsp.getIn().verifyChecksum()) {
            if (rsp.getIn().getUnitNumber() != this.device.getUnitNumber()) {
                this.logMessage("DiscoverPointsJob Error: Request to unit " + this.device.getUnitNumber() + " but received from " + rsp.getIn().getUnitNumber());
                return controllerType;
            }
            if (rsp instanceof PupNumericDataResponse) {
                PupNumericDataResponse dataRsp = (PupNumericDataResponse)rsp;
                controllerType = dataRsp.getDouble().getInt();
                this.device.setControllerType(controllerType);
                this.config.setCt(controllerType);
            }
        }
        return controllerType;
    }

    private void getChannelMapByLearning() throws Exception {
        int numChannels = this.readChannel(0);
        this.logMessage("device " + this.device.getUnitNumber() + " has " + numChannels + " channels");
        for (int i = 1; i != numChannels; ++i) {
            String description;
            int channel;
            try {
                channel = this.readChannel(i);
            }
            catch (PupException e) {
                this.logMessage("error discovering the channel number for channel index " + i + "," + e.toString());
                continue;
            }
            try {
                description = this.readChannelDescription(channel);
            }
            catch (PupException e) {
                description = Integer.toHexString(channel).toUpperCase();
            }
            this.logMessage(" -- index " + i + " is channel " + Integer.toHexString(channel) + " desc:" + description);
            if (description.trim().length() < 2) {
                description = Integer.toHexString(channel).toUpperCase();
            }
            String prefix = this.createPointNamePrefix(description);
            this.logMessage("   -- prefix:" + prefix);
            this.channelMap.add(new Channel(channel, description, prefix));
            if (this.isAlive()) continue;
            return;
        }
    }

    private void learnChannels() {
        block9: {
            try {
                int size = this.channelMap.size();
                if (size <= 0) break block9;
                for (int progress = 0; progress < size; ++progress) {
                    Channel channelPair = this.channelMap.elementAt(progress);
                    if (channelPair.getChannel() > this.config.getMaxChannel() || channelPair.getChannel() < this.config.getMinChannel()) continue;
                    this.logMessage("Learning " + this.device.getUnitNumber() + "[" + channelPair.toString() + "]");
                    try {
                        this.learnChannel(channelPair, "  ", false, (BComponent)this.getLearnedPoints());
                    }
                    catch (InterruptedException ie) {
                        this.logMessage("canceled by user before job completion");
                        return;
                    }
                    catch (Exception e) {
                        if (channelPair.getChannel() > 61952 && channelPair.getChannel() < 62208) {
                            try {
                                this.learnChannel(channelPair, "$$", false, (BComponent)this.getLearnedPoints());
                            }
                            catch (Exception e1) {
                                this.logMessage("error while learning attributes in channel " + Integer.toHexString(channelPair.getChannel()) + ", learn may be incomplete..., " + e1.toString());
                            }
                        }
                        this.logMessage("error while learning attributes in channel " + Integer.toHexString(channelPair.getChannel()) + ", learn may be incomplete..., " + e.toString());
                    }
                    this.progress((progress + 1) * 100 / size);
                    if (this.isAlive()) continue;
                    return;
                }
            }
            catch (Throwable e) {
                this.failed(e);
            }
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void learnChannel(Channel channelPair, String attribute, boolean next, BComponent parent) throws Exception {
        int channel = channelPair.getChannel();
        String desc = channelPair.getDesc();
        String prefix = channelPair.getPrefix();
        PupReadAttributeMessage msg = new PupReadAttributeMessage(this.device.getUnitNumber(), channel, attribute);
        msg.setFetchNextFlag(next);
        PupResponse rsp = (PupResponse)this.device.pupNetwork().sendSync(msg);
        if (rsp == null) throw new PupException("no response " + channelPair);
        if (!rsp.getIn().verifyChecksum()) throw new PupException("bad checksum " + channelPair);
        if (rsp.getIn().getUnitNumber() != this.device.getUnitNumber()) {
            throw new PupException("DiscoverPointsJob Error: Request to unit " + this.device.getUnitNumber() + " but received from " + rsp.getIn().getUnitNumber());
        }
        if (rsp instanceof PupNumericDataResponse) {
            PupNumericDataResponse dataRsp = (PupNumericDataResponse)rsp;
            String attr = dataRsp.getAttributeName();
            int dataType = dataRsp.getDataType();
            BString dataValue = dataRsp.getString();
            BPupDiscoveryPoint newPoint = new BPupDiscoveryPoint(channel, desc, attr, dataType, dataValue.toString(null), prefix);
            parent.add(null, (BValue)newPoint);
            if (!dataRsp.isLast()) {
                if (parent instanceof BPupDiscoveryPoint) {
                    try {
                        this.learnChannel(channelPair, attr, true, parent);
                        return;
                    }
                    catch (InterruptedException ie) {
                        throw ie;
                    }
                    catch (Exception e) {
                        this.logMessage("error:" + e.toString());
                        return;
                    }
                } else {
                    try {
                        this.learnChannel(channelPair, attr, true, newPoint);
                        return;
                    }
                    catch (InterruptedException ie) {
                        throw ie;
                    }
                    catch (Exception e) {
                        this.logMessage("error:" + e.toString());
                        return;
                    }
                }
            } else {
                this.fireChannelLearned((BValue)parent);
            }
            return;
        } else if (rsp instanceof PupTextDataResponse) {
            PupTextDataResponse textRsp = (PupTextDataResponse)rsp;
            String attr = textRsp.getAttributeName();
            int dataType = 256;
            BPupDiscoveryPoint newPoint = new BPupDiscoveryPoint(channel, desc, attr, dataType, textRsp.getText(), prefix);
            parent.add(null, (BValue)newPoint);
            if (textRsp.isLast()) return;
            if (parent instanceof BPupDiscoveryPoint) {
                this.learnChannel(channelPair, attr, true, parent);
                return;
            } else {
                this.learnChannel(channelPair, attr, true, newPoint);
            }
            return;
        } else {
            if (!(rsp instanceof PupErrorResponse)) throw new PupException("invalid response type " + channelPair + " " + rsp.toDebugString());
            PupErrorResponse errRsp = (PupErrorResponse)rsp;
            throw new PupException("error response " + channelPair + errRsp.toString());
        }
    }

    private boolean supportsReadChannelsCommand(int manufacturer, int type) {
        try {
            BOrd fileOrd = this.device.pupNetwork().getDeviceTypesFile();
            BIFile file = (BIFile)fileOrd.resolve().get();
            XElem root = XParser.make((InputStream)file.getInputStream()).parse();
            XElem[] deviceTypes = root.elems("device");
            for (int i = 0; i < deviceTypes.length; ++i) {
                int cm = deviceTypes[i].geti("cm", 0);
                int ct = deviceTypes[i].geti("ct", 0);
                if (cm != manufacturer || ct != type) continue;
                return deviceTypes[i].getb("rdChCmd", false);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return true;
    }

    private void getChannelMapFromXml(int manufacturer, int type) {
        try {
            BOrd fileOrd = this.device.pupNetwork().getDeviceTypesFile();
            BIFile file = (BIFile)fileOrd.resolve().get();
            XElem root = XParser.make((InputStream)file.getInputStream()).parse();
            XElem[] deviceTypes = root.elems("device");
            for (int i = 0; i < deviceTypes.length; ++i) {
                int cm = deviceTypes[i].geti("cm", 0);
                int ct = deviceTypes[i].geti("ct", 0);
                if (cm != manufacturer || ct != type) continue;
                XElem[] channels = deviceTypes[i].elems("channel");
                for (int j = 0; j < channels.length; ++j) {
                    try {
                        String addressStr = channels[j].get("address", "0x00");
                        int address = Integer.parseInt(addressStr, 16);
                        String description = channels[j].get("desc", "generic channel");
                        String prefix = channels[j].get("prefix", "");
                        this.channelMap.add(new Channel(address, description, prefix));
                        continue;
                    }
                    catch (NumberFormatException e) {
                        continue;
                    }
                    catch (NullPointerException e) {
                        // empty catch block
                    }
                }
                return;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private int readChannel(int index) throws Exception {
        PupReadChannelsMessage msg = new PupReadChannelsMessage(this.device.getUnitNumber(), index);
        PupResponse rsp = (PupResponse)this.device.pupNetwork().sendSync(msg);
        if (rsp != null) {
            if (rsp.getIn().verifyChecksum()) {
                if (rsp.getIn().getUnitNumber() != this.device.getUnitNumber()) {
                    throw new PupException("DiscoverPointsJob: Request to unit " + this.device.getUnitNumber() + " but received from " + rsp.getIn().getUnitNumber());
                }
                if (rsp instanceof PupReadChannelsResponse) {
                    PupReadChannelsResponse chRsp = (PupReadChannelsResponse)rsp;
                    int rspIndex = chRsp.getIndex();
                    int data = chRsp.getData();
                    if (rspIndex != index) {
                        throw new PupException("cannot learn channel " + index + ": returned index not equal to requested index");
                    }
                    return data;
                }
                if (rsp instanceof PupErrorResponse) {
                    PupErrorResponse errRsp = (PupErrorResponse)rsp;
                    throw new PupException("cannot learn channel " + index + ":" + errRsp.toString());
                }
                throw new PupException("cannot learn channel " + index + ": invalid response message type");
            }
            throw new PupException("cannot learn channel " + index + ": checksum error");
        }
        throw new PupException("cannot learn channel " + index + ": no response");
    }

    private String readChannelDescription(int channel) throws Exception {
        PupReadAttributeMessage msg = new PupReadAttributeMessage(this.device.getUnitNumber(), channel, "ON");
        PupResponse rsp = (PupResponse)this.device.pupNetwork().sendSync(msg);
        if (rsp != null) {
            if (rsp.getIn().verifyChecksum()) {
                if (rsp.getIn().getUnitNumber() != this.device.getUnitNumber()) {
                    throw new PupException("DiscoverPointsJob Error: Request to unit " + this.device.getUnitNumber() + " but received from " + rsp.getIn().getUnitNumber());
                }
                if (rsp instanceof PupTextDataResponse) {
                    PupTextDataResponse attRsp = (PupTextDataResponse)rsp;
                    return attRsp.getText();
                }
                if (rsp instanceof PupErrorResponse) {
                    PupErrorResponse errRsp = (PupErrorResponse)rsp;
                    throw new PupException("device:" + this.device.getUnitNumber() + ", cannot learn description of channel " + Integer.toHexString(channel) + ":" + errRsp.toString());
                }
                throw new PupException("device:" + this.device.getUnitNumber() + ",cannot learn description of channel " + Integer.toHexString(channel) + ": invalid response message type");
            }
            throw new PupException("device:" + this.device.getUnitNumber() + ",cannot learn description of channel " + Integer.toHexString(channel) + ": checksum error");
        }
        throw new PupException("device:" + this.device.getUnitNumber() + ",cannot learn description of channel " + Integer.toHexString(channel) + ": no response");
    }

    private String createPointNamePrefix(String desc) {
        if (desc.length() == 4) {
            try {
                Integer.parseInt(desc, 16);
                return "Chan" + desc.toUpperCase();
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        desc = TextUtil.toFriendly((String)desc);
        StringBuilder sb = new StringBuilder();
        StringTokenizer st = new StringTokenizer(desc);
        while (st.hasMoreTokens()) {
            String token = st.nextToken();
            try {
                Integer.parseInt(desc, 10);
                Integer.parseInt(desc, 16);
                sb.append(token.toUpperCase());
            }
            catch (Exception exception) {
                if (token.length() > 3) {
                    sb.append(TextUtil.capitalize((String)token.substring(0, 3)));
                    for (int i = 3; i < token.length(); ++i) {
                        if (!Character.isDigit(token.charAt(i))) continue;
                        sb.append(token.charAt(i));
                    }
                    continue;
                }
                sb.append(TextUtil.capitalize((String)token));
            }
        }
        return sb.toString();
    }

    private void logMessage(String message) {
        this.log().message(message);
        if (this.device.pupNetwork() != null) {
            int severity = this.device.pupNetwork().getLog().getSeverity();
            this.device.pupNetwork().getLog().setSeverity(1);
            this.device.pupNetwork().getLog().message("Discover Points Job:" + message);
            this.device.pupNetwork().getLog().setSeverity(severity);
        }
    }

    private class Channel {
        int channel;
        String desc;
        String prefix;

        Channel(int channel, String desc, String prefix) {
            this.channel = channel;
            this.desc = desc;
            this.prefix = prefix;
        }

        int getChannel() {
            return this.channel;
        }

        String getDesc() {
            return this.desc;
        }

        String getPrefix() {
            return this.prefix;
        }

        public String toString() {
            return "channel:" + Integer.toHexString(this.channel) + ":" + this.desc + ":" + this.prefix;
        }
    }
}

