/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.seriestransform.source.ui;

import com.tridium.bql.util.BDynamicTimeRange;
import com.tridium.bql.util.BDynamicTimeRangeType;
import com.tridium.workbench.fieldeditors.BDynamicTimeRangeFE;
import com.tridium.workbench.fieldeditors.BTimeEditors;
import javax.baja.gx.BImage;
import javax.baja.nre.annotations.Generated;
import javax.baja.nre.annotations.NiagaraAction;
import javax.baja.nre.annotations.NiagaraActions;
import javax.baja.nre.annotations.NiagaraType;
import javax.baja.sys.Action;
import javax.baja.sys.BAbsTime;
import javax.baja.sys.BComponent;
import javax.baja.sys.BEnumRange;
import javax.baja.sys.BIcon;
import javax.baja.sys.BObject;
import javax.baja.sys.BValue;
import javax.baja.sys.Context;
import javax.baja.sys.Slot;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.ui.BAbstractButton;
import javax.baja.ui.BButton;
import javax.baja.ui.BDialog;
import javax.baja.ui.BFrame;
import javax.baja.ui.BLabel;
import javax.baja.ui.BListDropDown;
import javax.baja.ui.BWidget;
import javax.baja.ui.enums.BButtonStyle;
import javax.baja.ui.list.BList;
import javax.baja.ui.pane.BEdgePane;
import javax.baja.ui.pane.BGridPane;
import javax.baja.util.Lexicon;
import javax.baja.workbench.fieldeditor.BWbFieldEditor;

@NiagaraType
@NiagaraActions(value={@NiagaraAction(name="editTimeRange"), @NiagaraAction(name="updateLayout")})
public class BHistoryDateRangeFE
extends BWbFieldEditor {
    @Generated
    public static final Action editTimeRange = BHistoryDateRangeFE.newAction((int)0, null);
    @Generated
    public static final Action updateLayout = BHistoryDateRangeFE.newAction((int)0, null);
    @Generated
    public static final Type TYPE = Sys.loadType(BHistoryDateRangeFE.class);
    private static final String prefTemplate = "WW-WWW-WWWW WW:WWWW to WW-WWW-WWWW WW:WWWW WWWWWWWWWWW";
    private static final Lexicon lex = Lexicon.make((String)"bql");
    private final BGridPane pane;
    private final BListDropDown typeChoice = BHistoryDateRangeFE.makeTypeChoice();
    private final BLabel timeRangeLabel = new BLabel();
    private final BButton editButton = new BButton(BImage.make((BIcon)BIcon.std((String)"clock.png")));
    private BAbsTime startTime;
    private BAbsTime endTime;

    @Generated
    public void editTimeRange() {
        this.invoke(editTimeRange, null, null);
    }

    @Generated
    public void updateLayout() {
        this.invoke(updateLayout, null, null);
    }

    @Generated
    public Type getType() {
        return TYPE;
    }

    public BHistoryDateRangeFE() {
        this.editButton.setButtonStyle(BButtonStyle.toolBar);
        this.editButton.setEnabled(false);
        this.pane = new BGridPane(1);
        BGridPane subPane = new BGridPane(2);
        subPane.add("typeChoice", (BValue)this.typeChoice);
        subPane.add("editButton", (BValue)this.editButton);
        this.pane.add(null, (BValue)subPane);
        this.pane.add("rangeLabel", (BValue)this.timeRangeLabel);
        this.linkTo((BComponent)this.typeChoice, (Slot)BListDropDown.listActionPerformed, (Slot)updateLayout);
        this.linkTo((BComponent)this.typeChoice, (Slot)BListDropDown.listActionPerformed, (Slot)setModified);
        this.linkTo((BComponent)this.typeChoice.getList(), (Slot)BList.selectionModified, (Slot)setModified);
        this.linkTo((BComponent)this.editButton, (Slot)BAbstractButton.actionPerformed, (Slot)editTimeRange);
        this.setContent((BWidget)this.pane);
    }

    public void doLoadValue(BObject value, Context cx) {
        BDynamicTimeRange range = (BDynamicTimeRange)value;
        this.typeChoice.setSelectedItem((Object)range.getRangeType());
        if (range.getRangeType() == BDynamicTimeRangeType.timeRange) {
            this.startTime = range.getFixedStartTime();
            this.endTime = range.getFixedEndTime();
        }
        if (this.startTime == null) {
            this.startTime = BAbsTime.NULL;
        }
        if (this.endTime == null) {
            this.endTime = BAbsTime.NULL;
        }
        if (range.getRangeType() == BDynamicTimeRangeType.timeRange) {
            this.editButton.setEnabled(!this.isReadonly());
            this.timeRangeLabel.setText(this.formatTimeRange(range.getFixedStartTime(), range.getFixedEndTime()));
        }
        this.relayout();
    }

    public BObject doSaveValue(BObject value, Context cx) throws Exception {
        BDynamicTimeRangeType rangeType = (BDynamicTimeRangeType)this.typeChoice.getSelectedItem();
        if (rangeType != BDynamicTimeRangeType.timeRange) {
            return BDynamicTimeRange.make((BDynamicTimeRangeType)rangeType);
        }
        return BDynamicTimeRange.make((BAbsTime)this.startTime, (BAbsTime)this.endTime);
    }

    protected void doSetReadonly(boolean readonly) {
        this.setReadonly(readonly);
        this.typeChoice.setEnabled(!readonly);
        this.editButton.setEnabled(!readonly);
    }

    public void doUpdateLayout() {
        BDynamicTimeRangeType type = (BDynamicTimeRangeType)this.typeChoice.getSelectedItem();
        if (type == BDynamicTimeRangeType.timeRange) {
            this.editButton.setEnabled(!this.isReadonly());
            this.timeRangeLabel.setText(this.formatTimeRange(this.startTime, this.endTime));
        } else {
            this.timeRangeLabel.setText("");
            this.editButton.setEnabled(false);
        }
    }

    public void doEditTimeRange() {
        BAbsTime tempStartTime = this.startTime;
        BAbsTime tempEndTime = this.endTime;
        while (true) {
            BTimeEditors eds = new BTimeEditors(tempStartTime, tempEndTime, this.getCurrentContext());
            int rc = BDialog.open((BWidget)this, (String)lex.getText("dynamicTimeRangeFE.editTimeRange"), (Object)eds, (int)3);
            if (rc == 2) {
                return;
            }
            tempStartTime = eds.getStartTime();
            tempEndTime = eds.getEndTime();
            if (tempStartTime.equals((Object)BAbsTime.NULL) || tempEndTime.equals((Object)BAbsTime.NULL) || tempEndTime.isAfter(tempStartTime)) break;
            BDialog.error((BWidget)this, (Object)lex.getText("dynamicTimeRangeFE.timeSequenceError"));
        }
        this.startTime = tempStartTime;
        this.endTime = tempEndTime;
        this.timeRangeLabel.setText(this.formatTimeRange(this.startTime, this.endTime));
        this.setModified();
    }

    private String formatTimeRange(BAbsTime startTime, BAbsTime endTime) {
        StringBuilder s = new StringBuilder(prefTemplate.length());
        if (startTime == null || startTime.isNull()) {
            s.append(lex.getText("dynamicTimeRangeFE.epoch"));
        } else {
            s.append(startTime.toString(this.getCurrentContext()));
        }
        s.append("  ").append(lex.getText("dynamicTimeRangeFE.to")).append("  ");
        if (endTime == null || endTime.isNull()) {
            s.append(lex.getText("dynamicTimeRangeFE.now"));
        } else {
            s.append(endTime.toString(this.getCurrentContext()));
        }
        return s.toString();
    }

    public static BListDropDown makeTypeChoice() {
        int[] ords;
        BListDropDown typeChoice = new BListDropDown();
        BList typeList = typeChoice.getList();
        BEnumRange range = BDynamicTimeRangeType.today.getRange();
        for (int ord : ords = range.getOrdinals()) {
            typeList.addItem((Object)range.get(ord));
        }
        typeChoice.setSelectedItem((Object)BDynamicTimeRangeType.today);
        return typeChoice;
    }

    public static void main(String[] args) {
        BEdgePane main = new BEdgePane();
        BDynamicTimeRangeFE ed = new BDynamicTimeRangeFE();
        ed.loadValue((BObject)BDynamicTimeRange.make((BDynamicTimeRangeType)BDynamicTimeRangeType.today));
        main.setTop((BWidget)ed);
        BFrame f = new BFrame();
        f.setContent((BWidget)main);
        f.setScreenBounds(200.0, 10.0, 700.0, 150.0);
        f.open();
    }
}

