/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.seriestransform.px.editor.make;

import com.tridium.seriestransform.BTransformQuery;
import com.tridium.seriestransform.binding.ui.BChartDescriptor;
import com.tridium.seriestransform.binding.ui.BDescriptorsFE;
import com.tridium.seriestransform.functions.ui.BDescriptors;
import com.tridium.seriestransform.graph.BTransformGraph;
import com.tridium.seriestransform.graph.ui.BTransformQueryEditor;
import com.tridium.seriestransform.px.editor.make.BMwTransformChart;
import com.tridium.ui.theme.Theme;
import javax.baja.chart.binding.BColumnIdentifier;
import javax.baja.gx.BInsets;
import javax.baja.nre.annotations.Generated;
import javax.baja.nre.annotations.NiagaraType;
import javax.baja.seriestransform.graph.BSeriesSchema;
import javax.baja.sys.BIBoolean;
import javax.baja.sys.BIEnum;
import javax.baja.sys.BINumeric;
import javax.baja.sys.BObject;
import javax.baja.sys.BValue;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.ui.BLabel;
import javax.baja.ui.BWidget;
import javax.baja.ui.enums.BHalign;
import javax.baja.ui.enums.BValign;
import javax.baja.ui.pane.BBorderPane;
import javax.baja.ui.pane.BGridPane;
import javax.baja.ui.pane.BLabelPane;
import javax.baja.ui.pane.BScrollPane;
import javax.baja.util.BTypeSpec;
import javax.baja.util.Lexicon;
import javax.baja.workbench.CannotSaveException;

@NiagaraType
public class BChartConfigPane
extends BLabelPane {
    @Generated
    public static final Type TYPE = Sys.loadType(BChartConfigPane.class);
    private static final Lexicon lex = Lexicon.make(BMwTransformChart.class);
    private static final String LBL_Y_AXES = lex.getText("mwConfig.chart.yaxes");
    private BTransformQuery query = new BTransformQuery();
    private BTransformQueryEditor tpe;
    private final BDescriptorsFE yaxesFE = new BDescriptorsFE();
    private BDescriptors descriptors = new BDescriptors();

    @Generated
    public Type getType() {
        return TYPE;
    }

    public BChartConfigPane() {
    }

    public BChartConfigPane(BWidget owner, BTransformGraph graph) {
        BGridPane master = new BGridPane(1);
        master.setValign(BValign.top);
        master.setHalign(BHalign.left);
        master.setRowGap(15.0);
        graph.lease();
        this.query.setGraphOrd(graph.getSlotPathOrd());
        this.tpe = new BTransformQueryEditor(owner);
        this.tpe.loadValue((BObject)this.query);
        master.add(null, (BValue)this.tpe);
        this.autoPopulateDescriptors(graph);
        BGridPane yaxesPane = new BGridPane(2);
        this.yaxesFE.loadValue((BObject)this.descriptors);
        yaxesPane.add(null, (BValue)new BLabel(LBL_Y_AXES));
        yaxesPane.add(null, (BValue)this.yaxesFE);
        master.add(null, (BValue)yaxesPane);
        BBorderPane bp = new BBorderPane((BWidget)master, BInsets.make((double)5.0, (double)0.0, (double)5.0, (double)5.0));
        BScrollPane scroll = new BScrollPane((BWidget)bp);
        scroll.setViewportBackground(Theme.pane().getControlBackground());
        this.setContent((BWidget)scroll);
    }

    private void autoPopulateDescriptors(BTransformGraph graph) {
        String[] fieldNames;
        graph.lease(3);
        BSeriesSchema schema = graph.getSchema();
        for (String name : fieldNames = schema.getFieldNames()) {
            BTypeSpec fieldType = schema.getFieldType(name);
            if (!fieldType.getTypeInfo().is(BINumeric.TYPE) && !fieldType.getTypeInfo().is(BIBoolean.TYPE) && !fieldType.getTypeInfo().is(BIEnum.TYPE)) continue;
            BChartDescriptor cd = new BChartDescriptor();
            cd.setSeriesName(name);
            cd.setYColumn(BColumnIdentifier.makeTableColumn((String)name));
            this.descriptors.add(null, (BValue)cd);
        }
    }

    public String getParameters() {
        try {
            this.query = (BTransformQuery)this.tpe.saveValue();
            return this.query.getQueryParams();
        }
        catch (CannotSaveException e) {
            e.printStackTrace();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return null;
    }

    public BDescriptors getYAxesDescriptors() {
        try {
            this.descriptors = (BDescriptors)this.yaxesFE.saveValue();
            return this.descriptors;
        }
        catch (CannotSaveException e) {
            e.printStackTrace();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return null;
    }

    public BTransformQuery getQuery() {
        return this.query;
    }
}

