/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.seriestransform.graph.ui;

import com.tridium.seriestransform.BTransformQuery;
import com.tridium.seriestransform.graph.BTransformGraph;
import com.tridium.seriestransform.graph.ui.BTransformQueryEditor;
import com.tridium.workbench.nav.BComponentMenuAgent;
import javax.baja.naming.BISession;
import javax.baja.naming.BOrd;
import javax.baja.nav.BINavNode;
import javax.baja.nre.annotations.AgentOn;
import javax.baja.nre.annotations.Generated;
import javax.baja.nre.annotations.NiagaraSingleton;
import javax.baja.nre.annotations.NiagaraType;
import javax.baja.security.BPermissions;
import javax.baja.space.BComponentSpace;
import javax.baja.sys.BComponent;
import javax.baja.sys.BObject;
import javax.baja.sys.Context;
import javax.baja.sys.Property;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.ui.BActionMenuItem;
import javax.baja.ui.BMenu;
import javax.baja.ui.BSubMenuItem;
import javax.baja.ui.BWidget;
import javax.baja.ui.Command;
import javax.baja.ui.CommandArtifact;
import javax.baja.ui.menu.BIMenu;
import javax.baja.ui.menu.BIMenuItem;
import javax.baja.util.Lexicon;
import javax.baja.workbench.BWbShell;

@NiagaraType(agent={@AgentOn(types={"seriesTransform:GraphNode"})})
@NiagaraSingleton
public class BTransformGraphMenuAgent
extends BComponentMenuAgent {
    @Generated
    public static final BTransformGraphMenuAgent INSTANCE = new BTransformGraphMenuAgent();
    @Generated
    public static final Type TYPE = Sys.loadType(BTransformGraphMenuAgent.class);
    private static final Lexicon lex = Lexicon.make(BTransformGraphMenuAgent.class);
    private static final String RESOLVE_GRAPH_CMD = lex.getText("graphMenu.resolve");

    @Generated
    public Type getType() {
        return TYPE;
    }

    protected BMenu doMakeMenu(BWidget owner, BObject target, Context cx) {
        BMenu menu = super.doMakeMenu(owner, target, cx);
        BComponent comp = (BComponent)target;
        BComponentSpace space = comp.getComponentSpace();
        boolean readonly = false;
        if (!comp.getPermissions(cx).has(BPermissions.adminWrite)) {
            readonly = true;
        } else if (space != null && space.isSpaceReadonly()) {
            readonly = true;
        }
        if (!readonly && target instanceof BTransformGraph) {
            BTransformGraph graph = (BTransformGraph)target;
            Property newMenuItem = menu.getProperty("new");
            if (newMenuItem != null) {
                menu.remove(newMenuItem);
            }
            menu.removeSubMenu("actions");
            if (graph.getPermissions(cx).has(4)) {
                BMenu viewsMenu = menu.removeSubMenu("views");
                menu.addSeparatorToFront();
                menu.addItemToFront("resolveGraph", (BIMenuItem)new BActionMenuItem((Command)new ResolveGraph(owner, target, graph)));
                menu.addSeparatorToFront();
                menu.addItemToFront("views", (BIMenuItem)new BSubMenuItem((BIMenu)viewsMenu));
            }
        }
        return menu;
    }

    public static class ResolveGraph
    extends Command {
        private final BTransformGraph graph;
        private final BOrd baseOrd;

        public ResolveGraph(BWidget owner, BObject target, BTransformGraph graph) {
            super(owner, RESOLVE_GRAPH_CMD);
            BINavNode navNode = (BINavNode)target;
            this.baseOrd = navNode.getNavOrd();
            this.graph = graph;
        }

        public CommandArtifact doInvoke() throws Exception {
            this.graph.lease(1);
            BTransformQuery transformQuery = new BTransformQuery();
            BOrd graphOrd = this.graph.getSlotPathOrd();
            transformQuery.setGraphOrd(graphOrd);
            BISession session = this.graph.getSession();
            Context cx = session.getSessionContext();
            transformQuery = BTransformQueryEditor.open(this.getOwner(), this.baseOrd, transformQuery, cx);
            if (null == transformQuery) {
                return null;
            }
            BOrd ord = BOrd.make((BOrd)this.graph.getAbsoluteOrd(), (String)transformQuery.toString());
            BWbShell wbShell = BWbShell.getWbShell((BWidget)this.getOwner());
            wbShell.hyperlink(ord);
            return null;
        }
    }
}

