/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.seriestransform.functions.ui;

import com.tridium.seriestransform.functions.BFunctionMapping;
import com.tridium.seriestransform.functions.ui.BFunctionList;
import com.tridium.seriestransform.functions.ui.BFunctionMappingConf;
import com.tridium.seriestransform.graph.ui.BConfigEditor;
import com.tridium.seriestransform.rollup.BRollupNode;
import com.tridium.seriestransform.schema.ui.BSchemaFacetsFE;
import com.tridium.ui.theme.Theme;
import java.util.HashMap;
import java.util.HashSet;
import javax.baja.gx.BBrush;
import javax.baja.gx.BColor;
import javax.baja.gx.BImage;
import javax.baja.gx.BInsets;
import javax.baja.gx.Graphics;
import javax.baja.nre.annotations.Generated;
import javax.baja.nre.annotations.NiagaraAction;
import javax.baja.nre.annotations.NiagaraActions;
import javax.baja.nre.annotations.NiagaraType;
import javax.baja.nre.util.TextUtil;
import javax.baja.seriestransform.graph.BGraphNode;
import javax.baja.seriestransform.graph.BSeriesSchema;
import javax.baja.seriestransform.graph.BTransformFunction;
import javax.baja.sys.Action;
import javax.baja.sys.BComponent;
import javax.baja.sys.BFacets;
import javax.baja.sys.BIcon;
import javax.baja.sys.BObject;
import javax.baja.sys.BString;
import javax.baja.sys.BValue;
import javax.baja.sys.BVector;
import javax.baja.sys.Property;
import javax.baja.sys.Slot;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.ui.BBorder;
import javax.baja.ui.BDropDown;
import javax.baja.ui.BLabel;
import javax.baja.ui.BNullWidget;
import javax.baja.ui.BRoundedDialog;
import javax.baja.ui.BTextField;
import javax.baja.ui.BWidget;
import javax.baja.ui.enums.BHalign;
import javax.baja.ui.event.BMouseEvent;
import javax.baja.ui.pane.BBorderPane;
import javax.baja.ui.pane.BEdgePane;
import javax.baja.ui.pane.BGridPane;
import javax.baja.ui.pane.BPane;
import javax.baja.ui.pane.BScrollPane;
import javax.baja.ui.pane.BTextEditorPane;
import javax.baja.ui.table.BTable;
import javax.baja.ui.table.TableCellRenderer;
import javax.baja.ui.table.TableController;
import javax.baja.ui.table.TableModel;
import javax.baja.units.BUnit;
import javax.baja.util.BTypeSpec;
import javax.baja.util.Lexicon;
import javax.baja.workbench.BWbPlugin;

@NiagaraType
@NiagaraActions(value={@NiagaraAction(name="checkSelectedParams"), @NiagaraAction(name="checkFacets"), @NiagaraAction(name="functionChanged")})
public class BFunctionMappingConfEditor
extends BEdgePane {
    @Generated
    public static final Action checkSelectedParams = BFunctionMappingConfEditor.newAction((int)0, null);
    @Generated
    public static final Action checkFacets = BFunctionMappingConfEditor.newAction((int)0, null);
    @Generated
    public static final Action functionChanged = BFunctionMappingConfEditor.newAction((int)0, null);
    @Generated
    public static final Type TYPE = Sys.loadType(BFunctionMappingConfEditor.class);
    private static final Lexicon lex = Lexicon.make(BFunctionMappingConfEditor.class);
    private static final String OUTPUT_LBL = lex.getText("functionEditor.outputField");
    private static final String FUNCTIONS_LBL = lex.getText("functionEditor.functionList");
    private static final String TITLE = lex.getText("functionEditor.title");
    private static final String INPUT_LBL = lex.getText("functionEditor.inputFieldNames");
    private static final String TYPE_LBL = lex.getText("functionEditor.inputFieldTypes");
    private static final String ARG_LBL = lex.getText("functionEditor.arguments");
    private static final String ERR_NO_PARAMS = lex.getText("functionEditor.warning.noparams");
    private static final String ERR_PARAM_TYPES = lex.getText("functionEditor.warning.paramtypes");
    private static final String ERR_UNMATCHED_UNITS = lex.getText("functionEditor.warning.unitsNotDeclared");
    private static final double CHECKW = 20.0;
    private static final BImage warning = BImage.make((BIcon)BIcon.std((String)"warning.png"));
    private static final BImage blank = BImage.make((BIcon)BIcon.std((String)"blank.png"));
    private static final int DISPLAY_TITLE_BG_COLOR = 0x666666;
    private BGraphNode src;
    private BFunctionMapping mapping;
    private BFunctionList lstFunctions;
    private BTextField outputTxt;
    private final BSchemaFacetsFE facetsFE = new BSchemaFacetsFE();
    private BLabel facetDisplay;
    private final BLabel warningImg = new BLabel(blank);
    private final BLabel warningTxt = new BLabel();
    private final BTextEditorPane textBox = new BTextEditorPane();
    private Row[] rows;
    private Model model;
    private BTable table;

    @Generated
    public void checkSelectedParams() {
        this.invoke(checkSelectedParams, null, null);
    }

    @Generated
    public void checkFacets() {
        this.invoke(checkFacets, null, null);
    }

    @Generated
    public void functionChanged() {
        this.invoke(functionChanged, null, null);
    }

    @Generated
    public Type getType() {
        return TYPE;
    }

    public static BFunctionMapping open(BWidget owner, BFunctionMapping mapping, BGraphNode inputSrc) throws Exception {
        BFunctionMappingConfEditor fme;
        int r;
        if (null == mapping) {
            mapping = new BFunctionMapping();
        }
        if ((r = BRoundedDialog.open((BWidget)owner, (String)TITLE, (Object)((Object)(fme = new BFunctionMappingConfEditor(mapping, inputSrc))), (int)3)) != 1) {
            return null;
        }
        return fme.saveMapping();
    }

    public BFunctionMappingConfEditor() {
    }

    public BFunctionMappingConfEditor(BFunctionMapping pa, BGraphNode src) {
        this.src = src;
        this.mapping = pa;
        boolean allowNonCumulativeFuncs = !(src instanceof BRollupNode);
        this.lstFunctions = new BFunctionList(allowNonCumulativeFuncs);
        this.linkTo((BComponent)this.facetsFE, (Slot)BWbPlugin.setModified, (Slot)checkFacets);
        this.linkTo((BComponent)this.lstFunctions, (Slot)BDropDown.valueModified, (Slot)functionChanged);
        BPane functionSelector = this.makeFunctionSelector();
        BPane fieldSelectionTable = this.makeFieldSelectionTable();
        BPane resultField = this.makeFunctionResultField();
        BTypeSpec functionTypeSpec = this.mapping.getFunctionTypeSpec();
        this.lstFunctions.setSelectedIndex(functionTypeSpec);
        BLabel label = new BLabel(FUNCTIONS_LBL);
        label.setForeground(BColor.white.toBrush());
        label.setFont(Theme.widget().getBoldText());
        label.setHalign(BHalign.left);
        BGridPane listPane = new BGridPane(2);
        listPane.add(null, (BValue)label);
        listPane.add(null, (BValue)this.lstFunctions);
        listPane.setHalign(BHalign.left);
        listPane.setColumnGap(10.0);
        BBorderPane top = new BBorderPane((BWidget)listPane, BInsets.make((double)3.0, (double)6.0, (double)3.0, (double)6.0));
        top.setFill(BColor.make((int)0x666666).toBrush());
        BGridPane errorDisplay = new BGridPane(2);
        errorDisplay.add(null, (BValue)this.warningImg);
        errorDisplay.add(null, (BValue)this.warningTxt);
        BGridPane content = new BGridPane(1);
        content.add(null, (BValue)top);
        content.add(null, (BValue)functionSelector);
        content.add(null, (BValue)new BNullWidget());
        content.add(null, (BValue)BFunctionMappingConfEditor.makeSubTitle(ARG_LBL));
        content.add(null, (BValue)fieldSelectionTable);
        content.add(null, (BValue)new BNullWidget());
        content.add(null, (BValue)BFunctionMappingConfEditor.makeSubTitle(OUTPUT_LBL));
        content.add(null, (BValue)resultField);
        content.add(null, (BValue)errorDisplay);
        content.setStretchColumn(0);
        content.setColumnAlign(BHalign.fill);
        this.doCheckSelectedParams();
        this.doCheckFacets();
        this.doFunctionChanged();
        BBorderPane pane = new BBorderPane((BWidget)content, BBorder.make((String)"1px solid black"), BInsets.make((double)0.0, (double)0.0, (double)0.0, (double)0.0));
        this.setCenter((BWidget)new BBorderPane((BWidget)pane, BBorder.inset, BInsets.make((double)0.0, (double)0.0, (double)0.0, (double)0.0)));
    }

    private static BPane makeSubTitle(String title) {
        BLabel label = new BLabel(title);
        label.setForeground(BColor.white.toBrush());
        label.setFont(Theme.widget().getBoldText());
        label.setHalign(BHalign.left);
        BEdgePane edge = new BEdgePane();
        edge.setLeft((BWidget)label);
        BBorderPane top = new BBorderPane((BWidget)edge, BInsets.make((double)3.0, (double)6.0, (double)3.0, (double)6.0));
        top.setFill(BColor.make((int)0x666666).toBrush());
        return top;
    }

    private BPane makeFunctionResultField() {
        this.outputTxt = new BTextField(this.mapping.getOutputField(), 30);
        this.facetsFE.loadValue((BObject)this.mapping.getFacets());
        this.facetDisplay = BConfigEditor.makeNoteLabel(this.facetsFE.getFacetString());
        BGridPane resultField = new BGridPane(2);
        resultField.add(null, (BValue)this.outputTxt);
        resultField.add(null, (BValue)this.facetsFE);
        resultField.setHalign(BHalign.left);
        BGridPane contentPane = new BGridPane(1);
        contentPane.add(null, (BValue)resultField);
        contentPane.add(null, (BValue)this.facetDisplay);
        contentPane.setHalign(BHalign.left);
        BBorderPane border = new BBorderPane((BWidget)contentPane, 10.0, 5.0, 5.0, 20.0);
        return border;
    }

    private BPane makeFunctionSelector() {
        this.textBox.setVisibleColumns(60);
        this.textBox.setVisibleRows(5);
        this.textBox.getEditor().setEditable(false);
        BGridPane functionsPane = new BGridPane(1);
        functionsPane.add(null, (BValue)this.textBox);
        functionsPane.setHalign(BHalign.left);
        functionsPane.setRowGap(5.0);
        BBorderPane border = new BBorderPane((BWidget)functionsPane, 10.0, 5.0, 0.0, 20.0);
        return border;
    }

    private BPane makeFieldSelectionTable() {
        Property[] props;
        HashSet<String> assignedInputs = new HashSet<String>();
        this.mapping.lease();
        BVector inputColNames = this.mapping.getInputFields();
        inputColNames.lease();
        for (Property property : props = inputColNames.getDynamicPropertiesArray()) {
            BString val = (BString)inputColNames.get(property);
            assignedInputs.add(val.toString());
        }
        String[] inputFields = this.src.getSrcFieldNames();
        BGraphNode[] sources = this.src.getSources();
        HashMap<String, BSeriesSchema> schemaMap = new HashMap<String, BSeriesSchema>();
        for (BGraphNode src : sources) {
            BSeriesSchema schema = src.getSchema();
            schemaMap.put(src.getName(), schema);
        }
        BSeriesSchema bSeriesSchema = this.src.getSchema();
        bSeriesSchema.lease();
        String keyField = bSeriesSchema.getKeyField();
        this.rows = new Row[inputFields.length];
        for (int index = 0; index < inputFields.length; ++index) {
            String fieldName = inputFields[index];
            if (fieldName.equals(keyField)) continue;
            String[] split = TextUtil.split((String)fieldName, (char)'.');
            String srcName = split[0];
            BSeriesSchema srcSchema = (BSeriesSchema)schemaMap.get(srcName);
            srcSchema.lease();
            BTypeSpec fieldType = srcSchema.getFieldType(split[1]);
            BFacets fieldFacets = srcSchema.getFieldFacets(split[1]);
            BUnit fieldUnits = (BUnit)fieldFacets.get("units", (BObject)BUnit.DEFAULT);
            this.rows[index] = new Row(fieldName, fieldType, fieldUnits, assignedInputs.contains(fieldName));
        }
        this.model = new Model();
        this.table = new BTable((TableModel)this.model);
        this.table.setCellRenderer((TableCellRenderer)new CellRenderer());
        this.table.setController((TableController)new Controller());
        this.table.setOptionsButtonVisible(false);
        BScrollPane scroll = new BScrollPane((BWidget)this.table);
        BBorderPane border = new BBorderPane((BWidget)scroll, BInsets.make((double)10.0, (double)5.0, (double)0.0, (double)20.0));
        return border;
    }

    private void setWarning(String msg) {
        this.warningImg.setImage(warning);
        this.warningTxt.setText(msg);
    }

    private void clearWarning() {
        this.warningImg.setImage(blank);
        this.warningTxt.setText("");
    }

    public BFunctionMapping saveMapping() throws Exception {
        BTypeSpec functionTypeSpec = (BTypeSpec)this.lstFunctions.getSelectedItem();
        this.mapping.setFunctionTypeSpec(functionTypeSpec);
        this.mapping.setOutputField(this.outputTxt.getText());
        BVector inputs = new BVector();
        for (Row row : this.rows) {
            if (!row.selected) continue;
            inputs.add(null, (BValue)BString.make((String)row.field));
        }
        this.mapping.setInputFields(inputs);
        BFacets saveValue = (BFacets)this.facetsFE.saveValue();
        this.mapping.setFacets(saveValue);
        return this.mapping;
    }

    public void doCheckSelectedParams() {
        this.validateConfig();
    }

    public void doCheckFacets() {
        this.facetDisplay.setText(this.facetsFE.getFacetString());
        this.validateConfig();
    }

    private void validateConfig() {
        BTypeSpec functionType = (BTypeSpec)this.lstFunctions.getSelectedItem();
        BTransformFunction function = (BTransformFunction)functionType.getInstance();
        Type[] argumentTypes = function.getArgumentTypes();
        BUnit outFieldUnits = this.getOutFieldUnits();
        boolean paramsSelected = false;
        for (Row row : this.rows) {
            if (!row.selected) continue;
            paramsSelected = true;
            Type resolvedType = row.fieldType.getResolvedType();
            if (!BFunctionMappingConf.isValidArgType(argumentTypes, resolvedType)) {
                this.setWarning(ERR_PARAM_TYPES);
                return;
            }
            if ((row.units == BUnit.DEFAULT || outFieldUnits != BUnit.DEFAULT) && row.units.isConvertible(outFieldUnits)) continue;
            this.setWarning(ERR_UNMATCHED_UNITS);
            return;
        }
        if (!paramsSelected) {
            this.setWarning(ERR_NO_PARAMS);
            return;
        }
        this.clearWarning();
    }

    private BUnit getOutFieldUnits() {
        try {
            BFacets facets = (BFacets)this.facetsFE.saveValue();
            if (null != facets) {
                return (BUnit)facets.get("units", (BObject)BUnit.DEFAULT);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return BUnit.DEFAULT;
    }

    public void doFunctionChanged() {
        this.updateFunctionDescription();
    }

    private void updateFunctionDescription() {
        BTypeSpec spec = (BTypeSpec)this.lstFunctions.getSelectedItem();
        BTransformFunction tf = (BTransformFunction)spec.getInstance();
        String functionDesc = tf.getFunctionDesc();
        this.textBox.setText(functionDesc);
    }

    private static class Row {
        String field;
        BUnit units;
        BTypeSpec fieldType;
        boolean selected;

        public Row(String fieldName, BTypeSpec fieldType, BUnit units, boolean selected) {
            this.field = fieldName;
            this.fieldType = fieldType;
            this.units = units;
            this.selected = selected;
        }
    }

    protected class Controller
    extends TableController {
        protected Controller() {
        }

        protected void cellPressed(BMouseEvent event, int row, int column) {
            boolean state;
            Row active = BFunctionMappingConfEditor.this.rows[row];
            active.selected = state = !active.selected;
            BFunctionMappingConfEditor.this.doCheckSelectedParams();
            BFunctionMappingConfEditor.this.repaint();
        }
    }

    protected static class CellRenderer
    extends TableCellRenderer {
        public double getPreferredCellWidth(TableCellRenderer.Cell cell) {
            if (cell.column == 0) {
                return 20.0;
            }
            Row row = (Row)cell.value;
            String s = row.field;
            double w = this.getFont(cell).width(s) + 12.0;
            return w;
        }

        public void paintCell(Graphics g, TableCellRenderer.Cell cell) {
            Row row = (Row)cell.value;
            BBrush fg = Theme.table().getTextBrush();
            BBrush bg = Theme.table().getWindowBackground();
            g.setBrush(bg);
            g.fillRect(0.0, 0.0, cell.width, cell.height);
            g.setBrush(fg);
            g.setFont(Theme.table().getCellFont());
            if (cell.column == 1) {
                g.drawString(row.field, 3.0, cell.height - 3.0);
            } else if (cell.column == 2) {
                g.drawString(row.fieldType.toString(), 3.0, cell.height - 3.0);
            } else if (cell.column == 0) {
                this.paintSelected(g, cell, row);
            }
        }

        public void paintSelected(Graphics g, TableCellRenderer.Cell cell, Row row) {
            double x = 0.0;
            boolean check = row.selected;
            if (check) {
                g.setBrush(BColor.make((int)-16744448));
                double dx = x + 7.0;
                double dy = 5.0;
                g.strokeLine(dx, dy + 4.0, dx + 2.0, dy + 6.0);
                g.strokeLine(dx + 1.0, dy + 4.0, dx + 2.0, dy + 5.0);
                g.strokeLine(dx + 1.0, dy + 3.0, dx + 3.0, dy + 5.0);
                g.strokeLine(dx + 2.0, dy + 4.0, dx + 6.0, dy);
                g.strokeLine(dx + 2.0, dy + 5.0, dx + 6.0, dy + 1.0);
                g.strokeLine(dx + 3.0, dy + 5.0, dx + 7.0, dy + 1.0);
            }
        }
    }

    protected class Model
    extends TableModel {
        protected Model() {
        }

        public int getRowCount() {
            return BFunctionMappingConfEditor.this.rows.length;
        }

        public int getColumnCount() {
            return 3;
        }

        public String getColumnName(int col) {
            switch (col) {
                case 0: {
                    return "";
                }
                case 1: {
                    return INPUT_LBL;
                }
                case 2: {
                    return TYPE_LBL;
                }
            }
            return "?";
        }

        public Object getSubject(int row) {
            return BFunctionMappingConfEditor.this.rows[row];
        }

        public Object getValueAt(int row, int col) {
            return BFunctionMappingConfEditor.this.rows[row];
        }
    }
}

