/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.samlEncryption;

import com.onelogin.saml.Utils;
import com.tridium.crypto.core.cert.KeyPurpose;
import com.tridium.nre.security.SecretChars;
import com.tridium.saml.SAMLConfigurationException;
import com.tridium.saml.SAMLException;
import com.tridium.saml.SAMLResponseException;
import com.tridium.saml.authnScheme.BISamlXmlDecrypter;
import com.tridium.samlEncryption.ValidationError;
import java.io.ByteArrayOutputStream;
import java.security.AccessController;
import java.security.PrivateKey;
import java.security.UnrecoverableKeyException;
import java.security.cert.X509Certificate;
import javax.baja.data.BIDataValue;
import javax.baja.nre.annotations.Facet;
import javax.baja.nre.annotations.Generated;
import javax.baja.nre.annotations.NiagaraProperties;
import javax.baja.nre.annotations.NiagaraProperty;
import javax.baja.nre.annotations.NiagaraType;
import javax.baja.security.BCertificateAliasAndPassword;
import javax.baja.security.BPassword;
import javax.baja.security.crypto.CertManagerFactory;
import javax.baja.security.crypto.IKeyStore;
import javax.baja.sys.BBoolean;
import javax.baja.sys.BComplex;
import javax.baja.sys.BComponent;
import javax.baja.sys.BFacets;
import javax.baja.sys.BString;
import javax.baja.sys.BValue;
import javax.baja.sys.Flags;
import javax.baja.sys.Property;
import javax.baja.sys.Slot;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.util.Lexicon;
import javax.xml.xpath.XPathExpressionException;
import org.apache.xml.security.Init;
import org.apache.xml.security.encryption.XMLCipher;
import org.apache.xml.security.utils.XMLUtils;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

@NiagaraType
@NiagaraProperties(value={@NiagaraProperty(name="samlServerEncryptionCert", type="String", defaultValue="", facets={@Facet(name="BFacets.FIELD_EDITOR", value="BString.make(\"workbench:CertificateAliasFE\")"), @Facet(name="BFacets.UX_FIELD_EDITOR", value="BString.make(\"webEditors:CertificateAliasEditor\")"), @Facet(value="BFacets.make(\"purposeId\", \"SERVER_CERT\")")}, deprecated=true), @NiagaraProperty(name="samlServerEncryptionCertAliasAndPassword", type="BCertificateAliasAndPassword", defaultValue="new BCertificateAliasAndPassword(\"\", BPassword.DEFAULT)", flags=4, facets={@Facet(value="BFacets.make(BFacets.SECURITY, BBoolean.TRUE)")})})
public class BSamlXmlDecrypter
extends BComponent
implements BISamlXmlDecrypter {
    @Deprecated
    @Generated
    public static final Property samlServerEncryptionCert = BSamlXmlDecrypter.newProperty((int)0, (String)"", (BFacets)BFacets.make((BFacets)BFacets.make((BFacets)BFacets.make((String)"fieldEditor", (BIDataValue)BString.make((String)"workbench:CertificateAliasFE")), (BFacets)BFacets.make((String)"uxFieldEditor", (BIDataValue)BString.make((String)"webEditors:CertificateAliasEditor"))), (BFacets)BFacets.make((String)"purposeId", (String)"SERVER_CERT")));
    @Generated
    public static final Property samlServerEncryptionCertAliasAndPassword = BSamlXmlDecrypter.newProperty((int)4, (BValue)new BCertificateAliasAndPassword("", BPassword.DEFAULT), (BFacets)BFacets.make((String)"security", (BIDataValue)BBoolean.TRUE));
    @Generated
    public static final Type TYPE = Sys.loadType(BSamlXmlDecrypter.class);

    @Deprecated
    @Generated
    public String getSamlServerEncryptionCert() {
        return this.getString(samlServerEncryptionCert);
    }

    @Deprecated
    @Generated
    public void setSamlServerEncryptionCert(String v) {
        this.setString(samlServerEncryptionCert, v, null);
    }

    @Generated
    public BCertificateAliasAndPassword getSamlServerEncryptionCertAliasAndPassword() {
        return (BCertificateAliasAndPassword)this.get(samlServerEncryptionCertAliasAndPassword);
    }

    @Generated
    public void setSamlServerEncryptionCertAliasAndPassword(BCertificateAliasAndPassword v) {
        this.set(samlServerEncryptionCertAliasAndPassword, (BValue)v, null);
    }

    @Generated
    public Type getType() {
        return TYPE;
    }

    public final Object fw(int x, Object a, Object b, Object c, Object d) {
        switch (x) {
            case 11: {
                this.fwStarted();
            }
        }
        return super.fw(x, a, b, c, d);
    }

    private void fwStarted() {
        if (!Flags.has((BComplex)this, (Slot)samlServerEncryptionCert, (int)0x10000000)) {
            this.getSamlServerEncryptionCertAliasAndPassword().setAlias(this.getSamlServerEncryptionCert());
            this.getSamlServerEncryptionCertAliasAndPassword().setPassword(BPassword.DEFAULT);
            Flags.add((BComponent)this, (Slot)samlServerEncryptionCert, null, (int[])new int[]{0x10000005});
        }
        if (!Flags.has((BComplex)this, (Slot)samlServerEncryptionCertAliasAndPassword, (int)0x10000000)) {
            Flags.add((BComponent)this, (Slot)samlServerEncryptionCertAliasAndPassword, null, (int[])new int[]{0x10000000});
            this.setFlags((Slot)samlServerEncryptionCertAliasAndPassword, this.getFlags((Slot)samlServerEncryptionCertAliasAndPassword) & 0xFFFFFFFB);
            this.getSamlServerEncryptionCertAliasAndPassword().setFacets((Slot)BCertificateAliasAndPassword.alias, BFacets.make((String)"purposeId", (String)KeyPurpose.SERVER_CERT.name()));
        }
    }

    public X509Certificate getEncryptionCertificate() throws SAMLException {
        IKeyStore keyStore;
        if (this.getSamlServerEncryptionCertAliasAndPassword().getAlias().isEmpty()) {
            return null;
        }
        try {
            keyStore = CertManagerFactory.getInstance().getKeyStore();
        }
        catch (Exception e) {
            throw new SAMLException("Error getting keystore", (Throwable)e);
        }
        try {
            X509Certificate encryptionCert = keyStore.getCertificate(this.getSamlServerEncryptionCertAliasAndPassword().getAlias());
            if (encryptionCert == null) {
                throw new SAMLConfigurationException(String.format("Invalid signing cert {%s}", this.getSamlServerEncryptionCertAliasAndPassword().getAlias()));
            }
            return encryptionCert;
        }
        catch (Exception e) {
            throw new SAMLConfigurationException(String.format("Invalid signing cert {%s}", this.getSamlServerEncryptionCertAliasAndPassword().getAlias()), (Throwable)e);
        }
    }

    public Document decryptAssertion(Document dom) throws SAMLException {
        PrivateKey key;
        block24: {
            try {
                if (this.getSamlServerEncryptionCertAliasAndPassword().getPassword().isDefault()) {
                    key = (PrivateKey)CertManagerFactory.getInstance().getKeyStore().getKey(this.getSamlServerEncryptionCertAliasAndPassword().getAlias(), null);
                    break block24;
                }
                try (SecretChars passwordChars = AccessController.doPrivileged(() -> ((BPassword)this.getSamlServerEncryptionCertAliasAndPassword().getPassword()).getSecretChars());){
                    key = (PrivateKey)CertManagerFactory.getInstance().getKeyStore().getKey(this.getSamlServerEncryptionCertAliasAndPassword().getAlias(), passwordChars.get());
                }
            }
            catch (UnrecoverableKeyException e) {
                throw new SAMLConfigurationException(Lexicon.make((String)"samlEncryption").get("saml.exception.badPassword"), (Throwable)e);
            }
            catch (Exception e) {
                throw new SAMLConfigurationException(Lexicon.make((String)"samlEncryption").get("saml.exception.noPrivateKey"), (Throwable)e);
            }
        }
        try {
            NodeList encryptedDataNodes = Utils.query((Document)dom, (String)"/samlp:Response/saml:EncryptedAssertion/xenc:EncryptedData");
            Element encryptedData = (Element)encryptedDataNodes.item(0);
            if (encryptedData == null) {
                throw new SAMLResponseException(Lexicon.make((String)"samlEncryption").get("saml.exception.noEncryptedData"));
            }
            this.decryptElement(encryptedData, key);
        }
        catch (SAMLException e) {
            throw e;
        }
        catch (XPathExpressionException e) {
            throw new SAMLResponseException(Lexicon.make((String)"samlEncryption").get("saml.exception.noEncryptedData"), (Throwable)e);
        }
        catch (Exception e) {
            throw new SAMLResponseException(Lexicon.make((String)"samlEncryption").get("saml.exception.couldNotDecrypt"), (Throwable)e);
        }
        try {
            NodeList AssertionDataNodes = Utils.query((Document)dom, (String)"/samlp:Response/saml:EncryptedAssertion/saml:Assertion");
            Node assertionNode = AssertionDataNodes.item(0);
            if (assertionNode == null) {
                throw new SAMLResponseException(Lexicon.make((String)"samlEncryption").get("saml.exception.noAssertion"));
            }
            assertionNode.getParentNode().getParentNode().replaceChild(assertionNode, assertionNode.getParentNode());
        }
        catch (XPathExpressionException e) {
            throw new SAMLResponseException(Lexicon.make((String)"samlEncryption").get("saml.exception.noAssertion"), (Throwable)e);
        }
        String xmlStr = BSamlXmlDecrypter.convertDocumentToString(dom);
        return Utils.loadXML((String)xmlStr);
    }

    private void decryptElement(Element encryptedDataElement, PrivateKey inputKey) throws Exception {
        AccessController.doPrivileged(() -> {
            Init.init();
            return null;
        });
        XMLCipher xmlCipher = XMLCipher.getInstance();
        xmlCipher.init(2, null);
        NodeList keyInfoInEncData = encryptedDataElement.getElementsByTagNameNS("http://www.w3.org/2000/09/xmldsig#", "KeyInfo");
        if (keyInfoInEncData.getLength() == 0) {
            throw new ValidationError("No KeyInfo inside EncryptedData element", 35);
        }
        NodeList childs = keyInfoInEncData.item(0).getChildNodes();
        for (int i = 0; i < childs.getLength(); ++i) {
            if (childs.item(i).getLocalName() == null || !childs.item(i).getLocalName().equals("RetrievalMethod")) continue;
            Element retrievalMethodElem = (Element)childs.item(i);
            if (!retrievalMethodElem.getAttribute("Type").equals("http://www.w3.org/2001/04/xmlenc#EncryptedKey")) {
                throw new ValidationError("Unsupported Retrieval Method found", 37);
            }
            String uri = retrievalMethodElem.getAttribute("URI").substring(1);
            NodeList encryptedKeyNodes = ((Element)encryptedDataElement.getParentNode()).getElementsByTagNameNS("http://www.w3.org/2001/04/xmlenc#", "EncryptedKey");
            for (int j = 0; j < encryptedKeyNodes.getLength(); ++j) {
                if (!((Element)encryptedKeyNodes.item(j)).getAttribute("Id").equals(uri)) continue;
                keyInfoInEncData.item(0).replaceChild(encryptedKeyNodes.item(j), childs.item(i));
            }
        }
        xmlCipher.setKEK(inputKey);
        xmlCipher.doFinal(encryptedDataElement.getOwnerDocument(), encryptedDataElement, false);
    }

    public static String convertDocumentToString(Document doc) {
        AccessController.doPrivileged(() -> {
            Init.init();
            return null;
        });
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        XMLUtils.outputDOM((Node)doc, baos);
        return Utils.toStringUtf8((byte[])baos.toByteArray());
    }
}

