/*
 * Decompiled with CFR 0.152.
 */
package com.tridiumx.entsec.threat;

import com.tridiumx.entsec.threat.BThreatLevelActivationJob;
import com.tridiumx.entsec.threat.BThreatLevelEntry;
import com.tridiumx.entsec.threat.BThreatLevelGroup;
import javax.baja.naming.BOrd;
import javax.baja.naming.BOrdList;
import javax.baja.nre.annotations.NiagaraProperty;
import javax.baja.nre.annotations.NiagaraType;
import javax.baja.sys.Context;
import javax.baja.sys.Property;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;

@NiagaraType
@NiagaraProperty(name="remoteMismatch", type="boolean", defaultValue="false", flags=5)
public class BRetrieveThreatLevelActivationStatusJob
extends BThreatLevelActivationJob {
    public static final Property remoteMismatch = BRetrieveThreatLevelActivationStatusJob.newProperty((int)5, (boolean)false, null);
    public static final Type TYPE = Sys.loadType(BRetrieveThreatLevelActivationStatusJob.class);
    private boolean mismatch = false;

    public boolean getRemoteMismatch() {
        return this.getBoolean(remoteMismatch);
    }

    public void setRemoteMismatch(boolean v) {
        this.setBoolean(remoteMismatch, v, null);
    }

    @Override
    public Type getType() {
        return TYPE;
    }

    public BRetrieveThreatLevelActivationStatusJob(BOrd ord, BThreatLevelEntry entry, String stationName) {
        this(BOrdList.make((BOrd)ord), entry, stationName);
    }

    public BRetrieveThreatLevelActivationStatusJob(BOrdList ordList, BThreatLevelEntry entry, String stationName) {
        this.setOrdList(ordList);
        this.setThreatLevel(entry);
        this.setStationName(stationName);
    }

    public BRetrieveThreatLevelActivationStatusJob() {
    }

    @Override
    public BThreatLevelActivationJob getJob(BOrdList ordList, BThreatLevelEntry activeLevelEntry, String stationName) {
        return new BRetrieveThreatLevelActivationStatusJob(ordList, activeLevelEntry, stationName);
    }

    @Override
    public void checkRemoteJobStatus(BThreatLevelActivationJob remoteJob) {
        BRetrieveThreatLevelActivationStatusJob statusJob = (BRetrieveThreatLevelActivationStatusJob)remoteJob;
        if (statusJob.getRemoteMismatch()) {
            if (this.originalJob) {
                this.mismatch = true;
            } else {
                this.setRemoteMismatch(true);
            }
        }
    }

    @Override
    public void setThreatLevel(BThreatLevelGroup current, BThreatLevelEntry entry, String stationName, Context cx, String auditContext) {
        current.lease();
        StringBuffer b = new StringBuffer();
        b.append(current.toDisplayString(cx));
        if (!current.getActiveLevel().equals((Object)entry)) {
            b.append(" is set to ").append(current.getActiveLevel().toString(cx)).append(", not ").append(entry.toString(cx));
            this.log().failed(b.toString());
            if (this.originalJob) {
                this.mismatch = true;
            } else {
                this.setRemoteMismatch(true);
            }
        } else if (!this.originalJob) {
            this.log().message("{ok}");
        }
    }

    @Override
    public void alarm(String sourceName, String message) {
    }

    @Override
    public void alarmIniated(String sourceName) {
    }

    @Override
    public void alarmComplete(String sourceName) {
    }

    @Override
    public void run(Context cx) throws Exception {
        super.run(cx);
        if (this.originalJob && this.mismatch) {
            throw new Exception(this.currentSourceName + " has a mismatch status.");
        }
    }
}

