/*
 * Decompiled with CFR 0.152.
 */
package com.tridiumx.entsec.securityUtil.ui.link;

import javax.baja.naming.UnresolvedException;
import javax.baja.nre.annotations.NiagaraType;
import javax.baja.nre.util.Array;
import javax.baja.nre.util.TextUtil;
import javax.baja.query.BExpression;
import javax.baja.query.expression.BFunctionExpression;
import javax.baja.query.util.Exprs;
import javax.baja.query.util.Funcs;
import javax.baja.sys.BBoolean;
import javax.baja.sys.BComponent;
import javax.baja.sys.BLink;
import javax.baja.sys.BObject;
import javax.baja.sys.BSimple;
import javax.baja.sys.BString;
import javax.baja.sys.Context;
import javax.baja.sys.Knob;
import javax.baja.sys.Slot;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.util.BTypeSpec;

@NiagaraType
public class BLinkTemplate
extends BObject {
    public static final Type TYPE = Sys.loadType(BLinkTemplate.class);
    public Type type;
    public Slot sourceSlot;
    public Slot targetSlot;
    public boolean displayPath = false;

    public Type getType() {
        return TYPE;
    }

    public BLinkTemplate() {
    }

    public BLinkTemplate(BTypeSpec typeSpec, String sourceSlotName, Slot targetSlot) {
        BComponent c = (BComponent)typeSpec.getInstance();
        this.type = typeSpec.getResolvedType();
        this.sourceSlot = c.getSlot(sourceSlotName);
        this.targetSlot = targetSlot;
    }

    public BLinkTemplate(BTypeSpec typeSpec, Slot sourceSlot, String targetSlotName) {
        BComponent c = (BComponent)typeSpec.getInstance();
        this.type = typeSpec.getResolvedType();
        this.sourceSlot = sourceSlot;
        this.targetSlot = c.getSlot(targetSlotName);
    }

    public BLinkTemplate(Type type, Slot sourceSlot, Slot targetSlot) {
        this.type = type;
        this.sourceSlot = sourceSlot;
        this.targetSlot = targetSlot;
    }

    public BExpression getAssignedLinksExpression(BComponent target, Context cx) {
        StringBuffer b = new StringBuffer();
        b.append(target.getHandle());
        b.append(".");
        b.append(this.sourceSlot.getName());
        b.append(".");
        b.append(this.targetSlot.getName());
        BFunctionExpression function = Funcs.make((String)"entsec:LinkTemplate.isLinked", (Type)BBoolean.TYPE, (BExpression)Exprs.simple((BSimple)BString.make((String)b.toString())));
        return function;
    }

    public BExpression getAssignedKnobsExpression(BComponent target, Context cx) {
        StringBuffer b = new StringBuffer();
        b.append(target.getHandle());
        b.append(".");
        b.append(this.sourceSlot.getName());
        b.append(".");
        b.append(this.targetSlot.getName());
        BFunctionExpression function = Funcs.make((String)"entsec:LinkTemplate.isKnobbed", (Type)BBoolean.TYPE, (BExpression)Exprs.simple((BSimple)BString.make((String)b.toString())));
        return function;
    }

    public static BBoolean isLinked(BObject target, BString params) {
        BComponent source = target.asComponent();
        String[] split = TextUtil.split((String)params.toString(), (char)'.');
        String handle = split[0];
        String sourceSlotName = split[1];
        String targetSlotName = split[2];
        Knob[] knobs = source.getKnobs(source.getSlot(sourceSlotName));
        for (int i = 0; i < knobs.length; ++i) {
            if (!knobs[i].getTargetSlotName().equals(targetSlotName) || !knobs[i].getTargetComponent().getHandle().toString().equals(handle)) continue;
            return BBoolean.make((boolean)true);
        }
        return BBoolean.make((boolean)false);
    }

    public static BBoolean isKnobbed(BObject target, BString params) {
        BComponent source = target.asComponent();
        String[] split = TextUtil.split((String)params.toString(), (char)'.');
        String handle = split[0];
        String sourceSlotName = split[1];
        String targetSlotName = split[2];
        try {
            BLink[] links = source.getLinks(source.getSlot(targetSlotName));
            for (int i = 0; i < links.length; ++i) {
                if (!links[i].getSourceSlotName().equals(sourceSlotName) || !links[i].getSourceComponent().getHandle().toString().equals(handle)) continue;
                return BBoolean.make((boolean)true);
            }
        }
        catch (UnresolvedException unresolvedException) {
            // empty catch block
        }
        return BBoolean.make((boolean)false);
    }

    public Object[] getAssignedLinks(BComponent target, Context cx) {
        BLink[] links = target.getLinks(this.targetSlot);
        Array a = new Array(BLink.class);
        for (int i = 0; i < links.length; ++i) {
            if (!links[i].getSourceOrd().get((BObject)target).getType().is(this.type)) continue;
            a.add((Object)links[i]);
        }
        return a.trim();
    }

    public Object[] getAssignedKnobs(BComponent source, Context cx) {
        Knob[] knobs = source.getKnobs(this.sourceSlot);
        Array a = new Array(Knob.class);
        for (int i = 0; i < knobs.length; ++i) {
            if (!knobs[i].getTargetOrd().get((BObject)source).getType().is(this.type)) continue;
            a.add((Object)knobs[i]);
        }
        return a.trim();
    }
}

