/*
 * Decompiled with CFR 0.152.
 */
package com.tridiumx.entsec.securityUtil.query.consolidated;

import javax.baja.collection.BIRandomAccessTable;
import javax.baja.collection.BITable;
import javax.baja.collection.Column;
import javax.baja.collection.Row;
import javax.baja.data.DataTypes;
import javax.baja.nre.annotations.NiagaraType;
import javax.baja.sys.BFacets;
import javax.baja.sys.BIObject;
import javax.baja.sys.BObject;
import javax.baja.sys.BValue;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;

@NiagaraType
public class BConsolidatedRow
extends BObject
implements Row<BObject> {
    public static final Type TYPE = Sys.loadType(BConsolidatedRow.class);
    private BObject value;
    private int row;
    private BITable<BObject> table;
    private BIRandomAccessTable<BObject> randomAccessTable;

    public Type getType() {
        return TYPE;
    }

    public BConsolidatedRow(BObject value, int row, BITable<BObject> table, BIRandomAccessTable<BObject> randomAccessTable) {
        this.value = value instanceof Row ? (BObject)((Row)value).safeCopy() : (value instanceof BValue ? ((BValue)value).newCopy() : value);
        this.row = row;
        this.table = table;
        this.randomAccessTable = randomAccessTable;
    }

    public BObject getValue() {
        return this.value;
    }

    public int getRow() {
        return this.row;
    }

    public BITable<BObject> getTable() {
        return this.table;
    }

    public BIRandomAccessTable<BObject> getRandomAccessTable() {
        return this.randomAccessTable;
    }

    public BObject rowObject() {
        return this.value;
    }

    public BIObject cell(Column col) {
        Column column = this.table.getColumns().get(col.getName());
        return this.randomAccessTable.get(this.row).cell(column);
    }

    public int getCellFlags(Column column) {
        return this.randomAccessTable.get(this.row).getCellFlags(column);
    }

    public BFacets getCellFacets(Column column) {
        return this.randomAccessTable.get(this.row).getTable().getTableFacets();
    }

    public Row<BObject> safeCopy() {
        return new BConsolidatedRow(this.value, this.row, this.table, this.randomAccessTable);
    }

    public BObject get(Column col) {
        return (BObject)this.cell(col);
    }

    public String getString(Column col) {
        try {
            return DataTypes.otos((BIObject)this.cell(col));
        }
        catch (Exception e) {
            return this.cell(col).toString();
        }
    }

    public double getDouble(Column col) {
        return DataTypes.otod((BIObject)this.cell(col));
    }

    public float getFloat(Column col) {
        return DataTypes.otof((BIObject)this.cell(col));
    }

    public int getInt(Column col) {
        return DataTypes.otoi((BIObject)this.cell(col));
    }

    public long getLong(Column col) {
        return DataTypes.otol((BIObject)this.cell(col));
    }

    public boolean getBoolean(Column col) {
        return DataTypes.otob((BIObject)this.cell(col));
    }

    public int getFlags(Column col) {
        return this.getCellFlags(col);
    }

    public BFacets getFacets(Column col) {
        return this.getCellFacets(col);
    }
}

