/*
 * Decompiled with CFR 0.152.
 */
package com.tridiumx.entsec.securityUtil.query.consolidated;

import com.tridium.bql.filter.BStringFilter;
import com.tridium.fox.sys.BFoxClientConnection;
import com.tridium.nd.BNiagaraNetwork;
import com.tridium.nd.BNiagaraStation;
import com.tridium.query.BProjCol;
import com.tridium.query.BQueryEngine;
import com.tridiumx.entsec.PasswordUtil;
import com.tridiumx.entsec.securityUtil.BActivityMonitor;
import com.tridiumx.entsec.securityUtil.query.BColumnsProvider;
import com.tridiumx.entsec.securityUtil.query.TypeSpecPath;
import com.tridiumx.entsec.securityUtil.query.consolidated.BConsolidatedColumnsProvider;
import com.tridiumx.entsec.securityUtil.query.consolidated.BConsolidatedDataChannel;
import com.tridiumx.entsec.securityUtil.query.consolidated.BConsolidatedQueryResult;
import com.tridiumx.entsec.securityUtil.query.consolidated.BConsolidatedRow;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.baja.agent.AgentList;
import javax.baja.collection.AbstractCursor;
import javax.baja.collection.BIRandomAccessTable;
import javax.baja.collection.BITable;
import javax.baja.collection.Column;
import javax.baja.collection.TableCursor;
import javax.baja.collection.Tables;
import javax.baja.hx.HxOp;
import javax.baja.naming.BOrd;
import javax.baja.nd.BINiagaraStation;
import javax.baja.nd.SysDefSession;
import javax.baja.nre.annotations.NiagaraType;
import javax.baja.nre.util.Array;
import javax.baja.nre.util.IFilter;
import javax.baja.nre.util.SortUtil;
import javax.baja.query.BQuery;
import javax.baja.security.BPassword;
import javax.baja.space.BSpace;
import javax.baja.sys.BIcon;
import javax.baja.sys.BObject;
import javax.baja.sys.BString;
import javax.baja.sys.BValue;
import javax.baja.sys.Context;
import javax.baja.sys.Cursor;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.util.BTypeSpec;
import javax.baja.util.BUuid;

@NiagaraType
public abstract class BConsolidatedQuery
extends BQuery {
    public static final Type TYPE = Sys.loadType(BConsolidatedQuery.class);
    private static final BIcon icon = BIcon.std((String)"doc.png");
    public static final Logger LOG = Logger.getLogger("securityUtil.consolidation");
    private static BColumnsProvider defaultColumnsProvider = new BColumnsProvider();

    public Type getType() {
        return TYPE;
    }

    public void started() {
        if (this.get("consolidatedColumnsProvider") == null) {
            this.add("consolidatedColumnsProvider", (BValue)new BConsolidatedColumnsProvider());
        }
    }

    public TypeSpecPath[] getDefaultColumns() {
        return defaultColumnsProvider.getDefaultColumns(this);
    }

    public TypeSpecPath[] getHiddenColumns() {
        return defaultColumnsProvider.getHiddenColumns(this);
    }

    public BProjCol makeColumn(TypeSpecPath typeSpecPath) {
        return defaultColumnsProvider.makeColumn(typeSpecPath, this);
    }

    public int getDefaultSortColumnIndex() {
        return 0;
    }

    public String getOptionsKey() {
        return defaultColumnsProvider.getOptionsKey(this);
    }

    public BTypeSpec[] subordinateServiceTypes() {
        return null;
    }

    public boolean leaseResults() {
        return false;
    }

    public BITable<BObject> getCollection(BStringFilter stationFilter, BOrd baseOrd, BQuery query, int sortCol, boolean sortAsc, Context cx) {
        return new BConsolidatedQueryResult(this, stationFilter, baseOrd, query, sortCol, sortAsc, cx);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    Cursor<BConsolidatedRow> doConsolidatedQuery(BStringFilter stationFilter, BOrd baseOrd, BQuery query, int sortCol, boolean sortAsc, IFilter filter, Context cx) {
        int len;
        Array cursors = new Array(BITable.class);
        BINiagaraStation[] subs = this.getSubordinateStations(stationFilter, cx);
        int n = len = subs != null ? subs.length : 0;
        if (len < 1) {
            if (stationFilter == null || stationFilter.accept((BObject)BString.make((String)Sys.getStation().getStationName()))) {
                BQueryEngine engine = BQueryEngine.make((BSpace)this.getComponentSpace());
                BITable table = engine.compile(query, baseOrd).execute(cx);
                BIRandomAccessTable rat = Tables.slurp((BITable)table);
                cursors.add((Object)table);
                if (this.leaseResults()) {
                    BConsolidatedQuery.leaseTableContents((BITable<BObject>)table);
                }
            }
        } else {
            boolean includeLocal = stationFilter == null || stationFilter.accept((BObject)BString.make((String)Sys.getStation().getStationName()));
            int num = includeLocal ? len + 1 : len;
            Counter counter = new Counter(num);
            StationQuery[] queries = new StationQuery[num];
            int idx = 0;
            BNiagaraNetwork nn = (BNiagaraNetwork)Sys.getService((Type)BNiagaraNetwork.TYPE);
            if (includeLocal) {
                int n2 = idx++;
                StationQuery stationQuery = new StationQuery(this, query, baseOrd, counter, this.leaseResults(), cx);
                queries[n2] = stationQuery;
                nn.getWorkers().process((Object)stationQuery);
            }
            String interest = TYPE + ".doConsolidatedQuery." + BUuid.make().toString();
            BOrd relOrd = baseOrd.relativizeToSession();
            for (int i = 0; i < len; ++i) {
                BNiagaraStation station = (BNiagaraStation)nn.getNiagaraStation(subs[i].getStationName());
                if (station == null || station.isDown() || station.isDisabled() || station.isFatalFault() || !station.getPermissions(cx).hasOperatorRead()) {
                    Counter counter2 = counter;
                    synchronized (counter2) {
                        --counter.count;
                        continue;
                    }
                }
                int n3 = idx++;
                StationQuery stationQuery = new StationQuery(interest, relOrd, nn, station, query, counter, this.leaseResults(), cx);
                queries[n3] = stationQuery;
                station.postAsync((Runnable)stationQuery);
            }
            Counter counter3 = counter;
            synchronized (counter3) {
                while (counter.count > 0) {
                    try {
                        counter.wait(20000L);
                    }
                    catch (InterruptedException e) {
                        e.printStackTrace();
                        break;
                    }
                }
                for (int i = 0; i < idx; ++i) {
                    if (queries[i].table == null) continue;
                    cursors.add(queries[i].table);
                }
            }
        }
        return new ConsolidatedCursor((BITable[])cursors.trim(), sortCol, sortAsc, filter);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected BINiagaraStation[] getSubordinateStations(BStringFilter stationFilter, Context cx) {
        BTypeSpec[] serviceTypes = this.subordinateServiceTypes();
        int len = serviceTypes != null ? serviceTypes.length : 0;
        BNiagaraNetwork nn = (BNiagaraNetwork)Sys.getService((Type)BNiagaraNetwork.TYPE);
        Array subordinates = new Array(BINiagaraStation.class);
        try (SysDefSession sysDef = nn.createSysDefSession(cx);){
            BINiagaraStation me = sysDef.getLocalStation();
            BINiagaraStation[] subs = sysDef.getSubordinates(me);
            for (int i = 0; i < subs.length; ++i) {
                if (stationFilter != null && !stationFilter.accept((BObject)BString.make((String)subs[i].getStationName()))) continue;
                Array services = sysDef.getServices(subs[i]);
                boolean add = true;
                for (int j = 0; j < len; ++j) {
                    if (services.contains((Object)serviceTypes[j])) continue;
                    add = false;
                    break;
                }
                if (!add) continue;
                subordinates.add((Object)subs[i]);
            }
        }
        return (BINiagaraStation[])subordinates.trim();
    }

    static void leaseTableContents(BITable<BObject> table) {
        try {
            if (table == null) {
                return;
            }
            TableCursor cursor = table.cursor();
            while (cursor.next()) {
                BObject obj = (BObject)cursor.get();
                if (obj == null || !obj.isComponent()) continue;
                obj.asComponent().lease();
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public AgentList getAgents(Context cx) {
        AgentList list = super.getAgents(cx);
        list.toTop("entsecHx:HxConsolidatedQueryView");
        return list;
    }

    public BIcon getIcon() {
        return icon;
    }

    static Object getColVal(BConsolidatedRow row, int rowIdx, int sortCol) {
        BITable<BObject> table = row.getTable();
        BIRandomAccessTable<BObject> randomAccessTable = row.getRandomAccessTable();
        Column column = table.getColumns().get(sortCol);
        return randomAccessTable.get(rowIdx).cell(column).toString();
    }

    static class ConsolidatedCursor
    extends AbstractCursor<BConsolidatedRow> {
        BITable<BObject>[] tables;
        Cursor<BObject>[] cursors;
        BIRandomAccessTable<BObject>[] randomAccessTables;
        int sortCol;
        boolean sortAsc;
        IFilter filter;
        BConsolidatedRow[] recs;
        boolean[] cursorEmpty;
        int[] currentRow;
        BConsolidatedRow currentRec;
        BConsolidatedRow iteratorRec = null;
        boolean checkThreshold;
        int count = 0;

        ConsolidatedCursor(BITable<BObject>[] tables, int sortCol, boolean sortAsc, IFilter filter) {
            this.tables = tables;
            this.sortCol = sortCol;
            this.sortAsc = sortAsc;
            this.filter = filter;
            int len = tables != null ? tables.length : 0;
            this.cursors = new Cursor[len];
            this.randomAccessTables = new BIRandomAccessTable[len];
            this.recs = new BConsolidatedRow[len];
            this.cursorEmpty = new boolean[len];
            this.checkThreshold = BActivityMonitor.MAX_RESULT_SIZE > 0;
            this.currentRow = new int[len];
            for (int i = 0; i < len; ++i) {
                this.currentRow[i] = -1;
                this.cursors[i] = tables[i].cursor();
                this.randomAccessTables[i] = Tables.slurp(tables[i]);
            }
        }

        public Context getContext() {
            if (this.cursors.length < 1) {
                return null;
            }
            try {
                return this.cursors[0].getContext();
            }
            catch (Throwable e) {
                e.printStackTrace();
                return null;
            }
        }

        public boolean advanceCursor() {
            BConsolidatedRow nextRec = null;
            int nextRecIdx = -1;
            int indexToNull = -1;
            for (int i = 0; i < this.recs.length; ++i) {
                if (this.cursorEmpty[i]) continue;
                if (this.recs[i] == null) {
                    boolean foundNext = false;
                    while (!foundNext && this.cursors[i].next()) {
                        BObject obj = (BObject)this.cursors[i].get();
                        if (this.filter != null && !this.filter.accept((Object)obj)) continue;
                        if (this.checkThreshold) {
                            if (this.count > BActivityMonitor.MAX_RESULT_SIZE) {
                                return false;
                            }
                            ++this.count;
                        }
                        this.currentRow[i] = this.currentRow[i] + 1;
                        this.recs[i] = new BConsolidatedRow(obj, this.currentRow[i], this.tables[i], this.randomAccessTables[i]);
                        foundNext = true;
                        break;
                    }
                    if (!foundNext) {
                        this.recs[i] = null;
                        this.cursorEmpty[i] = true;
                    }
                }
                if (this.recs[i] == null) continue;
                if (nextRec != null) {
                    if (this.sortCol < 0) continue;
                    int comparison = SortUtil.compare((Object)BConsolidatedQuery.getColVal(this.recs[i], this.currentRow[i], this.sortCol), (Object)BConsolidatedQuery.getColVal(nextRec, nextRecIdx, this.sortCol));
                    if ((!this.sortAsc || comparison >= 0) && (this.sortAsc || comparison <= 0)) continue;
                    nextRec = this.recs[i];
                    nextRecIdx = this.currentRow[i];
                    indexToNull = i;
                    continue;
                }
                nextRec = this.recs[i];
                nextRecIdx = this.currentRow[i];
                indexToNull = i;
            }
            this.currentRec = nextRec;
            if (indexToNull >= 0) {
                this.recs[indexToNull] = null;
            }
            return this.currentRec != null;
        }

        public boolean nextComponent() {
            for (int i = 0; i < this.cursors.length; ++i) {
                while (this.cursors[i].next()) {
                }
            }
            return false;
        }

        public boolean next(Class<?> cls) {
            return this.nextComponent();
        }

        protected BConsolidatedRow doGet() {
            if (this.currentRec != null) {
                this.iteratorRec = this.currentRec;
            }
            return this.iteratorRec;
        }
    }

    static class Counter {
        int count = 0;

        Counter(int count) {
            this.count = count;
        }
    }

    static class StationQuery
    implements Runnable {
        BITable<BObject> table = null;
        BConsolidatedQuery cQuery = null;
        BQuery query = null;
        BOrd ord = null;
        Counter counter = null;
        String interest = null;
        BNiagaraNetwork nn = null;
        BNiagaraStation station = null;
        boolean leaseTable = false;
        Context cx = null;

        StationQuery(BConsolidatedQuery cQuery, BQuery query, BOrd baseOrd, Counter counter, boolean leaseTable, Context cx) {
            this.cQuery = cQuery;
            this.query = query;
            this.ord = baseOrd;
            this.counter = counter;
            this.leaseTable = leaseTable;
            this.cx = cx;
        }

        StationQuery(String interest, BOrd relOrd, BNiagaraNetwork nn, BNiagaraStation station, BQuery query, Counter counter, boolean leaseTable, Context cx) {
            this.interest = interest;
            this.ord = relOrd;
            this.nn = nn;
            this.station = station;
            this.query = query;
            this.counter = counter;
            this.leaseTable = leaseTable;
            this.cx = cx;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            block33: {
                try {
                    if (this.cQuery != null) {
                        BQueryEngine engine = BQueryEngine.make((BSpace)this.cQuery.getComponentSpace());
                        this.table = engine.compile(this.query, this.ord).execute(this.cx);
                        if (this.leaseTable) {
                            BConsolidatedQuery.leaseTableContents(this.table);
                        }
                        break block33;
                    }
                    Object connection = null;
                    BFoxClientConnection.StringInterest sInterest = new BFoxClientConnection.StringInterest(this.interest);
                    try {
                        connection = this.station.getClientConnection();
                        connection.engageNoRetry((BFoxClientConnection.Interest)sInterest);
                        BConsolidatedDataChannel channel = (BConsolidatedDataChannel)connection.getChannels().get("consolidatedData", BConsolidatedDataChannel.TYPE);
                        BPassword password = BPassword.DEFAULT;
                        if (this.cx instanceof HxOp) {
                            password = PasswordUtil.getSessionPassword((HxOp)this.cx);
                        }
                        this.table = channel.resolveQuery(this.query, this.ord, this.cx != null ? this.cx.getUser() : null, password, this.leaseTable);
                    }
                    catch (Exception e) {
                        String stationName;
                        String string = stationName = this.station != null ? this.station.getName() : "null";
                        if (e.toString().indexOf("this is not allowed") > -1) {
                            LOG.log(Level.SEVERE, "Failure running query against " + stationName, e);
                        } else if (e.toString().indexOf("javax.baja.security.AuthenticationException") > -1) {
                            if (this.cx instanceof HxOp) {
                                PasswordUtil.removeSessionPassword((HxOp)this.cx);
                            }
                        } else if (LOG.isLoggable(Level.FINE)) {
                            LOG.log(Level.FINE, "Failure running query against " + stationName, e);
                        }
                    }
                    finally {
                        if (connection != null) {
                            connection.disengage((BFoxClientConnection.Interest)sInterest);
                        }
                    }
                }
                catch (Exception e) {
                    if (LOG.isLoggable(Level.FINE)) {
                        if (this.cQuery != null) {
                            LOG.log(Level.FINE, "Failed running local query", e);
                        } else {
                            String stationName = this.station != null ? this.station.getName() : "null";
                            LOG.log(Level.FINE, "Failed running query against " + stationName, e);
                        }
                    }
                }
                finally {
                    Counter counter = this.counter;
                    synchronized (counter) {
                        --this.counter.count;
                        if (this.counter.count < 1) {
                            this.counter.notifyAll();
                        }
                    }
                }
            }
        }
    }
}

