/*
 * Decompiled with CFR 0.152.
 */
package com.tridiumx.entsec.securityUtil.query.consolidated;

import com.tridium.data.BToDataTable;
import com.tridium.data.DataTableDecoder;
import com.tridium.data.DataTableEncoder;
import com.tridium.fox.message.FoxMessage;
import com.tridium.fox.session.Fox;
import com.tridium.fox.session.FoxCircuit;
import com.tridium.fox.session.FoxRequest;
import com.tridium.fox.session.FoxResponse;
import com.tridium.fox.session.InvalidCommandException;
import com.tridium.fox.sys.BFoxChannel;
import com.tridium.nd.BNiagaraNetwork;
import com.tridium.nd.BNiagaraStation;
import com.tridium.nre.util.LegacyStorageUtil;
import com.tridium.query.BQueryEngine;
import com.tridiumx.entsec.securityUtil.query.consolidated.BConsolidatedQuery;
import java.io.DataInput;
import java.io.DataInputStream;
import java.io.DataOutput;
import java.io.DataOutputStream;
import javax.baja.collection.BITable;
import javax.baja.data.BIDataTable;
import javax.baja.io.ValueDocDecoder;
import javax.baja.io.ValueDocEncoder;
import javax.baja.naming.BOrd;
import javax.baja.nre.annotations.NiagaraType;
import javax.baja.query.BQuery;
import javax.baja.security.AuthenticationException;
import javax.baja.security.BPassword;
import javax.baja.space.BSpace;
import javax.baja.sys.BFacets;
import javax.baja.sys.BIObject;
import javax.baja.sys.BObject;
import javax.baja.sys.BValue;
import javax.baja.sys.BasicContext;
import javax.baja.sys.Context;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.user.BUser;
import javax.baja.user.BUserService;

@NiagaraType
public class BConsolidatedDataChannel
extends BFoxChannel {
    public static final Type TYPE = Sys.loadType(BConsolidatedDataChannel.class);

    public Type getType() {
        return TYPE;
    }

    public BConsolidatedDataChannel() {
        super("consolidatedData");
    }

    public FoxResponse process(FoxRequest req) throws Exception {
        String command = req.command;
        if (command == "setRemoteIp") {
            return this.setRemoteIp(req);
        }
        throw new InvalidCommandException(command);
    }

    public void circuitOpened(FoxCircuit circuit) throws Exception {
        String command = circuit.command;
        if (command == "resolveQuery") {
            this.resolveQuery(circuit);
            return;
        }
        throw new InvalidCommandException(command);
    }

    public BITable<? extends BIObject> resolveQuery(BQuery query, BOrd ord, BUser user, BPassword password, boolean leaseTable) throws Exception {
        FoxMessage req = new FoxMessage();
        if (ord != null) {
            req.add("ord", ord.toString());
        }
        if (user != null) {
            req.add("param1", LegacyStorageUtil.encode((String)user.getUsername(), (int)0));
            req.add("param2", password.encodeToString());
        }
        req.add("leaseTable", leaseTable);
        FoxCircuit circuit = this.openCircuit("resolveQuery");
        circuit.writeMessage(req);
        ValueDocEncoder encoder = new ValueDocEncoder(circuit.getOutputStream());
        encoder.setEncodeTransients(true);
        encoder.setEncodeComments(false);
        if (this.getConnection().session().isLegacyConnection()) {
            encoder.getPlugin().setVersion(ValueDocEncoder.BOG_VERSION_1);
        }
        encoder.encodeDocument((BValue)query);
        encoder.flush();
        circuit.flush();
        FoxMessage resp = circuit.readMessage();
        if (resp.getString("exception", null) != null) {
            throw Fox.exceptionTranslator.messageToException(resp);
        }
        BIDataTable result = DataTableDecoder.decode((DataInput)new DataInputStream(circuit.getInputStream()));
        circuit.close();
        return result;
    }

    public void resolveQuery(FoxCircuit circuit) throws Exception {
        FoxMessage req = circuit.readMessage();
        String ordText = req.getString("ord", null);
        String username = req.getString("param1", null);
        boolean leaseTable = req.getBoolean("leaseTable", false);
        ValueDocDecoder decoder = new ValueDocDecoder(circuit.getInputStream());
        BQuery query = (BQuery)decoder.decodeDocument(false);
        BUser user = null;
        try {
            Context cx = this.getSessionContext();
            if (username != null) {
                username = LegacyStorageUtil.decode((String)username);
                BUserService userService = (BUserService)Sys.getService((Type)BUserService.TYPE);
                user = (BUser)userService.get(username);
                if (user == null) {
                    throw new AuthenticationException("User '" + username + "' does not exist on subordinate");
                }
                if (!cx.getUser().getName().equals(username) && !user.getPermissions((Context)cx.getUser()).hasOperatorWrite()) {
                    throw new AuthenticationException("User '" + username + "' has more permissions than Niagara Network User '" + cx.getUser().getName() + "', this is not allowed.");
                }
                BFacets facets = cx != null ? cx.getFacets() : BFacets.NULL;
                cx = new BasicContext(user, facets);
            }
            BOrd ord = ordText != null ? BOrd.make((String)("local:|" + ordText)) : BOrd.make((String)"local:|station:|slot:/");
            BQueryEngine engine = BQueryEngine.make((BSpace)this.getComponentSpace());
            BITable table = engine.compile(query, ord).execute(cx);
            if (leaseTable) {
                BConsolidatedQuery.leaseTableContents((BITable<BObject>)table);
            }
            BIDataTable result = null;
            result = table instanceof BIDataTable ? (BIDataTable)table : BToDataTable.toDataTable((BITable)table);
            FoxMessage resp = new FoxMessage();
            resp.add("resolved", true);
            circuit.writeMessage(resp);
            circuit.flush();
            DataOutputStream out = new DataOutputStream(circuit.getOutputStream());
            DataTableEncoder.encode((BIDataTable)result, (DataOutput)out, (Context)cx);
            out.flush();
            out.close();
        }
        catch (Exception e) {
            circuit.writeMessage(Fox.exceptionTranslator.exceptionToMessage((Throwable)e));
            circuit.flush();
            return;
        }
    }

    public void setRemoteIp(String stationName) throws Exception {
        FoxRequest req = this.makeRequest("setRemoteIp");
        req.add("stationName", stationName);
        FoxResponse resp = this.sendSync(req);
    }

    public FoxResponse setRemoteIp(FoxRequest req) throws Exception {
        FoxResponse resp = new FoxResponse(req);
        String stationName = req.getString("stationName");
        BNiagaraNetwork nn = (BNiagaraNetwork)Sys.getService((Type)BNiagaraNetwork.TYPE);
        BNiagaraStation station = (BNiagaraStation)nn.getNiagaraStation(stationName);
        station.setAddress(BOrd.make((String)("ip:" + this.getServerConnection().session().getRemoteHost())));
        resp.add("success", true);
        return resp;
    }
}

