/*
 * Decompiled with CFR 0.152.
 */
package com.tridiumx.entsec.securityUtil.query;

import com.tridium.query.BProjCol;
import com.tridium.query.expression.BField;
import com.tridium.query.expression.BFunction;
import com.tridium.smartTableHx.HxOptionsManager;
import com.tridiumx.entsec.filter.PrefilteringUtil;
import com.tridiumx.entsec.securityUtil.query.BColumnsProvider;
import com.tridiumx.entsec.securityUtil.query.BDoubleExtent;
import com.tridiumx.entsec.securityUtil.query.BEmptyExtent;
import com.tridiumx.entsec.securityUtil.query.TypeSpecPath;
import com.tridiumx.entsec.securityUtil.ui.query.BQueryTableOptions;
import java.lang.reflect.Method;
import java.util.Comparator;
import javax.baja.agent.AgentFilter;
import javax.baja.agent.AgentList;
import javax.baja.hx.HxOp;
import javax.baja.naming.SlotPath;
import javax.baja.nre.util.Array;
import javax.baja.nre.util.TextUtil;
import javax.baja.query.BExpression;
import javax.baja.query.BExtent;
import javax.baja.query.BProjection;
import javax.baja.query.BProjectionColumn;
import javax.baja.query.BQuery;
import javax.baja.query.BSingleExtent;
import javax.baja.query.expression.BFunctionExpression;
import javax.baja.query.util.Exprs;
import javax.baja.query.util.Funcs;
import javax.baja.sys.BComplex;
import javax.baja.sys.BComponent;
import javax.baja.sys.BObject;
import javax.baja.sys.BSimple;
import javax.baja.sys.BString;
import javax.baja.sys.BValue;
import javax.baja.sys.Context;
import javax.baja.sys.Flags;
import javax.baja.sys.Property;
import javax.baja.sys.Slot;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.ui.BWidget;
import javax.baja.util.BTypeSpec;

public abstract class QueryUtil {
    public static final BColumnsProvider defaultProvider = new BColumnsProvider();
    public static final String STANDARD_COLUMNS = "columns";
    public static final String BASE_ORD = "base";

    public static BTypeSpec getRowType(BQuery query) {
        BSingleExtent extent = (BSingleExtent)query.getExtent();
        if (extent != null) {
            return extent.getBaseExtent();
        }
        return BTypeSpec.DEFAULT;
    }

    public static void makeReadonlyRowType(BQuery query) {
        Property p = query.getProperty("extent");
        if (p == null) {
            return;
        }
        query.setFlags((Slot)p, query.getFlags((Slot)p) | 1);
    }

    public static BQuery getWorkingCopy(BQuery query, Context cx) {
        return QueryUtil.getWorkingCopy(query, (BObject)query, cx);
    }

    public static BQuery getWorkingCopy(BQuery query, BObject base, Context cx) {
        query.lease(10);
        BQuery q = (BQuery)query.newCopy(true);
        q.select(QueryUtil.getWorkingProjection(query, base, cx));
        if (q.getExtent() == null) {
            q.from((BExtent)new BSingleExtent(BTypeSpec.DEFAULT));
        }
        return q;
    }

    public static BQueryTableOptions getOptions(BObject base, Context cx) {
        if (cx instanceof HxOp) {
            BQueryTableOptions options = (BQueryTableOptions)new HxOptionsManager(base, (HxOp)cx).load(BQueryTableOptions.TYPE);
            return options;
        }
        BQueryTableOptions options = null;
        if (BWidget.getApplication() != null) {
            options = BQueryTableOptions.make();
        }
        return options;
    }

    public static boolean isDefaultProjection(BQuery query) {
        BProjectionColumn[] columns;
        BQuery defaultQuery = QueryUtil.makeQuery((BQuery)query.getType().getInstance(), QueryUtil.getRowType(query));
        BProjection defaultProjection = defaultQuery.getProjection();
        BProjection projection = query.getProjection();
        if (projection == null) {
            return true;
        }
        BProjectionColumn[] defaultColumns = (BProjectionColumn[])defaultProjection.getChildren(BProjectionColumn.class);
        if (defaultColumns.length != (columns = (BProjectionColumn[])projection.getChildren(BProjectionColumn.class)).length) {
            return false;
        }
        for (int i = 0; i < defaultColumns.length; ++i) {
            if (defaultColumns[i].equivalent((Object)columns[i])) continue;
            return false;
        }
        return true;
    }

    public static String getColumnName(BProjectionColumn c) {
        if (c.getColumnExpression() instanceof BField) {
            return ((BField)c.getColumnExpression()).getFieldPath();
        }
        return ((BFunction)c.getColumnExpression()).getFunctionName();
    }

    public static BProjection getWorkingProjection(BQuery query, BObject base, Context cx) {
        BQueryTableOptions options = QueryUtil.getOptions(base, cx);
        BProjection projection = null;
        if (options != null) {
            projection = options.getProjection(query, cx);
        }
        if (projection != null) {
            return (BProjection)projection.newCopy(true);
        }
        projection = query.getProjection();
        if (projection != null && ((BProjectionColumn[])projection.getChildren(BProjectionColumn.class)).length > 0) {
            return (BProjection)projection.newCopy(true);
        }
        BQuery copy = (BQuery)query.newCopy(true);
        BTypeSpec rowType = QueryUtil.getRowType(query);
        if (rowType == BTypeSpec.DEFAULT) {
            return new BProjection();
        }
        projection = (copy = QueryUtil.makeQuery(copy, rowType)).getProjection();
        if (projection != null && ((BProjectionColumn[])projection.getChildren(BProjectionColumn.class)).length > 0) {
            return (BProjection)projection.newCopy(true);
        }
        throw new IllegalStateException("no working projection found");
    }

    public static void addHiddenColumns(BQuery query) {
        BTypeSpec typeSpec = ((BSingleExtent)query.getExtent()).getBaseExtent();
        TypeSpecPath[] keys = QueryUtil.getProvider(query).getHiddenColumns(query);
        for (int i = 0; i < keys.length; ++i) {
            QueryUtil.addHiddenColumn(query, keys[i]);
        }
    }

    public static void addHiddenColumn(BQuery query, TypeSpecPath key) {
        QueryUtil.addColumn(query, key, 4);
    }

    public static Property addSlotFacetColumn(BQuery query, Type returnType, String name, String colDisplayName) {
        BFunctionExpression exp = Funcs.make((String)"entsec:QueryTableOptions.getSlotFacetValue", (Type)BObject.TYPE, (BExpression)Exprs.simple((BSimple)BString.make((String)name)));
        TypeSpecPath typeSpecPath = new TypeSpecPath(returnType.getTypeSpec(), name, colDisplayName, (BExpression)exp);
        return QueryUtil.addColumn(query, typeSpecPath);
    }

    public static Property addColumn(BQuery query, TypeSpecPath key) {
        return QueryUtil.addColumn(query, key, 0);
    }

    public static Property addColumn(BQuery query, TypeSpecPath key, int flags) {
        BTypeSpec tableTypeSpec = QueryUtil.getRowType(query);
        BProjection projection = query.getProjection();
        if (projection == null) {
            projection = new BProjection();
            query.select(projection);
        }
        String escaped = SlotPath.escape((String)TextUtil.fromFriendly((String)key.alias));
        BProjCol projCol = QueryUtil.makeColumn(query, key);
        if (projection.get(escaped) == null) {
            return projection.add(escaped, (BValue)projCol, flags);
        }
        Property p = projection.getProperty(escaped);
        if (flags == 0 && Flags.isHidden((BComplex)projection, (Slot)p)) {
            projection.setFlags((Slot)p, projection.getFlags((Slot)p) & 0xFFFFFFFB);
        }
        return projection.getProperty(escaped);
    }

    public static BProjCol makeColumn(BQuery query, TypeSpecPath key) {
        return QueryUtil.getProvider(query).makeColumn(key, query);
    }

    public static int getHiddenColumnsCount(BQuery query) {
        BProjection projection = query.getProjection();
        int count = 0;
        Property[] props = projection.getPropertiesArray();
        for (int i = 0; i < props.length; ++i) {
            if (!Flags.isHidden((BComplex)projection, (Slot)props[i])) continue;
            ++count;
        }
        return count;
    }

    public static void reorderColumns(BQuery query) {
        BProjection projection = query.getProjection();
        if (projection == null) {
            return;
        }
        QueryUtil.reorderColumns(projection);
    }

    public static void reorderColumns(final BProjection projection) {
        Array a = new Array((Object[])projection.getDynamicPropertiesArray());
        a = a.sort((Comparator)new Comparator<Property>(){

            @Override
            public int compare(Property p1, Property p2) {
                if (Flags.isHidden((BComplex)projection, (Slot)p1) && !Flags.isHidden((BComplex)projection, (Slot)p2)) {
                    return 1;
                }
                if (!Flags.isHidden((BComplex)projection, (Slot)p1) && Flags.isHidden((BComplex)projection, (Slot)p2)) {
                    return -1;
                }
                return 0;
            }
        });
        projection.reorder((Property[])a.trim());
    }

    public static boolean hasDefaultFilters(BQuery query) {
        BProjectionColumn[] columns = query.getProjection().getProjectionColumns();
        for (int i = 0; i < columns.length; ++i) {
            if (columns[i].get("defaultFilter") == null) continue;
            return true;
        }
        return false;
    }

    public static BQuery reset(BQuery query) {
        if (query.hasProjection() && query.getProperty("projection").isDynamic()) {
            query.remove((BComplex)query.getProjection());
        }
        if (query.hasPredicate() && query.getProperty("predicate").isDynamic()) {
            query.remove((BComplex)query.getPredicate());
        }
        if (query.hasGrouping() && query.getProperty("grouping").isDynamic()) {
            query.remove((BComplex)query.getGrouping());
        }
        if (query.hasHaving() && query.getProperty("having").isDynamic()) {
            query.remove((BComplex)query.getHaving());
        }
        if (query.hasOrdering() && query.getProperty("ordering").isDynamic()) {
            query.remove((BComplex)query.getOrdering());
        }
        if (query.hasExtent() && query.getProperty("extent").isDynamic()) {
            query.remove((BComplex)query.getExtent());
        }
        PrefilteringUtil.removePrefiltering(query);
        return query;
    }

    public static BQuery makeQueryReset(BQuery query) {
        BTypeSpec typeSpec = QueryUtil.getRowType(query);
        return QueryUtil.makeQueryReset((BQuery)query.newCopy(true), typeSpec);
    }

    public static BQuery makeQueryReset(BQuery query, BTypeSpec typeSpec) {
        return QueryUtil.makeQuery(QueryUtil.reset((BQuery)query.newCopy(true)), typeSpec);
    }

    public static BQuery makeQuery(BTypeSpec typeSpec) {
        BQuery query = QueryUtil.makeQuery(new BQuery(), typeSpec);
        if (query.getProjection() != null && query.getProjection().get("in") != null) {
            query.getProjection().remove("in");
        }
        return query;
    }

    public static BQuery makeQuery(BQuery query, BTypeSpec typeSpec) {
        BSingleExtent extent = new BSingleExtent(typeSpec);
        if (query.getExtent() == null) {
            query.from((BExtent)extent);
        } else if (!(query.getExtent() instanceof BDoubleExtent || query.getExtent() instanceof BEmptyExtent || extent.equivalent((Object)query.getExtent()))) {
            query.set("extent", (BValue)extent);
        }
        BColumnsProvider provider = QueryUtil.getProvider(query);
        TypeSpecPath[] columns = provider.getDefaultColumns(query);
        BProjection projection = new BProjection();
        query.select(projection);
        for (int i = 0; i < columns.length; ++i) {
            QueryUtil.addColumn(query, columns[i]);
        }
        TypeSpecPath[] keys = provider.getHiddenColumns(query);
        for (int i = 0; i < keys.length; ++i) {
            QueryUtil.addHiddenColumn(query, keys[i]);
        }
        if (query.getProjection() != null && query.getProjection().get("in") != null) {
            query.getProjection().remove("in");
        }
        return query;
    }

    public static BQuery makeQuery(BTypeSpec typeSpec, String[] directProps) {
        Object propTypeSpec = null;
        Array a = new Array(TypeSpecPath.class);
        for (int i = 0; i < directProps.length; ++i) {
            a.add((Object)TypeSpecPath.make(typeSpec, directProps[i]));
        }
        return QueryUtil.makeQuery(typeSpec, (TypeSpecPath[])a.trim());
    }

    public static BQuery makeQuery(BTypeSpec typeSpec, TypeSpecPath[] columns) {
        BQuery query = new BQuery();
        query.from((BExtent)new BSingleExtent(typeSpec));
        query.select(new BProjection());
        for (int i = 0; i < columns.length; ++i) {
            QueryUtil.addColumn(query, columns[i]);
        }
        BColumnsProvider provider = QueryUtil.getProvider(query);
        TypeSpecPath[] keys = provider.getHiddenColumns(query);
        for (int i = 0; i < keys.length; ++i) {
            QueryUtil.addHiddenColumn(query, keys[i]);
        }
        return query;
    }

    public static void ensureValidQuery(BQuery query) {
        if (query.getProjection() == null) {
            query.select(new BProjection());
        }
        boolean validColumn = false;
        BProjectionColumn[] columns = query.getProjection().getProjectionColumns();
        for (int i = 0; i < columns.length; ++i) {
            if (Flags.isHidden((BComplex)query.getProjection(), (Slot)columns[i].getPropertyInParent())) continue;
            validColumn = true;
        }
        if (!validColumn) {
            BTypeSpec typeSpec = QueryUtil.getRowType(query);
            BExtent extent = query.getExtent();
            query.getProjection().removeAll();
            if (!(extent == null || query.getProperty("extent") != null && query.getProperty("extent").isFrozen())) {
                query.from(extent);
            }
            QueryUtil.makeQuery(query, typeSpec);
        }
    }

    public static TypeSpecPath[] getDefaultColumns(BQuery query) {
        BColumnsProvider provider = QueryUtil.getProvider(query);
        return provider.getDefaultColumns(query);
    }

    public static BColumnsProvider getProvider(BQuery query) {
        BColumnsProvider[] providers = (BColumnsProvider[])query.getChildren(BColumnsProvider.class);
        if (providers.length > 0) {
            return providers[providers.length - 1];
        }
        BTypeSpec typeSpec = QueryUtil.getRowType(query);
        if (typeSpec != BTypeSpec.DEFAULT) {
            Type type = typeSpec.getResolvedType();
            AgentList list = Sys.getRegistry().getAgents(type.getTypeInfo()).filter(AgentFilter.is((Type)BColumnsProvider.TYPE));
            if (list.size() > 0) {
                return (BColumnsProvider)list.getDefault().getInstance();
            }
        }
        return defaultProvider;
    }

    public static TypeSpecPath[] getStandardColumns() {
        Array a = new Array(TypeSpecPath.class);
        Method[] methods = BComponent.class.getMethods();
        for (int i = 0; i < methods.length; ++i) {
            if (methods[i].getReturnType().equals(Void.TYPE) || methods[i].getReturnType().toString().indexOf("[L") != -1 || methods[i].getParameterTypes().length != 0 && (methods[i].getParameterTypes().length != 1 || !Context.class.isAssignableFrom(methods[i].getParameterTypes()[0]))) continue;
            String name = methods[i].getName();
            if (name.indexOf("get") == 0) {
                name = name.substring(3);
                name = TextUtil.decapitalize((String)name);
            }
            TypeSpecPath tsp = new TypeSpecPath(BTypeSpec.make((String)"baja:String"), name);
            a.add((Object)tsp);
        }
        Comparator<TypeSpecPath> c = new Comparator<TypeSpecPath>(){

            @Override
            public int compare(TypeSpecPath s1, TypeSpecPath s2) {
                return s1.path.compareTo(s2.path);
            }
        };
        a = a.sort((Comparator)c);
        return (TypeSpecPath[])a.trim();
    }
}

