/*
 * Decompiled with CFR 0.152.
 */
package com.tridiumx.entsec.securityUtil.query;

import com.tridiumx.entsec.securityUtil.query.QueryUtil;
import com.tridiumx.entsec.securityUtil.query.TypeSpecPath;
import com.tridiumx.entsec.securityUtil.query.consolidated.BConsolidatedQuery;
import javax.baja.bacnet.BBacnetNetwork;
import javax.baja.bacnet.export.BBacnetPointDescriptor;
import javax.baja.naming.BOrd;
import javax.baja.nre.annotations.NiagaraType;
import javax.baja.query.BExpression;
import javax.baja.query.expression.BFunctionExpression;
import javax.baja.query.util.Funcs;
import javax.baja.query.util.Predicates;
import javax.baja.sys.BBoolean;
import javax.baja.sys.BComplex;
import javax.baja.sys.BIcon;
import javax.baja.sys.BObject;
import javax.baja.sys.BSimple;
import javax.baja.sys.BString;
import javax.baja.sys.BValue;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.util.BTypeSpec;
import javax.baja.util.Lexicon;

@NiagaraType
public class BBacnetPoints
extends BConsolidatedQuery {
    public static final Type TYPE = Sys.loadType(BBacnetPoints.class);
    static BIcon ICON = BIcon.make((String)"module://bacnet/com/tridium/bacnet/ui/icons/bacObject.png");
    static final Lexicon lex = Lexicon.make(BBacnetPoints.class);

    @Override
    public Type getType() {
        return TYPE;
    }

    @Override
    public void started() {
        super.started();
        if (this.get("base") == null) {
            this.add("base", (BValue)BOrd.make((String)"service:bacnet:BacnetNetwork"));
            QueryUtil.makeQuery(this, BBacnetPointDescriptor.TYPE.getTypeSpec());
        }
        BFunctionExpression exp = Funcs.make((String)"entsec:BacnetPoints.isAccessExport", (Type)BBoolean.TYPE, (BExpression[])new BExpression[0]);
        this.where(Predicates.eq((BExpression)exp, (BSimple)BBoolean.TRUE));
    }

    @Override
    public TypeSpecPath[] getDefaultColumns() {
        TypeSpecPath[] result = new TypeSpecPath[]{new TypeSpecPath(BString.TYPE.getTypeSpec(), "description", lex.getText("hardware.bacnet.description")), new TypeSpecPath(BString.TYPE.getTypeSpec(), "objectId", lex.getText("hardware.bacnet.objectId")), new TypeSpecPath(BString.TYPE.getTypeSpec(), "status", lex.getText("hardware.bacnet.status"))};
        return result;
    }

    @Override
    public String getOptionsKey() {
        String key = super.getOptionsKey();
        return "ConsolidatedBacnet" + key;
    }

    @Override
    public BTypeSpec[] subordinateServiceTypes() {
        return new BTypeSpec[]{BBacnetNetwork.TYPE.getTypeSpec()};
    }

    public static BObject isAccessExport(BObject target) {
        try {
            BObject obj;
            if (target instanceof BBacnetPointDescriptor && (obj = ((BBacnetPointDescriptor)target).getPointOrd().get(target)).isComplex()) {
                for (BComplex parent = obj.asComplex(); parent != null; parent = parent.getParent()) {
                    if (!parent.getType().getTypeSpec().toString().equals("accessDriver:AccessNetwork")) continue;
                    return BBoolean.TRUE;
                }
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return BBoolean.FALSE;
    }

    @Override
    public BIcon getIcon() {
        return ICON;
    }
}

