/*
 * Decompiled with CFR 0.152.
 */
package com.tridiumx.entsec.securityUtil.query;

import com.tridiumx.entsec.securityUtil.query.BColumnsProvider;
import com.tridiumx.entsec.securityUtil.query.TypeSpecPath;
import javax.baja.alarm.BAlarmClass;
import javax.baja.alarm.BAlarmPriorities;
import javax.baja.alarm.BSourceState;
import javax.baja.nre.annotations.AgentOn;
import javax.baja.nre.annotations.NiagaraType;
import javax.baja.nre.util.Array;
import javax.baja.query.BExpression;
import javax.baja.query.BQuery;
import javax.baja.query.expression.BFunctionExpression;
import javax.baja.query.util.Exprs;
import javax.baja.query.util.Funcs;
import javax.baja.sys.BInteger;
import javax.baja.sys.BObject;
import javax.baja.sys.BSimple;
import javax.baja.sys.BString;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.util.BTypeSpec;

@NiagaraType(agent={@AgentOn(types={"alarm:AlarmClass"})})
public class BAlarmClassColumnsProvider
extends BColumnsProvider {
    public static final Type TYPE = Sys.loadType(BAlarmClassColumnsProvider.class);

    @Override
    public Type getType() {
        return TYPE;
    }

    @Override
    public TypeSpecPath[] getDefaultColumns(BQuery query) {
        Array a = new Array(TypeSpecPath.class);
        a.add((Object)TypeSpecPath.DISPLAY_NAME);
        BFunctionExpression function = Funcs.make((String)"entsec:AlarmClassColumnsProvider.getPriority", (Type)BInteger.TYPE, (BExpression)Exprs.simple((BSimple)BString.make((String)"offnormal")));
        TypeSpecPath priorityColumn = new TypeSpecPath(BTypeSpec.make((String)"baja:String"), "priority", null, (BExpression)function);
        a.add((Object)priorityColumn);
        a.add((Object)new TypeSpecPath(BAlarmClass.totalAlarmCount));
        a.add((Object)new TypeSpecPath(BAlarmClass.openAlarmCount));
        a.add((Object)new TypeSpecPath(BAlarmClass.inAlarmCount));
        a.add((Object)new TypeSpecPath(BAlarmClass.unackedAlarmCount));
        a.add((Object)new TypeSpecPath(BAlarmClass.timeOfLastAlarm));
        return (TypeSpecPath[])a.trim();
    }

    public static BObject getPriority(BObject target, BString sourceStateName) {
        if (!(target instanceof BAlarmClass) || sourceStateName == null) {
            return null;
        }
        BAlarmClass alarmClass = (BAlarmClass)target;
        BAlarmPriorities priorities = alarmClass.getPriority();
        BSourceState state = BSourceState.make((String)sourceStateName.toString());
        int priority = priorities.getPriority(state);
        return BInteger.make((int)priority);
    }
}

