/*
 * Decompiled with CFR 0.152.
 */
package com.tridiumx.entsec.securityUtil.orion;

import com.tridium.orion.BIOrionApp;
import com.tridiumx.entsec.BEnterpriseSecurityService;
import com.tridiumx.entsec.orionTools.history.BOrionHistoryConsolidator;
import com.tridiumx.entsec.securityUtil.monitorSysDef.BMonitorSysDefSecurity;
import com.tridiumx.entsec.securityUtil.orion.BLocalHistoryQuery;
import javax.baja.agent.AgentList;
import javax.baja.history.BHistoryId;
import javax.baja.naming.BOrd;
import javax.baja.nre.annotations.NiagaraProperties;
import javax.baja.nre.annotations.NiagaraProperty;
import javax.baja.nre.annotations.NiagaraType;
import javax.baja.status.BStatus;
import javax.baja.sys.BValue;
import javax.baja.sys.Context;
import javax.baja.sys.Property;
import javax.baja.sys.Slot;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.util.BTypeSpec;

@NiagaraType
@NiagaraProperties(value={@NiagaraProperty(name="consolidatorStatus", type="BStatus", defaultValue="BStatus.ok", flags=7, override=true), @NiagaraProperty(name="enabled", type="boolean", defaultValue="false", flags=1, override=true), @NiagaraProperty(name="consolidationDisabled", type="boolean", defaultValue="false", flags=1), @NiagaraProperty(name="defaultLocalHistory", type="BHistoryId", defaultValue="BHistoryId.NULL"), @NiagaraProperty(name="query", type="BLocalHistoryQuery", defaultValue="new BLocalHistoryQuery()")})
public class BSecurityHistoryConsolidator
extends BOrionHistoryConsolidator {
    public static final Property consolidatorStatus = BSecurityHistoryConsolidator.newProperty((int)7, (BValue)BStatus.ok, null);
    public static final Property enabled = BSecurityHistoryConsolidator.newProperty((int)1, (boolean)false, null);
    public static final Property consolidationDisabled = BSecurityHistoryConsolidator.newProperty((int)1, (boolean)false, null);
    public static final Property defaultLocalHistory = BSecurityHistoryConsolidator.newProperty((int)0, (BValue)BHistoryId.NULL, null);
    public static final Property query = BSecurityHistoryConsolidator.newProperty((int)0, (BValue)new BLocalHistoryQuery(), null);
    public static final Type TYPE = Sys.loadType(BSecurityHistoryConsolidator.class);

    public boolean getConsolidationDisabled() {
        return this.getBoolean(consolidationDisabled);
    }

    public void setConsolidationDisabled(boolean v) {
        this.setBoolean(consolidationDisabled, v, null);
    }

    public BHistoryId getDefaultLocalHistory() {
        return (BHistoryId)this.get(defaultLocalHistory);
    }

    public void setDefaultLocalHistory(BHistoryId v) {
        this.set(defaultLocalHistory, (BValue)v, null);
    }

    public BLocalHistoryQuery getQuery() {
        return (BLocalHistoryQuery)this.get(query);
    }

    public void setQuery(BLocalHistoryQuery v) {
        this.set(query, (BValue)v, null);
    }

    @Override
    public Type getType() {
        return TYPE;
    }

    public BSecurityHistoryConsolidator() {
    }

    public BSecurityHistoryConsolidator(BHistoryId localHistory, BTypeSpec recType, boolean readonlyRecType) {
        this.setHistoryRecordType(recType);
        if (readonlyRecType) {
            this.setFlags((Slot)historyRecordType, this.getFlags((Slot)historyRecordType) | 1);
        }
        this.setDefaultLocalHistory(localHistory);
    }

    public BSecurityHistoryConsolidator(BHistoryId localHistory, BTypeSpec recType, boolean readonlyRecType, boolean disableConsolidation) {
        this(localHistory, recType, readonlyRecType);
        this.setConsolidationDisabled(disableConsolidation);
    }

    @Override
    public void validateOrionApp(BIOrionApp app) {
        this.updateRowType();
    }

    @Override
    public void stationStarted() throws Exception {
        super.stationStarted();
        this.linkToProvider();
    }

    @Override
    public void stopped() throws Exception {
        super.stopped();
        this.unlinkFromProvider();
    }

    public void descendantsStarted() throws Exception {
        super.descendantsStarted();
        BValue obj = this.getQuery().get("base");
        if (obj == null || obj.equals((Object)BOrd.NULL)) {
            this.setQuery(new BLocalHistoryQuery(this));
        }
        if (Sys.isStationStarted()) {
            this.linkToProvider();
        }
    }

    @Override
    public void changed(Property p, Context c) {
        if (p == enabled) {
            super.changed(BOrionHistoryConsolidator.enabled, c);
        } else if (p == consolidatorStatus) {
            super.changed(BOrionHistoryConsolidator.consolidatorStatus, c);
        } else {
            super.changed(p, c);
        }
        if (!this.isRunning()) {
            return;
        }
        if (p == historyRecordType || p == defaultLocalHistory) {
            this.setQuery(new BLocalHistoryQuery(this));
        } else if (p == consolidationDisabled) {
            this.updateHistoryEventRegistration(false);
        }
    }

    @Override
    public boolean isUnoperational() {
        return this.getConsolidationDisabled() || !this.getEnabled() || !this.validRowType() || !BMonitorSysDefSecurity.isPlatformValidSupervisor();
    }

    public boolean isUiUnoperational() {
        if (this.isSubReport()) {
            return ((BSecurityHistoryConsolidator)this.getParent()).isUnoperational();
        }
        return this.isUnoperational();
    }

    protected void linkToProvider() {
        Property p = this.getProperty("providerLink");
        if (p != null) {
            this.remove(p);
        }
        if (this.get("hasAccessSystemLink") != null || this.isSubReport()) {
            return;
        }
        BMonitorSysDefSecurity provider = this.getMonitorSysDef();
        if (provider != null) {
            this.linkTo("hasAccessSystemLink", provider, (Slot)BMonitorSysDefSecurity.hasAccessSystem, (Slot)enabled);
        }
    }

    private void unlinkFromProvider() {
        Property p = this.getProperty("hasAccessSystemLink");
        if (p != null) {
            this.remove(p);
        }
    }

    private BMonitorSysDefSecurity getMonitorSysDef() {
        try {
            BEnterpriseSecurityService entsecService = (BEnterpriseSecurityService)Sys.getService((Type)BEnterpriseSecurityService.TYPE);
            return entsecService.getMonitorSysDefSecurity();
        }
        catch (Exception exception) {
            return null;
        }
    }

    public String getDisplayName(Slot slot, Context cx) {
        if (slot == query) {
            return this.getDisplayName(cx);
        }
        return super.getDisplayName(slot, cx);
    }

    @Override
    public AgentList getAgents(Context cx) {
        AgentList list = super.getAgents(cx);
        this.lease();
        if (this.isUiUnoperational()) {
            list.toTop("entsecHx:HxLocalHistoryTableView");
        } else {
            list.toTop("entsec:OrionHistoryView");
            list.toTop("entsecHx:HxOrionHistoryView");
        }
        return list;
    }
}

