/*
 * Decompiled with CFR 0.152.
 */
package com.tridiumx.entsec.securityUtil.monitorSysDef;

import javax.baja.nre.annotations.NiagaraProperties;
import javax.baja.nre.annotations.NiagaraProperty;
import javax.baja.nre.annotations.NiagaraType;
import javax.baja.sys.BStruct;
import javax.baja.sys.BValue;
import javax.baja.sys.Context;
import javax.baja.sys.Property;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.util.BTypeSpec;

@NiagaraType
@NiagaraProperties(value={@NiagaraProperty(name="id", type="int", defaultValue="UNKNOWN"), @NiagaraProperty(name="role", type="int", defaultValue="UNKNOWN"), @NiagaraProperty(name="stationName", type="String", defaultValue=""), @NiagaraProperty(name="serviceTypeSpec", type="BTypeSpec", defaultValue="BTypeSpec.DEFAULT")})
public class BMonitorSysDefEvent
extends BStruct {
    public static final int UNKNOWN = -1;
    public static final int INSERT = 0;
    public static final int UPDATE = 1;
    public static final int DELETE = 2;
    public static final int SUPERVISOR = 0;
    public static final int SUBORDINATE = 1;
    public static final Property id = BMonitorSysDefEvent.newProperty((int)0, (int)-1, null);
    public static final Property role = BMonitorSysDefEvent.newProperty((int)0, (int)-1, null);
    public static final Property stationName = BMonitorSysDefEvent.newProperty((int)0, (String)"", null);
    public static final Property serviceTypeSpec = BMonitorSysDefEvent.newProperty((int)0, (BValue)BTypeSpec.DEFAULT, null);
    public static final Type TYPE = Sys.loadType(BMonitorSysDefEvent.class);

    public int getId() {
        return this.getInt(id);
    }

    public void setId(int v) {
        this.setInt(id, v, null);
    }

    public int getRole() {
        return this.getInt(role);
    }

    public void setRole(int v) {
        this.setInt(role, v, null);
    }

    public String getStationName() {
        return this.getString(stationName);
    }

    public void setStationName(String v) {
        this.setString(stationName, v, null);
    }

    public BTypeSpec getServiceTypeSpec() {
        return (BTypeSpec)this.get(serviceTypeSpec);
    }

    public void setServiceTypeSpec(BTypeSpec v) {
        this.set(serviceTypeSpec, (BValue)v, null);
    }

    public Type getType() {
        return TYPE;
    }

    public BMonitorSysDefEvent() {
    }

    public BMonitorSysDefEvent(int id, int role, String station, BTypeSpec typeSpec) {
        this.setId(id);
        this.setRole(role);
        this.setStationName(station);
        this.setServiceTypeSpec(typeSpec);
    }

    public static BMonitorSysDefEvent makeInsert(int role, String station, BTypeSpec typeSpec) {
        return new BMonitorSysDefEvent(0, role, station, typeSpec);
    }

    public static BMonitorSysDefEvent makeUpdate(int role, String station, BTypeSpec typeSpec) {
        return new BMonitorSysDefEvent(1, role, station, typeSpec);
    }

    public static BMonitorSysDefEvent makeDelete(int role, String station, BTypeSpec typeSpec) {
        return new BMonitorSysDefEvent(2, role, station, typeSpec);
    }

    public static boolean isInsert(int id) {
        return id == 0;
    }

    public static boolean isUpdate(int id) {
        return id == 1;
    }

    public static boolean isDelete(int id) {
        return id == 2;
    }

    public static boolean isSupervisor(int role) {
        return role == 0;
    }

    public static boolean isSubordinate(int role) {
        return role == 1;
    }

    public String toString(Context cx) {
        StringBuffer sb = new StringBuffer();
        String id = "Unknown: ";
        String role = " <Unknown>";
        String typeSpec = " " + this.getServiceTypeSpec().toString();
        switch (this.getId()) {
            case 0: {
                id = "Inserted: ";
                break;
            }
            case 1: {
                id = "Updated: ";
                break;
            }
            case 2: {
                id = "Deleted: ";
            }
        }
        switch (this.getRole()) {
            case 0: {
                role = " <Supervisor>";
                break;
            }
            case 1: {
                role = " <Subordinate>";
            }
        }
        return sb.append(id).append(this.getStationName()).append(role).append(typeSpec).toString();
    }
}

